/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class WriteEntity
extends Entity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isTempURI = false;
    private transient boolean isDynamicPartitionWrite = false;
    private transient boolean isTxnAnalyze = false;
    private WriteType writeType;

    public WriteEntity() {
    }

    public WriteEntity(Catalog catalog, WriteType type) {
        super(catalog, true);
        this.setWriteTypeInternal(type);
    }

    public WriteEntity(Database database, WriteType type) {
        super(database, true);
        this.setWriteTypeInternal(type);
    }

    public WriteEntity(DataConnector connector, WriteType type) {
        super(connector, true);
        this.setWriteTypeInternal(type);
    }

    public WriteEntity(Table t, WriteType type) {
        super(t, true);
        this.setWriteTypeInternal(type);
    }

    public WriteEntity(Table t, WriteType type, boolean complete) {
        super(t, complete);
        this.setWriteTypeInternal(type);
    }

    public WriteEntity(Function function, WriteType type) {
        super(function, true);
        this.setWriteTypeInternal(type);
    }

    public WriteEntity(Database db, String objName, String className, Entity.Type type, WriteType writeType) {
        super(db, objName, className, type);
        this.writeType = writeType;
    }

    public WriteEntity(Partition p, WriteType type) {
        super(p, true);
        this.setWriteTypeInternal(type);
    }

    public WriteEntity(DummyPartition p, WriteType type, boolean complete) {
        super(p, complete);
        this.setWriteTypeInternal(type);
    }

    public WriteEntity(Path d, boolean isLocal) {
        this(d, isLocal, false);
    }

    public WriteEntity(Path d, boolean isLocal, boolean isTemp) {
        super(d, isLocal, true);
        this.isTempURI = isTemp;
        this.writeType = WriteType.PATH_WRITE;
    }

    public WriteEntity(String name, Entity.Type t) {
        super(name, t);
        this.writeType = WriteType.DDL_NO_LOCK;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    private void setWriteTypeInternal(WriteType type) {
        this.writeType = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof WriteEntity) {
            WriteEntity ore = (WriteEntity)o;
            return this.getName().equalsIgnoreCase(ore.getName()) && this.writeType == ore.writeType;
        }
        return false;
    }

    public String toStringDetail() {
        return "WriteEntity(" + this.toString() + ") Type=" + this.getType() + " WriteType=" + this.getWriteType();
    }

    public boolean isTempURI() {
        return this.isTempURI;
    }

    public static WriteType determineAlterTableWriteType(AlterTableType op, Table table, HiveConf conf) {
        switch (op) {
            case ARCHIVE: 
            case UNARCHIVE: 
            case ALTERLOCATION: 
            case DROPPARTITION: 
            case RENAMEPARTITION: 
            case SKEWED_BY: 
            case SET_SKEWED_LOCATION: 
            case INTO_BUCKETS: 
            case ALTERPARTITION: 
            case TRUNCATE: 
            case MERGEFILES: {
                if (AcidUtils.isLocklessReadsEnabled(table, conf)) {
                    throw new UnsupportedOperationException(op.name());
                }
                return WriteType.DDL_EXCLUSIVE;
            }
            case CLUSTERED_BY: 
            case NOT_SORTED: 
            case NOT_CLUSTERED: 
            case SET_FILE_FORMAT: 
            case SET_SERDE: 
            case ADDCOLS: 
            case DROP_COLUMN: 
            case REPLACE_COLUMNS: 
            case RENAME_COLUMN: 
            case ADD_CONSTRAINT: 
            case DROP_CONSTRAINT: 
            case OWNER: 
            case RENAME: 
            case DROPPROPS: {
                return AcidUtils.isLocklessReadsEnabled(table, conf) ? WriteType.DDL_EXCL_WRITE : WriteType.DDL_EXCLUSIVE;
            }
            case ADDPARTITION: 
            case SET_SERDE_PROPS: 
            case ADDPROPS: 
            case UPDATESTATS: {
                return WriteType.DDL_SHARED;
            }
            case COMPACT: 
            case TOUCH: {
                return WriteType.DDL_NO_LOCK;
            }
        }
        throw new RuntimeException("Unknown operation " + op.toString());
    }

    public boolean isDynamicPartitionWrite() {
        return this.isDynamicPartitionWrite;
    }

    public void setDynamicPartitionWrite(boolean t) {
        this.isDynamicPartitionWrite = t;
    }

    public String toDetailedString() {
        return this.toString() + " Type=" + this.getTyp() + " WriteType=" + this.getWriteType() + " isDP=" + this.isDynamicPartitionWrite();
    }

    public boolean isTxnAnalyze() {
        return this.isTxnAnalyze;
    }

    public void setTxnAnalyze(boolean isTxnAnalyze) {
        this.isTxnAnalyze = isTxnAnalyze;
    }

    public static enum WriteType {
        DDL_EXCLUSIVE,
        DDL_EXCL_WRITE,
        DDL_SHARED,
        DDL_NO_LOCK,
        INSERT,
        INSERT_OVERWRITE,
        UPDATE,
        DELETE,
        CTAS,
        PATH_WRITE;

    }
}

