/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.ConcurrentModificationException;
import java.util.Map;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinEagerRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinPersistableTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.Writable;

public class MapJoinTableContainerSerDe {
    private final MapJoinObjectSerDeContext keyContext;
    private final MapJoinObjectSerDeContext valueContext;

    public MapJoinTableContainerSerDe(MapJoinObjectSerDeContext keyContext, MapJoinObjectSerDeContext valueContext) {
        this.keyContext = keyContext;
        this.valueContext = valueContext;
    }

    public MapJoinObjectSerDeContext getKeyContext() {
        return this.keyContext;
    }

    public MapJoinObjectSerDeContext getValueContext() {
        return this.valueContext;
    }

    public MapJoinPersistableTableContainer load(ObjectInputStream in) throws HiveException {
        MapJoinPersistableTableContainer tableContainer;
        AbstractSerDe keySerDe = this.keyContext.getSerDe();
        AbstractSerDe valueSerDe = this.valueContext.getSerDe();
        try {
            String name = in.readUTF();
            Map metaData = (Map)in.readObject();
            tableContainer = this.create(name, metaData);
        }
        catch (IOException e) {
            throw new HiveException("IO error while trying to create table container", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Class Initialization error while trying to create table container", (Throwable)e);
        }
        try {
            Writable keyContainer = (Writable)keySerDe.getSerializedClass().newInstance();
            Writable valueContainer = (Writable)valueSerDe.getSerializedClass().newInstance();
            int numKeys = in.readInt();
            for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
                MapJoinKeyObject key = new MapJoinKeyObject();
                key.read(this.keyContext, in, keyContainer);
                MapJoinEagerRowContainer values = new MapJoinEagerRowContainer();
                values.read(this.valueContext, in, valueContainer);
                tableContainer.put(key, values);
            }
            return tableContainer;
        }
        catch (IOException e) {
            throw new HiveException("IO error while trying to create table container", (Throwable)e);
        }
        catch (Exception e) {
            throw new HiveException("Error while trying to create table container", (Throwable)e);
        }
    }

    private void loadNormal(MapJoinPersistableTableContainer container, ObjectInputStream in, Writable keyContainer, Writable valueContainer) throws Exception {
        int numKeys = in.readInt();
        for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
            MapJoinKeyObject key = new MapJoinKeyObject();
            key.read(this.keyContext, in, keyContainer);
            if (container.get(key) == null) {
                container.put(key, new MapJoinEagerRowContainer());
            }
            MapJoinEagerRowContainer values = (MapJoinEagerRowContainer)container.get(key);
            values.read(this.valueContext, in, valueContainer);
            container.put(key, values);
        }
    }

    private void loadOptimized(MapJoinBytesTableContainer container, ObjectInputStream in, Writable key, Writable value) throws Exception {
        int numKeys = in.readInt();
        for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
            key.readFields((DataInput)in);
            long numRows = in.readLong();
            for (long rowIndex = 0L; rowIndex < numRows; ++rowIndex) {
                value.readFields((DataInput)in);
                container.putRow(key, value);
            }
        }
    }

    public void persist(ObjectOutputStream out, MapJoinPersistableTableContainer tableContainer) throws HiveException {
        int numKeys = tableContainer.size();
        try {
            out.writeUTF(tableContainer.getClass().getName());
            out.writeObject(tableContainer.getMetaData());
            out.writeInt(numKeys);
            for (Map.Entry<MapJoinKey, MapJoinRowContainer> entry : tableContainer.entrySet()) {
                entry.getKey().write(this.keyContext, out);
                entry.getValue().write(this.valueContext, out);
            }
        }
        catch (SerDeException e) {
            String msg = "SerDe error while attempting to persist table container";
            throw new HiveException(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = "IO error while attempting to persist table container";
            throw new HiveException(msg, (Throwable)e);
        }
        if (numKeys != tableContainer.size()) {
            throw new ConcurrentModificationException("TableContainer was modified while persisting: " + tableContainer);
        }
    }

    public static void persistDummyTable(ObjectOutputStream out) throws IOException {
        HashMapWrapper tableContainer = new HashMapWrapper();
        out.writeUTF(tableContainer.getClass().getName());
        out.writeObject(tableContainer.getMetaData());
        out.writeInt(tableContainer.size());
    }

    private MapJoinPersistableTableContainer create(String name, Map<String, String> metaData) throws HiveException {
        try {
            Class clazz = JavaUtils.loadClass((String)name);
            Constructor constructor = clazz.getDeclaredConstructor(Map.class);
            return (MapJoinPersistableTableContainer)constructor.newInstance(metaData);
        }
        catch (Exception e) {
            String msg = "Error while attempting to create table container of type: " + name + ", with metaData: " + metaData;
            throw new HiveException(msg, (Throwable)e);
        }
    }
}

