/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ColumnInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String internalName;
    private String alias = null;
    private boolean isSkewedCol;
    private String tabAlias;
    private boolean isVirtualCol;
    private boolean isHiddenPartitionCol;
    private ObjectInspector objectInspector;
    private boolean isHiddenVirtualCol;
    private String typeName;
    private final boolean nullable;

    public ColumnInfo() {
        this.nullable = true;
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isVirtualCol) {
        this(internalName, type, tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, TypeInfo type, boolean nullable, String tabAlias, boolean isVirtualCol) {
        this(internalName, type, nullable, tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, Class type, String tabAlias, boolean isVirtualCol) {
        this(internalName, TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable((Class)type), tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isVirtualCol, boolean isHiddenVirtualCol) {
        this(internalName, TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)type), true, tabAlias, isVirtualCol, isHiddenVirtualCol);
    }

    public ColumnInfo(String internalName, TypeInfo type, boolean nullable, String tabAlias, boolean isVirtualCol, boolean isHiddenVirtualCol) {
        this(internalName, TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)type), nullable, tabAlias, isVirtualCol, isHiddenVirtualCol);
    }

    public ColumnInfo(String internalName, ObjectInspector objectInspector, String tabAlias, boolean isVirtualCol) {
        this(internalName, objectInspector, true, tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, ObjectInspector objectInspector, boolean nullable, String tabAlias, boolean isVirtualCol, boolean isHiddenVirtualCol) {
        this.internalName = internalName;
        this.objectInspector = objectInspector;
        this.tabAlias = tabAlias;
        this.isVirtualCol = isVirtualCol;
        this.isHiddenVirtualCol = isHiddenVirtualCol;
        this.nullable = nullable;
        this.setTypeName(this.getType().getTypeName());
    }

    public ColumnInfo(ColumnInfo columnInfo) {
        this.internalName = columnInfo.getInternalName();
        this.alias = columnInfo.getAlias();
        this.isSkewedCol = columnInfo.isSkewedCol();
        this.tabAlias = columnInfo.getTabAlias();
        this.isVirtualCol = columnInfo.getIsVirtualCol();
        this.isHiddenPartitionCol = columnInfo.isHiddenPartitionCol();
        this.isHiddenVirtualCol = columnInfo.isHiddenVirtualCol();
        this.nullable = columnInfo.nullable;
        this.setType(columnInfo.getType());
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = StringInternUtils.internIfNotNull((String)typeName);
    }

    public TypeInfo getType() {
        return TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.objectInspector);
    }

    public ObjectInspector getObjectInspector() {
        return this.objectInspector;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setType(TypeInfo type) {
        this.objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)type);
        this.setTypeName(type.getTypeName());
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getTabAlias() {
        return this.tabAlias;
    }

    public boolean getIsVirtualCol() {
        return this.isVirtualCol || this.isHiddenPartitionCol;
    }

    public boolean isHiddenPartitionCol() {
        return this.isHiddenPartitionCol;
    }

    public boolean isHiddenVirtualCol() {
        return this.isHiddenVirtualCol;
    }

    public String toString() {
        return this.internalName + ": " + this.typeName;
    }

    public void setAlias(String col_alias) {
        this.alias = StringInternUtils.internIfNotNull((String)col_alias);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setTabAlias(String tabAlias) {
        this.tabAlias = tabAlias;
    }

    public void setVirtualCol(boolean isVirtualCol) {
        this.isVirtualCol = isVirtualCol;
    }

    public void setHiddenVirtualCol(boolean isHiddenVirtualCol) {
        this.isHiddenVirtualCol = isHiddenVirtualCol;
    }

    public void setHiddenPartitionCol(boolean isPartitionCol) {
        this.isHiddenPartitionCol = isPartitionCol;
    }

    public boolean isSkewedCol() {
        return this.isSkewedCol;
    }

    public void setSkewedCol(boolean isSkewedCol) {
        this.isSkewedCol = isSkewedCol;
    }

    private boolean checkEquals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public int hashCode() {
        return this.internalName.hashCode() + this.typeName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnInfo) || obj == null) {
            return false;
        }
        ColumnInfo dest = (ColumnInfo)obj;
        return this.checkEquals(this.internalName, dest.getInternalName()) && this.checkEquals(this.tabAlias, dest.getTabAlias()) && this.checkEquals(this.alias, dest.getAlias()) && this.checkEquals(this.getType(), dest.getType()) && this.isSkewedCol == dest.isSkewedCol() && this.isVirtualCol == dest.getIsVirtualCol() && this.isHiddenVirtualCol == dest.isHiddenVirtualCol();
    }

    public boolean internalEquals(ColumnInfo dest) {
        if (dest == null) {
            return false;
        }
        return this.checkEquals(this.internalName, dest.getInternalName()) && this.checkEquals(this.getType(), dest.getType()) && this.isSkewedCol == dest.isSkewedCol() && this.isVirtualCol == dest.getIsVirtualCol() && this.isHiddenVirtualCol == dest.isHiddenVirtualCol();
    }

    public boolean isSameColumnForRR(ColumnInfo other) {
        return this.checkEquals(this.tabAlias, other.tabAlias) && this.checkEquals(this.alias, other.alias) && this.checkEquals(this.internalName, other.internalName) && this.checkEquals(this.getType(), other.getType());
    }

    public String toMappingString(String tab, String col) {
        return tab + "." + col + " => {" + this.tabAlias + ", " + this.alias + ", " + this.internalName + ": " + this.getType() + "}";
    }

    public void setObjectinspector(ObjectInspector writableObjectInspector) {
        this.objectInspector = writableObjectInspector;
    }

    public boolean isNullable() {
        return this.nullable;
    }
}

