/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.column.show.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ShowColumnsOperation
extends DDLOperation<ShowColumnsDesc> {
    public ShowColumnsOperation(DDLOperationContext context, ShowColumnsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        try (DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((ShowColumnsDesc)this.desc).getResFile()), this.context);){
            List<FieldSchema> columns = this.getColumnsByPattern();
            this.writeColumns(outStream, columns);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR);
        }
        return 0;
    }

    private List<FieldSchema> getColumnsByPattern() throws HiveException {
        List<FieldSchema> columns = this.getCols();
        Matcher matcher = this.getMatcher();
        return this.filterColumns(columns, matcher);
    }

    private List<FieldSchema> getCols() throws HiveException {
        Table table = this.context.getDb().getTable(((ShowColumnsDesc)this.desc).getTableName());
        ArrayList<FieldSchema> allColumns = new ArrayList<FieldSchema>();
        allColumns.addAll(table.getCols());
        allColumns.addAll(table.getPartCols());
        return allColumns;
    }

    private Matcher getMatcher() {
        String columnPattern = ((ShowColumnsDesc)this.desc).getPattern();
        if (columnPattern == null) {
            columnPattern = "*";
        }
        columnPattern = columnPattern.toLowerCase();
        columnPattern = columnPattern.replaceAll("\\*", ".*");
        Pattern pattern = Pattern.compile(columnPattern);
        return pattern.matcher("");
    }

    private List<FieldSchema> filterColumns(List<FieldSchema> columns, Matcher matcher) {
        ArrayList<FieldSchema> result = new ArrayList<FieldSchema>();
        for (FieldSchema column : columns) {
            matcher.reset(column.getName());
            if (!matcher.matches()) continue;
            result.add(column);
        }
        if (((ShowColumnsDesc)this.desc).isSorted()) {
            result.sort(new Comparator<FieldSchema>(){

                @Override
                public int compare(FieldSchema f1, FieldSchema f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
        }
        return result;
    }

    private void writeColumns(DataOutputStream outStream, List<FieldSchema> columns) throws IOException {
        ShowUtils.TextMetaDataTable tmd = new ShowUtils.TextMetaDataTable();
        for (FieldSchema fieldSchema : columns) {
            tmd.addRow(fieldSchema.getName());
        }
        boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
        outStream.writeBytes(tmd.renderTable(isOutputPadded));
    }
}

