/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.desc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hive.common.util.HiveStringUtils;

abstract class DescDataConnectorFormatter {
    DescDataConnectorFormatter() {
    }

    static DescDataConnectorFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonDescDataConnectorFormatter();
        }
        return new TextDescDataConnectorFormatter();
    }

    abstract void showDataConnectorDescription(DataOutputStream var1, String var2, String var3, String var4, String var5, PrincipalType var6, String var7, Map<String, String> var8) throws HiveException;

    static class JsonDescDataConnectorFormatter
    extends DescDataConnectorFormatter {
        JsonDescDataConnectorFormatter() {
        }

        @Override
        void showDataConnectorDescription(DataOutputStream out, String connector, String type, String url, String ownerName, PrincipalType ownerType, String comment, Map<String, String> params) throws HiveException {
            MapBuilder builder = MapBuilder.create().put("connector", connector).put("type", type).put("url", url);
            if (ownerName != null) {
                builder.put("owner", ownerName);
            }
            if (ownerType != null) {
                builder.put("ownerType", ownerType.name());
            }
            if (comment != null) {
                builder.put("comment", comment);
            }
            if (MapUtils.isNotEmpty(params)) {
                builder.put("params", params);
            }
            ShowUtils.asJson(out, builder.build());
        }
    }

    static class TextDescDataConnectorFormatter
    extends DescDataConnectorFormatter {
        TextDescDataConnectorFormatter() {
        }

        @Override
        void showDataConnectorDescription(DataOutputStream out, String connector, String type, String url, String ownerName, PrincipalType ownerType, String comment, Map<String, String> params) throws HiveException {
            try {
                out.write(connector.getBytes(StandardCharsets.UTF_8));
                out.write(9);
                if (type != null) {
                    out.write(type.getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (url != null) {
                    out.write(url.getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (ownerName != null) {
                    out.write(ownerName.getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (ownerType != null) {
                    out.write(ownerType.name().getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (comment != null) {
                    out.write(HiveStringUtils.escapeJava((String)comment).getBytes(StandardCharsets.UTF_8));
                }
                out.write(9);
                if (MapUtils.isNotEmpty(params)) {
                    out.write(params.toString().getBytes(StandardCharsets.UTF_8));
                }
                out.write(10);
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }
}

