/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.create;

import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.catalog.create.CreateCatalogDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={948})
public class CreateCatalogAnalyzer
extends BaseSemanticAnalyzer {
    public CreateCatalogAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String catalogName = CreateCatalogAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String locationUrl = CreateCatalogAnalyzer.unescapeSQLString(root.getChild(1).getChild(0).getText());
        this.outputs.add(this.toWriteEntity(locationUrl));
        boolean ifNotExists = false;
        String comment = null;
        block4: for (int i = 2; i < root.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)root.getChild(i);
            switch (childNode.getToken().getType()) {
                case 1051: {
                    ifNotExists = true;
                    continue block4;
                }
                case 934: {
                    comment = CreateCatalogAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE CATALOG statement");
                }
            }
        }
        CreateCatalogDesc desc = new CreateCatalogDesc(catalogName, comment, locationUrl, ifNotExists);
        Catalog catalog = new Catalog(catalogName, locationUrl);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        this.outputs.add(new WriteEntity(catalog, WriteEntity.WriteType.DDL_NO_LOCK));
    }
}

