/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.TxnWriteDetails;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetWriteIdsForTxnIDHandler
implements QueryHandler<List<TxnWriteDetails>> {
    private final long txnId;

    public GetWriteIdsForTxnIDHandler(long txnId) {
        this.txnId = txnId;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT DISTINCT \"T2W_DATABASE\", \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" \"COMMITTED\" WHERE \"T2W_TXNID\" = :txnId";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("txnId", (Object)this.txnId);
    }

    public List<TxnWriteDetails> extractData(ResultSet rs) throws SQLException, DataAccessException {
        ArrayList<TxnWriteDetails> dbsUpdated = new ArrayList<TxnWriteDetails>();
        while (rs.next()) {
            TxnWriteDetails entry = new TxnWriteDetails(this.txnId, rs.getString(1), rs.getLong(2));
            dbsUpdated.add(entry);
        }
        return dbsUpdated;
    }
}

