/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector;

import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.dataconnector.IDataConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.AbstractJDBCConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.DerbySQLConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.HiveJDBCConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.MSSQLConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.MySQLConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.OracleConnectorProvider;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.PostgreSQLConnectorProvider;

public class JDBCConnectorProviderFactory {
    public static IDataConnectorProvider get(String dbName, DataConnector connector) {
        AbstractJDBCConnectorProvider provider = null;
        switch (connector.getType().toLowerCase()) {
            case "mysql": {
                provider = new MySQLConnectorProvider(dbName, connector);
                break;
            }
            case "postgres": {
                provider = new PostgreSQLConnectorProvider(dbName, connector);
                break;
            }
            case "derby": {
                provider = new DerbySQLConnectorProvider(dbName, connector);
                break;
            }
            case "oracle": {
                provider = new OracleConnectorProvider(dbName, connector);
                break;
            }
            case "mssql": {
                provider = new MSSQLConnectorProvider(dbName, connector);
                break;
            }
            case "hivejdbc": {
                provider = new HiveJDBCConnectorProvider(dbName, connector);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported JDBC type");
            }
        }
        return provider;
    }
}

