/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.ConfigurationDocGen;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;

public class DefaultConfiguration
extends AccumuloConfiguration {
    private static DefaultConfiguration instance = null;
    private Map<String, String> resolvedProps = null;

    public static synchronized DefaultConfiguration getInstance() {
        if (instance == null) {
            instance = new DefaultConfiguration();
            ConfigSanityCheck.validate(instance);
        }
        return instance;
    }

    @Override
    public String get(Property property) {
        return property.getDefaultValue();
    }

    private synchronized Map<String, String> getResolvedProps() {
        if (this.resolvedProps == null) {
            this.resolvedProps = new HashMap<String, String>();
            for (Property prop : Property.values()) {
                if (prop.getType().equals((Object)PropertyType.PREFIX)) continue;
                this.resolvedProps.put(prop.getKey(), prop.getDefaultValue());
            }
        }
        return this.resolvedProps;
    }

    @Override
    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        for (Map.Entry<String, String> entry : this.getResolvedProps().entrySet()) {
            if (!filter.accept(entry.getKey())) continue;
            props.put(entry.getKey(), entry.getValue());
        }
    }

    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
        if (args.length == 2 && args[0].equals("--generate-html")) {
            new ConfigurationDocGen(new PrintStream(args[1], Constants.UTF8.name())).generateHtml();
        } else if (args.length == 2 && args[0].equals("--generate-latex")) {
            new ConfigurationDocGen(new PrintStream(args[1], Constants.UTF8.name())).generateLaTeX();
        } else {
            throw new IllegalArgumentException("Usage: " + DefaultConfiguration.class.getName() + " --generate-html <filename> | --generate-latex <filename>");
        }
    }
}

