/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.processors.DfsProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.hcatalog.cli.HCatDriver;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzer;
import org.apache.hive.hcatalog.common.HCatUtil;

public class HCatCli {
    private static Log LOG = null;

    public static void main(String[] args) {
        String grp;
        String perms;
        try {
            LogUtils.initHiveLog4j();
        }
        catch (LogUtils.LogInitializationException logInitializationException) {
            // empty catch block
        }
        LOG = LogFactory.getLog(HCatCli.class);
        CliSessionState ss = new CliSessionState(new HiveConf(SessionState.class));
        ss.in = System.in;
        try {
            ss.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            ss.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.exit(1);
        }
        HiveConf conf = ss.getConf();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, (String)HCatSemanticAnalyzer.class.getName());
        String engine = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        String MR_ENGINE = "mr";
        if (!"mr".equalsIgnoreCase(engine)) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, (String)"mr");
            LOG.info((Object)("Forcing " + HiveConf.ConfVars.HIVE_EXECUTION_ENGINE + " to " + "mr"));
        }
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"exec");
        OptionBuilder.withDescription((String)"hcat command given from command line");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"hcat commands in file");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"group");
        OptionBuilder.withDescription((String)"group for the db/table specified in CREATE statement");
        options.addOption(OptionBuilder.create((char)'g'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"perms");
        OptionBuilder.withDescription((String)"permissions for the db/table specified in CREATE statement");
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use hadoop value for given property");
        options.addOption(OptionBuilder.create((char)'D'));
        options.addOption(new Option("h", "help", false, "Print help information"));
        GnuParser parser = new GnuParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            HCatCli.printUsage(options, System.err);
            System.exit(1);
        }
        HCatCli.setConfProperties(conf, cmdLine.getOptionProperties("D"));
        SessionState.start((SessionState)ss);
        if (cmdLine.hasOption('h')) {
            HCatCli.printUsage(options, ss.out);
            HCatCli.sysExit((SessionState)ss, 0);
        }
        String execString = cmdLine.getOptionValue('e');
        String fileName = cmdLine.getOptionValue('f');
        if (execString != null && fileName != null) {
            ss.err.println("The '-e' and '-f' options cannot be specified simultaneously");
            HCatCli.printUsage(options, ss.err);
            HCatCli.sysExit((SessionState)ss, 1);
        }
        if ((perms = cmdLine.getOptionValue('p')) != null) {
            HCatCli.validatePermissions(ss, conf, perms);
        }
        if ((grp = cmdLine.getOptionValue('g')) != null) {
            conf.set("hcat.group", grp);
        }
        if (execString != null) {
            HCatCli.sysExit((SessionState)ss, HCatCli.processLine(execString));
        }
        try {
            if (fileName != null) {
                HCatCli.sysExit((SessionState)ss, HCatCli.processFile(fileName));
            }
        }
        catch (FileNotFoundException e) {
            ss.err.println("Input file not found. (" + e.getMessage() + ")");
            HCatCli.sysExit((SessionState)ss, 1);
        }
        catch (IOException e) {
            ss.err.println("Could not open input file for reading. (" + e.getMessage() + ")");
            HCatCli.sysExit((SessionState)ss, 1);
        }
        HCatCli.printUsage(options, ss.err);
        HCatCli.sysExit((SessionState)ss, 1);
    }

    private static void sysExit(SessionState ss, int retCode) {
        try {
            ss.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
        System.exit(retCode);
    }

    private static void setConfProperties(HiveConf conf, Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            conf.set((String)e.getKey(), (String)e.getValue());
        }
    }

    private static int processLine(String line) {
        int ret = 0;
        String command = "";
        for (String oneCmd : line.split(";")) {
            if (StringUtils.endsWith((String)oneCmd, (String)"\\")) {
                command = command + StringUtils.chop((String)oneCmd) + ";";
                continue;
            }
            if (StringUtils.isBlank((String)(command = command + oneCmd))) continue;
            ret = HCatCli.processCmd(command);
            command = "";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int processFile(String fileName) throws IOException {
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            String line;
            fileReader = new FileReader(fileName);
            reader = new BufferedReader(fileReader);
            StringBuilder qsb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                qsb.append(line + "\n");
            }
            int n = HCatCli.processLine(qsb.toString());
            return n;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static int processCmd(String cmd) {
        long end;
        SessionState ss = SessionState.get();
        long start = System.currentTimeMillis();
        String firstToken = (cmd = cmd.trim()).split("\\s+")[0].trim();
        if (firstToken.equalsIgnoreCase("set")) {
            return new SetProcessor().run(cmd.substring(firstToken.length()).trim()).getResponseCode();
        }
        if (firstToken.equalsIgnoreCase("dfs")) {
            return new DfsProcessor((Configuration)ss.getConf()).run(cmd.substring(firstToken.length()).trim()).getResponseCode();
        }
        HCatDriver driver = new HCatDriver();
        int ret = driver.run(cmd).getResponseCode();
        if (ret != 0) {
            driver.close();
            HCatCli.sysExit(ss, ret);
        }
        ArrayList res = new ArrayList();
        try {
            while (driver.getResults(res)) {
                for (String r : res) {
                    ss.out.println(r);
                }
                res.clear();
            }
        }
        catch (IOException e) {
            ss.err.println("Failed with exception " + e.getClass().getName() + ":" + e.getMessage() + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            ret = 1;
        }
        catch (CommandNeedRetryException e) {
            ss.err.println("Failed with exception " + ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage() + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            ret = 1;
        }
        int cret = driver.close();
        if (ret == 0) {
            ret = cret;
        }
        if ((end = System.currentTimeMillis()) > start) {
            double timeTaken = (double)(end - start) / 1000.0;
            ss.err.println("Time taken: " + timeTaken + " seconds");
        }
        return ret;
    }

    private static void printUsage(Options options, OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        new HelpFormatter().printHelp(pw, 148, "hcat { -e \"<query>\" | -f \"<filepath>\" } [ -g \"<group>\" ] [ -p \"<perms>\" ] [ -D\"<name>=<value>\" ]", null, options, 1, 3, null, false);
        pw.flush();
    }

    private static void validatePermissions(CliSessionState ss, HiveConf conf, String perms) {
        perms = perms.trim();
        FsPermission fp = null;
        if (perms.matches("^\\s*([r,w,x,-]{9})\\s*$")) {
            fp = FsPermission.valueOf((String)("d" + perms));
        } else if (perms.matches("^\\s*([0-7]{3})\\s*$")) {
            fp = new FsPermission(Short.decode("0" + perms).shortValue());
        } else {
            ss.err.println("Invalid permission specification: " + perms);
            HCatCli.sysExit((SessionState)ss, 1);
        }
        if (!HCatUtil.validateMorePermissive(fp.getUserAction(), fp.getGroupAction())) {
            ss.err.println("Invalid permission specification: " + perms + " : user permissions must be more permissive than group permission ");
            HCatCli.sysExit((SessionState)ss, 1);
        }
        if (!HCatUtil.validateMorePermissive(fp.getGroupAction(), fp.getOtherAction())) {
            ss.err.println("Invalid permission specification: " + perms + " : group permissions must be more permissive than other permission ");
            HCatCli.sysExit((SessionState)ss, 1);
        }
        if (!(HCatUtil.validateExecuteBitPresentIfReadOrWrite(fp.getUserAction()) && HCatUtil.validateExecuteBitPresentIfReadOrWrite(fp.getGroupAction()) && HCatUtil.validateExecuteBitPresentIfReadOrWrite(fp.getOtherAction()))) {
            ss.err.println("Invalid permission specification: " + perms + " : permissions must have execute permissions if read or write permissions are specified ");
            HCatCli.sysExit((SessionState)ss, 1);
        }
        conf.set("hcat.perms", "d" + fp.toString());
    }
}

