/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.RegexSerDe;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.hcatalog.streaming.AbstractRecordWriter;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.StreamingIOFailure;

public class StrictRegexWriter
extends AbstractRecordWriter {
    private RegexSerDe serde;
    private String regex;

    public StrictRegexWriter(HiveEndPoint endPoint) throws ConnectionError, SerializationError, StreamingException {
        super(endPoint, null);
    }

    public StrictRegexWriter(HiveEndPoint endPoint, HiveConf conf) throws ConnectionError, SerializationError, StreamingException {
        super(endPoint, conf);
    }

    public StrictRegexWriter(String regex, HiveEndPoint endPoint, HiveConf conf) throws ConnectionError, SerializationError, StreamingException {
        super(endPoint, conf);
        this.regex = regex;
    }

    @Override
    SerDe getSerde() throws SerializationError {
        if (this.serde != null) {
            return this.serde;
        }
        this.serde = StrictRegexWriter.createSerde(this.tbl, this.conf, this.regex);
        return this.serde;
    }

    @Override
    public void write(long transactionId, byte[] record) throws StreamingIOFailure, SerializationError {
        try {
            Object encodedRow = this.encode(record);
            this.updater.insert(transactionId, encodedRow);
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Error writing record in transaction(" + transactionId + ")", e);
        }
    }

    private static RegexSerDe createSerde(Table tbl, HiveConf conf, String regex) throws SerializationError {
        try {
            Properties tableProps = MetaStoreUtils.getTableMetadata((Table)tbl);
            tableProps.setProperty("input.regex", regex);
            ArrayList<String> tableColumns = StrictRegexWriter.getCols(tbl);
            tableProps.setProperty("columns", StringUtils.join(tableColumns, (String)","));
            RegexSerDe serde = new RegexSerDe();
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)conf, (Properties)tableProps, null);
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde " + RegexSerDe.class.getName(), (Exception)((Object)e));
        }
    }

    private static ArrayList<String> getCols(Table table) {
        List cols = table.getSd().getCols();
        ArrayList<String> colNames = new ArrayList<String>(cols.size());
        for (FieldSchema col : cols) {
            colNames.add(col.getName().toLowerCase());
        }
        return colNames;
    }

    private Object encode(byte[] utf8StrRecord) throws SerializationError {
        try {
            Text blob = new Text(utf8StrRecord);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert byte[] record into Object", (Exception)((Object)e));
        }
    }
}

