/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.common.jsonexplain.tez.Attr;
import org.apache.hadoop.hive.common.jsonexplain.tez.Connection;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.tez.Vertex;
import org.json.JSONException;
import org.json.JSONObject;

public class Op {
    String name;
    String operatorId;
    Op parent;
    List<Op> children;
    List<Attr> attrs;
    JSONObject opObject;
    Vertex vertex;
    String outputVertexName;

    public Op(String name, String id, String outputVertexName, List<Op> children, List<Attr> attrs, JSONObject opObject, Vertex vertex) throws JSONException {
        this.name = name;
        this.operatorId = id;
        this.outputVertexName = outputVertexName;
        this.children = children;
        this.attrs = attrs;
        this.opObject = opObject;
        this.vertex = vertex;
    }

    private void inlineJoinOp() throws Exception {
        if (this.name.equals("Map Join Operator")) {
            JSONObject mapjoinObj = this.opObject.getJSONObject("Map Join Operator");
            JSONObject verticeObj = mapjoinObj.getJSONObject("input vertices:");
            HashMap<String, String> posToVertex = new HashMap<String, String>();
            for (String pos : JSONObject.getNames(verticeObj)) {
                String vertexName = verticeObj.getString(pos);
                posToVertex.put(pos, vertexName);
                Connection c = null;
                for (Connection connection : this.vertex.parentConnections) {
                    if (!connection.from.name.equals(vertexName)) continue;
                    c = connection;
                    break;
                }
                if (c == null) continue;
                TezJsonParser.addInline(this, c);
            }
            this.removeAttr("input vertices:");
            JSONObject keys = mapjoinObj.getJSONObject("keys:");
            if (keys.length() != 0) {
                JSONObject newKeys = new JSONObject();
                for (String key : JSONObject.getNames(keys)) {
                    String vertexName = (String)posToVertex.get(key);
                    if (vertexName != null) {
                        newKeys.put(vertexName, keys.get(key));
                        continue;
                    }
                    newKeys.put(this.vertex.name, keys.get(key));
                }
                this.removeAttr("keys:");
                this.attrs.add(new Attr("keys:", newKeys.toString()));
            }
        } else if (this.name.equals("Merge Join Operator")) {
            if (this.vertex != null) {
                for (Vertex v : this.vertex.mergeJoinDummyVertexs) {
                    TezJsonParser.addInline(this, new Connection(null, v));
                }
            }
        } else {
            throw new Exception("Unknown join operator");
        }
    }

    private String getNameWithOpId() {
        if (this.operatorId != null) {
            return this.name + " [" + this.operatorId + "]";
        }
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void print(PrintStream out, List<Boolean> indentFlag, boolean branchOfJoinOp) throws Exception {
        ArrayList<Boolean> vertexFlag;
        if (TezJsonParser.printSet.contains(this)) {
            out.println(TezJsonParser.prefixString(indentFlag) + " Please refer to the previous " + this.getNameWithOpId());
            return;
        }
        TezJsonParser.printSet.add(this);
        if (!branchOfJoinOp) {
            out.println(TezJsonParser.prefixString(indentFlag) + this.getNameWithOpId());
        } else {
            out.println(TezJsonParser.prefixString(indentFlag, "|<-") + this.getNameWithOpId());
        }
        branchOfJoinOp = false;
        if (this.name.contains("Join")) {
            this.inlineJoinOp();
            branchOfJoinOp = true;
        }
        ArrayList<Connection> noninlined = new ArrayList<Connection>();
        if (this.parent == null && this.vertex != null) {
            for (Connection connection : this.vertex.parentConnections) {
                if (TezJsonParser.isInline(connection.from)) continue;
                noninlined.add(connection);
            }
        }
        ArrayList<Boolean> attFlag = new ArrayList<Boolean>();
        attFlag.addAll(indentFlag);
        if (branchOfJoinOp || this.parent == null && !noninlined.isEmpty()) {
            attFlag.add(true);
        } else {
            attFlag.add(false);
        }
        Collections.sort(this.attrs);
        for (Attr attr : this.attrs) {
            out.println(TezJsonParser.prefixString(attFlag) + attr.toString());
        }
        if (TezJsonParser.inlineMap.containsKey(this)) {
            void var6_9;
            boolean bl = false;
            while (var6_9 < TezJsonParser.inlineMap.get(this).size()) {
                Connection connection = TezJsonParser.inlineMap.get(this).get((int)var6_9);
                vertexFlag = new ArrayList();
                vertexFlag.addAll(indentFlag);
                if (branchOfJoinOp) {
                    vertexFlag.add(true);
                } else {
                    vertexFlag.add(false);
                }
                connection.from.print(out, vertexFlag, connection.type, this.vertex);
                ++var6_9;
            }
        }
        if (this.parent != null) {
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            arrayList.addAll(indentFlag);
            arrayList.add(false);
            this.parent.print(out, arrayList, branchOfJoinOp);
        } else {
            void var6_12;
            boolean bl = false;
            while (var6_12 < noninlined.size()) {
                Vertex v = ((Connection)noninlined.get((int)var6_12)).from;
                vertexFlag = new ArrayList<Boolean>();
                vertexFlag.addAll(indentFlag);
                if (var6_12 != noninlined.size() - 1) {
                    vertexFlag.add(true);
                } else {
                    vertexFlag.add(false);
                }
                v.print(out, vertexFlag, ((Connection)noninlined.get((int)var6_12)).type, this.vertex);
                ++var6_12;
            }
        }
    }

    public void removeAttr(String name) {
        int removeIndex = -1;
        for (int index = 0; index < this.attrs.size(); ++index) {
            if (!this.attrs.get((int)index).name.equals(name)) continue;
            removeIndex = index;
            break;
        }
        if (removeIndex != -1) {
            this.attrs.remove(removeIndex);
        }
    }
}

