/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument;

import org.apache.accumulo.trace.instrument.Sampler;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.TraceProxy;
import org.apache.accumulo.trace.instrument.TraceRunnable;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.accumulo.trace.thrift.TInfo;

public class Trace {
    public static Span on(String description) {
        return Tracer.getInstance().on(description);
    }

    public static void off() {
        Tracer.getInstance().stopTracing();
        Tracer.getInstance().flush();
    }

    public static void offNoFlush() {
        Tracer.getInstance().stopTracing();
    }

    public static boolean isTracing() {
        return Tracer.getInstance().isTracing();
    }

    public static Span currentTrace() {
        return Tracer.getInstance().currentTrace();
    }

    public static Span start(String description) {
        return Tracer.getInstance().start(description);
    }

    public static Span trace(TInfo info, String description) {
        if (info.traceId == 0L) {
            return Tracer.NULL_SPAN;
        }
        return Tracer.getInstance().continueTrace(description, info.traceId, info.parentId);
    }

    public static Span startThread(Span parent, String description) {
        return Tracer.getInstance().startThread(parent, description);
    }

    public static void endThread(Span span2) {
        Tracer.getInstance().endThread(span2);
    }

    public static Runnable wrap(Runnable runnable) {
        if (Trace.isTracing()) {
            return new TraceRunnable(Trace.currentTrace(), runnable);
        }
        return runnable;
    }

    public static <T> T wrapAll(T instance) {
        return TraceProxy.trace(instance);
    }

    public static <T> T wrapAll(T instance, Sampler dist) {
        return TraceProxy.trace(instance, dist);
    }
}

