/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.hcatalog.templeton.tool.JobStateTracker;
import org.apache.hive.hcatalog.templeton.tool.NotFoundException;
import org.apache.hive.hcatalog.templeton.tool.TempletonStorage;
import org.apache.hive.hcatalog.templeton.tool.ZooKeeperCleanup;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;

public class ZooKeeperStorage
implements TempletonStorage {
    public static final String TRACKINGDIR = "/created";
    public String storage_root = null;
    public String job_path = null;
    public String job_trackingpath = null;
    public String overhead_path = null;
    public static final String ZK_HOSTS = "templeton.zookeeper.hosts";
    public static final String ZK_SESSION_TIMEOUT = "templeton.zookeeper.session-timeout";
    public static final String ENCODING = "UTF-8";
    private static final Log LOG = LogFactory.getLog(ZooKeeperStorage.class);
    private CuratorFramework zk;

    public static CuratorFramework zkOpen(String zkHosts, int zkSessionTimeoutMs) throws IOException {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework zk = CuratorFrameworkFactory.newClient((String)zkHosts, (int)zkSessionTimeoutMs, (int)CuratorFrameworkFactory.builder().getConnectionTimeoutMs(), (RetryPolicy)retryPolicy);
        zk.start();
        return zk;
    }

    public static CuratorFramework zkOpen(Configuration conf) throws IOException {
        return ZooKeeperStorage.zkOpen(conf.get(ZK_HOSTS), conf.getInt(ZK_SESSION_TIMEOUT, CuratorFrameworkFactory.builder().getSessionTimeoutMs()));
    }

    public void close() throws IOException {
        if (this.zk != null) {
            this.zk.close();
        }
    }

    @Override
    public void startCleanup(Configuration config) {
        try {
            ZooKeeperCleanup.startInstance(config);
        }
        catch (Exception e) {
            LOG.warn((Object)"Cleanup instance didn't start.");
        }
    }

    public void create(TempletonStorage.Type type, String id) throws IOException {
        boolean wasCreated = false;
        try {
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.zk.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(this.makeZnode(type, id));
            wasCreated = true;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception ex) {
            throw new IOException("Error creating " + this.makeZnode(type, id), ex);
        }
        if (wasCreated) {
            try {
                if (type.equals((Object)TempletonStorage.Type.JOB)) {
                    JobStateTracker jt = new JobStateTracker(id, this.zk, false, this.job_trackingpath);
                    jt.create();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error tracking (jobId=" + id + "): " + e.getMessage()));
                try {
                    this.zk.delete().forPath(this.makeZnode(type, id));
                }
                catch (Exception ex) {
                    throw new IOException("Failed to delete " + this.makeZnode(type, id) + ":" + ex);
                }
            }
        }
        try {
            if (this.zk.checkExists().forPath(this.makeZnode(type, id)) == null) {
                throw new IOException("Unable to create " + this.makeZnode(type, id));
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (wasCreated) {
            try {
                this.saveField(type, id, "created", Long.toString(System.currentTimeMillis()));
            }
            catch (NotFoundException nfe) {
                throw new IOException("Couldn't write to node " + id, nfe);
            }
        }
    }

    public String getPath(TempletonStorage.Type type) {
        String typepath = this.overhead_path;
        switch (type) {
            case JOB: {
                typepath = this.job_path;
                break;
            }
            case JOBTRACKING: {
                typepath = this.job_trackingpath;
            }
        }
        return typepath;
    }

    public static String[] getPaths(String fullpath) {
        ArrayList<String> paths = new ArrayList<String>();
        if (fullpath.length() < 2) {
            paths.add(fullpath);
        } else {
            int location = 0;
            while ((location = fullpath.indexOf("/", location + 1)) > 0) {
                paths.add(fullpath.substring(0, location));
            }
            paths.add(fullpath);
        }
        String[] strings = new String[paths.size()];
        return paths.toArray(strings);
    }

    private void setFieldData(TempletonStorage.Type type, String id, String name, String val) throws Exception {
        try {
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.zk.create().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(this.makeFieldZnode(type, id, name), val.getBytes(ENCODING));
        }
        catch (KeeperException.NodeExistsException e) {
            this.zk.setData().forPath(this.makeFieldZnode(type, id, name), val.getBytes(ENCODING));
        }
    }

    public String makeFieldZnode(TempletonStorage.Type type, String id, String name) {
        return this.makeZnode(type, id) + "/" + name;
    }

    public String makeZnode(TempletonStorage.Type type, String id) {
        return this.getPath(type) + "/" + id;
    }

    @Override
    public void saveField(TempletonStorage.Type type, String id, String key, String val) throws NotFoundException {
        try {
            if (val != null) {
                this.create(type, id);
                this.setFieldData(type, id, key, val);
            }
        }
        catch (Exception e) {
            throw new NotFoundException("Writing " + key + ": " + val + ", " + e.getMessage());
        }
    }

    @Override
    public String getField(TempletonStorage.Type type, String id, String key) {
        try {
            byte[] b = (byte[])this.zk.getData().forPath(this.makeFieldZnode(type, id, key));
            return new String(b, ENCODING);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean delete(TempletonStorage.Type type, String id) throws NotFoundException {
        try {
            for (String child : (List)this.zk.getChildren().forPath(this.makeZnode(type, id))) {
                try {
                    this.zk.delete().forPath(this.makeFieldZnode(type, id, child));
                }
                catch (Exception e) {
                    throw new NotFoundException("Couldn't delete " + this.makeFieldZnode(type, id, child));
                }
            }
            try {
                this.zk.delete().forPath(this.makeZnode(type, id));
            }
            catch (Exception e) {
                throw new NotFoundException("Couldn't delete " + this.makeZnode(type, id));
            }
        }
        catch (Exception e) {
            throw new NotFoundException("Couldn't get children of " + this.makeZnode(type, id));
        }
        return true;
    }

    @Override
    public List<String> getAllForType(TempletonStorage.Type type) {
        try {
            return (List)this.zk.getChildren().forPath(this.getPath(type));
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    @Override
    public void openStorage(Configuration config) throws IOException {
        this.storage_root = config.get("templeton.storage.root");
        this.job_path = this.storage_root + "/jobs";
        this.job_trackingpath = this.storage_root + TRACKINGDIR;
        this.overhead_path = this.storage_root + "/overhead";
        if (this.zk == null) {
            this.zk = ZooKeeperStorage.zkOpen(config);
        }
    }

    @Override
    public void closeStorage() throws IOException {
        this.close();
    }
}

