/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.apache.hive.hcatalog.templeton.tool.JobStateTracker;
import org.apache.hive.hcatalog.templeton.tool.ZooKeeperStorage;

public class ZooKeeperCleanup
extends Thread {
    protected Configuration appConf;
    public static final String ZK_CLEANUP_INTERVAL = "templeton.zookeeper.cleanup.interval";
    public static final String ZK_CLEANUP_MAX_AGE = "templeton.zookeeper.cleanup.maxage";
    protected static long interval = 43200000L;
    protected static long maxage = 604800000L;
    private static final Log LOG = LogFactory.getLog(ZooKeeperCleanup.class);
    private boolean stop = false;
    private static ZooKeeperCleanup thisclass = null;
    private static boolean isRunning = false;

    private ZooKeeperCleanup(Configuration appConf) {
        this.appConf = appConf;
        interval = appConf.getLong(ZK_CLEANUP_INTERVAL, interval);
        maxage = appConf.getLong(ZK_CLEANUP_MAX_AGE, maxage);
    }

    public static ZooKeeperCleanup getInstance(Configuration appConf) {
        if (thisclass != null) {
            return thisclass;
        }
        thisclass = new ZooKeeperCleanup(appConf);
        return thisclass;
    }

    public static void startInstance(Configuration appConf) throws IOException {
        if (!isRunning) {
            ZooKeeperCleanup.getInstance(appConf).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CuratorFramework zk = null;
        List<String> nodes = null;
        isRunning = true;
        while (!this.stop) {
            try {
                try {
                    String node;
                    boolean deleted;
                    zk = ZooKeeperStorage.zkOpen(this.appConf);
                    nodes = this.getChildList(zk);
                    Iterator<String> iterator = nodes.iterator();
                    while (iterator.hasNext() && (deleted = this.checkAndDelete(node = iterator.next(), zk))) {
                    }
                    zk.close();
                }
                catch (Exception e) {
                    LOG.error((Object)("Cleanup cycle failed: " + e.getMessage()));
                }
                finally {
                    if (zk != null) {
                        zk.close();
                    }
                }
                long sleepMillis = (long)(Math.random() * (double)interval);
                LOG.info((Object)("Next execution: " + new Date(new Date().getTime() + sleepMillis)));
                Thread.sleep(sleepMillis);
            }
            catch (Exception e) {
                isRunning = false;
                LOG.error((Object)("Cleanup failed: " + e.getMessage()), (Throwable)e);
            }
        }
        isRunning = false;
    }

    public List<String> getChildList(CuratorFramework zk) {
        try {
            List<String> jobs = JobStateTracker.getTrackingJobs(this.appConf, zk);
            Collections.sort(jobs);
            return jobs;
        }
        catch (IOException e) {
            LOG.info((Object)"No jobs to check.");
            return new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndDelete(String node, CuratorFramework zk) {
        JobState state = null;
        try {
            JobStateTracker tracker = new JobStateTracker(node, zk, true, this.appConf.get("templeton.storage.root/created"));
            long now = new Date().getTime();
            state = new JobState(tracker.getJobID(), this.appConf);
            long then = 0L;
            if (state.getCreated() != null) {
                then = state.getCreated();
            }
            if (now - then > maxage) {
                LOG.info((Object)("Deleting " + tracker.getJobID()));
                state.delete();
                tracker.delete();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOG.info((Object)("checkAndDelete failed for " + node + " due to: " + e.getMessage()));
            boolean bl = true;
            return bl;
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                }
                catch (IOException e) {
                    LOG.info((Object)"Couldn't close job state.");
                }
            }
        }
    }

    public void exit() {
        this.stop = true;
    }
}

