/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.ColumnDesc;
import org.apache.hive.hcatalog.templeton.DatabaseDesc;
import org.apache.hive.hcatalog.templeton.ExecBean;
import org.apache.hive.hcatalog.templeton.ExecService;
import org.apache.hive.hcatalog.templeton.HcatException;
import org.apache.hive.hcatalog.templeton.JsonBuilder;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.PartitionDesc;
import org.apache.hive.hcatalog.templeton.SecureProxySupport;
import org.apache.hive.hcatalog.templeton.SimpleWebException;
import org.apache.hive.hcatalog.templeton.TableDesc;
import org.apache.hive.hcatalog.templeton.TableLikeDesc;
import org.apache.hive.hcatalog.templeton.TablePropertyDesc;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

public class HcatDelegator
extends LauncherDelegator {
    private static final Log LOG = LogFactory.getLog(HcatDelegator.class);
    private ExecService execService;

    public HcatDelegator(AppConfig appConf, ExecService execService) {
        super(appConf);
        this.execService = execService;
    }

    public ExecBean run(String user, String exec, boolean format, String group, String permissions) throws NotAuthorizedException, BusyException, ExecuteException, IOException {
        try (SecureProxySupport proxy = new SecureProxySupport();){
            List<String> args = this.makeArgs(exec, format, group, permissions);
            proxy.open(user, this.appConf);
            String cp = HcatDelegator.makeOverrideClasspath(this.appConf);
            Map<String, String> env = TempletonUtils.hadoopUserEnv(user, cp);
            proxy.addEnv(env);
            proxy.addArgs(args);
            if (this.appConf.clusterHcat().toLowerCase().endsWith(".py")) {
                ExecBean execBean = this.execService.run(this.appConf.clusterPython(), args, env);
                return execBean;
            }
            ExecBean execBean = this.execService.run(this.appConf.clusterHcat(), args, env);
            return execBean;
        }
    }

    private List<String> makeArgs(String exec, boolean format, String group, String permissions) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.appConf.clusterHcat().toLowerCase().endsWith(".py")) {
            args.add(this.appConf.clusterHcat());
        }
        args.add("-e");
        args.add('\"' + exec + '\"');
        if (TempletonUtils.isset(group)) {
            args.add("-g");
            args.add(group);
        }
        if (TempletonUtils.isset(permissions)) {
            args.add("-p");
            args.add(permissions);
        }
        if (format) {
            args.add("-D");
            args.add("hive.ddl.output.format=json");
            args.add("-D");
            args.add("hive.format=json");
        }
        LOG.info((Object)("Main.getAppConfigInstance().get(AppConfig.UNIT_TEST_MODE)=" + Main.getAppConfigInstance().get("templeton.unit.test.mode")));
        if (System.getProperty("test.warehouse.dir") != null) {
            args.add("-D");
            args.add("hive.metastore.warehouse.dir=" + System.getProperty("test.warehouse.dir"));
        }
        return args;
    }

    public Response descDatabase(String user, String db, boolean extended) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = "desc database " + db + "; ";
        if (extended) {
            exec = "desc database extended " + db + "; ";
        }
        try {
            String res = this.jsonRun(user, exec);
            return JsonBuilder.create(res).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to describe database: " + db, e.execBean, exec);
        }
    }

    public Response listDatabases(String user, String dbPattern) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("show databases like '%s';", dbPattern);
        try {
            String res = this.jsonRun(user, exec);
            return JsonBuilder.create(res).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to show databases for: " + dbPattern, e.execBean, exec);
        }
    }

    public Response createDatabase(String user, DatabaseDesc desc) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = "create database";
        if (desc.ifNotExists) {
            exec = exec + " if not exists";
        }
        exec = exec + " " + desc.database;
        if (TempletonUtils.isset(desc.comment)) {
            exec = exec + String.format(" comment '%s'", desc.comment);
        }
        if (TempletonUtils.isset(desc.location)) {
            exec = exec + String.format(" location '%s'", desc.location);
        }
        if (TempletonUtils.isset(desc.properties)) {
            exec = exec + String.format(" with dbproperties (%s)", this.makePropertiesStatement(desc.properties));
        }
        exec = exec + ";";
        String res = this.jsonRun(user, exec, desc.group, desc.permissions);
        return JsonBuilder.create(res).put("database", desc.database).build();
    }

    public Response dropDatabase(String user, String db, boolean ifExists, String option, String group, String permissions) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = "drop database";
        if (ifExists) {
            exec = exec + " if exists";
        }
        exec = exec + " " + db;
        if (TempletonUtils.isset(option)) {
            exec = exec + " " + option;
        }
        exec = exec + ";";
        String res = this.jsonRun(user, exec, group, permissions);
        return JsonBuilder.create(res).put("database", db).build();
    }

    public Response createTable(String user, String db, TableDesc desc) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = this.makeCreateTable(db, desc);
        try {
            String res = this.jsonRun(user, exec, desc.group, desc.permissions, true);
            return JsonBuilder.create(res).put("database", db).put("table", desc.table).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to create table: " + desc.table, e.execBean, exec);
        }
    }

    public Response createTableLike(String user, String db, TableLikeDesc desc) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; create", db);
        if (desc.external) {
            exec = exec + " external";
        }
        exec = exec + String.format(" table %s like %s", desc.newTable, desc.existingTable);
        if (TempletonUtils.isset(desc.location)) {
            exec = exec + String.format(" location '%s'", desc.location);
        }
        exec = exec + ";";
        try {
            String res = this.jsonRun(user, exec, desc.group, desc.permissions, true);
            return JsonBuilder.create(res).put("database", db).put("table", desc.newTable).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to create table: " + desc.newTable, e.execBean, exec);
        }
    }

    public Response descTable(String user, String db, String table, boolean extended) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = "use " + db + "; ";
        exec = extended ? exec + "desc extended " + table + "; " : exec + "desc " + table + "; ";
        try {
            String res = this.jsonRun(user, exec);
            return JsonBuilder.create(res).put("database", db).put("table", table).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to describe database: " + db, e.execBean, exec);
        }
    }

    public Response listTables(String user, String db, String tablePattern) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; show tables like '%s';", db, tablePattern);
        try {
            String res = this.jsonRun(user, exec);
            return JsonBuilder.create(res).put("database", db).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to show tables for: " + tablePattern, e.execBean, exec);
        }
    }

    public Response descExtendedTable(String user, String db, String table) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; show table extended like %s;", db, table);
        try {
            Response res0 = this.descTable(user, db, table, true);
            if (res0.getStatus() != 200) {
                return res0;
            }
            Map m = (Map)res0.getEntity();
            Map tableInfo = (Map)m.get("tableInfo");
            String res = this.jsonRun(user, exec);
            JsonBuilder jb = JsonBuilder.create(this.singleTable(res, table)).remove("tableName").put("database", db).put("table", table).put("retention", tableInfo.get("retention")).put("sd", tableInfo.get("sd")).put("parameters", tableInfo.get("parameters")).put("parametersSize", tableInfo.get("parametersSize")).put("tableType", tableInfo.get("tableType"));
            String loc = (String)jb.getMap().get("location");
            if (loc != null && loc.startsWith("hdfs://")) {
                try {
                    FileSystem fs = FileSystem.get((Configuration)this.appConf);
                    FileStatus status = fs.getFileStatus(new Path(new URI(loc)));
                    jb.put("group", status.getGroup());
                    jb.put("permission", status.getPermission().toString());
                }
                catch (Exception e) {
                    LOG.warn((Object)(e.getMessage() + " Couldn't get permissions for " + loc));
                }
            }
            return jb.build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to show table: " + table, e.execBean, exec);
        }
    }

    private String makeCols(List<ColumnDesc> cols) {
        ArrayList<String> res = new ArrayList<String>();
        for (ColumnDesc col : cols) {
            res.add(this.makeOneCol(col));
        }
        return StringUtils.join(res, (String)", ");
    }

    private String makeOneCol(ColumnDesc col) {
        String res = String.format("%s %s", col.name, col.type);
        if (TempletonUtils.isset(col.comment)) {
            res = res + String.format(" comment '%s'", col.comment);
        }
        return res;
    }

    private String makeCreateTable(String db, TableDesc desc) {
        String exec = String.format("use %s; create", db);
        if (desc.external) {
            exec = exec + " external";
        }
        exec = exec + " table";
        if (desc.ifNotExists) {
            exec = exec + " if not exists";
        }
        exec = exec + " " + desc.table;
        if (TempletonUtils.isset(desc.columns)) {
            exec = exec + String.format("(%s)", this.makeCols(desc.columns));
        }
        if (TempletonUtils.isset(desc.comment)) {
            exec = exec + String.format(" comment '%s'", desc.comment);
        }
        if (TempletonUtils.isset(desc.partitionedBy)) {
            exec = exec + String.format(" partitioned by (%s)", this.makeCols(desc.partitionedBy));
        }
        if (desc.clusteredBy != null) {
            exec = exec + String.format(" clustered by %s", this.makeClusteredBy(desc.clusteredBy));
        }
        if (desc.format != null) {
            exec = exec + " " + this.makeStorageFormat(desc.format);
        }
        if (TempletonUtils.isset(desc.location)) {
            exec = exec + String.format(" location '%s'", desc.location);
        }
        if (TempletonUtils.isset(desc.tableProperties)) {
            exec = exec + String.format(" tblproperties (%s)", this.makePropertiesStatement(desc.tableProperties));
        }
        exec = exec + ";";
        return exec;
    }

    private String makeClusteredBy(TableDesc.ClusteredByDesc desc) {
        String res = String.format("(%s)", StringUtils.join(desc.columnNames, (String)", "));
        if (TempletonUtils.isset(desc.sortedBy)) {
            res = res + String.format(" sorted by (%s)", this.makeClusterSortList(desc.sortedBy));
        }
        res = res + String.format(" into %s buckets", desc.numberOfBuckets);
        return res;
    }

    private String makeClusterSortList(List<TableDesc.ClusterSortOrderDesc> descs) {
        ArrayList<String> res = new ArrayList<String>();
        for (TableDesc.ClusterSortOrderDesc desc : descs) {
            res.add(this.makeOneClusterSort(desc));
        }
        return StringUtils.join(res, (String)", ");
    }

    private String makeOneClusterSort(TableDesc.ClusterSortOrderDesc desc) {
        return String.format("%s %s", desc.columnName, desc.order.toString());
    }

    private String makeStorageFormat(TableDesc.StorageFormatDesc desc) {
        String res = "";
        if (desc.rowFormat != null) {
            res = res + this.makeRowFormat(desc.rowFormat);
        }
        if (TempletonUtils.isset(desc.storedAs)) {
            res = res + String.format(" stored as %s", desc.storedAs);
        }
        if (desc.storedBy != null) {
            res = res + " " + this.makeStoredBy(desc.storedBy);
        }
        return res;
    }

    private String makeRowFormat(TableDesc.RowFormatDesc desc) {
        String res = this.makeTermBy(desc.fieldsTerminatedBy, "fields") + this.makeTermBy(desc.collectionItemsTerminatedBy, "collection items") + this.makeTermBy(desc.mapKeysTerminatedBy, "map keys") + this.makeTermBy(desc.linesTerminatedBy, "lines");
        if (TempletonUtils.isset(res)) {
            return "row format delimited" + res;
        }
        if (desc.serde != null) {
            return this.makeSerdeFormat(desc.serde);
        }
        return "";
    }

    private String makeTermBy(String sep, String fieldName) {
        if (TempletonUtils.isset(sep)) {
            return String.format(" %s terminated by '%s'", fieldName, sep);
        }
        return "";
    }

    private String makeSerdeFormat(TableDesc.SerdeDesc desc) {
        String res = "row format serde " + desc.name;
        if (TempletonUtils.isset(desc.properties)) {
            res = res + String.format(" with serdeproperties (%s)", this.makePropertiesStatement(desc.properties));
        }
        return res;
    }

    private String makePropertiesStatement(Map<String, String> properties) {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            res.add(String.format("'%s'='%s'", e.getKey(), e.getValue()));
        }
        return StringUtils.join(res, (String)", ");
    }

    private String makeStoredBy(TableDesc.StoredByDesc desc) {
        String res = String.format("stored by '%s'", desc.className);
        if (TempletonUtils.isset(desc.properties)) {
            res = res + String.format(" with serdeproperties (%s)", this.makePropertiesStatement(desc.properties));
        }
        return res;
    }

    private String singleTable(String json, String table) throws IOException {
        Map obj = JsonBuilder.jsonToMap(json);
        if (JsonBuilder.isError(obj)) {
            return json;
        }
        List tables = (List)obj.get("tables");
        if (TempletonUtils.isset(tables)) {
            return JsonBuilder.mapToJson(tables.get(0));
        }
        return JsonBuilder.createError(ErrorMsg.INVALID_TABLE.format(table), ErrorMsg.INVALID_TABLE.getErrorCode()).buildJson();
    }

    public Response dropTable(String user, String db, String table, boolean ifExists, String group, String permissions) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; drop table", db);
        if (ifExists) {
            exec = exec + " if exists";
        }
        exec = exec + String.format(" %s;", table);
        try {
            String res = this.jsonRun(user, exec, group, permissions, true);
            return JsonBuilder.create(res).put("database", db).put("table", table).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to drop table: " + table, e.execBean, exec);
        }
    }

    public Response renameTable(String user, String db, String oldTable, String newTable, String group, String permissions) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; alter table %s rename to %s;", db, oldTable, newTable);
        try {
            String res = this.jsonRun(user, exec, group, permissions, true);
            return JsonBuilder.create(res).put("database", db).put("table", newTable).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to rename table: " + oldTable, e.execBean, exec);
        }
    }

    public Response descTableProperty(String user, String db, String table, String property) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String value;
        Response res = this.descTable(user, db, table, true);
        if (res.getStatus() != 200) {
            return res;
        }
        Map props = this.tableProperties(res.getEntity());
        HashMap<String, String> found = null;
        if (props != null && (value = (String)props.get(property)) != null) {
            found = new HashMap<String, String>();
            found.put(property, value);
        }
        return JsonBuilder.create().put("database", db).put("table", table).put("property", found).build();
    }

    public Response listTableProperties(String user, String db, String table) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        Response res = this.descTable(user, db, table, true);
        if (res.getStatus() != 200) {
            return res;
        }
        Map props = this.tableProperties(res.getEntity());
        return JsonBuilder.create().put("database", db).put("table", table).put("properties", props).build();
    }

    public Response addOneTableProperty(String user, String db, String table, TablePropertyDesc desc) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; alter table %s set tblproperties ('%s'='%s');", db, table, desc.name, desc.value);
        try {
            String res = this.jsonRun(user, exec, desc.group, desc.permissions, true);
            return JsonBuilder.create(res).put("database", db).put("table", table).put("property", desc.name).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to add table property: " + table, e.execBean, exec);
        }
    }

    private Map tableProperties(Object extendedTable) {
        if (!(extendedTable instanceof Map)) {
            return null;
        }
        Map m = (Map)extendedTable;
        Map tableInfo = (Map)m.get("tableInfo");
        if (tableInfo == null) {
            return null;
        }
        return (Map)tableInfo.get("parameters");
    }

    public Response listPartitions(String user, String db, String table) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = "use " + db + "; ";
        exec = exec + "show partitions " + table + "; ";
        try {
            String res = this.jsonRun(user, exec);
            return JsonBuilder.create(res).put("database", db).put("table", table).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to show partitions for table: " + table, e.execBean, exec);
        }
    }

    public Response descOnePartition(String user, String db, String table, String partition) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = "use " + db + "; ";
        exec = exec + "show table extended like " + table + " partition (" + partition + "); ";
        try {
            String res = this.jsonRun(user, exec);
            return JsonBuilder.create(this.singleTable(res, table)).remove("tableName").put("database", db).put("table", table).put("partition", partition).build();
        }
        catch (HcatException e) {
            if (e.execBean.stderr.contains("SemanticException") && e.execBean.stderr.contains("Partition not found")) {
                String emsg = "Partition " + partition + " for table " + table + " does not exist" + db + "." + table + " does not exist";
                return JsonBuilder.create().put("error", emsg).put("errorCode", ErrorMsg.INVALID_PARTITION.getErrorCode()).put("database", db).put("table", table).put("partition", partition).build();
            }
            throw new HcatException("unable to show partition: " + table + " " + partition, e.execBean, exec);
        }
    }

    public Response addOnePartition(String user, String db, String table, PartitionDesc desc) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; alter table %s add", db, table);
        if (desc.ifNotExists) {
            exec = exec + " if not exists";
        }
        exec = exec + String.format(" partition (%s)", desc.partition);
        if (TempletonUtils.isset(desc.location)) {
            exec = exec + String.format(" location '%s'", desc.location);
        }
        exec = exec + ";";
        try {
            String res = this.jsonRun(user, exec, desc.group, desc.permissions, true);
            if (res.indexOf("AlreadyExistsException") > -1) {
                return JsonBuilder.create().put("error", "Partition already exists").put("errorCode", ErrorMsg.PARTITION_EXISTS.getErrorCode()).put("database", db).put("table", table).put("partition", desc.partition).build();
            }
            return JsonBuilder.create(res).put("database", db).put("table", table).put("partition", desc.partition).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to add partition: " + desc, e.execBean, exec);
        }
    }

    public Response dropPartition(String user, String db, String table, String partition, boolean ifExists, String group, String permissions) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; alter table %s drop", db, table);
        if (ifExists) {
            exec = exec + " if exists";
        }
        exec = exec + String.format(" partition (%s);", partition);
        try {
            String res = this.jsonRun(user, exec, group, permissions, true);
            return JsonBuilder.create(res).put("database", db).put("table", table).put("partition", partition).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to drop partition: " + partition, e.execBean, exec);
        }
    }

    public Response listColumns(String user, String db, String table) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        try {
            return this.descTable(user, db, table, false);
        }
        catch (HcatException e) {
            throw new HcatException("unable to show columns for table: " + table, e.execBean, e.statement);
        }
    }

    public Response descOneColumn(String user, String db, String table, String column) throws SimpleWebException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        Map fields;
        Response res = this.listColumns(user, db, table);
        if (res.getStatus() != 200) {
            return res;
        }
        Object o = res.getEntity();
        Map map = fields = o != null && o instanceof Map ? (Map)o : null;
        if (fields == null) {
            throw new SimpleWebException(404, "Internal error, unable to find column " + column);
        }
        List cols = (List)fields.get("columns");
        Map found = null;
        if (cols != null) {
            for (Map col : cols) {
                if (!column.equals(col.get("name"))) continue;
                found = col;
                break;
            }
        }
        if (found == null) {
            throw new SimpleWebException(404, "unable to find column " + column, (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("description", fields);
                }
            });
        }
        fields.remove("columns");
        fields.put("column", found);
        return Response.fromResponse((Response)res).entity((Object)fields).build();
    }

    public Response addOneColumn(String user, String db, String table, ColumnDesc desc) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        String exec = String.format("use %s; alter table %s add columns (%s %s", db, table, desc.name, desc.type);
        if (TempletonUtils.isset(desc.comment)) {
            exec = exec + String.format(" comment '%s'", desc.comment);
        }
        exec = exec + ");";
        try {
            String res = this.jsonRun(user, exec, desc.group, desc.permissions, true);
            return JsonBuilder.create(res).put("database", db).put("table", table).put("column", desc.name).build();
        }
        catch (HcatException e) {
            throw new HcatException("unable to add column: " + desc, e.execBean, exec);
        }
    }

    private boolean isValid(ExecBean eb, boolean requireEmptyOutput) {
        if (eb == null) {
            return false;
        }
        try {
            Map m = JsonBuilder.jsonToMap(eb.stdout);
            if (m.containsKey("error")) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        if (eb.exitcode != 0) {
            return false;
        }
        return !requireEmptyOutput || !TempletonUtils.isset(eb.stdout);
    }

    private String jsonRun(String user, String exec, String group, String permissions, boolean requireEmptyOutput) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        ExecBean res = this.run(user, exec, true, group, permissions);
        if (!this.isValid(res, requireEmptyOutput)) {
            throw new HcatException("Failure calling hcat: " + exec, res, exec);
        }
        return res.stdout;
    }

    private String jsonRun(String user, String exec) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        return this.jsonRun(user, exec, null, null);
    }

    private String jsonRun(String user, String exec, String group, String permissions) throws HcatException, NotAuthorizedException, BusyException, ExecuteException, IOException {
        return this.jsonRun(user, exec, group, permissions, false);
    }
}

