/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.grafana.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hertzbeat.common.entity.grafana.GrafanaDashboard;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.grafana.common.GrafanaConstants;
import org.apache.hertzbeat.grafana.config.GrafanaProperties;
import org.apache.hertzbeat.grafana.dao.DashboardDao;
import org.apache.hertzbeat.grafana.service.DatasourceService;
import org.apache.hertzbeat.grafana.service.ServiceAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class DashboardService {
    private static final Logger log = LoggerFactory.getLogger(DashboardService.class);
    @Autowired
    private ServiceAccountService serviceAccountService;
    @Autowired
    private DashboardDao dashboardDao;
    @Autowired
    private GrafanaProperties grafanaProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DatasourceService datasourceService;

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> createOrUpdateDashboard(String dashboardJson, Long monitorId) {
        Map dashboardObjectMap;
        if (!this.grafanaProperties.enabled()) {
            log.info("HertzBeat Grafana config not enabled");
            throw new RuntimeException("HertzBeat Grafana config not enabled");
        }
        String token = this.serviceAccountService.getToken();
        String url = this.grafanaProperties.getPrefix() + this.grafanaProperties.getUrl() + "/api/dashboards/db";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        try {
            dashboardObjectMap = (Map)JsonUtil.fromJson((String)dashboardJson, Map.class);
        }
        catch (Exception e) {
            log.error("Failed to parse dashboardJson. Monitor ID: {}. JSON: {}", new Object[]{monitorId, dashboardJson, e});
            throw new RuntimeException("Invalid dashboard JSON structure", e);
        }
        if (dashboardObjectMap == null) {
            log.error("Parsed dashboardJson is null. Monitor ID: {}. Original JSON: {}", (Object)monitorId, (Object)dashboardJson);
            throw new RuntimeException("Parsed dashboard JSON is null");
        }
        if (dashboardObjectMap.containsKey("id")) {
            dashboardObjectMap.remove("id");
            log.debug("Removed 'id' field from dashboard JSON for monitorId: {}", (Object)monitorId);
        }
        HashMap<String, Object> requestPayload = new HashMap<String, Object>();
        requestPayload.put("dashboard", dashboardObjectMap);
        requestPayload.put("overwrite", true);
        String finalJsonPayload = JsonUtil.toJson(requestPayload);
        HttpEntity requestEntity = new HttpEntity((Object)finalJsonPayload, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                GrafanaDashboard grafanaDashboard = (GrafanaDashboard)JsonUtil.fromJson((String)((String)response.getBody()), GrafanaDashboard.class);
                if (grafanaDashboard != null) {
                    grafanaDashboard.setEnabled(true);
                    String currentDatasourceName = this.datasourceService.getCurrentDatasourceName();
                    String useDatasource = currentDatasourceName != null ? GrafanaConstants.generateUseDatasource(currentDatasourceName) : "";
                    String relativeDashboardUrl = grafanaDashboard.getUrl();
                    String fullDashboardUrl = this.grafanaProperties.exposeUrl().replaceAll("/$", "") + relativeDashboardUrl;
                    grafanaDashboard.setUrl(fullDashboardUrl + "?kiosk=tv&refresh=15s&var-instance=" + monitorId + useDatasource);
                    grafanaDashboard.setMonitorId(monitorId);
                    this.dashboardDao.save(grafanaDashboard);
                    log.info("Successfully created/updated Grafana dashboard for monitorId: {}. Response: {}", (Object)monitorId, response.getBody());
                } else {
                    log.error("Failed to parse Grafana response into GrafanaDashboard object. MonitorId: {}. Response body: {}", (Object)monitorId, response.getBody());
                }
                return response;
            }
            log.error("Failed to create/update Grafana dashboard for monitorId: {}. Status: {}, Response: {}", new Object[]{monitorId, response.getStatusCode(), response.getBody()});
            throw new RuntimeException("Failed to create/update Grafana dashboard: " + response.getStatusCode() + " - " + (String)response.getBody());
        }
        catch (HttpClientErrorException ex) {
            String responseBody = ex.getResponseBodyAsString();
            log.error("Grafana API request failed for monitorId: {}. Status: {}. URL: {}. Request: {}. Response: {}", new Object[]{monitorId, ex.getStatusCode(), url, finalJsonPayload, responseBody, ex});
            if (ex instanceof HttpClientErrorException.Forbidden) {
                throw new RuntimeException("Grafana Access Denied: " + responseBody, ex);
            }
            if (ex instanceof HttpClientErrorException.NotFound) {
                throw new RuntimeException("Grafana API endpoint or resource not found: " + responseBody, ex);
            }
            throw new RuntimeException("Grafana API client error (" + ex.getStatusCode() + "): " + responseBody, ex);
        }
        catch (Exception ex) {
            log.error("An unexpected error occurred while creating/updating Grafana dashboard for monitorId: {}. URL: {}. Request: {}", new Object[]{monitorId, url, finalJsonPayload, ex});
            throw new RuntimeException("Error during Grafana dashboard operation: " + ex.getMessage(), ex);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteDashboard(Long monitorId) {
        GrafanaDashboard grafanaDashboard = this.dashboardDao.findByMonitorId(monitorId);
        if (Objects.isNull(grafanaDashboard)) {
            log.info("No Grafana dashboard found for monitorId {} to delete.", (Object)monitorId);
            return;
        }
        String uid = grafanaDashboard.getUid();
        List<GrafanaDashboard> grafanaDashboards = this.dashboardDao.findByUid(uid);
        if (grafanaDashboards.size() > 1) {
            this.dashboardDao.deleteByMonitorId(monitorId);
            log.info("Deleted hertzbeat dashboard record for monitorId: {}, Grafana dashboard with UID: {} still used by other monitors.", (Object)monitorId, (Object)uid);
        } else {
            String token = this.serviceAccountService.getToken();
            String url = this.grafanaProperties.getPrefix() + this.grafanaProperties.getUrl() + String.format("/api/dashboards/uid/%s", uid);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(token);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            try {
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                if (!response.getStatusCode().is2xxSuccessful()) {
                    log.error("Failed to delete Grafana dashboard with UID: {}. Status: {}, Response: {}", new Object[]{uid, response.getStatusCode(), response.getBody()});
                    throw new RuntimeException("Failed to delete Grafana dashboard: " + response.getStatusCode() + " - " + (String)response.getBody());
                }
                this.dashboardDao.deleteByMonitorId(monitorId);
                log.info("Successfully deleted Grafana dashboard with UID: {} and corresponding hertzbeat record for monitorId: {}", (Object)uid, (Object)monitorId);
            }
            catch (HttpClientErrorException ex) {
                String responseBody = ex.getResponseBodyAsString();
                log.error("Grafana API request failed during dashboard deletion for UID: {}. Status: {}. URL: {}. Response: {}", new Object[]{uid, ex.getStatusCode(), url, responseBody, ex});
                if (ex.getStatusCode() == HttpStatus.NOT_FOUND) {
                    log.warn("Grafana dashboard with UID: {} not found during deletion attempt. Assuming already deleted. Deleting local record for monitorId: {}", (Object)uid, (Object)monitorId);
                    this.dashboardDao.deleteByMonitorId(monitorId);
                }
                throw new RuntimeException("Grafana API client error during deletion (" + ex.getStatusCode() + "): " + responseBody, ex);
            }
            catch (Exception ex) {
                log.error("An unexpected error occurred while deleting Grafana dashboard with UID: {}. URL: {}", new Object[]{uid, url, ex});
                throw new RuntimeException("Error during Grafana dashboard deletion: " + ex.getMessage(), ex);
            }
        }
    }

    public GrafanaDashboard getDashboardByMonitorId(Long monitorId) {
        return this.dashboardDao.findByMonitorId(monitorId);
    }

    public void closeGrafanaDashboard(Long monitorId) {
        GrafanaDashboard grafanaDashboard = this.dashboardDao.findByMonitorId(monitorId);
        if (grafanaDashboard != null) {
            if (grafanaDashboard.isEnabled()) {
                grafanaDashboard.setEnabled(false);
                this.dashboardDao.save(grafanaDashboard);
                log.info("Disabled Grafana dashboard link in HertzBeat for monitorId: {}", (Object)monitorId);
            } else {
                log.info("Grafana dashboard link for monitorId: {} was already disabled.", (Object)monitorId);
            }
        } else {
            log.warn("No Grafana dashboard record found for monitorId {} to disable.", (Object)monitorId);
        }
    }
}

