/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.management.JMException;
import org.apache.helix.zookeeper.api.client.ChildrenSubscribeResult;
import org.apache.helix.zookeeper.datamodel.SessionAwareZNRecord;
import org.apache.helix.zookeeper.exception.ZkClientException;
import org.apache.helix.zookeeper.util.GZipCompressionUtil;
import org.apache.helix.zookeeper.util.ZNRecordUtil;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkConnection;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.RecursivePersistListener;
import org.apache.helix.zookeeper.zkclient.ZkConnection;
import org.apache.helix.zookeeper.zkclient.ZkEventThread;
import org.apache.helix.zookeeper.zkclient.ZkLock;
import org.apache.helix.zookeeper.zkclient.annotation.PreFetchChangedData;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallMonitorContext;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallbacks;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncRetryCallContext;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncRetryThread;
import org.apache.helix.zookeeper.zkclient.deprecated.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.exception.ZkBadVersionException;
import org.apache.helix.zookeeper.zkclient.exception.ZkException;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.apache.helix.zookeeper.zkclient.exception.ZkMarshallingError;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.apache.helix.zookeeper.zkclient.exception.ZkNodeExistsException;
import org.apache.helix.zookeeper.zkclient.exception.ZkSessionMismatchedException;
import org.apache.helix.zookeeper.zkclient.exception.ZkTimeoutException;
import org.apache.helix.zookeeper.zkclient.metric.ZkClientMonitor;
import org.apache.helix.zookeeper.zkclient.serialize.BasicZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.PathBasedZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.helix.zookeeper.zkclient.util.ExponentialBackoffStrategy;
import org.apache.helix.zookeeper.zkclient.util.ZkPathRecursiveWatcherTrie;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClient
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZkClient.class);
    public static final long TTL_NOT_SET = -1L;
    private static final long MAX_RECONNECT_INTERVAL_MS = 30000L;
    private static final int NUM_CHILDREN_LIMIT = 100000;
    private static final boolean SYNC_ON_SESSION = Boolean.parseBoolean(System.getProperty("zk.zkclient.autosync.enabled", "true"));
    private static final String SYNC_PATH = "/";
    private static AtomicLong UID = new AtomicLong(0L);
    public final long _uid;
    private static final int WRITE_SIZE_LIMIT = Integer.getInteger("jute.maxbuffer", 1024000);
    private final IZkConnection _connection;
    private final long _operationRetryTimeoutInMillis;
    private final Map<String, Set<IZkChildListener>> _childListener = new ConcurrentHashMap<String, Set<IZkChildListener>>();
    private final ConcurrentHashMap<String, Set<IZkDataListenerEntry>> _dataListener = new ConcurrentHashMap();
    private final ZkPathRecursiveWatcherTrie _zkPathRecursiveWatcherTrie = new ZkPathRecursiveWatcherTrie();
    private final Set<org.apache.helix.zookeeper.zkclient.IZkStateListener> _stateListener = new CopyOnWriteArraySet<org.apache.helix.zookeeper.zkclient.IZkStateListener>();
    private Watcher.Event.KeeperState _currentState;
    private final ZkLock _zkEventLock = new ZkLock();
    private boolean _isNewSessionEventFired;
    private boolean _shutdownTriggered;
    private ZkEventThread _eventThread;
    private Thread _zookeeperEventThread;
    private volatile boolean _closed;
    private PathBasedZkSerializer _pathBasedZkSerializer;
    private ZkClientMonitor _monitor;
    private boolean _usePersistWatcher;
    private final ReentrantLock _persistListenerMutex;
    protected final ZkAsyncRetryThread _asyncCallRetryThread;

    protected ZkClient(IZkConnection zkConnection, int connectionTimeout, long operationRetryTimeout, PathBasedZkSerializer zkSerializer, String monitorType, String monitorKey, String monitorInstanceName, boolean monitorRootPathOnly, boolean connectOnInit, boolean usePersistWatcher) {
        if (zkConnection == null) {
            throw new NullPointerException("Zookeeper connection is null!");
        }
        this._uid = UID.getAndIncrement();
        this.validateWriteSizeLimitConfig();
        this._connection = zkConnection;
        this._pathBasedZkSerializer = zkSerializer;
        this._operationRetryTimeoutInMillis = operationRetryTimeout;
        this._isNewSessionEventFired = false;
        this._asyncCallRetryThread = new ZkAsyncRetryThread(zkConnection.getServers());
        this._asyncCallRetryThread.start();
        LOG.debug("ZkClient created with uid {}, _asyncCallRetryThread id {}", (Object)this._uid, (Object)this._asyncCallRetryThread.getId());
        if (monitorKey != null && !monitorKey.isEmpty() && monitorType != null && !monitorType.isEmpty()) {
            this._monitor = new ZkClientMonitor(monitorType, monitorKey, monitorInstanceName, monitorRootPathOnly, this._eventThread);
        } else {
            LOG.info("ZkClient monitor key or type is not provided. Skip monitoring.");
        }
        if (connectOnInit) {
            this.connect(connectionTimeout, this);
        }
        this._usePersistWatcher = usePersistWatcher;
        this._persistListenerMutex = new ReentrantLock();
    }

    protected ZkClient(IZkConnection zkConnection, int connectionTimeout, long operationRetryTimeout, PathBasedZkSerializer zkSerializer, String monitorType, String monitorKey, String monitorInstanceName, boolean monitorRootPathOnly) {
        this(zkConnection, connectionTimeout, operationRetryTimeout, zkSerializer, monitorType, monitorKey, monitorInstanceName, monitorRootPathOnly, true, false);
    }

    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        ChildrenSubscribeResult result = this.subscribeChildChanges(path, listener, false);
        return result.getChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildrenSubscribeResult subscribeChildChanges(String path, IZkChildListener listener, boolean skipWatchingNonExistNode) {
        if (this._usePersistWatcher) {
            this.addPersistListener(path, listener);
        } else {
            Map<String, Set<IZkChildListener>> map = this._childListener;
            synchronized (map) {
                this.addChildListener(path, listener);
            }
        }
        List<String> children = this.watchForChilds(path, skipWatchingNonExistNode);
        if (children == null && skipWatchingNonExistNode) {
            this.unsubscribeChildChanges(path, listener);
            LOG.info("zkclient{}, watchForChilds failed to install no-existing watch and add listener. Path: {}", (Object)this._uid, (Object)path);
            return new ChildrenSubscribeResult(children, false);
        }
        return new ChildrenSubscribeResult(children, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeChildChanges(String path, IZkChildListener childListener) {
        if (this._usePersistWatcher) {
            this.removePersistListener(path, childListener);
        } else {
            Map<String, Set<IZkChildListener>> map = this._childListener;
            synchronized (map) {
                this.removeChildListener(path, childListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subscribeDataChanges(String path, IZkDataListener listener, boolean skipWatchingNonExistNode) {
        if (this._usePersistWatcher) {
            this.addPersistListener(path, listener);
        } else {
            ConcurrentHashMap<String, Set<IZkDataListenerEntry>> concurrentHashMap = this._dataListener;
            synchronized (concurrentHashMap) {
                this.addDataListener(path, listener);
            }
        }
        boolean watchInstalled = this.watchForData(path, skipWatchingNonExistNode);
        if (!watchInstalled) {
            this.unsubscribeDataChanges(path, listener);
            LOG.info("zkclient {} watchForData failed to install no-existing path and thus add listener. Path: {}", (Object)this._uid, (Object)path);
            return false;
        }
        LOG.debug("zkclient {}, Subscribed data changes for {}", (Object)this._uid, (Object)path);
        return true;
    }

    public void subscribeDataChanges(String path, IZkDataListener listener) {
        this.subscribeDataChanges(path, listener, false);
    }

    public void subscribePersistRecursiveListener(String path, RecursivePersistListener recursivePersistListener) {
        if (!this._usePersistWatcher) {
            throw new UnsupportedOperationException("Can not subscribe PersistRecursiveWatcher. Persist listener is not enabled.");
        }
        ManipulateListener addListener = () -> {
            if (this.hasChildOrDataListeners(path)) {
                throw new UnsupportedOperationException("Can not subscribe PersistRecursiveWatcher. There is an existing listener on " + path);
            }
            this.retryUntilConnected(() -> {
                this.getConnection().addWatch(path, this, AddWatchMode.PERSISTENT_RECURSIVE);
                return null;
            });
            this._zkPathRecursiveWatcherTrie.addRecursiveListener(path, recursivePersistListener);
        };
        this.executeWithInPersistListenerMutex(addListener);
    }

    public void unsubscribePersistRecursiveListener(String path, RecursivePersistListener recursivePersistListener) {
        if (!this._usePersistWatcher) {
            throw new UnsupportedOperationException("Can not subscribe PersistRecursiveWatcher. Persist listener is not enabled.");
        }
        ManipulateListener removeListeners = () -> {
            this._zkPathRecursiveWatcherTrie.removeRecursiveListener(path, recursivePersistListener);
            if (this._zkPathRecursiveWatcherTrie.hasListenerOnPath(path)) {
                return;
            }
            try {
                this.getConnection().removeWatches(path, this, Watcher.WatcherType.Any);
            }
            catch (KeeperException.NoWatcherException e) {
                LOG.warn("Persist watcher is already removed on path: {}", (Object)path);
            }
        };
        this.executeWithInPersistListenerMutex(removeListeners);
    }

    private boolean isPrefetchEnabled(IZkDataListener dataListener) {
        PreFetchChangedData preFetch = dataListener.getClass().getAnnotation(PreFetchChangedData.class);
        if (preFetch != null) {
            return preFetch.enabled();
        }
        Method callbackMethod = IZkDataListener.class.getMethods()[0];
        try {
            Method method = dataListener.getClass().getMethod(callbackMethod.getName(), callbackMethod.getParameterTypes());
            PreFetchChangedData preFetchInMethod = method.getAnnotation(PreFetchChangedData.class);
            if (preFetchInMethod != null) {
                return preFetchInMethod.enabled();
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Zkclient {}, No method {} defined in listener {}", new Object[]{this._uid, callbackMethod.getName(), dataListener.getClass().getCanonicalName()});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeDataChanges(String path, IZkDataListener dataListener) {
        if (this._usePersistWatcher) {
            this.removePersistListener(path, dataListener);
        } else {
            ConcurrentHashMap<String, Set<IZkDataListenerEntry>> concurrentHashMap = this._dataListener;
            synchronized (concurrentHashMap) {
                this.removeDataListener(path, dataListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeStateChanges(org.apache.helix.zookeeper.zkclient.IZkStateListener listener) {
        Set<org.apache.helix.zookeeper.zkclient.IZkStateListener> set = this._stateListener;
        synchronized (set) {
            this._stateListener.add(listener);
        }
    }

    @Deprecated
    public void subscribeStateChanges(IZkStateListener listener) {
        this.subscribeStateChanges(new IZkStateListenerI0ItecImpl(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeStateChanges(org.apache.helix.zookeeper.zkclient.IZkStateListener stateListener) {
        Set<org.apache.helix.zookeeper.zkclient.IZkStateListener> set = this._stateListener;
        synchronized (set) {
            this._stateListener.remove(stateListener);
        }
    }

    @Deprecated
    public void unsubscribeStateChanges(IZkStateListener stateListener) {
        this.unsubscribeStateChanges(new IZkStateListenerI0ItecImpl(stateListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAll() {
        if (this._usePersistWatcher) {
            ManipulateListener removeAllListeners = () -> Stream.concat(this._childListener.keySet().stream(), this._dataListener.keySet().stream()).forEach(p -> {
                try {
                    this.getConnection().removeWatches((String)p, this, Watcher.WatcherType.Any);
                }
                catch (InterruptedException | KeeperException e) {
                    LOG.error("Failed to remove persistent watcher for {} ", p, (Object)e);
                }
            });
            this.executeWithInPersistListenerMutex(removeAllListeners);
            return;
        }
        Object object = this._childListener;
        synchronized (object) {
            this._childListener.clear();
        }
        object = this._dataListener;
        synchronized (object) {
            this._dataListener.clear();
        }
        object = this._stateListener;
        synchronized (object) {
            this._stateListener.clear();
        }
    }

    public void createPersistent(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistent(path, false);
    }

    public void createPersistentWithTTL(String path, long ttl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistentWithTTL(path, false, ttl);
    }

    public void createContainer(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createContainer(path, false);
    }

    public void createPersistent(String path, boolean createParents) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistent(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    public void createPersistentWithTTL(String path, boolean createParents, long ttl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistentWithTTL(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE, ttl);
    }

    public void createContainer(String path, boolean createParents) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createContainer(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    public void createPersistent(String path, boolean createParents, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            this.create(path, null, acl, CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException e) {
            if (!createParents) {
                throw e;
            }
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createPersistent(parentDir, createParents, acl);
            this.createPersistent(path, createParents, acl);
        }
    }

    public void createPersistentWithTTL(String path, boolean createParents, List<ACL> acl, long ttl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            this.create(path, null, acl, CreateMode.PERSISTENT_WITH_TTL, ttl);
        }
        catch (ZkNodeExistsException e) {
            if (!createParents) {
                throw e;
            }
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createPersistentWithTTL(parentDir, createParents, acl, ttl);
            this.createPersistentWithTTL(path, createParents, acl, ttl);
        }
    }

    public void createContainer(String path, boolean createParents, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            this.create(path, null, acl, CreateMode.CONTAINER);
        }
        catch (ZkNodeExistsException e) {
            if (!createParents) {
                throw e;
            }
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createContainer(parentDir, createParents, acl);
            this.createContainer(path, createParents, acl);
        }
    }

    public void createPersistent(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, CreateMode.PERSISTENT);
    }

    public void createPersistentWithTTL(String path, Object data, long ttl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, CreateMode.PERSISTENT_WITH_TTL, ttl);
    }

    public void createContainer(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, CreateMode.CONTAINER);
    }

    public void createPersistent(String path, Object data, List<ACL> acl) {
        this.create(path, data, acl, CreateMode.PERSISTENT);
    }

    public void createPersistentWithTTL(String path, Object data, List<ACL> acl, long ttl) {
        this.create(path, data, acl, CreateMode.PERSISTENT_WITH_TTL, ttl);
    }

    public void createContainer(String path, Object data, List<ACL> acl) {
        this.create(path, data, acl, CreateMode.CONTAINER);
    }

    public String createPersistentSequential(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public String createPersistentSequentialWithTTL(String path, Object data, long ttl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, ttl);
    }

    public String createPersistentSequential(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, acl, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public String createPersistentSequentialWithTTL(String path, Object data, List<ACL> acl, long ttl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, acl, CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, ttl);
    }

    public void createEphemeral(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, String sessionId) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createEphemeral(path, null, sessionId);
    }

    public void createEphemeral(String path, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, acl, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, List<ACL> acl, String sessionId) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, acl, CreateMode.EPHEMERAL, -1L, sessionId);
    }

    public String create(String path, Object data, CreateMode mode) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    public String create(String path, Object data, CreateMode mode, long ttl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, mode, ttl);
    }

    public String create(String path, Object datat, List<ACL> acl, CreateMode mode) throws IllegalArgumentException, ZkException {
        return this.create(path, datat, acl, mode, -1L, null);
    }

    public String create(String path, Object datat, List<ACL> acl, CreateMode mode, long ttl) throws IllegalArgumentException, ZkException {
        return this.create(path, datat, acl, mode, ttl, null);
    }

    private String create(String path, Object dataObject, List<ACL> acl, CreateMode mode, long ttl, String expectedSessionId) throws IllegalArgumentException, ZkException {
        String string;
        if (path == null) {
            throw new NullPointerException("Path must not be null.");
        }
        if (acl == null || acl.size() == 0) {
            throw new NullPointerException("Missing value for ACL");
        }
        long startT = System.currentTimeMillis();
        try {
            byte[] dataBytes = dataObject == null ? null : this.serialize(dataObject, path);
            this.checkDataSizeLimit(path, dataBytes);
            String actualPath = mode.isTTL() ? this.retryUntilConnected(() -> this.getExpectedZookeeper(expectedSessionId).create(path, dataBytes, acl, mode, null, ttl)) : this.retryUntilConnected(() -> this.getExpectedZookeeper(expectedSessionId).create(path, dataBytes, acl, mode));
            this.record(path, dataBytes, startT, ZkClientMonitor.AccessType.WRITE);
            string = actualPath;
        }
        catch (Exception e) {
            try {
                this.recordFailure(path, ZkClientMonitor.AccessType.WRITE);
                throw e;
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("zkclient {} create, path {}, time {} ms", new Object[]{this._uid, path, endT - startT});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("zkclient {} create, path {}, time {} ms", new Object[]{this._uid, path, endT - startT});
        }
        return string;
    }

    public void createEphemeral(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, Object data, String sessionId) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, -1L, sessionId);
    }

    public void createEphemeral(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, acl, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, Object data, List<ACL> acl, String sessionId) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, acl, CreateMode.EPHEMERAL, -1L, sessionId);
    }

    public String createEphemeralSequential(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    public String createEphemeralSequential(String path, Object data, List<ACL> acl, String sessionId) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, acl, CreateMode.EPHEMERAL_SEQUENTIAL, -1L, sessionId);
    }

    public String createEphemeralSequential(String path, Object data, String sessionId) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, -1L, sessionId);
    }

    public String createEphemeralSequential(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, acl, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        boolean dataChanged;
        long notificationTime = System.currentTimeMillis();
        LOG.debug("zkclient {}, Received event: {} ", (Object)this._uid, (Object)event);
        if (event.getType() == Watcher.Event.EventType.PersistentWatchRemoved) {
            return;
        }
        this._zookeeperEventThread = Thread.currentThread();
        boolean stateChanged = event.getPath() == null;
        boolean sessionExpired = stateChanged && event.getState() == Watcher.Event.KeeperState.Expired;
        boolean znodeChanged = event.getPath() != null;
        boolean bl = dataChanged = event.getType() == Watcher.Event.EventType.NodeDataChanged || event.getType() == Watcher.Event.EventType.NodeDeleted || event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeChildrenChanged;
        if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
            LOG.debug("zkclient {}, Path {} is deleted", (Object)this._uid, (Object)event.getPath());
        }
        this.getEventLock().lock();
        try {
            if (this.getShutdownTrigger()) {
                LOG.debug("zkclient {} ignoring event {}|{} since shutdown triggered", new Object[]{this._uid, event.getType(), event.getPath()});
                return;
            }
            if (stateChanged) {
                this.processStateChanged(event);
            }
            if (dataChanged) {
                this.processDataOrChildChange(event, notificationTime);
            }
        }
        finally {
            if (stateChanged) {
                this.getEventLock().getStateChangedCondition().signalAll();
                if (event.getState() == Watcher.Event.KeeperState.Expired) {
                    this.getEventLock().getZNodeEventCondition().signalAll();
                    this.getEventLock().getDataChangedCondition().signalAll();
                }
            }
            if (znodeChanged) {
                this.getEventLock().getZNodeEventCondition().signalAll();
            }
            if (dataChanged) {
                this.getEventLock().getDataChangedCondition().signalAll();
            }
            this.getEventLock().unlock();
            this.recordStateChange(stateChanged, dataChanged, sessionExpired);
            LOG.debug("zkclient {} Leaving process event", (Object)this._uid);
        }
    }

    private void fireAllEvents(WatchedEvent event) {
        for (Map.Entry<String, Set<IZkChildListener>> entry : this._childListener.entrySet()) {
            this.fireChildChangedEvents(entry.getKey(), entry.getValue(), true, event.getType());
        }
        for (Map.Entry<String, Set<Object>> entry : this._dataListener.entrySet()) {
            this.fireDataChangedEvents(entry.getKey(), entry.getValue(), OptionalLong.empty(), true, event.getType());
        }
    }

    public List<String> getChildren(String path) {
        return this.getChildren(path, !this._usePersistWatcher && this.hasChildOrDataListeners(path));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> getChildren(final String path, final boolean watch) {
        List<String> list;
        this.validateNativeZkWatcherType(watch);
        long startT = System.currentTimeMillis();
        try {
            List<String> children = this.retryUntilConnected(new Callable<List<String>>(){
                private int connectionLossRetryCount = 0;

                @Override
                public List<String> call() throws Exception {
                    try {
                        return ZkClient.this.getConnection().getChildren(path, watch);
                    }
                    catch (KeeperException.ConnectionLossException e) {
                        ++this.connectionLossRetryCount;
                        if (this.connectionLossRetryCount >= 3) {
                            ZkClient.this.checkNumChildrenLimit(path);
                            this.connectionLossRetryCount = 0;
                        }
                        throw e;
                    }
                }
            });
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            list = children;
        }
        catch (ZkNoNodeException e) {
            try {
                this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
                throw e;
                catch (Exception e2) {
                    this.recordFailure(path, ZkClientMonitor.AccessType.READ);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("zkclient {} getChildren, path {} time: {} ms", new Object[]{this._uid, path, endT - startT});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("zkclient {} getChildren, path {} time: {} ms", new Object[]{this._uid, path, endT - startT});
        }
        return list;
    }

    public int countChildren(String path) {
        try {
            return this.getChildren(path).size();
        }
        catch (ZkNoNodeException e) {
            return 0;
        }
    }

    public boolean exists(String path) {
        return this.exists(path, !this._usePersistWatcher && this.hasChildOrDataListeners(path));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean exists(final String path, final boolean watch) {
        boolean bl;
        this.validateNativeZkWatcherType(watch);
        long startT = System.currentTimeMillis();
        try {
            boolean exists = this.retryUntilConnected(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ZkClient.this.getConnection().exists(path, watch);
                }
            });
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            bl = exists;
        }
        catch (ZkNoNodeException e) {
            try {
                this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
                throw e;
                catch (Exception e2) {
                    this.recordFailure(path, ZkClientMonitor.AccessType.READ);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("zkclient exists, path: {}, time: {} ms", new Object[]{this._uid, path, endT - startT});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("zkclient exists, path: {}, time: {} ms", new Object[]{this._uid, path, endT - startT});
        }
        return bl;
    }

    public Stat getStat(String path) {
        return this.getStat(path, false);
    }

    private Stat getStat(String path, boolean watch) {
        Stat stat;
        this.validateNativeZkWatcherType(watch);
        long startT = System.currentTimeMillis();
        try {
            Stat stat2 = this.retryUntilConnected(() -> ((ZkConnection)this.getConnection()).getZookeeper().exists(path, watch));
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            stat = stat2;
        }
        catch (Exception e) {
            try {
                this.recordFailure(path, ZkClientMonitor.AccessType.READ);
                throw e;
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("zkclient exists, path: {}, time: {} ms", new Object[]{this._uid, path, endT - startT});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("zkclient exists, path: {}, time: {} ms", new Object[]{this._uid, path, endT - startT});
        }
        return stat;
    }

    private Stat installWatchOnlyPathExist(String path) {
        long startT = System.currentTimeMillis();
        Stat stat = new Stat();
        try {
            LOG.debug("installWatchOnlyPathExist with path: {} ", (Object)path);
            this.retryUntilConnected(() -> ((ZkConnection)this.getConnection()).getZookeeper().getData(path, true, stat));
        }
        catch (ZkNoNodeException e) {
            LOG.debug("installWatchOnlyPathExist path not existing: {}", (Object)path);
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            Stat stat2 = null;
            long endT = System.currentTimeMillis();
            if (LOG.isTraceEnabled()) {
                LOG.trace("zkclient getData (installWatchOnlyPathExist), path: {}, time: {} ms", new Object[]{this._uid, path, endT - startT});
            }
            return stat2;
        }
        try {
            this.record(path, null, startT, ZkClientMonitor.AccessType.READ);
            Stat e = stat;
        }
        catch (Exception e) {
            try {
                this.recordFailure(path, ZkClientMonitor.AccessType.READ);
                throw e;
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("zkclient getData (installWatchOnlyPathExist), path: {}, time: {} ms", new Object[]{this._uid, path, endT - startT});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("zkclient getData (installWatchOnlyPathExist), path: {}, time: {} ms", new Object[]{this._uid, path, endT - startT});
        }
        return e;
    }

    protected void processStateChanged(WatchedEvent event) {
        LOG.info("zkclient {}, zookeeper state changed ( {} )", (Object)this._uid, (Object)event.getState());
        Watcher.Event.KeeperState prevState = this._currentState;
        this.setCurrentState(event.getState());
        if (this.getShutdownTrigger()) {
            return;
        }
        this.fireStateChangedEvent(prevState, event.getState());
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            if (!this._isNewSessionEventFired && !"0".equals(this.getHexSessionId())) {
                this.fireNewSessionEvents();
                this._isNewSessionEventFired = true;
                this.fireAllEvents(event);
            }
        } else if (event.getState() == Watcher.Event.KeeperState.Expired) {
            this._isNewSessionEventFired = false;
            this.reconnectOnExpiring();
        }
    }

    private void reconnectOnExpiring() {
        if (!this.isManagingZkConnection()) {
            return;
        }
        int retryCount = 0;
        long currTime = System.currentTimeMillis();
        Exception reconnectException = new ZkException("Shutdown triggered.");
        while (!this.isClosed()) {
            try {
                this.reconnect();
                return;
            }
            catch (ZkInterruptedException interrupt) {
                reconnectException = interrupt;
                break;
            }
            catch (Exception e) {
                reconnectException = e;
                long waitInterval = ExponentialBackoffStrategy.getWaitInterval(currTime, 30000L, true, retryCount++);
                LOG.warn("ZkClient {}, reconnect on expiring failed. Will retry after {} ms", new Object[]{this._uid, waitInterval, e});
                try {
                    Thread.sleep(waitInterval);
                }
                catch (InterruptedException ex) {
                    reconnectException = ex;
                    break;
                }
            }
        }
        LOG.info("Zkclient {} unable to re-establish connection. Notifying consumer of the following exception:{}", (Object)this._uid, (Object)reconnectException);
        this.fireSessionEstablishmentError(reconnectException);
    }

    private void reconnect() {
        this.getEventLock().lock();
        try {
            ZkConnection connection = (ZkConnection)this.getConnection();
            connection.reconnect(this);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    private void doAsyncSync(final ZooKeeper zk, final String path, long startT, final ZkAsyncCallbacks.SyncCallbackHandler cb) {
        try {
            zk.sync(path, (AsyncCallback.VoidCallback)cb, (Object)new ZkAsyncRetryCallContext(this._asyncCallRetryThread, cb, this._monitor, startT, 0, true){

                @Override
                protected void doRetry() throws Exception {
                    ZkClient.this.doAsyncSync(zk, path, System.currentTimeMillis(), cb);
                }
            });
        }
        catch (RuntimeException e) {
            cb.processResult(KeeperException.Code.APIERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, true));
            throw e;
        }
    }

    private boolean issueSync(ZooKeeper zk) {
        String sessionId = Long.toHexString(zk.getSessionId());
        ZkAsyncCallbacks.SyncCallbackHandler callbackHandler = new ZkAsyncCallbacks.SyncCallbackHandler(sessionId);
        long startT = System.currentTimeMillis();
        this.doAsyncSync(zk, SYNC_PATH, startT, callbackHandler);
        callbackHandler.waitForSuccess();
        KeeperException.Code code = KeeperException.Code.get((int)callbackHandler.getRc());
        if (code == KeeperException.Code.OK) {
            LOG.info("zkclient {}, sycnOnNewSession with sessionID {} async return code: {} and proceeds", new Object[]{this._uid, sessionId, code});
            return true;
        }
        return false;
    }

    private void fireNewSessionEvents() {
        if (!this.isManagingZkConnection()) {
            return;
        }
        final String sessionId = this.getHexSessionId();
        if (SYNC_ON_SESSION) {
            final ZooKeeper zk = ((ZkConnection)this.getConnection()).getZookeeper();
            this._eventThread.send(new ZkEventThread.ZkEvent("Sync call before new session event of session " + sessionId, sessionId){

                @Override
                public void run() throws Exception {
                    if (!ZkClient.this.issueSync(zk)) {
                        LOG.warn("zkclient{}, Failed to call sync() on new session {}", (Object)ZkClient.this._uid, (Object)sessionId);
                    }
                }
            });
        }
        for (final org.apache.helix.zookeeper.zkclient.IZkStateListener stateListener : this._stateListener) {
            this._eventThread.send(new ZkEventThread.ZkEvent("New session event sent to " + stateListener, sessionId){

                @Override
                public void run() throws Exception {
                    stateListener.handleNewSession(sessionId);
                }
            });
        }
    }

    protected void fireStateChangedEvent(final Watcher.Event.KeeperState prevState, final Watcher.Event.KeeperState curState) {
        String sessionId = this.getHexSessionId();
        for (final org.apache.helix.zookeeper.zkclient.IZkStateListener stateListener : this._stateListener) {
            String description = "State changed to " + curState + " sent to " + stateListener;
            this._eventThread.send(new ZkEventThread.ZkEvent(description, sessionId){

                @Override
                public void run() throws Exception {
                    stateListener.handleStateChanged(prevState, curState);
                }
            });
        }
    }

    private void fireSessionEstablishmentError(final Throwable error) {
        for (final org.apache.helix.zookeeper.zkclient.IZkStateListener stateListener : this._stateListener) {
            this._eventThread.send(new ZkEventThread.ZkEvent("Session establishment error(" + error + ") sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleSessionEstablishmentError(error);
                }
            });
        }
    }

    private boolean hasChildOrDataListeners(String path) {
        Set<IZkDataListenerEntry> dataListeners = this._dataListener.get(path);
        if (dataListeners != null && dataListeners.size() > 0) {
            return true;
        }
        Set<IZkChildListener> childListeners = this._childListener.get(path);
        return childListeners != null && childListeners.size() > 0;
    }

    @Deprecated
    public boolean deleteRecursive(String path) {
        try {
            this.deleteRecursively(path);
            return true;
        }
        catch (ZkClientException e) {
            LOG.error("zkcient {}, Failed to recursively delete path {}, exception {}", new Object[]{this._uid, path, e});
            return false;
        }
    }

    public void deleteRecursively(String path) throws ZkClientException {
        List<String> children;
        try {
            children = this.getChildren(path, false);
        }
        catch (ZkNoNodeException e) {
            return;
        }
        for (String subPath : children) {
            this.deleteRecursively(path + SYNC_PATH + subPath);
        }
        try {
            this.delete(path);
        }
        catch (Exception e) {
            LOG.error("zkclient {}, Failed to delete {}, exception {}", new Object[]{this._uid, path, e});
            throw new ZkClientException("Failed to delete " + path, e);
        }
    }

    private void processDataOrChildChange(final WatchedEvent event, long notificationTime) {
        Set<IZkChildListener> childListeners;
        boolean pathExists;
        final String path = event.getPath();
        boolean bl = pathExists = event.getType() != Watcher.Event.EventType.NodeDeleted;
        if (Watcher.Event.EventType.NodeDeleted == event.getType()) {
            LOG.debug("zkclient{}, Event NodeDeleted: {}", (Object)this._uid, (Object)event.getPath());
        }
        if (!(event.getType() != Watcher.Event.EventType.NodeChildrenChanged && event.getType() != Watcher.Event.EventType.NodeCreated && event.getType() != Watcher.Event.EventType.NodeDeleted || (childListeners = this._childListener.get(path)) == null || childListeners.isEmpty())) {
            this.fireChildChangedEvents(path, childListeners, pathExists, event.getType());
        }
        if (event.getType() == Watcher.Event.EventType.NodeDataChanged || event.getType() == Watcher.Event.EventType.NodeDeleted || event.getType() == Watcher.Event.EventType.NodeCreated) {
            Set<RecursivePersistListener> recListeners;
            Set<IZkDataListenerEntry> listeners = this._dataListener.get(path);
            if (listeners != null && !listeners.isEmpty()) {
                this.fireDataChangedEvents(event.getPath(), listeners, OptionalLong.of(notificationTime), pathExists, event.getType());
            }
            if (this._usePersistWatcher && !(recListeners = this._zkPathRecursiveWatcherTrie.getAllRecursiveListeners(path)).isEmpty()) {
                for (final RecursivePersistListener listener : recListeners) {
                    this._eventThread.send(new ZkEventThread.ZkEvent("Data of " + path + " changed sent to " + listener){

                        @Override
                        public void run() throws Exception {
                            listener.handleZNodeChange(path, event.getType());
                        }
                    });
                }
            }
        }
    }

    private void fireDataChangedEvents(final String path, Set<IZkDataListenerEntry> listeners, final OptionalLong notificationTime, final boolean pathExists, final Watcher.Event.EventType eventType) {
        try {
            final ZkPathStatRecord pathStatRecord = new ZkPathStatRecord(path);
            for (final IZkDataListenerEntry listener : listeners) {
                this._eventThread.send(new ZkEventThread.ZkEvent("Data of " + path + " changed sent to " + listener.getDataListener() + " prefetch data: " + listener.isPrefetchData()){

                    @Override
                    public void run() throws Exception {
                        if (!pathStatRecord.pathChecked()) {
                            Stat stat = null;
                            stat = ZkClient.this._usePersistWatcher || !pathExists ? ZkClient.this.getStat(path, false) : ZkClient.this.installWatchOnlyPathExist(path);
                            pathStatRecord.recordPathStat(stat, notificationTime);
                        }
                        if (!pathStatRecord.pathExists()) {
                            listener.getDataListener().handleDataDeleted(path);
                        } else {
                            Object data = null;
                            if (listener.isPrefetchData()) {
                                LOG.debug("zkclient {} Prefetch data for path: {}", (Object)ZkClient.this._uid, (Object)path);
                                try {
                                    data = ZkClient.this.readData(path, null, !ZkClient.this._usePersistWatcher);
                                }
                                catch (ZkNoNodeException e) {
                                    LOG.warn("zkclient {} Prefetch data for path: {} failed.", new Object[]{ZkClient.this._uid, path, e});
                                    listener.getDataListener().handleDataDeleted(path);
                                    return;
                                }
                            }
                            listener.getDataListener().handleDataChange(path, data, eventType);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("zkclient {} Failed to fire data changed event for path: {}", new Object[]{this._uid, path, e});
        }
    }

    private void fireChildChangedEvents(final String path, Set<IZkChildListener> childListeners, final boolean pathExists, final Watcher.Event.EventType eventType) {
        try {
            final ZkPathStatRecord pathStatRecord = new ZkPathStatRecord(path);
            for (final IZkChildListener listener : childListeners) {
                this._eventThread.send(new ZkEventThread.ZkEvent("Children of " + path + " changed sent to " + listener){

                    @Override
                    public void run() throws Exception {
                        if (!pathStatRecord.pathChecked()) {
                            Stat stat = null;
                            stat = ZkClient.this._usePersistWatcher || !pathExists || !ZkClient.this.hasChildOrDataListeners(path) ? ZkClient.this.getStat(path, false) : ZkClient.this.installWatchOnlyPathExist(path);
                            pathStatRecord.recordPathStat(stat, OptionalLong.empty());
                        }
                        List<String> children = null;
                        if (pathStatRecord.pathExists()) {
                            try {
                                children = ZkClient.this.getChildren(path);
                            }
                            catch (ZkNoNodeException e) {
                                LOG.warn("zkclient {} Get children under path: {} failed.", new Object[]{ZkClient.this._uid, path, e});
                            }
                        }
                        listener.handleChildChange(path, children, eventType);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("zkclient {} Failed to fire child changed event. Unable to getChildren.", (Object)this._uid, (Object)e);
        }
    }

    public boolean waitUntilExists(String path, TimeUnit timeUnit, long time) throws ZkInterruptedException {
        Date timeout = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        LOG.debug("Waiting until znode {} {} becomes available.", (Object)this._uid, (Object)path);
        if (this.exists(path)) {
            return true;
        }
        this.acquireEventLock();
        try {
            boolean gotSignal;
            while (!this.exists(path, true)) {
                gotSignal = this.getEventLock().getZNodeEventCondition().awaitUntil(timeout);
                if (gotSignal) continue;
                boolean bl = false;
                return bl;
            }
            gotSignal = true;
            return gotSignal;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public IZkConnection getConnection() {
        return this._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForEstablishedSession(long timeout, TimeUnit timeUnit) {
        this.validateCurrentThread();
        this.acquireEventLock();
        try {
            if (!this.waitForKeeperState(Watcher.Event.KeeperState.SyncConnected, timeout, timeUnit)) {
                throw new ZkTimeoutException("Waiting to be connected to ZK server has timed out.");
            }
            long l = this.getSessionId();
            return l;
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public boolean waitUntilConnected(long time, TimeUnit timeUnit) throws ZkInterruptedException {
        return this.waitForKeeperState(Watcher.Event.KeeperState.SyncConnected, time, timeUnit);
    }

    public boolean waitForKeeperState(Watcher.Event.KeeperState keeperState, long time, TimeUnit timeUnit) throws ZkInterruptedException {
        this.validateCurrentThread();
        Date timeout = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        LOG.debug("zkclient {}, Waiting for keeper state {} ", (Object)this._uid, (Object)keeperState);
        this.acquireEventLock();
        try {
            boolean stillWaiting = true;
            while (this._currentState != keeperState) {
                if (!stillWaiting) {
                    boolean bl = false;
                    return bl;
                }
                stillWaiting = this.getEventLock().getStateChangedCondition().awaitUntil(timeout);
            }
            LOG.debug("zkclient {} State is {}", (Object)this._uid, (Object)(this._currentState == null ? "CLOSED" : this._currentState));
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    private void acquireEventLock() {
        try {
            this.getEventLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T retryUntilConnected(Callable<T> callable) throws IllegalArgumentException, ZkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void waitForRetry(long maxSleep) {
        if (this.waitUntilConnected(this._operationRetryTimeoutInMillis, TimeUnit.MILLISECONDS)) {
            try {
                Thread.sleep(maxSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    public void setCurrentState(Watcher.Event.KeeperState currentState) {
        this.getEventLock().lock();
        try {
            this._currentState = currentState;
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public ZkLock getEventLock() {
        return this._zkEventLock;
    }

    public boolean delete(String path) {
        return this.delete(path, -1);
    }

    public boolean delete(final String path, final int expectedVersion) {
        boolean success;
        long startT = System.currentTimeMillis();
        try {
            try {
                this.retryUntilConnected(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ZkClient.this.getConnection().delete(path, expectedVersion);
                        return null;
                    }
                });
                success = true;
            }
            catch (ZkNoNodeException e) {
                success = false;
                LOG.debug("zkclient {}, Failed to delete path {}, znode does not exist!", new Object[]{this._uid, path, e});
            }
            this.record(path, null, startT, ZkClientMonitor.AccessType.WRITE);
        }
        catch (Exception e) {
            try {
                this.recordFailure(path, ZkClientMonitor.AccessType.WRITE);
                throw e;
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("zkclient {} delete, path: {}, time {} ms", new Object[]{this._uid, path, endT - startT});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("zkclient {} delete, path: {}, time {} ms", new Object[]{this._uid, path, endT - startT});
        }
        return success;
    }

    public void setZkSerializer(ZkSerializer zkSerializer) {
        this._pathBasedZkSerializer = new BasicZkSerializer(zkSerializer);
    }

    public void setZkSerializer(PathBasedZkSerializer zkSerializer) {
        this._pathBasedZkSerializer = zkSerializer;
    }

    public PathBasedZkSerializer getZkSerializer() {
        return this._pathBasedZkSerializer;
    }

    public byte[] serialize(Object data, String path) {
        return this._pathBasedZkSerializer.serialize(data, path);
    }

    public <T> T deserialize(byte[] data, String path) {
        if (data == null) {
            return null;
        }
        return (T)this._pathBasedZkSerializer.deserialize(data, path);
    }

    public <T> T readData(String path) {
        return this.readData(path, false);
    }

    public <T> T readData(String path, boolean returnNullIfPathNotExists) {
        T data;
        block2: {
            data = null;
            try {
                data = this.readData(path, null);
            }
            catch (ZkNoNodeException e) {
                if (returnNullIfPathNotExists) break block2;
                throw e;
            }
        }
        return data;
    }

    public <T> T readData(String path, Stat stat) {
        return this.readData(path, stat, !this._usePersistWatcher && this.hasChildOrDataListeners(path));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readData(final String path, final Stat stat, final boolean watch) {
        T t;
        this.validateNativeZkWatcherType(watch);
        long startT = System.currentTimeMillis();
        byte[] data = null;
        try {
            data = this.retryUntilConnected(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return ZkClient.this.getConnection().readData(path, stat, watch);
                }
            });
            this.record(path, data, startT, ZkClientMonitor.AccessType.READ);
            t = this.deserialize(data, path);
        }
        catch (ZkNoNodeException e) {
            try {
                this.record(path, data, startT, ZkClientMonitor.AccessType.READ);
                throw e;
                catch (Exception e2) {
                    this.recordFailure(path, ZkClientMonitor.AccessType.READ);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("zkclient {}, getData, path {}, time {} ms", new Object[]{this._uid, path, endT - startT});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("zkclient {}, getData, path {}, time {} ms", new Object[]{this._uid, path, endT - startT});
        }
        return t;
    }

    public <T> T readDataAndStat(String path, Stat stat, boolean returnNullIfPathNotExists) {
        T data;
        block2: {
            data = null;
            try {
                data = this.readData(path, stat);
            }
            catch (ZkNoNodeException e) {
                if (returnNullIfPathNotExists) break block2;
                throw e;
            }
        }
        return data;
    }

    public void writeData(String path, Object object) {
        this.writeData(path, object, -1);
    }

    public <T> void updateDataSerialized(String path, DataUpdater<T> updater) {
        boolean retry;
        Stat stat = new Stat();
        do {
            retry = false;
            try {
                T oldData = this.readData(path, stat);
                T newData = updater.update(oldData);
                this.writeData(path, newData, stat.getVersion());
            }
            catch (ZkBadVersionException e) {
                retry = true;
            }
        } while (retry);
    }

    public void writeData(String path, Object datat, int expectedVersion) {
        this.writeDataReturnStat(path, datat, expectedVersion);
    }

    public Stat writeDataReturnStat(String path, Object datat, int expectedVersion) {
        Stat stat;
        long startT = System.currentTimeMillis();
        try {
            byte[] data = this.serialize(datat, path);
            this.checkDataSizeLimit(path, data);
            Stat stat2 = (Stat)this.retryUntilConnected(() -> this.getConnection().writeDataReturnStat(path, data, expectedVersion));
            this.record(path, data, startT, ZkClientMonitor.AccessType.WRITE);
            stat = stat2;
        }
        catch (Exception e) {
            try {
                this.recordFailure(path, ZkClientMonitor.AccessType.WRITE);
                throw e;
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("zkclient {}, setData, path {}, time {} ms", new Object[]{this._uid, path, endT - startT});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("zkclient {}, setData, path {}, time {} ms", new Object[]{this._uid, path, endT - startT});
        }
        return stat;
    }

    public Stat writeDataGetStat(String path, Object datat, int expectedVersion) {
        return this.writeDataReturnStat(path, datat, expectedVersion);
    }

    public void asyncCreate(String path, Object datat, CreateMode mode, ZkAsyncCallbacks.CreateCallbackHandler cb) {
        byte[] data;
        long startT = System.currentTimeMillis();
        try {
            data = datat == null ? null : this.serialize(datat, path);
        }
        catch (ZkMarshallingError e) {
            cb.processResult(KeeperException.Code.MARSHALLINGERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, false), null);
            return;
        }
        this.doAsyncCreate(path, data, mode, -1L, startT, cb, this.parseExpectedSessionId(datat));
    }

    private void doAsyncCreate(final String path, final byte[] data, final CreateMode mode, final long ttl, long startT, final ZkAsyncCallbacks.CreateCallbackHandler cb, final String expectedSessionId) {
        try {
            this.retryUntilConnected(() -> {
                this.getExpectedZookeeper(expectedSessionId).create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode, (AsyncCallback.Create2Callback)cb, (Object)new ZkAsyncRetryCallContext(this._asyncCallRetryThread, cb, this._monitor, startT, 0, false, GZipCompressionUtil.isCompressed(data)){

                    @Override
                    protected void doRetry() {
                        ZkClient.this.doAsyncCreate(path, data, mode, ttl, System.currentTimeMillis(), cb, expectedSessionId);
                    }
                }, ttl);
                return null;
            });
        }
        catch (RuntimeException e) {
            cb.processResult(KeeperException.Code.APIERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, false), null, null);
            throw e;
        }
    }

    public void asyncCreate(String path, Object datat, CreateMode mode, long ttl, ZkAsyncCallbacks.CreateCallbackHandler cb) {
        byte[] data;
        long startT = System.currentTimeMillis();
        try {
            data = datat == null ? null : this.serialize(datat, path);
        }
        catch (ZkMarshallingError e) {
            cb.processResult(KeeperException.Code.MARSHALLINGERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, false), null, null);
            return;
        }
        this.doAsyncCreate(path, data, mode, ttl, startT, cb, this.parseExpectedSessionId(datat));
    }

    public void asyncSetData(String path, Object datat, int version, ZkAsyncCallbacks.SetDataCallbackHandler cb) {
        byte[] data;
        long startT = System.currentTimeMillis();
        try {
            data = this.serialize(datat, path);
        }
        catch (ZkMarshallingError e) {
            cb.processResult(KeeperException.Code.MARSHALLINGERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, false), null);
            return;
        }
        this.doAsyncSetData(path, data, version, startT, cb, this.parseExpectedSessionId(datat));
    }

    private void doAsyncSetData(final String path, final byte[] data, final int version, long startT, final ZkAsyncCallbacks.SetDataCallbackHandler cb, final String expectedSessionId) {
        try {
            this.retryUntilConnected(() -> {
                this.getExpectedZookeeper(expectedSessionId).setData(path, data, version, (AsyncCallback.StatCallback)cb, (Object)new ZkAsyncRetryCallContext(this._asyncCallRetryThread, cb, this._monitor, startT, data == null ? 0 : data.length, false, GZipCompressionUtil.isCompressed(data)){

                    @Override
                    protected void doRetry() {
                        ZkClient.this.doAsyncSetData(path, data, version, System.currentTimeMillis(), cb, expectedSessionId);
                    }
                });
                return null;
            });
        }
        catch (RuntimeException e) {
            cb.processResult(KeeperException.Code.APIERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, false), null);
            throw e;
        }
    }

    public void asyncGetData(final String path, final ZkAsyncCallbacks.GetDataCallbackHandler cb) {
        long startT = System.currentTimeMillis();
        try {
            this.retryUntilConnected(() -> {
                ((ZkConnection)this.getConnection()).getZookeeper().getData(path, null, (AsyncCallback.DataCallback)cb, (Object)new ZkAsyncRetryCallContext(this._asyncCallRetryThread, cb, this._monitor, startT, 0, true){

                    @Override
                    protected void doRetry() {
                        ZkClient.this.asyncGetData(path, cb);
                    }
                });
                return null;
            });
        }
        catch (RuntimeException e) {
            cb.processResult(KeeperException.Code.APIERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, true), null, null);
            throw e;
        }
    }

    public void asyncExists(final String path, final ZkAsyncCallbacks.ExistsCallbackHandler cb) {
        long startT = System.currentTimeMillis();
        try {
            this.retryUntilConnected(() -> {
                ((ZkConnection)this.getConnection()).getZookeeper().exists(path, null, (AsyncCallback.StatCallback)cb, (Object)new ZkAsyncRetryCallContext(this._asyncCallRetryThread, cb, this._monitor, startT, 0, true){

                    @Override
                    protected void doRetry() {
                        ZkClient.this.asyncExists(path, cb);
                    }
                });
                return null;
            });
        }
        catch (RuntimeException e) {
            cb.processResult(KeeperException.Code.APIERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, true), null);
            throw e;
        }
    }

    public void asyncDelete(final String path, final ZkAsyncCallbacks.DeleteCallbackHandler cb) {
        long startT = System.currentTimeMillis();
        try {
            this.retryUntilConnected(() -> {
                ((ZkConnection)this.getConnection()).getZookeeper().delete(path, -1, (AsyncCallback.VoidCallback)cb, (Object)new ZkAsyncRetryCallContext(this._asyncCallRetryThread, cb, this._monitor, startT, 0, false){

                    @Override
                    protected void doRetry() {
                        ZkClient.this.asyncDelete(path, cb);
                    }
                });
                return null;
            });
        }
        catch (RuntimeException e) {
            cb.processResult(KeeperException.Code.APIERROR.intValue(), path, new ZkAsyncCallMonitorContext(this._monitor, startT, 0, false));
            throw e;
        }
    }

    private void checkDataSizeLimit(String path, byte[] data) {
        if (data == null) {
            return;
        }
        if (data.length > WRITE_SIZE_LIMIT) {
            throw new ZkClientException("Data size of path " + path + " is greater than write size limit " + WRITE_SIZE_LIMIT + " bytes");
        }
    }

    public void watchForData(String path) {
        this.watchForData(path, false);
    }

    private boolean watchForData(final String path, final boolean skipWatchingNonExistNode) {
        try {
            if (this._usePersistWatcher) {
                return this.retryUntilConnected(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        if (!skipWatchingNonExistNode || ZkClient.this.exists(path)) {
                            ZkClient.this.getConnection().addWatch(path, ZkClient.this, AddWatchMode.PERSISTENT);
                            return true;
                        }
                        return false;
                    }
                });
            }
            if (skipWatchingNonExistNode) {
                this.retryUntilConnected(() -> ((ZkConnection)this.getConnection()).getZookeeper().getData(path, true, new Stat()));
            } else {
                this.retryUntilConnected(() -> ((ZkConnection)this.getConnection()).getZookeeper().exists(path, true));
            }
        }
        catch (ZkNoNodeException e) {
            LOG.info("zkclient {}, watchForData path not existing: {} ", (Object)this._uid, (Object)path);
            return false;
        }
        return true;
    }

    public List<String> watchForChilds(String path) {
        return this.watchForChilds(path, false);
    }

    private List<String> watchForChilds(final String path, final boolean skipWatchingNonExistNode) {
        if (this._zookeeperEventThread != null && Thread.currentThread() == this._zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        return this.retryUntilConnected(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                if (!skipWatchingNonExistNode && !ZkClient.this._usePersistWatcher) {
                    ZkClient.this.exists(path, true);
                }
                try {
                    if (ZkClient.this._usePersistWatcher) {
                        if (!skipWatchingNonExistNode || ZkClient.this.exists(path)) {
                            ZkClient.this.getConnection().addWatch(path, ZkClient.this, AddWatchMode.PERSISTENT);
                        }
                        return ZkClient.this.getChildren(path, false);
                    }
                    return ZkClient.this.getChildren(path, true);
                }
                catch (ZkNoNodeException e) {
                    LOG.info("zkclient{} watchForChilds path not existing:{} skipWatchingNodeNoteExist: {}", new Object[]{ZkClient.this._uid, path, skipWatchingNonExistNode});
                    return null;
                }
            }
        });
    }

    public void addAuthInfo(final String scheme, final byte[] auth) {
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ZkClient.this.getConnection().addAuthInfo(scheme, auth);
                return null;
            }
        });
    }

    public void connect(long maxMsToWaitUntilConnected) throws ZkInterruptedException, ZkTimeoutException, IllegalStateException {
        this.connect(maxMsToWaitUntilConnected, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(long maxMsToWaitUntilConnected, Watcher watcher) throws ZkInterruptedException, ZkTimeoutException, IllegalStateException {
        boolean started = false;
        try {
            boolean result;
            this.acquireEventLock();
            if (this.isClosed()) {
                throw new IllegalStateException("ZkClient already closed!");
            }
            if (this._currentState != null) {
                throw new IllegalStateException("ZkClient is not in init state. connect() has already been called.");
            }
            this.setShutdownTrigger(false);
            IZkConnection zkConnection = this.getConnection();
            this._eventThread = new ZkEventThread(zkConnection.getServers());
            if (this._monitor != null && !(result = this._monitor.setAndInitZkEventThreadMonitor(this._eventThread))) {
                LOG.error("register _eventThread monitor failed due to an existing one");
            }
            this._eventThread.start();
            LOG.debug("ZkClient {},  _eventThread {}", (Object)this._uid, (Object)this._eventThread.getId());
            if (this.isManagingZkConnection()) {
                zkConnection.connect(watcher);
                LOG.debug("zkclient{} Awaiting connection to Zookeeper server", (Object)this._uid);
                if (!this.waitUntilConnected(maxMsToWaitUntilConnected, TimeUnit.MILLISECONDS)) {
                    throw new ZkTimeoutException("Unable to connect to zookeeper server within timeout: " + maxMsToWaitUntilConnected);
                }
            } else {
                if (this.isConnectionClosed()) {
                    throw new ZkClientException("Unable to connect to zookeeper server with the specified ZkConnection");
                }
                this.setCurrentState(Watcher.Event.KeeperState.SyncConnected);
            }
            started = true;
        }
        finally {
            this.getEventLock().unlock();
            if (!started) {
                this.close();
            }
        }
        try {
            if (this._monitor != null) {
                this._monitor.register();
            }
        }
        catch (JMException e) {
            LOG.error("Error in creating ZkClientMonitor", (Throwable)e);
        }
    }

    public long getCreationTime(String path) {
        this.acquireEventLock();
        try {
            long l = this.getConnection().getCreateTime(path);
            return l;
        }
        catch (KeeperException e) {
            throw ZkException.create(e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public String getServers() {
        return this.getConnection().getServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ZkInterruptedException {
        block14: {
            if (LOG.isTraceEnabled()) {
                StackTraceElement[] calls = Thread.currentThread().getStackTrace();
                LOG.trace("Closing a zkclient uid:{}, callStack: {} ", (Object)this._uid, Arrays.asList(calls));
            }
            this.getEventLock().lock();
            IZkConnection connection = this.getConnection();
            try {
                if (connection == null || this._closed) {
                    return;
                }
                this.setShutdownTrigger(true);
                if (this._asyncCallRetryThread != null) {
                    this._asyncCallRetryThread.interrupt();
                    this._asyncCallRetryThread.join(2000L);
                }
                this._eventThread.interrupt();
                this._eventThread.join(2000L);
                if (this.isManagingZkConnection()) {
                    LOG.info("Closing zkclient uid:{}, zk:{}", (Object)this._uid, (Object)((ZkConnection)connection).getZookeeper());
                    connection.close();
                }
                this._closed = true;
                this.setCurrentState(null);
                this.getEventLock().getStateChangedCondition().signalAll();
            }
            catch (InterruptedException e) {
                if (connection == null) break block14;
                try {
                    Thread.interrupted();
                    if (this.isManagingZkConnection()) {
                        connection.close();
                    }
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedException e1) {
                    throw new ZkInterruptedException(e1);
                }
            }
            finally {
                this.getEventLock().unlock();
                if (this._monitor != null) {
                    this._monitor.unregister();
                }
                LOG.info("Closed zkclient with uid:{}", (Object)this._uid);
            }
        }
    }

    public boolean isClosed() {
        try {
            this.getEventLock().lock();
            boolean bl = this._closed;
            return bl;
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public boolean isConnectionClosed() {
        IZkConnection connection = this.getConnection();
        return connection == null || connection.getZookeeperState() == null || !connection.getZookeeperState().isAlive();
    }

    public void setShutdownTrigger(boolean triggerState) {
        this._shutdownTriggered = triggerState;
    }

    public boolean getShutdownTrigger() {
        return this._shutdownTriggered;
    }

    public int numberOfListeners() {
        int listeners = 0;
        for (Set<IZkChildListener> set : this._childListener.values()) {
            listeners += set.size();
        }
        for (Set<Object> set : this._dataListener.values()) {
            listeners += set.size();
        }
        return listeners += this._stateListener.size();
    }

    public List<OpResult> multi(final Iterable<Op> ops) throws ZkException {
        if (ops == null) {
            throw new NullPointerException("ops must not be null.");
        }
        return this.retryUntilConnected(new Callable<List<OpResult>>(){

            @Override
            public List<OpResult> call() throws Exception {
                return ZkClient.this.getConnection().multi(ops);
            }
        });
    }

    protected boolean isManagingZkConnection() {
        return true;
    }

    public long getSessionId() {
        ZkConnection zkConnection = (ZkConnection)this.getConnection();
        ZooKeeper zk = zkConnection.getZookeeper();
        if (zk == null) {
            throw new ZkClientException("ZooKeeper connection information is not available now. ZkClient might be disconnected.");
        }
        return zkConnection.getZookeeper().getSessionId();
    }

    private String getHexSessionId() {
        return Long.toHexString(this.getSessionId());
    }

    private ZooKeeper getExpectedZookeeper(String expectedSessionId) {
        ZooKeeper zk = ((ZkConnection)this.getConnection()).getZookeeper();
        if (expectedSessionId == null || expectedSessionId.isEmpty()) {
            return zk;
        }
        String actualSessionId = Long.toHexString(zk.getSessionId());
        if (!actualSessionId.equals(expectedSessionId)) {
            throw new ZkSessionMismatchedException("Failed to get expected zookeeper instance! There is a session id mismatch. Expected: " + expectedSessionId + ". Actual: " + actualSessionId);
        }
        return zk;
    }

    private String parseExpectedSessionId(Object data) {
        if (!(data instanceof SessionAwareZNRecord)) {
            return null;
        }
        return ((SessionAwareZNRecord)data).getExpectedSessionId();
    }

    private void record(String path, byte[] data, long startTimeMilliSec, ZkClientMonitor.AccessType accessType) {
        if (this._monitor != null) {
            int dataSize = data != null ? data.length : 0;
            this._monitor.record(path, dataSize, startTimeMilliSec, accessType);
            if (GZipCompressionUtil.isCompressed(data)) {
                this._monitor.increaseZnodeCompressCounter();
            }
        }
    }

    private void recordFailure(String path, ZkClientMonitor.AccessType accessType) {
        if (this._monitor != null) {
            this._monitor.recordFailure(path, accessType);
        }
    }

    private void recordStateChange(boolean stateChanged, boolean dataChanged, boolean sessionExpired) {
        if (this._monitor != null) {
            if (stateChanged) {
                this._monitor.increaseStateChangeEventCounter();
            }
            if (dataChanged) {
                this._monitor.increaseDataChangeEventCounter();
            }
            if (sessionExpired) {
                this._monitor.increasExpiredSessionCounter();
            }
        }
    }

    private void validateCurrentThread() {
        if (this._zookeeperEventThread != null && Thread.currentThread() == this._zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
    }

    private void checkNumChildrenLimit(String path) throws KeeperException {
        Stat stat = this.getStat(path);
        if (stat == null) {
            return;
        }
        if (stat.getNumChildren() > 100000) {
            LOG.error("Failed to get children for path {} because of connection loss. Number of children {} exceeds limit {}, aborting retry.", new Object[]{path, stat.getNumChildren(), 100000});
            throw new KeeperException.MarshallingErrorException();
        }
        LOG.debug("Number of children {} is less than limit {}, not exiting retry.", (Object)stat.getNumChildren(), (Object)100000);
    }

    private void validateWriteSizeLimitConfig() {
        int serializerSize = ZNRecordUtil.getSerializerWriteSizeLimit();
        LOG.info("ZNRecord serializer write size limit: {}; ZkClient write size limit: {}", (Object)serializerSize, (Object)WRITE_SIZE_LIMIT);
        if (serializerSize > WRITE_SIZE_LIMIT) {
            throw new IllegalStateException("ZNRecord serializer write size limit " + serializerSize + " is greater than ZkClient size limit " + WRITE_SIZE_LIMIT);
        }
    }

    private void addDataListener(String path, IZkDataListener listener) {
        Set<IZkDataListenerEntry> listenerEntries = this._dataListener.get(path);
        if (listenerEntries == null) {
            listenerEntries = new CopyOnWriteArraySet<IZkDataListenerEntry>();
            this._dataListener.put(path, listenerEntries);
        }
        boolean prefetchEnabled = this.isPrefetchEnabled(listener);
        IZkDataListenerEntry listenerEntry = new IZkDataListenerEntry(listener, prefetchEnabled);
        listenerEntries.add(listenerEntry);
        if (prefetchEnabled) {
            LOG.debug("zkclient {} subscribed data changes for {}, listener {}, prefetch data {}", new Object[]{this._uid, path, listener, prefetchEnabled});
        }
    }

    private void removeDataListener(String path, IZkDataListener dataListener) {
        Set<IZkDataListenerEntry> listeners = this._dataListener.get(path);
        if (listeners != null) {
            IZkDataListenerEntry listenerEntry = new IZkDataListenerEntry(dataListener);
            listeners.remove(listenerEntry);
        }
        if (listeners == null || listeners.isEmpty()) {
            this._dataListener.remove(path);
        }
    }

    private void addChildListener(String path, IZkChildListener listener) {
        Set<IZkChildListener> listeners = this._childListener.get(path);
        if (listeners == null) {
            listeners = new CopyOnWriteArraySet<IZkChildListener>();
            this._childListener.put(path, listeners);
        }
        listeners.add(listener);
    }

    private void removeChildListener(String path, IZkChildListener listener) {
        Set<IZkChildListener> listeners = this._childListener.get(path);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    private void addPersistListener(String path, Object listener) {
        ManipulateListener addListeners = () -> {
            if (this._zkPathRecursiveWatcherTrie.hasListenerOnPath(path)) {
                throw new UnsupportedOperationException("Can not subscribe PersistListener when there is an recursive listener on path: " + path);
            }
            if (listener instanceof IZkChildListener) {
                this.addChildListener(path, (IZkChildListener)listener);
            } else if (listener instanceof IZkDataListener) {
                this.addDataListener(path, (IZkDataListener)listener);
            }
        };
        this.executeWithInPersistListenerMutex(addListeners);
    }

    private void removePersistListener(String path, Object listener) {
        ManipulateListener removeListeners = () -> {
            try {
                if (listener instanceof IZkChildListener) {
                    this.removeChildListener(path, (IZkChildListener)listener);
                } else if (listener instanceof IZkDataListener) {
                    this.removeDataListener(path, (IZkDataListener)listener);
                }
                if (!this.hasChildOrDataListeners(path)) {
                    this.getConnection().removeWatches(path, this, Watcher.WatcherType.Any);
                }
            }
            catch (KeeperException.NoWatcherException e) {
                LOG.warn("Persist watcher is already removed");
            }
        };
        this.executeWithInPersistListenerMutex(removeListeners);
    }

    private void executeWithInPersistListenerMutex(ManipulateListener runnable) {
        try {
            this._persistListenerMutex.lockInterruptibly();
            runnable.run();
        }
        catch (KeeperException.NoWatcherException e) {
            LOG.warn("Persist watcher is already removed");
        }
        catch (InterruptedException | KeeperException ex) {
            throw new ZkException(ex);
        }
        finally {
            this._persistListenerMutex.unlock();
        }
    }

    private void validateNativeZkWatcherType(boolean watch) {
        if (this._usePersistWatcher && watch) {
            throw new IllegalArgumentException("Can not subscribe one time watcher when ZkClient is using PersistWatcher");
        }
    }

    static interface ManipulateListener {
        public void run() throws KeeperException, InterruptedException;
    }

    private static class IZkStateListenerI0ItecImpl
    implements org.apache.helix.zookeeper.zkclient.IZkStateListener {
        private IZkStateListener _listener;

        IZkStateListenerI0ItecImpl(IZkStateListener listener) {
            this._listener = listener;
        }

        @Override
        public void handleStateChanged(Watcher.Event.KeeperState keeperState) throws Exception {
            this._listener.handleStateChanged(keeperState);
        }

        @Override
        public void handleNewSession(String sessionId) throws Exception {
            this._listener.handleNewSession();
        }

        @Override
        public void handleSessionEstablishmentError(Throwable error) throws Exception {
            this._listener.handleSessionEstablishmentError(error);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IZkStateListenerI0ItecImpl)) {
                return false;
            }
            if (this._listener == null) {
                return false;
            }
            IZkStateListenerI0ItecImpl defaultListener = (IZkStateListenerI0ItecImpl)obj;
            return this._listener.equals(defaultListener._listener);
        }

        public int hashCode() {
            return this._listener.hashCode();
        }
    }

    private class ZkPathStatRecord {
        private final String _path;
        private Stat _stat = null;
        private boolean _checked = false;

        public ZkPathStatRecord(String path) {
            this._path = path;
        }

        public boolean pathExists() {
            return this._stat != null;
        }

        public boolean pathChecked() {
            return this._checked;
        }

        public void recordPathStat(Stat stat, OptionalLong notificationTime) {
            this._checked = true;
            this._stat = stat;
            if (ZkClient.this._monitor != null && stat != null && notificationTime.isPresent()) {
                long updateTime = Math.max(stat.getCtime(), stat.getMtime());
                if (notificationTime.getAsLong() > updateTime) {
                    ZkClient.this._monitor.recordDataPropagationLatency(this._path, notificationTime.getAsLong() - updateTime);
                }
            }
        }
    }

    private class IZkDataListenerEntry {
        final IZkDataListener _dataListener;
        final boolean _prefetchData;

        public IZkDataListenerEntry(IZkDataListener dataListener, boolean prefetchData) {
            this._dataListener = dataListener;
            this._prefetchData = prefetchData;
        }

        public IZkDataListenerEntry(IZkDataListener dataListener) {
            this._dataListener = dataListener;
            this._prefetchData = false;
        }

        public IZkDataListener getDataListener() {
            return this._dataListener;
        }

        public boolean isPrefetchData() {
            return this._prefetchData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IZkDataListenerEntry)) {
                return false;
            }
            IZkDataListenerEntry that = (IZkDataListenerEntry)o;
            return this._dataListener.equals(that._dataListener);
        }

        public int hashCode() {
            return this._dataListener.hashCode();
        }
    }
}

