/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;
import org.apache.helix.task.TaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMonitor
extends DynamicMBeanProvider {
    private static final String JOB_KEY = "Job";
    private static final Logger LOG = LoggerFactory.getLogger(JobMonitor.class);
    private static final long DEFAULT_RESET_INTERVAL_MS = 3600000L;
    private final ObjectName _initObjectName;
    private String _clusterName;
    private String _jobType;
    private long _lastResetTime;
    private SimpleDynamicMetric<Long> _successfulJobCount;
    private SimpleDynamicMetric<Long> _failedJobCount;
    private SimpleDynamicMetric<Long> _abortedJobCount;
    private SimpleDynamicMetric<Long> _existingJobGauge;
    private SimpleDynamicMetric<Long> _queuedJobGauge;
    private SimpleDynamicMetric<Long> _runningJobGauge;
    private SimpleDynamicMetric<Long> _availableThreadGauge;
    @Deprecated
    private SimpleDynamicMetric<Long> _maximumJobLatencyGauge;
    @Deprecated
    private SimpleDynamicMetric<Long> _jobLatencyCount;
    private HistogramDynamicMetric _jobLatencyGauge;
    private HistogramDynamicMetric _submissionToProcessDelayGauge;
    private HistogramDynamicMetric _submissionToScheduleDelayGauge;
    private HistogramDynamicMetric _controllerInducedDelayGauge;

    public JobMonitor(String clusterName, String jobType, ObjectName objectName) {
        this._clusterName = clusterName;
        this._jobType = jobType;
        this._initObjectName = objectName;
        this._lastResetTime = System.currentTimeMillis();
        this._successfulJobCount = new SimpleDynamicMetric<Long>("SuccessfulJobCount", 0L);
        this._failedJobCount = new SimpleDynamicMetric<Long>("FailedJobCount", 0L);
        this._abortedJobCount = new SimpleDynamicMetric<Long>("AbortedJobCount", 0L);
        this._existingJobGauge = new SimpleDynamicMetric<Long>("ExistingJobGauge", 0L);
        this._queuedJobGauge = new SimpleDynamicMetric<Long>("QueuedJobGauge", 0L);
        this._runningJobGauge = new SimpleDynamicMetric<Long>("RunningJobGauge", 0L);
        this._availableThreadGauge = new SimpleDynamicMetric<Long>("AvailableThreadGauge", 0L);
        this._maximumJobLatencyGauge = new SimpleDynamicMetric<Long>("MaximumJobLatencyGauge", 0L);
        this._jobLatencyCount = new SimpleDynamicMetric<Long>("JobLatencyCount", 0L);
        this._jobLatencyGauge = new HistogramDynamicMetric("JobLatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._submissionToProcessDelayGauge = new HistogramDynamicMetric("SubmissionToProcessDelayGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._submissionToScheduleDelayGauge = new HistogramDynamicMetric("SubmissionToScheduleDelayGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._controllerInducedDelayGauge = new HistogramDynamicMetric("ControllerInducedDelayGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s", this._clusterName, JOB_KEY, this._jobType);
    }

    public String getJobType() {
        return this._jobType;
    }

    public void updateJobMetricsWithLatency(TaskState to) {
        this.updateJobMetricsWithLatency(to, 0L);
    }

    public void updateJobMetricsWithLatency(TaskState to, long latency) {
        if (to.equals((Object)TaskState.FAILED) || to.equals((Object)TaskState.TIMED_OUT)) {
            this.incrementSimpleDynamicMetric(this._failedJobCount);
        } else if (to.equals((Object)TaskState.COMPLETED)) {
            this.incrementSimpleDynamicMetric(this._successfulJobCount);
            this._maximumJobLatencyGauge.updateValue(Math.max(this._maximumJobLatencyGauge.getValue(), latency));
            if (latency > 0L) {
                this.incrementSimpleDynamicMetric(this._jobLatencyCount, latency);
                this._jobLatencyGauge.updateValue(latency);
            }
        } else if (to.equals((Object)TaskState.ABORTED)) {
            this.incrementSimpleDynamicMetric(this._abortedJobCount);
        }
    }

    public void resetJobGauge() {
        this._queuedJobGauge.updateValue(0L);
        this._existingJobGauge.updateValue(0L);
        this._runningJobGauge.updateValue(0L);
        if (this._lastResetTime + 3600000L < System.currentTimeMillis()) {
            this._lastResetTime = System.currentTimeMillis();
            this._maximumJobLatencyGauge.updateValue(0L);
        }
    }

    public void updateJobGauge(TaskState to) {
        this.incrementSimpleDynamicMetric(this._existingJobGauge);
        if (to == null || to.equals((Object)TaskState.NOT_STARTED)) {
            this.incrementSimpleDynamicMetric(this._queuedJobGauge);
        } else if (to.equals((Object)TaskState.IN_PROGRESS)) {
            this.incrementSimpleDynamicMetric(this._runningJobGauge);
        }
    }

    public void updateAvailableThreadGauge(long availableThreads) {
        this._availableThreadGauge.updateValue(availableThreads);
    }

    public void updateSubmissionToProcessDelayGauge(long delay) {
        this._submissionToProcessDelayGauge.updateValue(delay);
    }

    public void updateSubmissionToScheduleDelayGauge(long delay) {
        this._submissionToScheduleDelayGauge.updateValue(delay);
    }

    public void updateControllerInducedDelayGauge(long delay) {
        this._controllerInducedDelayGauge.updateValue(delay);
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._successfulJobCount);
        attributeList.add(this._failedJobCount);
        attributeList.add(this._abortedJobCount);
        attributeList.add(this._existingJobGauge);
        attributeList.add(this._queuedJobGauge);
        attributeList.add(this._runningJobGauge);
        attributeList.add(this._availableThreadGauge);
        attributeList.add(this._maximumJobLatencyGauge);
        attributeList.add(this._jobLatencyCount);
        attributeList.add(this._jobLatencyGauge);
        attributeList.add(this._submissionToProcessDelayGauge);
        attributeList.add(this._submissionToScheduleDelayGauge);
        attributeList.add(this._controllerInducedDelayGauge);
        this.doRegister(attributeList, this._initObjectName);
        return this;
    }
}

