ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(b,E,P){"use strict";var k=b("./lib/dom"),L=b("./lib/oop"),$=b("./lib/event_emitter").EventEmitter,_=b("./lib/lang"),S=b("./range").Range,x=b("./range_list").RangeList,R=b("./keyboard/hash_handler").HashHandler,A=b("./tokenizer").Tokenizer,M=b("./clipboard"),y={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,t,a){var n=e.session.getTextRange();return a?n.replace(/\n\r?([ \t]*\S)/g,"\n"+a+"$1"):n},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return M.getText&&M.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.start||""},BLOCK_COMMENT_END:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:s.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:s.bind(null,{year:"2-digit"}),CURRENT_MONTH:s.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:s.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:s.bind(null,{month:"short"}),CURRENT_DATE:s.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:s.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:s.bind(null,{weekday:"short"}),CURRENT_HOUR:s.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:s.bind(null,{minute:"2-digit"}),CURRENT_SECOND:s.bind(null,{second:"2-digit"})};function s(e){var t=(new Date).toLocaleString("en-us",e);return 1==t.length?"0"+t:t}y.SELECTED_TEXT=y.SELECTION;var i=function(){this.snippetMap={},this.snippetNameMap={}};(function(){L.implement(this,$),this.getTokenizer=function(){return i.$tokenizer||this.createTokenizer()},this.createTokenizer=function(){function e(n){return n=n.substr(1),/^\d+$/.test(n)?[{tabstopId:parseInt(n,10)}]:[{text:n}]}function t(n){return"(?:[^\\\\"+n+"]|\\\\.)"}var a={regex:"/("+t("/")+"+)/",onMatch:function(n,r,c){var o=c[0];return o.fmtString=!0,o.guard=n.slice(1,-1),o.flag="",""},next:"formatString"};return i.$tokenizer=new A({start:[{regex:/\\./,onMatch:function(n,r,c){var o=n[1];return("}"==o&&c.length||-1!="`$\\".indexOf(o))&&(n=o),[n]}},{regex:/}/,onMatch:function(n,r,c){return[c.length?c.shift():n]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(n,r,c){var o=e(n.substr(1));return c.unshift(o[0]),o},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+t("\\|")+"*\\|",onMatch:function(n,r,c){var o=n.slice(1,-1).replace(/\\[,|\\]|,/g,function(h){return 2==h.length?h[1]:"\0"}).split("\0").map(function(h){return{value:h}});return c[0].choices=o,[o[0]]},next:"start"},a,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(n,r,c){return c.length&&c[0].expectElse?(c[0].expectElse=!1,c[0].ifEnd={elseEnd:c[0]},[c[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(n,r,c){var o=n[1];return"}"==o&&c.length||-1!="`$\\".indexOf(o)?n=o:"n"==o?n="\n":"t"==o?n="\t":-1!="ulULE".indexOf(o)&&(n={changeCase:o,local:o>"a"}),[n]}},{regex:"/\\w*}",onMatch:function(n,r,c){var o=c.shift();return o&&(o.flag=n.slice(1,-1)),this.next=o&&o.tabstopId?"start":"",[o||n]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(n,r,c){return[{text:n.slice(1)}]}},{regex:/\${\w+/,onMatch:function(n,r,c){var o={text:n.slice(2)};return c.unshift(o),[o]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(n,r,c){var o=c.shift();return this.next=o&&o.tabstopId?"start":"",[o||n]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(n,r,c){return c[0].formatFunction=n.slice(2,-1),[c.shift()]},next:"formatString"},a,{regex:/:[\?\-+]?/,onMatch:function(n,r,c){"+"==n[1]&&(c[0].ifEnd=c[0]),"?"==n[1]&&(c[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},this.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(a){return a.value||a})},this.getVariableValue=function(e,t,a){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";if(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t))return"";var n=this.variables[t];return"function"==typeof n&&(n=this.variables[t](e,t,a)),null==n?"":n},this.variables=y,this.tmStrFormat=function(e,t,a){if(!t.fmt)return e;var r=t.guard;r=new RegExp(r,(t.flag||"").replace(/[^gim]/g,""));var c="string"==typeof t.fmt?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,o=this,h=e.replace(r,function(){var l=o.variables.__;o.variables.__=[].slice.call(arguments);for(var d=o.resolveVariables(c,a),u="E",g=0;g<d.length;g++){var v=d[g];if("object"==typeof v)if(d[g]="",v.changeCase&&v.local){var w=d[g+1];w&&"string"==typeof w&&(d[g]="u"==v.changeCase?w[0].toUpperCase():w[0].toLowerCase(),d[g+1]=w.substr(1))}else v.changeCase&&(u=v.changeCase);else"U"==u?d[g]=v.toUpperCase():"L"==u&&(d[g]=v.toLowerCase())}return o.variables.__=l,d.join("")});return h},this.tmFormatFunction=function(e,t,a){return"upcase"==t.formatFunction?e.toUpperCase():"downcase"==t.formatFunction?e.toLowerCase():e},this.resolveVariables=function(e,t){for(var a=[],n="",r=!0,c=0;c<e.length;c++){var o=e[c];if("string"!=typeof o){if(o){if(r=!1,o.fmtString){var h=e.indexOf(o,c+1);-1==h&&(h=e.length),o.fmt=e.slice(c+1,h),c=h}if(o.text){var l=this.getVariableValue(t,o.text,n)+"";o.fmtString&&(l=this.tmStrFormat(l,o,t)),o.formatFunction&&(l=this.tmFormatFunction(l,o,t)),l&&!o.ifEnd?(a.push(l),d(o)):!l&&o.ifEnd&&d(o.ifEnd)}else o.elseEnd?d(o.elseEnd):(null!=o.tabstopId||null!=o.changeCase)&&a.push(o)}}else a.push(o),"\n"==o?(r=!0,n=""):r&&(n=/^\t*/.exec(o)[0],r=/\S/.test(o))}function d(u){var g=e.indexOf(u,c+1);-1!=g&&(c=g)}return a},this.insertSnippetForSelection=function(e,t){var a=e.getCursorPosition(),n=e.session.getLine(a.row),r=e.session.getTabString(),c=n.match(/^\s*/)[0];a.column<c.length&&(c=c.slice(0,a.column)),t=t.replace(/\r/g,"");var o=this.tokenizeTmSnippet(t);o=(o=this.resolveVariables(o,e)).map(function(C){return"\n"==C?C+c:"string"==typeof C?C.replace(/\t/g,r):C});var h=[];o.forEach(function(C,O){if("object"==typeof C){var I=C.tabstopId,N=h[I];if(N||((N=h[I]=[]).index=I,N.value="",N.parents={}),-1===N.indexOf(C)){C.choices&&!N.choices&&(N.choices=C.choices),N.push(C);var U=o.indexOf(C,O+1);if(-1!==U){var B=o.slice(O+1,U);B.some(function(Z){return"object"==typeof Z})&&!N.value?N.value=B:B.length&&(!N.value||"string"!=typeof N.value)&&(N.value=B.join(""))}}}}),h.forEach(function(C){C.length=0});var l={};function d(C){for(var O=[],I=0;I<C.length;I++){var N=C[I];if("object"==typeof N){if(l[N.tabstopId])continue;N=O[C.lastIndexOf(N,I-1)]||{tabstopId:N.tabstopId}}O[I]=N}return O}for(var u=0;u<o.length;u++){var g=o[u];if("object"==typeof g){var v=g.tabstopId,w=h[v],F=o.indexOf(g,u+1);if(l[v]){l[v]===g&&(delete l[v],Object.keys(l).forEach(function(C){w.parents[C]=!0}));continue}l[v]=g;var H=w.value;"string"!=typeof H?H=d(H):g.fmt&&(H=this.tmStrFormat(H,g,e)),o.splice.apply(o,[u+1,Math.max(0,F-u)].concat(H,g)),-1===w.indexOf(g)&&w.push(g)}}var D=0,z=0,V="";o.forEach(function(C){if("string"==typeof C){var O=C.split("\n");O.length>1?(z=O[O.length-1].length,D+=O.length-1):z+=C.length,V+=C}else C&&(C.start?C.end={row:D,column:z}:C.start={row:D,column:z})});var W=e.getSelectionRange(),K=e.session.replace(W,V);new f(e).addTabstops(h,W.start,K,e.inVirtualSelectionMode&&e.selection.index)},this.insertSnippet=function(e,t){var a=this;if(e.inVirtualSelectionMode)return a.insertSnippetForSelection(e,t);e.forEachSelection(function(){a.insertSnippetForSelection(e,t)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},this.$getScope=function(e){var t=e.session.$mode.$id||"";if("html"===(t=t.split("/").pop())||"php"===t){"php"===t&&!e.session.$mode.inlinePhp&&(t="html");var a=e.getCursorPosition(),n=e.session.getState(a.row);"object"==typeof n&&(n=n[0]),n.substring&&("js-"==n.substring(0,3)?t="javascript":"css-"==n.substring(0,4)?t="css":"php-"==n.substring(0,4)&&(t="php"))}return t},this.getActiveScopes=function(e){var t=this.$getScope(e),a=[t],n=this.snippetMap;return n[t]&&n[t].includeScopes&&a.push.apply(a,n[t].includeScopes),a.push("_"),a},this.expandWithTab=function(e,t){var a=this,n=e.forEachSelection(function(){return a.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return n&&e.tabstopManager&&e.tabstopManager.tabNext(),n},this.expandSnippetForSelection=function(e,t){var h,a=e.getCursorPosition(),n=e.session.getLine(a.row),r=n.substring(0,a.column),c=n.substr(a.column),o=this.snippetMap;return this.getActiveScopes(e).some(function(l){var d=o[l];return d&&(h=this.findMatchingSnippet(d,r,c)),!!h},this),!!h&&(t&&t.dryRun||(e.session.doc.removeInLine(a.row,a.column-h.replaceBefore.length,a.column+h.replaceAfter.length),this.variables.M__=h.matchBefore,this.variables.T__=h.matchAfter,this.insertSnippetForSelection(e,h.content),this.variables.M__=this.variables.T__=null),!0)},this.findMatchingSnippet=function(e,t,a){for(var n=e.length;n--;){var r=e[n];if((!r.startRe||r.startRe.test(t))&&(!r.endRe||r.endRe.test(a))&&(r.startRe||r.endRe))return r.matchBefore=r.startRe?r.startRe.exec(t):[""],r.matchAfter=r.endRe?r.endRe.exec(a):[""],r.replaceBefore=r.triggerRe?r.triggerRe.exec(t)[0]:"",r.replaceAfter=r.endTriggerRe?r.endTriggerRe.exec(a)[0]:"",r}},this.snippetMap={},this.snippetNameMap={},this.register=function(e,t){var a=this.snippetMap,n=this.snippetNameMap,r=this;function c(l){return l&&!/^\^?\(.*\)\$?$|^\\b$/.test(l)&&(l="(?:"+l+")"),l||""}function o(l,d,u){return l=c(l),d=c(d),u?(l=d+l)&&"$"!=l[l.length-1]&&(l+="$"):(l+=d)&&"^"!=l[0]&&(l="^"+l),new RegExp(l)}function h(l){l.scope||(l.scope=t||"_"),a[t=l.scope]||(a[t]=[],n[t]={});var d=n[t];if(l.name){var u=d[l.name];u&&r.unregister(u),d[l.name]=l}a[t].push(l),l.prefix&&(l.tabTrigger=l.prefix),!l.content&&l.body&&(l.content=Array.isArray(l.body)?l.body.join("\n"):l.body),l.tabTrigger&&!l.trigger&&(!l.guard&&/^\w/.test(l.tabTrigger)&&(l.guard="\\b"),l.trigger=_.escapeRegExp(l.tabTrigger)),(l.trigger||l.guard||l.endTrigger||l.endGuard)&&(l.startRe=o(l.trigger,l.guard,!0),l.triggerRe=new RegExp(l.trigger),l.endRe=o(l.endTrigger,l.endGuard,!0),l.endTriggerRe=new RegExp(l.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(h):Object.keys(e).forEach(function(l){h(e[l])}),this._signal("registerSnippets",{scope:t})},this.unregister=function(e,t){var a=this.snippetMap,n=this.snippetNameMap;function r(c){var o=n[c.scope||t];if(o&&o[c.name]){delete o[c.name];var h=a[c.scope||t],l=h&&h.indexOf(c);l>=0&&h.splice(l,1)}}e.content?r(e):Array.isArray(e)&&e.forEach(r)},this.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var r,t=[],a={},n=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;r=n.exec(e);){if(r[1])try{a=JSON.parse(r[1]),t.push(a)}catch(l){}if(r[4])a.content=r[4].replace(/^\t/gm,""),t.push(a),a={};else{var c=r[2],o=r[3];if("regex"==c){var h=/\/((?:[^\/\\]|\\.)*)|$/g;a.guard=h.exec(o)[1],a.trigger=h.exec(o)[1],a.endTrigger=h.exec(o)[1],a.endGuard=h.exec(o)[1]}else"snippet"==c?(a.tabTrigger=o.match(/^\S*/)[0],a.name||(a.name=o)):c&&(a[c]=o)}}return t},this.getSnippetByName=function(e,t){var n,a=this.snippetNameMap;return this.getActiveScopes(t).some(function(r){var c=a[r];return c&&(n=c[e]),!!n},this),n}}).call(i.prototype);var f=function(e){if(e.tabstopManager)return e.tabstopManager;e.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=_.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)};(function(){this.attach=function(e){this.index=0,this.ranges=[],this.tabstops=[],this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges=null,this.tabstops=null,this.selectedTabstop=null,this.editor.removeListener("change",this.$onChange),this.editor.removeListener("changeSelection",this.$onChangeSelection),this.editor.removeListener("changeSession",this.$onChangeSession),this.editor.commands.removeListener("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.editor=null},this.onChange=function(e){for(var t="r"==e.action[0],a=this.selectedTabstop||{},n=a.parents||{},r=(this.tabstops||[]).slice(),c=0;c<r.length;c++){var o=r[c];if(o.rangeList.$bias=o==a||n[o.index]?0:1,"remove"==e.action&&o!==a){var l=o.parents&&o.parents[a.index],d=o.rangeList.pointIndex(e.start,l);d=d<0?-d-1:d+1;for(var u=o.rangeList.pointIndex(e.end,l),g=o.rangeList.ranges.slice(d,u=u<0?-u-1:u-1),v=0;v<g.length;v++)this.removeRange(g[v])}o.rangeList.$onChange(e)}var w=this.editor.session;!this.$inChange&&t&&1==w.getLength()&&!w.getValue()&&this.detach()},this.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var t=this.editor.session,a=t.getTextRange(e.firstNonLinked),n=0;n<e.length;n++){var r=e[n];if(r.linked){var o=E.snippetManager.tmStrFormat(a,r.original,this.editor);t.replace(r,o)}}this.$inChange=!1}},this.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},this.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,t=this.editor.selection.anchor,a=this.editor.selection.isEmpty(),n=0;n<this.ranges.length;n++)if(!this.ranges[n].linked){var r=this.ranges[n].contains(e.row,e.column),c=a||this.ranges[n].contains(t.row,t.column);if(r&&c)return}this.detach()}},this.onChangeSession=function(){this.detach()},this.tabNext=function(e){var t=this.tabstops.length,a=this.index+(e||1);(a=Math.min(Math.max(a,1),t))==t&&(a=0),this.selectTabstop(a),0===a&&this.detach()},this.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t&&this.addTabstopMarkers(t),this.index=e,(t=this.tabstops[this.index])&&t.length){this.selectedTabstop=t;var a=t.firstNonLinked||t;if(t.choices&&(a.cursor=a.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(a);else{var n=this.editor.multiSelect;n.toSingleRange(a);for(var r=0;r<t.length;r++)t.hasLinkedRanges&&t[r].linked||n.addRange(t[r].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},this.addTabstops=function(e,t,a){var n=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!e[0]){var r=S.fromPoints(a,a);m(r.start,t),m(r.end,t),e[0]=[r],e[0].index=0}var o=[this.index+1,0],h=this.ranges;e.forEach(function(l,d){for(var u=this.$openTabstops[d]||l,g=0;g<l.length;g++){var v=l[g],w=S.fromPoints(v.start,v.end||v.start);p(w.start,t),p(w.end,t),w.original=v,w.tabstop=u,h.push(w),u!=l?u.unshift(w):u[g]=w,v.fmtString||u.firstNonLinked&&n?(w.linked=!0,u.hasLinkedRanges=!0):u.firstNonLinked||(u.firstNonLinked=w)}u.firstNonLinked||(u.hasLinkedRanges=!1),u===l&&(o.push(u),this.$openTabstops[d]=u),this.addTabstopMarkers(u),u.rangeList=u.rangeList||new x,u.rangeList.$bias=0,u.rangeList.addList(u)},this),o.length>2&&(this.tabstops.length&&o.push(o.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,o))},this.addTabstopMarkers=function(e){var t=this.editor.session;e.forEach(function(a){a.markerId||(a.markerId=t.addMarker(a,"ace_snippet-marker","text"))})},this.removeTabstopMarkers=function(e){var t=this.editor.session;e.forEach(function(a){t.removeMarker(a.markerId),a.markerId=null})},this.removeRange=function(e){var t=e.tabstop.indexOf(e);-1!=t&&e.tabstop.splice(t,1),-1!=(t=this.ranges.indexOf(e))&&this.ranges.splice(t,1),-1!=(t=e.tabstop.rangeList.ranges.indexOf(e))&&e.tabstop.splice(t,1),this.editor.session.removeMarker(e.markerId),e.tabstop.length||(-1!=(t=this.tabstops.indexOf(e.tabstop))&&this.tabstops.splice(t,1),this.tabstops.length||this.detach())},this.keyboardHandler=new R,this.keyboardHandler.bindKeys({Tab:function(e){E.snippetManager&&E.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}})}).call(f.prototype);var p=function(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row},m=function(e,t){e.row==t.row&&(e.column-=t.column),e.row-=t.row};k.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),E.snippetManager=new i;var T=b("./editor").Editor;(function(){this.insertSnippet=function(e,t){return E.snippetManager.insertSnippet(this,e,t)},this.expandSnippet=function(e){return E.snippetManager.expandWithTab(this,e)}}).call(T.prototype)}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom"],function(b,E,P){"use strict";var k=b("../virtual_renderer").VirtualRenderer,L=b("../editor").Editor,$=b("../range").Range,_=b("../lib/event"),S=b("../lib/lang"),x=b("../lib/dom"),R=function(y){return"suggest-aria-id:".concat(y)},A=function(y){var s=new k(y);s.$maxLines=4;var i=new L(s);return i.setHighlightActiveLine(!1),i.setShowPrintMargin(!1),i.renderer.setShowGutter(!1),i.renderer.setHighlightGutterLine(!1),i.$mouseHandler.$focusTimeout=0,i.$highlightTagPending=!0,i};x.importCssString("\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin: 0.9em;\n}\n.ace_completion-message {\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}","autocompletion.css",!1),E.AcePopup=function(y){var s=x.createElement("div"),i=new A(s);y&&y.appendChild(s),s.style.display="none",i.renderer.content.style.cursor="default",i.renderer.setStyle("ace_autocomplete"),i.renderer.container.setAttribute("role","listbox"),i.renderer.container.setAttribute("aria-label","Autocomplete suggestions"),i.setOption("displayIndentGuides",!1),i.setOption("dragDelay",150);var f=function(){};i.focus=f,i.$isFocused=!0,i.renderer.$cursorLayer.restartTimer=f,i.renderer.$cursorLayer.element.style.opacity=0,i.renderer.$maxLines=8,i.renderer.$keepTextAreaAtCursor=!1,i.setHighlightActiveLine(!1),i.session.highlight(""),i.session.$searchHighlight.clazz="ace_highlight-marker",i.on("mousedown",function(n){var r=n.getDocumentPosition();i.selection.moveToPosition(r),T.start.row=T.end.row=r.row,n.stop()});var p,m=new $(-1,0,-1,1/0),T=new $(-1,0,-1,1/0);T.id=i.session.addMarker(T,"ace_active-line","fullLine"),i.setSelectOnHover=function(n){n?m.id&&(i.session.removeMarker(m.id),m.id=null):m.id=i.session.addMarker(m,"ace_line-hover","fullLine")},i.setSelectOnHover(!1),i.on("mousemove",function(n){if(p){if(p.x!=n.x||p.y!=n.y){(p=n).scrollTop=i.renderer.scrollTop;var r=p.getDocumentPosition().row;m.start.row!=r&&(m.id||i.setRow(r),t(r))}}else p=n}),i.renderer.on("beforeRender",function(){if(p&&-1!=m.start.row){p.$pos=null;var n=p.getDocumentPosition().row;m.id||i.setRow(n),t(n,!0)}}),i.renderer.on("afterRender",function(){var n=i.getRow(),r=i.renderer.$textLayer,c=r.element.childNodes[n-r.config.firstRow],o=document.activeElement;if(c!==r.selectedNode&&r.selectedNode&&(x.removeCssClass(r.selectedNode,"ace_selected"),o.removeAttribute("aria-activedescendant"),r.selectedNode.removeAttribute("id")),r.selectedNode=c,c){x.addCssClass(c,"ace_selected");var h=R(n);c.id=h,i.renderer.container.setAttribute("aria-activedescendant",h),o.setAttribute("aria-activedescendant",h),c.setAttribute("aria-label",i.getData(n).value)}});var e=function(){t(-1)},t=function(n,r){n!==m.start.row&&(m.start.row=m.end.row=n,r||i.session._emit("changeBackMarker"),i._emit("changeHoverMarker"))};i.getHoveredRow=function(){return m.start.row},_.addListener(i.container,"mouseout",e),i.on("hide",e),i.on("changeSelection",e),i.session.doc.getLength=function(){return i.data.length},i.session.doc.getLine=function(n){var r=i.data[n];return"string"==typeof r?r:r&&r.value||""};var a=i.session.bgTokenizer;return a.$tokenizeRow=function(n){var r=i.data[n],c=[];if(!r)return c;"string"==typeof r&&(r={value:r});var o=r.caption||r.value||r.name;function h(H,D){H&&c.push({type:(r.className||"")+(D||""),value:H})}for(var l=o.toLowerCase(),d=(i.filterText||"").toLowerCase(),u=0,g=0,v=0;v<=d.length;v++)if(v!=g&&(r.matchMask&1<<v||v==d.length)){var w=d.slice(g,v);g=v;var F=l.indexOf(w,u);if(-1==F)continue;h(o.slice(u,F),""),h(o.slice(F,u=F+w.length),"completion-highlight")}return h(o.slice(u,o.length),""),r.meta&&c.push({type:"completion-meta",value:r.meta}),r.message&&c.push({type:"completion-message",value:r.message}),c},a.$updateOnChange=f,a.start=f,i.session.$computeWidth=function(){return this.screenWidth=0},i.isOpen=!1,i.isTopdown=!1,i.autoSelect=!0,i.filterText="",i.data=[],i.setData=function(n,r){i.filterText=r||"",i.setValue(S.stringRepeat("\n",n.length),-1),i.data=n||[],i.setRow(0)},i.getData=function(n){return i.data[n]},i.getRow=function(){return T.start.row},i.setRow=function(n){n=Math.max(this.autoSelect?0:-1,Math.min(this.data.length,n)),T.start.row!=n&&(i.selection.clearSelection(),T.start.row=T.end.row=n||0,i.session._emit("changeBackMarker"),i.moveCursorTo(n||0,0),i.isOpen&&i._signal("select"))},i.on("changeSelection",function(){i.isOpen&&i.setRow(i.selection.lead.row),i.renderer.scrollCursorIntoView()}),i.hide=function(){this.container.style.display="none",this._signal("hide"),i.isOpen=!1},i.show=function(n,r,c){var o=this.container,h=window.innerHeight,l=window.innerWidth,d=this.renderer,g=n.top+this.$borderSize;g>h/2&&!c&&g+r+d.$maxLines*r*1.4>h?(d.$maxPixelHeight=g-2*this.$borderSize,o.style.top="",o.style.bottom=h-g+"px",i.isTopdown=!1):(d.$maxPixelHeight=h-(g+=r)-.2*r,o.style.top=g+"px",o.style.bottom="",i.isTopdown=!0),o.style.display="";var w=n.left;w+o.offsetWidth>l&&(w=l-o.offsetWidth),o.style.left=w+"px",this._signal("show"),p=null,i.isOpen=!0},i.goTo=function(n){var r=this.getRow(),c=this.session.getLength()-1;switch(n){case"up":r=r<=0?c:r-1;break;case"down":r=r>=c?-1:r+1;break;case"start":r=0;break;case"end":r=c}this.setRow(r)},i.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},i.$imageSize=0,i.$borderSize=1,i},E.$singleLineEditor=A,E.getAriaId=R}),ace.define("ace/autocomplete/util",["require","exports","module"],function(b,E,P){"use strict";E.parForEach=function(L,$,_){var S=0,x=L.length;0===x&&_();for(var R=0;R<x;R++)$(L[R],function(A,M){++S===x&&_(A,M)})};var k=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;E.retrievePrecedingIdentifier=function(L,$,_){_=_||k;for(var S=[],x=$-1;x>=0&&_.test(L[x]);x--)S.push(L[x]);return S.reverse().join("")},E.retrieveFollowingIdentifier=function(L,$,_){_=_||k;for(var S=[],x=$;x<L.length&&_.test(L[x]);x++)S.push(L[x]);return S},E.getCompletionPrefix=function(L){var S,$=L.getCursorPosition(),_=L.session.getLine($.row);return L.completers.forEach(function(x){x.identifierRegexps&&x.identifierRegexps.forEach(function(R){!S&&R&&(S=this.retrievePrecedingIdentifier(_,$.column,R))}.bind(this))}.bind(this)),S||this.retrievePrecedingIdentifier(_,$.column)}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config"],function(b,E,P){"use strict";var k=b("./keyboard/hash_handler").HashHandler,L=b("./autocomplete/popup").AcePopup,$=b("./autocomplete/popup").getAriaId,_=b("./autocomplete/util"),S=b("./lib/lang"),x=b("./lib/dom"),R=b("./snippets").snippetManager,A=b("./config"),M=function(){this.autoInsert=!1,this.autoSelect=!0,this.exactMatch=!1,this.gatherCompletionsId=0,this.keyboardHandler=new k,this.keyboardHandler.bindKeys(this.commands),this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.changeTimer=S.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=S.delayedCall(this.updateDocTooltip.bind(this),50)};(function(){this.$init=function(){return this.popup=new L(document.body||document.documentElement),this.popup.on("click",function(s){this.insertMatch(),s.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.tooltipTimer.bind(null,null)),this.popup.on("select",this.tooltipTimer.bind(null,null)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},this.getPopup=function(){return this.popup||this.$init()},this.openPopup=function(s,i,f){this.popup||this.$init(),this.popup.autoSelect=this.autoSelect,this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions({activeDescendant:$(this.popup.getRow())}),s.keyBinding.addKeyboardHandler(this.keyboardHandler);var p=s.renderer;if(this.popup.setRow(this.autoSelect?0:-1),f)f&&!i&&this.detach();else{this.popup.setTheme(s.getTheme()),this.popup.setFontSize(s.getFontSize());var m=p.layerConfig.lineHeight,T=p.$cursorLayer.getPixelPosition(this.base,!0);T.left-=this.popup.getTextLeftOffset();var e=s.container.getBoundingClientRect();T.top+=e.top-p.layerConfig.offset,T.left+=e.left-s.renderer.scrollLeft,T.left+=p.gutterWidth,this.popup.show(T,m)}this.changeTimer.cancel()},this.detach=function(){this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener),this.changeTimer.cancel(),this.hideDocTooltip(),this.gatherCompletionsId+=1,this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completions=this.base=null},this.changeListener=function(s){var i=this.editor.selection.lead;(i.row!=this.base.row||i.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},this.blurListener=function(s){var i=document.activeElement,f=this.editor.textInput.getElement(),p=s.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(s.relatedTarget);i!=f&&i.parentNode!=(this.popup&&this.popup.container)&&!p&&i!=this.tooltipNode&&s.relatedTarget!=f&&this.detach()},this.mousedownListener=function(s){this.detach()},this.mousewheelListener=function(s){this.detach()},this.goTo=function(s){this.popup.goTo(s)},this.insertMatch=function(s,i){if(s||(s=this.popup.getData(this.popup.getRow())),!s)return!1;var f=this.completions;if(this.editor.startOperation({command:{name:"insertMatch"}}),s.completer&&s.completer.insertMatch)s.completer.insertMatch(this.editor,s);else{if(!f)return!1;if(f.filterText)for(var T,p=this.editor.selection.getAllRanges(),m=0;T=p[m];m++)T.start.column-=f.filterText.length,this.editor.session.remove(T);s.snippet?R.insertSnippet(this.editor,s.snippet):this.editor.execCommand("insertstring",s.value||s)}this.completions==f&&this.detach(),this.editor.endOperation()},this.commands={Up:function(s){s.completer.goTo("up")},Down:function(s){s.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(s){s.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(s){s.completer.goTo("end")},Esc:function(s){s.completer.detach()},Return:function(s){return s.completer.insertMatch()},"Shift-Return":function(s){s.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(s){var i=s.completer.insertMatch();if(i||s.tabstopManager)return i;s.completer.goTo("down")},PageUp:function(s){s.completer.popup.gotoPageUp()},PageDown:function(s){s.completer.popup.gotoPageDown()}},this.gatherCompletions=function(s,i){var f=s.getSession(),p=s.getCursorPosition(),m=_.getCompletionPrefix(s);this.base=f.doc.createAnchor(p.row,p.column-m.length),this.base.$insertRight=!0;var T=[],e=s.completers.length;return s.completers.forEach(function(t,a){t.getCompletions(s,f,p,m,function(n,r){!n&&r&&(T=T.concat(r)),i(null,{prefix:_.getCompletionPrefix(s),matches:T,finished:0==--e})})}),!0},this.showPopup=function(s,i){this.editor&&this.detach(),this.activated=!0,this.editor=s,s.completer!=this&&(s.completer&&s.completer.detach(),s.completer=this),s.on("changeSelection",this.changeListener),s.on("blur",this.blurListener),s.on("mousedown",this.mousedownListener),s.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,i)},this.updateCompletions=function(s,i){if(s&&this.base&&this.completions){var f=this.editor.getCursorPosition(),p=this.editor.session.getTextRange({start:this.base,end:f});if(p==this.completions.filterText)return;return this.completions.setFilter(p),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=p||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,p,s):this.detach()}if(i&&i.matches)return f=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(f.row,f.column),this.base.$insertRight=!0,this.completions=new y(i.matches),this.openPopup(this.editor,"",s);var m=this.gatherCompletionsId,T=function(r){if(r.finished)return this.detach()}.bind(this),e=function(r){var c=r.prefix;this.completions=new y(r.matches),this.exactMatch&&(this.completions.exactMatch=!0),this.completions.setFilter(c);var h=this.completions.filtered;return!h.length||1==h.length&&h[0].value==c&&!h[0].snippet?T(r):this.autoInsert&&1==h.length&&r.finished?this.insertMatch(h[0]):void this.openPopup(this.editor,c,s)}.bind(this),t=!0,a=null;if(this.gatherCompletions(this.editor,function(r,c){var o=c.prefix,h=c&&c.matches;if(!h||!h.length)return T(c);if(0===o.indexOf(c.prefix)&&m==this.gatherCompletionsId){if(t)return void(a=c);e(c)}}.bind(this)),t=!1,a){var n=a;a=null,e(n)}},this.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},this.updateDocTooltip=function(){var s=this.popup,i=s.data,f=i&&(i[s.getHoveredRow()]||i[s.getRow()]),p=null;return f&&this.editor&&this.popup.isOpen?(this.editor.completers.some(function(m){return m.getDocTooltip&&(p=m.getDocTooltip(f)),p}),!p&&"string"!=typeof f&&(p=f),"string"==typeof p&&(p={docText:p}),p&&(p.docHTML||p.docText)?void this.showDocTooltip(p):this.hideDocTooltip()):this.hideDocTooltip()},this.showDocTooltip=function(s){this.tooltipNode||(this.tooltipNode=x.createElement("div"),this.tooltipNode.className="ace_tooltip ace_doc-tooltip",this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this));var i=this.tooltipNode;s.docHTML?i.innerHTML=s.docHTML:s.docText&&(i.textContent=s.docText),i.parentNode||document.body.appendChild(i);var f=this.popup,p=f.container.getBoundingClientRect();i.style.top=f.container.style.top,i.style.bottom=f.container.style.bottom,i.style.display="block",window.innerWidth-p.right<320?p.left<320?f.isTopdown?(i.style.top=p.bottom+"px",i.style.left=p.left+"px",i.style.right="",i.style.bottom=""):(i.style.top=f.container.offsetTop-i.offsetHeight+"px",i.style.left=p.left+"px",i.style.right="",i.style.bottom=""):(i.style.right=window.innerWidth-p.left+"px",i.style.left=""):(i.style.left=p.right+1+"px",i.style.right="")},this.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var s=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==s&&this.editor.focus(),this.tooltipNode=null,s.parentNode&&s.parentNode.removeChild(s)}},this.onTooltipClick=function(s){for(var i=s.target;i&&i!=this.tooltipNode;){if("A"==i.nodeName&&i.href){i.rel="noreferrer",i.target="_blank";break}i=i.parentNode}},this.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var s=this.popup.container;s&&s.parentNode&&s.parentNode.removeChild(s)}this.popup=null}}).call(M.prototype),M.for=function(s){return s.completer||(A.get("sharedPopups")?(M.$shared||(M.$sharedInstance=new M),s.completer=M.$sharedInstance):(s.completer=new M,s.once("destroy",function(i,f){f.completer.destroy()}))),s.completer},M.startCommand={name:"startAutocomplete",exec:function(s,i){var f=M.for(s);f.autoInsert=!1,f.autoSelect=!0,f.showPopup(s,i),f.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var y=function(s,i){this.all=s,this.filtered=s,this.filterText=i||"",this.exactMatch=!1};(function(){this.setFilter=function(s){if(s.length>this.filterText&&0===s.lastIndexOf(this.filterText,0))var i=this.filtered;else i=this.all;this.filterText=s,i=(i=this.filterCompletions(i,this.filterText)).sort(function(p,m){return m.exactMatch-p.exactMatch||m.$score-p.$score||(p.caption||p.value).localeCompare(m.caption||m.value)});var f=null;i=i.filter(function(p){var m=p.snippet||p.caption||p.value;return m!==f&&(f=m,!0)}),this.filtered=i},this.filterCompletions=function(s,i){var f=[],p=i.toUpperCase(),m=i.toLowerCase();e:for(var e,T=0;e=s[T];T++){var t=e.caption||e.value||e.snippet;if(t){var c,o,a=-1,n=0,r=0;if(this.exactMatch){if(i!==t.substr(0,i.length))continue e}else{var h=t.toLowerCase().indexOf(m);if(h>-1)r=h;else for(var l=0;l<i.length;l++){var d=t.indexOf(m[l],a+1),u=t.indexOf(p[l],a+1);if((c=d>=0&&(u<0||d<u)?d:u)<0)continue e;(o=c-a-1)>0&&(-1===a&&(r+=10),r+=o,n|=1<<l),a=c}}e.matchMask=n,e.exactMatch=r?0:1,e.$score=(e.score||0)-r,f.push(e)}}return f}}).call(y.prototype),E.Autocomplete=M,E.FilteredList=y}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(b,E,P){var k=b("../range").Range,L=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;E.getCompletions=function(S,x,R,A,M){var y=function _(S,x){var R=function $(S,x){return S.getTextRange(k.fromPoints({row:0,column:0},x)).split(L).length-1}(S,x),A=S.getValue().split(L),M=Object.create(null),y=A[R];return A.forEach(function(s,i){if(s&&s!==y){var f=Math.abs(R-i),p=A.length-f;M[s]=M[s]?Math.max(p,M[s]):p}}),M}(x,R);M(null,Object.keys(y).map(function(i){return{caption:i,value:i,score:y[i],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(b,E,P){"use strict";var k=b("../snippets").snippetManager,L=b("../autocomplete").Autocomplete,$=b("../config"),_=b("../lib/lang"),S=b("../autocomplete/util"),x=b("../autocomplete/text_completer"),R={getCompletions:function(e,t,a,n,r){if(t.$mode.completer)return t.$mode.completer.getCompletions(e,t,a,n,r);var c=e.session.getState(a.row);r(null,t.$mode.getCompletions(c,t,a,n))}},A=function(e){var t={};return e.replace(/\${(\d+)(:(.*?))?}/g,function(a,n,r,c){return t[n]=c||""}).replace(/\$(\d+?)/g,function(a,n){return t[n]})},M={getCompletions:function(e,t,a,n,r){var c=[],o=t.getTokenAt(a.row,a.column);o&&o.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?c.push("html-tag"):c=k.getActiveScopes(e);var h=k.snippetMap,l=[];c.forEach(function(d){for(var u=h[d]||[],g=u.length;g--;){var v=u[g],w=v.name||v.tabTrigger;!w||l.push({caption:w,snippet:v.content,meta:v.tabTrigger&&!v.name?v.tabTrigger+"\u21e5 ":"snippet",type:"snippet"})}},this),r(null,l)},getDocTooltip:function(e){"snippet"==e.type&&!e.docHTML&&(e.docHTML=["<b>",_.escapeHTML(e.caption),"</b>","<hr></hr>",_.escapeHTML(A(e.snippet))].join(""))}},y=[M,x,R];E.setCompleters=function(e){y.length=0,e&&y.push.apply(y,e)},E.addCompleter=function(e){y.push(e)},E.textCompleter=x,E.keyWordCompleter=R,E.snippetCompleter=M;var s={name:"expandSnippet",exec:function(e){return k.expandWithTab(e)},bindKey:"Tab"},i=function(e,t){f(t.session.$mode)},f=function(e){"string"==typeof e&&(e=$.$modes[e]),e&&(k.files||(k.files={}),p(e.$id,e.snippetFileId),e.modes&&e.modes.forEach(f))},p=function(e,t){!t||!e||k.files[e]||(k.files[e]={},$.loadModule(t,function(a){!a||(k.files[e]=a,!a.snippets&&a.snippetText&&(a.snippets=k.parseSnippetFile(a.snippetText)),k.register(a.snippets||[],a.scope),a.includeScopes&&(k.snippetMap[a.scope].includeScopes=a.includeScopes,a.includeScopes.forEach(function(n){f("ace/mode/"+n)})))}))},m=function(e){var t=e.editor,a=t.completer&&t.completer.activated;if("backspace"===e.command.name)a&&!S.getCompletionPrefix(t)&&t.completer.detach();else if("insertstring"===e.command.name&&S.getCompletionPrefix(t)&&!a){var r=L.for(t);r.autoInsert=!1,r.showPopup(t)}},T=b("../editor").Editor;b("../config").defineOptions(T.prototype,"editor",{enableBasicAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:y),this.commands.addCommand(L.startCommand)):this.commands.removeCommand(L.startCommand)},value:!1},enableLiveAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:y),this.commands.on("afterExec",m)):this.commands.removeListener("afterExec",m)},value:!1},enableSnippets:{set:function(e){e?(this.commands.addCommand(s),this.on("changeMode",i),i(0,this)):(this.commands.removeCommand(s),this.off("changeMode",i))},value:!1}})}),ace.require(["ace/ext/language_tools"],function(b){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=b)});