/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.engine.application.CorsResponseHelper;
import org.restlet.engine.util.SetUtils;
import org.restlet.routing.Filter;

public class CorsFilter
extends Filter {
    public boolean allowAllRequestedHeaders = true;
    private boolean allowedCredentials = false;
    private Set<String> allowedHeaders = null;
    private Set<String> allowedOrigins = SetUtils.newHashSet("*");
    private CorsResponseHelper corsResponseHelper;
    private Set<Method> defaultAllowedMethods = new HashSet<Method>(Arrays.asList(Method.GET, Method.POST, Method.PUT, Method.DELETE, Method.PATCH));
    private Set<String> exposedHeaders = null;
    private int maxAge = -1;
    private boolean skippingResourceForCorsOptions = false;

    public CorsFilter() {
        this(null);
    }

    public CorsFilter(Context context) {
        super(context, null);
    }

    public CorsFilter(Context context, Restlet next) {
        super(context, next);
    }

    @Override
    protected void afterHandle(Request request, Response response) {
        this.getCorsResponseHelper().addCorsResponseHeaders(request, response);
    }

    @Override
    protected int beforeHandle(Request request, Response response) {
        if (this.skippingResourceForCorsOptions && Method.OPTIONS.equals(request.getMethod()) && this.getCorsResponseHelper().isCorsRequest(request)) {
            response.setAllowedMethods(this.getDefaultAllowedMethods());
            return 1;
        }
        return 0;
    }

    public Set<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    protected CorsResponseHelper getCorsResponseHelper() {
        if (this.corsResponseHelper == null) {
            this.corsResponseHelper = new CorsResponseHelper();
            this.corsResponseHelper.setAllowedCredentials(this.allowedCredentials);
            this.corsResponseHelper.setAllowedOrigins(this.allowedOrigins);
            this.corsResponseHelper.setAllowAllRequestedHeaders(this.allowAllRequestedHeaders);
            this.corsResponseHelper.setAllowedHeaders(this.allowedHeaders);
            this.corsResponseHelper.setExposedHeaders(this.exposedHeaders);
            this.corsResponseHelper.setMaxAge(this.maxAge);
        }
        return this.corsResponseHelper;
    }

    public Set<Method> getDefaultAllowedMethods() {
        return this.defaultAllowedMethods;
    }

    public Set<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isAllowAllRequestedHeaders() {
        return this.allowAllRequestedHeaders;
    }

    public boolean isAllowedCredentials() {
        return this.allowedCredentials;
    }

    public boolean isSkippingResourceForCorsOptions() {
        return this.skippingResourceForCorsOptions;
    }

    public CorsFilter setAllowedCredentials(boolean allowedCredentials) {
        this.allowedCredentials = allowedCredentials;
        return this;
    }

    public CorsFilter setAllowedHeaders(Set<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public CorsFilter setAllowedOrigins(Set<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public CorsFilter setAllowingAllRequestedHeaders(boolean allowingAllRequestedHeaders) {
        this.allowAllRequestedHeaders = allowingAllRequestedHeaders;
        return this;
    }

    public CorsFilter setDefaultAllowedMethods(Set<Method> defaultAllowedMethods) {
        this.defaultAllowedMethods = defaultAllowedMethods;
        return this;
    }

    public CorsFilter setExposedHeaders(Set<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    public CorsFilter setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public CorsFilter setSkippingResourceForCorsOptions(boolean skipResourceForCorsOptions) {
        this.skippingResourceForCorsOptions = skipResourceForCorsOptions;
        return this;
    }
}

