@REM ----------------------------------------------------------------------------
@REM Copyright 2001-2004 The Apache Software Foundation.
@REM
@REM Licensed under the Apache License, Version 2.0 (the "License");
@REM you may not use this file except in compliance with the License.
@REM You may obtain a copy of the License at
@REM
@REM      http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM Unless required by applicable law or agreed to in writing, software
@REM distributed under the License is distributed on an "AS IS" BASIS,
@REM WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM See the License for the specific language governing permissions and
@REM limitations under the License.
@REM ----------------------------------------------------------------------------
@REM

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\conf;"%REPO%"\org\apache\helix\metadata-store-directory-common\1.0.3\metadata-store-directory-common-1.0.3.jar;"%REPO%"\org\apache\httpcomponents\httpclient\4.5.8\httpclient-4.5.8.jar;"%REPO%"\org\apache\httpcomponents\httpcore\4.4.11\httpcore-4.4.11.jar;"%REPO%"\commons-logging\commons-logging\1.2\commons-logging-1.2.jar;"%REPO%"\com\google\guava\guava\20.0\guava-20.0.jar;"%REPO%"\org\yaml\snakeyaml\1.17\snakeyaml-1.17.jar;"%REPO%"\org\slf4j\slf4j-api\1.7.32\slf4j-api-1.7.32.jar;"%REPO%"\org\apache\logging\log4j\log4j-slf4j-impl\2.17.1\log4j-slf4j-impl-2.17.1.jar;"%REPO%"\org\apache\logging\log4j\log4j-api\2.17.1\log4j-api-2.17.1.jar;"%REPO%"\org\apache\logging\log4j\log4j-core\2.17.1\log4j-core-2.17.1.jar;"%REPO%"\org\apache\helix\helix-core\1.0.3\helix-core-1.0.3.jar;"%REPO%"\org\apache\helix\helix-common\1.0.3\helix-common-1.0.3.jar;"%REPO%"\org\apache\helix\metrics-common\1.0.3\metrics-common-1.0.3.jar;"%REPO%"\org\apache\helix\zookeeper-api\1.0.3\zookeeper-api-1.0.3.jar;"%REPO%"\org\apache\zookeeper\zookeeper\3.5.9\zookeeper-3.5.9.jar;"%REPO%"\org\apache\zookeeper\zookeeper-jute\3.5.9\zookeeper-jute-3.5.9.jar;"%REPO%"\org\apache\yetus\audience-annotations\0.5.0\audience-annotations-0.5.0.jar;"%REPO%"\io\netty\netty-handler\4.1.50.Final\netty-handler-4.1.50.Final.jar;"%REPO%"\io\netty\netty-common\4.1.50.Final\netty-common-4.1.50.Final.jar;"%REPO%"\io\netty\netty-resolver\4.1.50.Final\netty-resolver-4.1.50.Final.jar;"%REPO%"\io\netty\netty-buffer\4.1.50.Final\netty-buffer-4.1.50.Final.jar;"%REPO%"\io\netty\netty-transport\4.1.50.Final\netty-transport-4.1.50.Final.jar;"%REPO%"\io\netty\netty-codec\4.1.50.Final\netty-codec-4.1.50.Final.jar;"%REPO%"\io\netty\netty-transport-native-epoll\4.1.50.Final\netty-transport-native-epoll-4.1.50.Final.jar;"%REPO%"\io\netty\netty-transport-native-unix-common\4.1.50.Final\netty-transport-native-unix-common-4.1.50.Final.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-core\2.11.0\jackson-core-2.11.0.jar;"%REPO%"\commons-io\commons-io\1.4\commons-io-1.4.jar;"%REPO%"\org\apache\commons\commons-math\2.1\commons-math-2.1.jar;"%REPO%"\org\apache\commons\commons-math3\3.6.1\commons-math3-3.6.1.jar;"%REPO%"\commons-codec\commons-codec\1.6\commons-codec-1.6.jar;"%REPO%"\io\dropwizard\metrics\metrics-core\4.1.14\metrics-core-4.1.14.jar;"%REPO%"\javax\xml\bind\jaxb-api\2.1\jaxb-api-2.1.jar;"%REPO%"\javax\xml\stream\stax-api\1.0-2\stax-api-1.0-2.jar;"%REPO%"\javax\activation\activation\1.1\activation-1.1.jar;"%REPO%"\org\apache\commons\commons-lang3\3.8.1\commons-lang3-3.8.1.jar;"%REPO%"\org\eclipse\jetty\jetty-server\9.1.0.RC0\jetty-server-9.1.0.RC0.jar;"%REPO%"\javax\servlet\javax.servlet-api\3.1.0\javax.servlet-api-3.1.0.jar;"%REPO%"\org\eclipse\jetty\jetty-http\9.1.0.RC0\jetty-http-9.1.0.RC0.jar;"%REPO%"\org\eclipse\jetty\jetty-util\9.1.0.RC0\jetty-util-9.1.0.RC0.jar;"%REPO%"\org\eclipse\jetty\jetty-io\9.1.0.RC0\jetty-io-9.1.0.RC0.jar;"%REPO%"\org\glassfish\jersey\core\jersey-server\2.10\jersey-server-2.10.jar;"%REPO%"\org\glassfish\jersey\core\jersey-common\2.10\jersey-common-2.10.jar;"%REPO%"\org\glassfish\jersey\bundles\repackaged\jersey-guava\2.10\jersey-guava-2.10.jar;"%REPO%"\org\glassfish\hk2\osgi-resource-locator\1.0.1\osgi-resource-locator-1.0.1.jar;"%REPO%"\org\glassfish\jersey\core\jersey-client\2.10\jersey-client-2.10.jar;"%REPO%"\javax\ws\rs\javax.ws.rs-api\2.0\javax.ws.rs-api-2.0.jar;"%REPO%"\javax\annotation\javax.annotation-api\1.2\javax.annotation-api-1.2.jar;"%REPO%"\org\glassfish\hk2\hk2-api\2.3.0-b05\hk2-api-2.3.0-b05.jar;"%REPO%"\org\glassfish\hk2\hk2-utils\2.3.0-b05\hk2-utils-2.3.0-b05.jar;"%REPO%"\org\glassfish\hk2\external\aopalliance-repackaged\2.3.0-b05\aopalliance-repackaged-2.3.0-b05.jar;"%REPO%"\org\glassfish\hk2\external\javax.inject\2.3.0-b05\javax.inject-2.3.0-b05.jar;"%REPO%"\org\glassfish\hk2\hk2-locator\2.3.0-b05\hk2-locator-2.3.0-b05.jar;"%REPO%"\org\javassist\javassist\3.18.1-GA\javassist-3.18.1-GA.jar;"%REPO%"\javax\validation\validation-api\1.1.0.Final\validation-api-1.1.0.Final.jar;"%REPO%"\org\eclipse\jetty\jetty-servlet\9.1.0.RC0\jetty-servlet-9.1.0.RC0.jar;"%REPO%"\org\eclipse\jetty\jetty-security\9.1.0.RC0\jetty-security-9.1.0.RC0.jar;"%REPO%"\org\glassfish\jersey\containers\jersey-container-jetty-http\2.9\jersey-container-jetty-http-2.9.jar;"%REPO%"\org\eclipse\jetty\jetty-continuation\9.1.1.v20140108\jetty-continuation-9.1.1.v20140108.jar;"%REPO%"\org\glassfish\jersey\containers\jersey-container-servlet-core\2.9\jersey-container-servlet-core-2.9.jar;"%REPO%"\org\glassfish\jersey\containers\jersey-container-grizzly2-servlet\2.9\jersey-container-grizzly2-servlet-2.9.jar;"%REPO%"\org\glassfish\jersey\containers\jersey-container-servlet\2.9\jersey-container-servlet-2.9.jar;"%REPO%"\org\glassfish\jersey\containers\jersey-container-grizzly2-http\2.9\jersey-container-grizzly2-http-2.9.jar;"%REPO%"\org\glassfish\grizzly\grizzly-http-server\2.3.8\grizzly-http-server-2.3.8.jar;"%REPO%"\org\glassfish\grizzly\grizzly-http\2.3.8\grizzly-http-2.3.8.jar;"%REPO%"\org\glassfish\grizzly\grizzly-framework\2.3.8\grizzly-framework-2.3.8.jar;"%REPO%"\org\glassfish\grizzly\grizzly-http-servlet\2.3.8\grizzly-http-servlet-2.3.8.jar;"%REPO%"\org\glassfish\jersey\test-framework\jersey-test-framework-core\2.15\jersey-test-framework-core-2.15.jar;"%REPO%"\org\ow2\asm\asm-debug-all\5.0.2\asm-debug-all-5.0.2.jar;"%REPO%"\org\glassfish\jersey\test-framework\providers\jersey-test-framework-provider-grizzly2\2.11\jersey-test-framework-provider-grizzly2-2.11.jar;"%REPO%"\com\thoughtworks\xstream\xstream\1.3.1\xstream-1.3.1.jar;"%REPO%"\xpp3\xpp3_min\1.1.4c\xpp3_min-1.1.4c.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-databind\2.11.0\jackson-databind-2.11.0.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-annotations\2.11.0\jackson-annotations-2.11.0.jar;"%REPO%"\commons-cli\commons-cli\1.2\commons-cli-1.2.jar;"%REPO%"\io\dropwizard\metrics\metrics-jersey2\4.1.14\metrics-jersey2-4.1.14.jar;"%REPO%"\io\dropwizard\metrics\metrics-annotation\4.1.14\metrics-annotation-4.1.14.jar;"%REPO%"\io\dropwizard\metrics\metrics-jmx\4.1.14\metrics-jmx-4.1.14.jar;"%REPO%"\org\apache\helix\helix-rest\1.0.3\helix-rest-1.0.3.jar
set EXTRA_JVM_ARGUMENTS=-Dlog4j2.formatMsgNoLookups=true -Dlog4j2.configurationFile=file://"$BASEDIR"/conf/log4j2.properties
goto endInit

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% %EXTRA_JVM_ARGUMENTS% -classpath %CLASSPATH_PREFIX%;%CLASSPATH% -Dapp.name="run-rest-admin" -Dapp.repo="%REPO%" -Dbasedir="%BASEDIR%" org.apache.helix.rest.server.HelixRestMain %CMD_LINE_ARGS%
if ERRORLEVEL 1 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=1

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@endlocal

:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
