/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.clusterMaintenanceService;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.RESTConfig;
import org.apache.helix.rest.client.CustomRestClient;
import org.apache.helix.rest.client.CustomRestClientFactory;
import org.apache.helix.rest.clusterMaintenanceService.HealthCheck;
import org.apache.helix.rest.clusterMaintenanceService.MaintenanceManagementInstanceInfo;
import org.apache.helix.rest.clusterMaintenanceService.api.OperationInterface;
import org.apache.helix.rest.common.HelixDataAccessorWrapper;
import org.apache.helix.rest.common.datamodel.RestSnapShot;
import org.apache.helix.rest.server.json.instance.InstanceInfo;
import org.apache.helix.rest.server.json.instance.StoppableCheck;
import org.apache.helix.rest.server.resources.helix.PerInstanceAccessor;
import org.apache.helix.rest.server.service.InstanceService;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.InstanceValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceManagementService {
    private static final Logger LOG = LoggerFactory.getLogger(MaintenanceManagementService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ExecutorService POOL = Executors.newCachedThreadPool();
    private static final String CUSTOM_INSTANCE_CHECK_HTTP_REQUESTS_ERROR_TOTAL = MetricRegistry.name(InstanceService.class, (String[])new String[]{"custom_instance_check_http_requests_error_total"});
    private static final String CUSTOM_INSTANCE_CHECK_HTTP_REQUESTS_DURATION = MetricRegistry.name(InstanceService.class, (String[])new String[]{"custom_instance_check_http_requests_duration"});
    public static final String ALL_HEALTH_CHECK_NONBLOCK = "allHealthCheckNonBlock";
    private final ConfigAccessor _configAccessor;
    private final CustomRestClient _customRestClient;
    private final String _namespace;
    private final boolean _skipZKRead;
    private final HelixDataAccessorWrapper _dataAccessor;
    private final Set<String> _nonBlockingHealthChecks;

    public MaintenanceManagementService(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor, boolean skipZKRead, String namespace) {
        this(dataAccessor, configAccessor, CustomRestClientFactory.get(), skipZKRead, Collections.emptySet(), namespace);
    }

    public MaintenanceManagementService(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor, boolean skipZKRead, Set<String> nonBlockingHealthChecks, String namespace) {
        this(dataAccessor, configAccessor, CustomRestClientFactory.get(), skipZKRead, nonBlockingHealthChecks, namespace);
    }

    public MaintenanceManagementService(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor, boolean skipZKRead, boolean continueOnFailure, String namespace) {
        this(dataAccessor, configAccessor, CustomRestClientFactory.get(), skipZKRead, continueOnFailure ? Collections.singleton(ALL_HEALTH_CHECK_NONBLOCK) : Collections.emptySet(), namespace);
    }

    @VisibleForTesting
    MaintenanceManagementService(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor, CustomRestClient customRestClient, boolean skipZKRead, Set<String> nonBlockingHealthChecks, String namespace) {
        this._dataAccessor = new HelixDataAccessorWrapper(dataAccessor, customRestClient, namespace);
        this._configAccessor = configAccessor;
        this._customRestClient = customRestClient;
        this._skipZKRead = skipZKRead;
        this._nonBlockingHealthChecks = nonBlockingHealthChecks;
        this._namespace = namespace;
    }

    public MaintenanceManagementInstanceInfo takeInstance(String clusterId, String instanceName, List<String> healthChecks, Map<String, String> healthCheckConfig, List<String> operations, Map<String, String> operationConfig, boolean performOperation) throws IOException {
        if ((healthChecks == null || healthChecks.isEmpty()) && (operations == null || operations.isEmpty())) {
            MaintenanceManagementInstanceInfo result = new MaintenanceManagementInstanceInfo(MaintenanceManagementInstanceInfo.OperationalStatus.FAILURE);
            result.addMessage("Invalid input. Please provide at least one health check or operation.");
            return result;
        }
        return this.takeFreeSingleInstanceHelper(clusterId, instanceName, healthChecks, healthCheckConfig, operations, operationConfig, performOperation, true);
    }

    public Map<String, MaintenanceManagementInstanceInfo> takeInstances(String clusterId, List<String> instances, List<String> healthChecks, Map<String, String> healthCheckConfig, List<String> operations, Map<String, String> operationConfig, boolean performOperation) throws IOException {
        return null;
    }

    public MaintenanceManagementInstanceInfo freeInstance(String clusterId, String instanceName, List<String> healthChecks, Map<String, String> healthCheckConfig, List<String> operations, Map<String, String> operationConfig, boolean performOperation) throws IOException {
        return this.takeFreeSingleInstanceHelper(clusterId, instanceName, healthChecks, healthCheckConfig, operations, operationConfig, performOperation, false);
    }

    public Map<String, MaintenanceManagementInstanceInfo> freeInstances(String clusterId, List<String> instances, List<String> healthChecks, Map<String, String> healthCheckConfig, List<String> operations, Map<String, String> operationConfig, boolean performOperation) throws IOException {
        return null;
    }

    public InstanceInfo getInstanceHealthInfo(String clusterId, String instanceName, List<HealthCheck> healthChecks) {
        InstanceInfo.Builder instanceInfoBuilder = new InstanceInfo.Builder(instanceName);
        InstanceConfig instanceConfig = (InstanceConfig)this._dataAccessor.getProperty(this._dataAccessor.keyBuilder().instanceConfig(instanceName));
        LiveInstance liveInstance = (LiveInstance)this._dataAccessor.getProperty(this._dataAccessor.keyBuilder().liveInstance(instanceName));
        if (instanceConfig != null) {
            instanceInfoBuilder.instanceConfig(instanceConfig.getRecord());
        } else {
            LOG.warn("Missing instance config for {}", (Object)instanceName);
        }
        if (liveInstance != null) {
            instanceInfoBuilder.liveInstance(liveInstance.getRecord());
            String sessionId = liveInstance.getEphemeralOwner();
            List<String> resourceNames = this._dataAccessor.getChildNames(this._dataAccessor.keyBuilder().currentStates(instanceName, sessionId));
            instanceInfoBuilder.resources(resourceNames);
            ArrayList<String> partitions = new ArrayList<String>();
            for (String resourceName : resourceNames) {
                CurrentState currentState = (CurrentState)this._dataAccessor.getProperty(this._dataAccessor.keyBuilder().currentState(instanceName, sessionId, resourceName));
                if (currentState != null && currentState.getPartitionStateMap() != null) {
                    partitions.addAll(currentState.getPartitionStateMap().keySet());
                    continue;
                }
                LOG.warn("Current state is either null or partitionStateMap is missing. InstanceName: {}, SessionId: {}, ResourceName: {}", new Object[]{instanceName, sessionId, resourceName});
            }
            instanceInfoBuilder.partitions(partitions);
        } else {
            LOG.warn("Missing live instance for {}", (Object)instanceName);
        }
        try {
            Map<String, Boolean> healthStatus = this.getInstanceHealthStatus(clusterId, instanceName, healthChecks);
            instanceInfoBuilder.healthStatus(healthStatus);
        }
        catch (HelixException ex) {
            LOG.error("Exception while getting health status. Cluster: {}, Instance: {}, reporting health status as unHealth", new Object[]{clusterId, instanceName, ex});
            instanceInfoBuilder.healthStatus(false);
        }
        return instanceInfoBuilder.build();
    }

    private List<OperationInterface> getAllOperationClasses(List<String> operations) {
        ArrayList<OperationInterface> operationAbstractClassList = new ArrayList<OperationInterface>();
        for (String operationClassName : operations) {
            try {
                LOG.info("Loading class: " + operationClassName);
                OperationInterface userOperation = (OperationInterface)HelixUtil.loadClass(this.getClass(), (String)operationClassName).newInstance();
                operationAbstractClassList.add(userOperation);
            }
            catch (Exception e) {
                LOG.error("No operation class found for: {}. message: ", (Object)operationClassName, (Object)e);
                throw new HelixException(String.format("No operation class found for: %s. message: %s", operationClassName, e));
            }
        }
        return operationAbstractClassList;
    }

    public StoppableCheck getInstanceStoppableCheck(String clusterId, String instanceName, String jsonContent) throws IOException {
        return this.batchGetInstancesStoppableChecks(clusterId, (List<String>)ImmutableList.of((Object)instanceName), jsonContent).get(instanceName);
    }

    public Map<String, StoppableCheck> batchGetInstancesStoppableChecks(String clusterId, List<String> instances, String jsonContent) throws IOException {
        HashMap<String, StoppableCheck> finalStoppableChecks = new HashMap<String, StoppableCheck>();
        List<String> instancesForCustomInstanceLevelChecks = this.batchHelixInstanceStoppableCheck(clusterId, instances, finalStoppableChecks);
        this.batchCustomInstanceStoppableCheck(clusterId, instancesForCustomInstanceLevelChecks, finalStoppableChecks, MaintenanceManagementService.getMapFromJsonPayload(jsonContent));
        return finalStoppableChecks;
    }

    private MaintenanceManagementInstanceInfo takeFreeSingleInstanceHelper(String clusterId, String instanceName, List<String> healthChecks, Map<String, String> healthCheckConfig, List<String> operations, Map<String, String> operationConfig, boolean performOperation, boolean isTakeInstance) {
        if (operations == null) {
            operations = new ArrayList<String>();
        }
        if (healthChecks == null) {
            healthChecks = new ArrayList<String>();
        }
        try {
            MaintenanceManagementInstanceInfo instanceInfo = this.batchInstanceHealthCheck(clusterId, (List<String>)ImmutableList.of((Object)instanceName), healthChecks, healthCheckConfig).getOrDefault(instanceName, new MaintenanceManagementInstanceInfo(MaintenanceManagementInstanceInfo.OperationalStatus.SUCCESS));
            if (!instanceInfo.isSuccessful()) {
                return instanceInfo;
            }
            List<OperationInterface> operationAbstractClassList = this.getAllOperationClasses(operations);
            this._dataAccessor.populateCache(OperationInterface.PROPERTY_TYPE_LIST);
            RestSnapShot sp = this._dataAccessor.getRestSnapShot();
            String continueOnFailuresName = PerInstanceAccessor.PerInstanceProperties.continueOnFailures.name();
            HashMap<String, Map<String, String>> operationConfigSet = new HashMap<String, Map<String, String>>();
            for (OperationInterface operationClass : operationAbstractClassList) {
                String operationClassName = operationClass.getClass().getName();
                Map<String, String> singleOperationConfig = operationConfig == null || !operationConfig.containsKey(operationClassName) ? Collections.emptyMap() : MaintenanceManagementService.getMapFromJsonPayload(operationConfig.get(operationClassName));
                operationConfigSet.put(operationClassName, singleOperationConfig);
                boolean continueOnFailures = singleOperationConfig.containsKey(continueOnFailuresName) && MaintenanceManagementService.getBooleanFromJsonPayload((String)singleOperationConfig.get(continueOnFailuresName));
                MaintenanceManagementInstanceInfo checkResult = isTakeInstance ? operationClass.operationCheckForTakeSingleInstance(instanceName, singleOperationConfig, sp) : operationClass.operationCheckForFreeSingleInstance(instanceName, singleOperationConfig, sp);
                instanceInfo.mergeResult(checkResult, continueOnFailures);
            }
            if (performOperation && instanceInfo.isSuccessful()) {
                for (OperationInterface operationClass : operationAbstractClassList) {
                    Map singleOperationConfig = (Map)operationConfigSet.get(operationClass.getClass().getName());
                    boolean continueOnFailures = singleOperationConfig.containsKey(continueOnFailuresName) && Boolean.parseBoolean((String)singleOperationConfig.get(continueOnFailuresName));
                    MaintenanceManagementInstanceInfo newResult = isTakeInstance ? operationClass.operationExecForTakeSingleInstance(instanceName, singleOperationConfig, sp) : operationClass.operationExecForFreeSingleInstance(instanceName, singleOperationConfig, sp);
                    instanceInfo.mergeResult(newResult, continueOnFailures);
                    if (instanceInfo.isSuccessful()) continue;
                    LOG.warn("Operation failed for {}, skip all following operations.", (Object)operationClass.getClass().getName());
                    break;
                }
            }
            return instanceInfo;
        }
        catch (Exception ex) {
            return new MaintenanceManagementInstanceInfo(MaintenanceManagementInstanceInfo.OperationalStatus.FAILURE, Collections.singletonList(ex.getMessage()));
        }
    }

    private List<String> batchHelixInstanceStoppableCheck(String clusterId, Collection<String> instances, Map<String, StoppableCheck> finalStoppableChecks) {
        Map<String, Future<StoppableCheck>> helixInstanceChecks = instances.stream().collect(Collectors.toMap(Function.identity(), instance -> POOL.submit(() -> this.performHelixOwnInstanceCheck(clusterId, (String)instance))));
        return this.filterInstancesForNextCheck(helixInstanceChecks, finalStoppableChecks);
    }

    private List<String> batchCustomInstanceStoppableCheck(String clusterId, List<String> instances, Map<String, StoppableCheck> finalStoppableChecks, Map<String, String> customPayLoads) {
        if (instances.isEmpty()) {
            return instances;
        }
        RESTConfig restConfig = this._configAccessor.getRESTConfig(clusterId);
        if (restConfig == null) {
            String errorMessage = String.format("The cluster %s hasn't enabled client side health checks yet, thus the stoppable check result is inaccurate", clusterId);
            LOG.error(errorMessage);
            throw new HelixException(errorMessage);
        }
        Map<String, Future<StoppableCheck>> customInstanceLevelChecks = instances.stream().collect(Collectors.toMap(Function.identity(), instance -> POOL.submit(() -> this.performCustomInstanceCheck(clusterId, (String)instance, restConfig.getBaseUrl(instance), customPayLoads))));
        List<String> instancesForCustomPartitionLevelChecks = this.filterInstancesForNextCheck(customInstanceLevelChecks, finalStoppableChecks);
        if (!instancesForCustomPartitionLevelChecks.isEmpty()) {
            Map<String, StoppableCheck> instancePartitionLevelChecks = this.performPartitionsCheck(instancesForCustomPartitionLevelChecks, restConfig, customPayLoads);
            ArrayList<String> instancesForFollowingChecks = new ArrayList<String>();
            for (Map.Entry<String, StoppableCheck> instancePartitionStoppableCheckEntry : instancePartitionLevelChecks.entrySet()) {
                String instance2 = instancePartitionStoppableCheckEntry.getKey();
                StoppableCheck stoppableCheck = instancePartitionStoppableCheckEntry.getValue();
                this.addStoppableCheck(finalStoppableChecks, instance2, stoppableCheck);
                if (!stoppableCheck.isStoppable() && !this.isNonBlockingCheck(stoppableCheck)) continue;
                instancesForFollowingChecks.add(instance2);
            }
            return instancesForFollowingChecks;
        }
        return instancesForCustomPartitionLevelChecks;
    }

    private Map<String, MaintenanceManagementInstanceInfo> batchInstanceHealthCheck(String clusterId, List<String> instances, List<String> healthChecks, Map<String, String> healthCheckConfig) {
        List<String> instancesForNext = new ArrayList<String>(instances);
        HashMap<String, MaintenanceManagementInstanceInfo> instanceInfos = new HashMap<String, MaintenanceManagementInstanceInfo>();
        HashMap<String, StoppableCheck> finalStoppableChecks = new HashMap<String, StoppableCheck>();
        for (String healthCheck : healthChecks) {
            if (healthCheck.equals("HelixInstanceStoppableCheck")) {
                instancesForNext = this.batchHelixInstanceStoppableCheck(clusterId, instancesForNext, finalStoppableChecks);
                continue;
            }
            if (healthCheck.equals("CustomInstanceStoppableCheck")) {
                instancesForNext = this.batchCustomInstanceStoppableCheck(clusterId, instancesForNext, finalStoppableChecks, healthCheckConfig);
                continue;
            }
            throw new UnsupportedOperationException(healthCheck + " is not supported yet!");
        }
        HashSet<String> clearedInstance = new HashSet<String>(instancesForNext);
        for (String instance : instances) {
            MaintenanceManagementInstanceInfo result = new MaintenanceManagementInstanceInfo(clearedInstance.contains(instance) ? MaintenanceManagementInstanceInfo.OperationalStatus.SUCCESS : MaintenanceManagementInstanceInfo.OperationalStatus.FAILURE);
            if (finalStoppableChecks.containsKey(instance) && !((StoppableCheck)finalStoppableChecks.get(instance)).isStoppable()) {
                result.addMessages(((StoppableCheck)finalStoppableChecks.get(instance)).getFailedChecks());
            }
            instanceInfos.put(instance, result);
        }
        return instanceInfos;
    }

    private void addStoppableCheck(Map<String, StoppableCheck> stoppableChecks, String instance, StoppableCheck stoppableCheck) {
        if (!stoppableChecks.containsKey(instance)) {
            stoppableChecks.put(instance, stoppableCheck);
        } else {
            stoppableChecks.get(instance).add(stoppableCheck);
        }
    }

    private List<String> filterInstancesForNextCheck(Map<String, Future<StoppableCheck>> futureStoppableCheckByInstance, Map<String, StoppableCheck> finalStoppableCheckByInstance) {
        ArrayList<String> instancesForNextCheck = new ArrayList<String>();
        for (Map.Entry<String, Future<StoppableCheck>> entry : futureStoppableCheckByInstance.entrySet()) {
            String instance = entry.getKey();
            try {
                StoppableCheck stoppableCheck = entry.getValue().get();
                if (!stoppableCheck.isStoppable()) {
                    this.addStoppableCheck(finalStoppableCheckByInstance, instance, stoppableCheck);
                }
                if (!stoppableCheck.isStoppable() && !this.isNonBlockingCheck(stoppableCheck)) continue;
                instancesForNextCheck.add(instance);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Failed to get StoppableChecks in parallel. Instance: {}", (Object)instance, (Object)e);
            }
        }
        return instancesForNextCheck;
    }

    private boolean isNonBlockingCheck(StoppableCheck stoppableCheck) {
        if (this._nonBlockingHealthChecks.isEmpty()) {
            return false;
        }
        if (this._nonBlockingHealthChecks.contains(ALL_HEALTH_CHECK_NONBLOCK)) {
            return true;
        }
        for (String failedCheck : stoppableCheck.getFailedChecks()) {
            if (failedCheck.startsWith("CUSTOM_")) {
                String[] checks = failedCheck.split(":", 3);
                failedCheck = checks[0] + ":" + checks[1];
            }
            if (this._nonBlockingHealthChecks.contains(failedCheck)) continue;
            return false;
        }
        return true;
    }

    private StoppableCheck performHelixOwnInstanceCheck(String clusterId, String instanceName) {
        LOG.info("Perform helix own custom health checks for {}/{}", (Object)clusterId, (Object)instanceName);
        Map<String, Boolean> helixStoppableCheck = this.getInstanceHealthStatus(clusterId, instanceName, HealthCheck.STOPPABLE_CHECK_LIST);
        return new StoppableCheck(helixStoppableCheck, StoppableCheck.Category.HELIX_OWN_CHECK);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StoppableCheck performCustomInstanceCheck(String clusterId, String instanceName, String baseUrl, Map<String, String> customPayLoads) {
        LOG.info("Perform instance level client side health checks for {}/{}", (Object)clusterId, (Object)instanceName);
        MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)this._namespace);
        try (Timer.Context timer = metrics.timer(CUSTOM_INSTANCE_CHECK_HTTP_REQUESTS_DURATION).time();){
            Map<String, Boolean> instanceStoppableCheck = this._customRestClient.getInstanceStoppableCheck(baseUrl, customPayLoads);
            StoppableCheck stoppableCheck = new StoppableCheck(instanceStoppableCheck, StoppableCheck.Category.CUSTOM_INSTANCE_CHECK);
            return stoppableCheck;
        }
        catch (IOException ex) {
            LOG.error("Custom client side instance level health check for {}/{} failed.", new Object[]{clusterId, instanceName, ex});
            metrics.counter(CUSTOM_INSTANCE_CHECK_HTTP_REQUESTS_ERROR_TOTAL).inc();
            return new StoppableCheck(false, Collections.singletonList(instanceName), StoppableCheck.Category.CUSTOM_INSTANCE_CHECK);
        }
    }

    private Map<String, StoppableCheck> performPartitionsCheck(List<String> instances, RESTConfig restConfig, Map<String, String> customPayLoads) {
        Map<String, Map<String, Boolean>> allPartitionsHealthOnLiveInstance = this._dataAccessor.getAllPartitionsHealthOnLiveInstance(restConfig, customPayLoads, this._skipZKRead);
        List externalViews = this._dataAccessor.getChildValues(this._dataAccessor.keyBuilder().externalViews(), true);
        HashMap<String, StoppableCheck> instanceStoppableChecks = new HashMap<String, StoppableCheck>();
        for (String instanceName : instances) {
            Map unHealthyPartitions = InstanceValidationUtil.perPartitionHealthCheck((List)externalViews, allPartitionsHealthOnLiveInstance, (String)instanceName, (HelixDataAccessor)this._dataAccessor);
            ArrayList<String> unHealthyPartitionsList = new ArrayList<String>();
            for (String partitionName : unHealthyPartitions.keySet()) {
                for (String reason : (List)unHealthyPartitions.get(partitionName)) {
                    unHealthyPartitionsList.add(reason.toUpperCase() + ":" + partitionName);
                }
            }
            StoppableCheck stoppableCheck = new StoppableCheck(unHealthyPartitionsList.isEmpty(), unHealthyPartitionsList, StoppableCheck.Category.CUSTOM_PARTITION_CHECK);
            instanceStoppableChecks.put(instanceName, stoppableCheck);
        }
        return instanceStoppableChecks;
    }

    public static Map<String, String> getMapFromJsonPayload(String jsonContent) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (jsonContent == null) {
            return result;
        }
        JsonNode jsonNode = OBJECT_MAPPER.readTree(jsonContent);
        jsonNode.fields().forEachRemaining(kv -> result.put((String)kv.getKey(), ((JsonNode)kv.getValue()).isValueNode() ? ((JsonNode)kv.getValue()).asText() : ((JsonNode)kv.getValue()).toString()));
        return result;
    }

    public static Map<String, String> getMapFromJsonPayload(JsonNode jsonNode) throws IllegalArgumentException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (jsonNode != null) {
            jsonNode.fields().forEachRemaining(kv -> result.put((String)kv.getKey(), ((JsonNode)kv.getValue()).isValueNode() ? ((JsonNode)kv.getValue()).asText() : ((JsonNode)kv.getValue()).toString()));
        }
        return result;
    }

    public static List<String> getListFromJsonPayload(JsonNode jsonContent) throws IllegalArgumentException {
        return jsonContent == null ? Collections.emptyList() : (List)OBJECT_MAPPER.convertValue((Object)jsonContent, List.class);
    }

    public static List<String> getListFromJsonPayload(String jsonString) throws IllegalArgumentException, JsonProcessingException {
        return jsonString == null ? Collections.emptyList() : (List)OBJECT_MAPPER.readValue(jsonString, List.class);
    }

    public static boolean getBooleanFromJsonPayload(String jsonString) throws IllegalArgumentException, JsonProcessingException {
        return OBJECT_MAPPER.readTree(jsonString).asBoolean();
    }

    @VisibleForTesting
    protected Map<String, Boolean> getInstanceHealthStatus(String clusterId, String instanceName, List<HealthCheck> healthChecks) {
        HashMap<String, Boolean> healthStatus = new HashMap<String, Boolean>();
        block12: for (HealthCheck healthCheck : healthChecks) {
            switch (healthCheck) {
                case INVALID_CONFIG: {
                    boolean validConfig;
                    try {
                        validConfig = InstanceValidationUtil.hasValidConfig((HelixDataAccessor)this._dataAccessor, (String)clusterId, (String)instanceName);
                    }
                    catch (HelixException e) {
                        validConfig = false;
                        LOG.warn("Cluster {} instance {} doesn't have valid config: {}", new Object[]{clusterId, instanceName, e.getMessage()});
                    }
                    healthStatus.put(HealthCheck.INVALID_CONFIG.name(), validConfig);
                    if (validConfig) continue block12;
                    return healthStatus;
                }
                case INSTANCE_NOT_ENABLED: {
                    healthStatus.put(HealthCheck.INSTANCE_NOT_ENABLED.name(), InstanceValidationUtil.isEnabled((HelixDataAccessor)this._dataAccessor, (String)instanceName));
                    continue block12;
                }
                case INSTANCE_NOT_ALIVE: {
                    healthStatus.put(HealthCheck.INSTANCE_NOT_ALIVE.name(), InstanceValidationUtil.isAlive((HelixDataAccessor)this._dataAccessor, (String)instanceName));
                    continue block12;
                }
                case INSTANCE_NOT_STABLE: {
                    boolean isStable = InstanceValidationUtil.isInstanceStable((HelixDataAccessor)this._dataAccessor, (String)instanceName);
                    healthStatus.put(HealthCheck.INSTANCE_NOT_STABLE.name(), isStable);
                    continue block12;
                }
                case HAS_ERROR_PARTITION: {
                    healthStatus.put(HealthCheck.HAS_ERROR_PARTITION.name(), !InstanceValidationUtil.hasErrorPartitions((HelixDataAccessor)this._dataAccessor, (String)clusterId, (String)instanceName));
                    continue block12;
                }
                case HAS_DISABLED_PARTITION: {
                    healthStatus.put(HealthCheck.HAS_DISABLED_PARTITION.name(), !InstanceValidationUtil.hasDisabledPartitions((HelixDataAccessor)this._dataAccessor, (String)clusterId, (String)instanceName));
                    continue block12;
                }
                case EMPTY_RESOURCE_ASSIGNMENT: {
                    healthStatus.put(HealthCheck.EMPTY_RESOURCE_ASSIGNMENT.name(), InstanceValidationUtil.hasResourceAssigned((HelixDataAccessor)this._dataAccessor, (String)clusterId, (String)instanceName));
                    continue block12;
                }
                case MIN_ACTIVE_REPLICA_CHECK_FAILED: {
                    healthStatus.put(HealthCheck.MIN_ACTIVE_REPLICA_CHECK_FAILED.name(), InstanceValidationUtil.siblingNodesActiveReplicaCheck((HelixDataAccessor)this._dataAccessor, (String)instanceName));
                    continue block12;
                }
            }
            LOG.error("Unsupported health check: {}", (Object)healthCheck);
        }
        return healthStatus;
    }
}

