/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.clusterMaintenanceService;

import java.util.ArrayList;
import java.util.List;

public class MaintenanceManagementInstanceInfo {
    private String operationResult;
    private OperationalStatus status;
    private List<String> messages;

    public MaintenanceManagementInstanceInfo(OperationalStatus status) {
        this.status = status;
        this.messages = new ArrayList<String>();
        this.operationResult = "";
    }

    public MaintenanceManagementInstanceInfo(OperationalStatus status, List<String> messages) {
        this.status = status;
        this.messages = messages;
        this.operationResult = "";
    }

    public MaintenanceManagementInstanceInfo(OperationalStatus status, String newOperationResult) {
        this.status = status;
        this.operationResult = newOperationResult;
        this.messages = new ArrayList<String>();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getOperationResult() {
        return this.operationResult;
    }

    public boolean hasOperationResult() {
        return !this.operationResult.isEmpty();
    }

    public void setOperationResult(String result) {
        this.operationResult = result;
    }

    public void addMessages(List<String> msg) {
        this.messages.addAll(msg);
    }

    public void addMessage(String meg) {
        this.messages.add(meg);
    }

    public boolean isSuccessful() {
        return this.status.equals((Object)OperationalStatus.SUCCESS);
    }

    public void mergeResult(MaintenanceManagementInstanceInfo info) {
        this.mergeResult(info, false);
    }

    public void mergeResult(MaintenanceManagementInstanceInfo info, boolean nonBlockingFailure) {
        this.messages.addAll(info.getMessages());
        OperationalStatus operationalStatus = this.status = (info.isSuccessful() || nonBlockingFailure) && this.isSuccessful() ? OperationalStatus.SUCCESS : OperationalStatus.FAILURE;
        if (info.hasOperationResult()) {
            this.operationResult = this.hasOperationResult() ? this.operationResult + "," + info.getOperationResult() : info.getOperationResult();
        }
    }

    public static enum OperationalStatus {
        SUCCESS,
        FAILURE;

    }
}

