"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var express = require("express");
var user_1 = require("./controllers/user");
var helix_1 = require("./controllers/helix");
function setRoutes(app) {
    var router = express.Router();
    var userCtrl = new user_1.UserCtrl(router);
    var helixCtrl = new helix_1.HelixCtrl(router);
    // Apply the routes to our application with the prefix /api
    app.use('/api', router);
    /* GET /admin to check app health. */
    app.get('/admin', function (req, res, next) {
        res.status(200).send("GOOD");
    });
}
exports.default = setRoutes;
//# sourceMappingURL=routes.js.map