"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var bodyParser = require("body-parser");
var dotenv = require("dotenv");
var express = require("express");
var morgan = require("morgan");
var path = require("path");
var fs = require("fs");
var http = require("http");
var https = require("https");
var session = require("express-session");
var config_1 = require("./config");
var routes_1 = require("./routes");
var app = express();
exports.app = app;
var server = http.createServer(app);
dotenv.load({ path: '.env' });
app.set('port', (process.env.PORT || 3000));
app.use('/', express.static(path.join(__dirname, '../public')));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));
app.use(session({
    store: config_1.SESSION_STORE,
    secret: 'helix',
    resave: true,
    saveUninitialized: true,
    cookie: { expires: new Date(2147483647000) }
}));
app.use(morgan('dev'));
routes_1.default(app);
app.get('/*', function (req, res) {
    res.sendFile(path.join(__dirname, '../public/index.html'));
});
server.listen(app.get('port'), function () {
    console.log("App is listening on port " + app.get('port') + " as HTTP");
});
process.on('uncaughtException', function (err) {
    console.error('uncaughtException: ' + err.message);
    console.error(err.stack);
});
// setup SSL
if (config_1.SSL.port > 0 && fs.existsSync(config_1.SSL.keyfile) && fs.existsSync(config_1.SSL.certfile)) {
    var credentials_1 = {
        key: fs.readFileSync(config_1.SSL.keyfile, 'ascii'),
        cert: fs.readFileSync(config_1.SSL.certfile, 'ascii'),
        ca: []
    };
    if (fs.existsSync(config_1.SSL.passfile)) {
        credentials_1.passphrase = fs.readFileSync(config_1.SSL.passfile, 'ascii').trim();
    }
    if (config_1.SSL.cafiles) {
        config_1.SSL.cafiles.forEach(function (cafile) {
            if (fs.existsSync(cafile)) {
                credentials_1.ca.push(fs.readFileSync(cafile, 'ascii'));
            }
        });
    }
    var httpsServer = https.createServer(credentials_1, app);
    httpsServer.listen(config_1.SSL.port, function () {
        console.log("App is listening on port " + config_1.SSL.port + " as HTTPS");
    });
}
//# sourceMappingURL=app.js.map