/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class ValidGroupTagConstraint
extends HardConstraint {
    ValidGroupTagConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        if (!replica.hasResourceInstanceGroupTag()) {
            return true;
        }
        return node.getInstanceTags().contains(replica.getResourceInstanceGroupTag());
    }

    @Override
    String getDescription() {
        return "Instance doesn't have the tag of the replica";
    }
}

