/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.zookeeper.datamodel.SessionAwareZNRecord;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class Message
extends HelixProperty {
    public static final long RELAY_MESSAGE_DEFAULT_EXPIRY = 5000L;
    private boolean _expired = false;
    public static final long MESSAGE_EXPECT_COMPLETION_PERIOD = HelixUtil.getSystemPropertyAsLong("helix.controller.message.ExpectMessageCompletionPeriod", TimeUnit.DAYS.toMillis(1L));
    public static final Comparator<Message> CREATE_TIME_COMPARATOR = new Comparator<Message>(){

        @Override
        public int compare(Message m1, Message m2) {
            return new Long(m1.getCreateTimeStamp()).compareTo(new Long(m2.getCreateTimeStamp()));
        }
    };

    public Message(MessageType type, String msgId) {
        this(type.name(), msgId);
    }

    public Message(String type, String msgId) {
        super(new SessionAwareZNRecord(msgId), msgId);
        this._record.setSimpleField(Attributes.MSG_TYPE.toString(), type);
        this.setMsgId(msgId);
        this.setMsgState(MessageState.NEW);
        this._record.setLongField(Attributes.CREATE_TIMESTAMP.toString(), new Date().getTime());
    }

    public Message(ZNRecord record) {
        super(new SessionAwareZNRecord(record, record.getId()));
        if (this.getMsgState() == null) {
            this.setMsgState(MessageState.NEW);
        }
        if (this.getCreateTimeStamp() == 0L) {
            this._record.setLongField(Attributes.CREATE_TIMESTAMP.toString(), new Date().getTime());
        }
    }

    public Message(ZNRecord record, String id) {
        super(new SessionAwareZNRecord(record, id));
        this.setMsgId(id);
    }

    @Deprecated
    public Message(Message message, String id) {
        super(new SessionAwareZNRecord(message.getRecord(), id));
        this.setMsgId(id);
    }

    public void setCreateTimeStamp(long timestamp) {
        this._record.setLongField(Attributes.CREATE_TIMESTAMP.toString(), timestamp);
    }

    public void setCompletionDueTimeStamp(long timestamp) {
        this._record.setLongField(Attributes.COMPLETION_DUE_TIMESTAMP.name(), timestamp);
    }

    public void setMsgSubType(String subType) {
        this._record.setSimpleField(Attributes.MSG_SUBTYPE.toString(), subType);
    }

    public String getMsgSubType() {
        return this._record.getSimpleField(Attributes.MSG_SUBTYPE.toString());
    }

    void setMsgType(MessageType type) {
        this._record.setSimpleField(Attributes.MSG_TYPE.toString(), type.toString());
    }

    public String getMsgType() {
        return this._record.getSimpleField(Attributes.MSG_TYPE.toString());
    }

    public String getTgtSessionId() {
        return this._record.getSimpleField(Attributes.TGT_SESSION_ID.toString());
    }

    public void setTgtSessionId(String tgtSessionId) {
        this._record.setSimpleField(Attributes.TGT_SESSION_ID.toString(), tgtSessionId);
    }

    public String getSrcSessionId() {
        return this._record.getSimpleField(Attributes.SRC_SESSION_ID.toString());
    }

    public void setSrcSessionId(String srcSessionId) {
        this._record.setSimpleField(Attributes.SRC_SESSION_ID.toString(), srcSessionId);
    }

    public void setExpectedSessionId(String expectedSessionId) {
        ((SessionAwareZNRecord)this._record).setExpectedSessionId(expectedSessionId);
    }

    public String getExecutionSessionId() {
        return this._record.getSimpleField(Attributes.EXE_SESSION_ID.toString());
    }

    public void setExecuteSessionId(String exeSessionId) {
        this._record.setSimpleField(Attributes.EXE_SESSION_ID.toString(), exeSessionId);
    }

    public String getMsgSrc() {
        return this._record.getSimpleField(Attributes.SRC_NAME.toString());
    }

    public void setSrcInstanceType(InstanceType type) {
        this._record.setEnumField(Attributes.SRC_INSTANCE_TYPE.toString(), type);
    }

    public InstanceType getSrcInstanceType() {
        return this._record.getEnumField(Attributes.SRC_INSTANCE_TYPE.toString(), InstanceType.class, InstanceType.PARTICIPANT);
    }

    public void setSrcName(String msgSrc) {
        this._record.setSimpleField(Attributes.SRC_NAME.toString(), msgSrc);
    }

    public String getTgtName() {
        return this._record.getSimpleField(Attributes.TGT_NAME.toString());
    }

    public void setMsgState(MessageState msgState) {
        this._record.setSimpleField(Attributes.MSG_STATE.toString(), msgState.toString().toLowerCase());
    }

    public MessageState getMsgState() {
        if (this._record.getSimpleField(Attributes.MSG_STATE.toString()) != null) {
            return MessageState.valueOf(this._record.getSimpleField(Attributes.MSG_STATE.toString()).toUpperCase());
        }
        return null;
    }

    public void setPartitionName(String partitionName) {
        this._record.setSimpleField(Attributes.PARTITION_NAME.toString(), partitionName);
    }

    public String getMsgId() {
        return this._record.getSimpleField(Attributes.MSG_ID.toString());
    }

    public void setMsgId(String msgId) {
        this._record.setSimpleField(Attributes.MSG_ID.toString(), msgId);
    }

    public void setFromState(String state) {
        this._record.setSimpleField(Attributes.FROM_STATE.toString(), state);
    }

    public String getFromState() {
        return this._record.getSimpleField(Attributes.FROM_STATE.toString());
    }

    public void setToState(String state) {
        this._record.setSimpleField(Attributes.TO_STATE.toString(), state);
    }

    public String getToState() {
        return this._record.getSimpleField(Attributes.TO_STATE.toString());
    }

    public void setTgtName(String msgTgt) {
        this._record.setSimpleField(Attributes.TGT_NAME.toString(), msgTgt);
    }

    public Boolean getDebug() {
        return false;
    }

    public Integer getGeneration() {
        return 1;
    }

    public void setResourceName(String resourceName) {
        this._record.setSimpleField(Attributes.RESOURCE_NAME.toString(), resourceName);
    }

    public String getResourceName() {
        return this._record.getSimpleField(Attributes.RESOURCE_NAME.toString());
    }

    public void setResourceGroupName(String resourceGroupName) {
        this._record.setSimpleField(Attributes.RESOURCE_GROUP_NAME.toString(), resourceGroupName);
    }

    public String getResourceGroupName() {
        return this._record.getSimpleField(Attributes.RESOURCE_GROUP_NAME.toString());
    }

    public void setResourceTag(String resourceTag) {
        this._record.setSimpleField(Attributes.RESOURCE_TAG.toString(), resourceTag);
    }

    public String getResourceTag() {
        return this._record.getSimpleField(Attributes.RESOURCE_TAG.toString());
    }

    public String getPartitionName() {
        return this._record.getSimpleField(Attributes.PARTITION_NAME.toString());
    }

    public String getStateModelDef() {
        return this._record.getSimpleField(Attributes.STATE_MODEL_DEF.toString());
    }

    public void setStateModelDef(String stateModelDefName) {
        this._record.setSimpleField(Attributes.STATE_MODEL_DEF.toString(), stateModelDefName);
    }

    public void setReadTimeStamp(long time) {
        this._record.setLongField(Attributes.READ_TIMESTAMP.toString(), time);
    }

    public void setExecuteStartTimeStamp(long time) {
        this._record.setLongField(Attributes.EXECUTE_START_TIMESTAMP.toString(), time);
    }

    public long getReadTimeStamp() {
        return this._record.getLongField(Attributes.READ_TIMESTAMP.toString(), 0L);
    }

    public long getExecuteStartTimeStamp() {
        return this._record.getLongField(Attributes.EXECUTE_START_TIMESTAMP.toString(), 0L);
    }

    public long getCreateTimeStamp() {
        return this._record.getLongField(Attributes.CREATE_TIMESTAMP.toString(), 0L);
    }

    public long getCompletionDueTimeStamp() {
        long completionDue = this._record.getLongField(Attributes.COMPLETION_DUE_TIMESTAMP.name(), 0L);
        if (completionDue == 0L) {
            completionDue = this.getCreateTimeStamp() + MESSAGE_EXPECT_COMPLETION_PERIOD;
        }
        return completionDue;
    }

    public void setCorrelationId(String correlationId) {
        this._record.setSimpleField(Attributes.CORRELATION_ID.toString(), correlationId);
    }

    public String getCorrelationId() {
        return this._record.getSimpleField(Attributes.CORRELATION_ID.toString());
    }

    public int getExecutionTimeout() {
        return this._record.getIntField(Attributes.TIMEOUT.toString(), -1);
    }

    public void setExecutionTimeout(int timeout) {
        this._record.setIntField(Attributes.TIMEOUT.toString(), timeout);
    }

    public void setRetryCount(int retryCount) {
        this._record.setIntField(Attributes.RETRY_COUNT.toString(), retryCount);
    }

    public int getRetryCount() {
        return this._record.getIntField(Attributes.RETRY_COUNT.toString(), 0);
    }

    public Map<String, String> getResultMap() {
        return this._record.getMapField(Attributes.MESSAGE_RESULT.toString());
    }

    public void setResultMap(Map<String, String> resultMap) {
        this._record.setMapField(Attributes.MESSAGE_RESULT.toString(), resultMap);
    }

    public String getStateModelFactoryName() {
        return this._record.getSimpleField(Attributes.STATE_MODEL_FACTORY_NAME.toString());
    }

    public void setStateModelFactoryName(String factoryName) {
        this._record.setSimpleField(Attributes.STATE_MODEL_FACTORY_NAME.toString(), factoryName);
    }

    @Override
    public int getBucketSize() {
        return this._record.getIntField(Attributes.BUCKET_SIZE.toString(), 0);
    }

    @Override
    public void setBucketSize(int bucketSize) {
        if (bucketSize > 0) {
            this._record.setIntField(Attributes.BUCKET_SIZE.toString(), bucketSize);
        }
    }

    public void setAttribute(Attributes attr, String val) {
        this._record.setSimpleField(attr.toString(), val);
    }

    public String getAttribute(Attributes attr) {
        return this._record.getSimpleField(attr.toString());
    }

    public static Message createReplyMessage(Message srcMessage, String instanceName, Map<String, String> taskResultMap) {
        if (srcMessage.getCorrelationId() == null) {
            throw new HelixException("Message " + srcMessage.getMsgId() + " does not contain correlation id");
        }
        Message replyMessage = new Message(MessageType.TASK_REPLY, UUID.randomUUID().toString());
        replyMessage.setCorrelationId(srcMessage.getCorrelationId());
        replyMessage.setResultMap(taskResultMap);
        replyMessage.setTgtSessionId("*");
        replyMessage.setMsgState(MessageState.NEW);
        replyMessage.setSrcName(instanceName);
        if (srcMessage.getSrcInstanceType() == InstanceType.CONTROLLER) {
            replyMessage.setTgtName(InstanceType.CONTROLLER.name());
        } else {
            replyMessage.setTgtName(srcMessage.getMsgSrc());
        }
        return replyMessage;
    }

    public void addPartitionName(String partitionName) {
        List<String> partitionNames;
        if (this._record.getListField(Attributes.PARTITION_NAME.toString()) == null) {
            this._record.setListField(Attributes.PARTITION_NAME.toString(), new ArrayList<String>());
        }
        if (!(partitionNames = this._record.getListField(Attributes.PARTITION_NAME.toString())).contains(partitionName)) {
            partitionNames.add(partitionName);
        }
    }

    public List<String> getPartitionNames() {
        List<String> partitionNames = this._record.getListField(Attributes.PARTITION_NAME.toString());
        if (partitionNames == null) {
            return Collections.emptyList();
        }
        return partitionNames;
    }

    public long getRelayTime() {
        return this._record.getLongField(Attributes.RELAY_TIME.name(), -1L);
    }

    public void setRelayTime(long completionTime) {
        this._record.setLongField(Attributes.RELAY_TIME.name(), completionTime);
    }

    public void attachRelayMessage(String instance, Message message) {
        List relayList = this._record.getListField(Attributes.RELAY_PARTICIPANTS.name());
        if (relayList == null) {
            relayList = Collections.EMPTY_LIST;
        }
        LinkedHashSet<String> relayParticipants = new LinkedHashSet<String>(relayList);
        relayParticipants.add(instance);
        Map<String, String> messageInfo = message.getRecord().getSimpleFields();
        messageInfo.put(Attributes.RELAY_MSG_ID.name(), message.getId());
        messageInfo.put(Attributes.MSG_SUBTYPE.name(), MessageType.RELAYED_MESSAGE.name());
        messageInfo.put(Attributes.RELAY_FROM.name(), this.getTgtName());
        messageInfo.put(Attributes.EXPIRY_PERIOD.name(), String.valueOf(5000L));
        this._record.setMapField(instance, messageInfo);
        this._record.setListField(Attributes.RELAY_PARTICIPANTS.name(), Lists.newArrayList(relayParticipants));
    }

    public Message getRelayMessage(String instance) {
        Map<String, String> messageInfo = this._record.getMapField(instance);
        if (messageInfo != null) {
            String id = messageInfo.get(Attributes.RELAY_MSG_ID.name());
            if (id == null && (id = messageInfo.get(Attributes.MSG_ID.name())) == null) {
                return null;
            }
            ZNRecord record = new ZNRecord(id);
            record.setSimpleFields(messageInfo);
            return new Message(record);
        }
        return null;
    }

    public String getRelaySrcHost() {
        return this._record.getSimpleField(Attributes.RELAY_FROM.name());
    }

    public Map<String, Message> getRelayMessages() {
        HashMap<String, Message> relayMessageMap = new HashMap<String, Message>();
        List<String> relayParticipants = this._record.getListField(Attributes.RELAY_PARTICIPANTS.name());
        if (relayParticipants != null) {
            for (String p : relayParticipants) {
                Message msg = this.getRelayMessage(p);
                if (p == null) continue;
                relayMessageMap.put(p, msg);
            }
        }
        return relayMessageMap;
    }

    public boolean hasRelayMessages() {
        List<String> relayHosts = this._record.getListField(Attributes.RELAY_PARTICIPANTS.name());
        return relayHosts != null && relayHosts.size() > 0;
    }

    public boolean isRelayMessage() {
        String subType = this._record.getStringField(Attributes.MSG_SUBTYPE.name(), null);
        String relayFrom = this._record.getStringField(Attributes.RELAY_FROM.name(), null);
        return MessageType.RELAYED_MESSAGE.name().equals(subType) && relayFrom != null;
    }

    public boolean isExpired() {
        if (this._expired) {
            return true;
        }
        long expiry = this.getExpiryPeriod();
        if (expiry < 0L) {
            return false;
        }
        long current = System.currentTimeMillis();
        if (this.isRelayMessage()) {
            long relayTime = this.getRelayTime();
            return relayTime > 0L && relayTime + expiry < current;
        }
        return this.getCreateTimeStamp() + expiry < current;
    }

    public void setExpired(boolean expired) {
        this._expired = expired;
    }

    public long getExpiryPeriod() {
        return this._record.getLongField(Attributes.EXPIRY_PERIOD.name(), -1L);
    }

    public void setExpiryPeriod(long expiry) {
        this._record.setLongField(Attributes.EXPIRY_PERIOD.name(), expiry);
    }

    public String getSrcClusterName() {
        return this._record.getStringField(Attributes.SRC_CLUSTER.name(), null);
    }

    public void setSrcClusterName(String clusterName) {
        this._record.setSimpleField(Attributes.SRC_CLUSTER.name(), clusterName);
    }

    public boolean isControlerMsg() {
        return this.getTgtName().equalsIgnoreCase(InstanceType.CONTROLLER.name());
    }

    public boolean isParticipantStatusChangeType() {
        return MessageType.PARTICIPANT_STATUS_CHANGE.name().equalsIgnoreCase(this.getMsgType());
    }

    public PropertyKey getKey(PropertyKey.Builder keyBuilder, String instanceName) {
        if (this.isControlerMsg()) {
            return keyBuilder.controllerMessage(this.getId());
        }
        return keyBuilder.message(instanceName, this.getId());
    }

    private boolean isNullOrEmpty(String data) {
        return data == null || data.length() == 0 || data.trim().length() == 0;
    }

    @Override
    public boolean isValid() {
        if (this.getMsgType().equals(MessageType.STATE_TRANSITION.name()) || this.getMsgType().equals(MessageType.STATE_TRANSITION_CANCELLATION.name())) {
            boolean isNotValid = this.isNullOrEmpty(this.getTgtName()) || this.isNullOrEmpty(this.getPartitionName()) || this.isNullOrEmpty(this.getResourceName()) || this.isNullOrEmpty(this.getStateModelDef()) || this.isNullOrEmpty(this.getToState()) || this.isNullOrEmpty(this.getFromState()) || this.isNullOrEmpty(this.getTgtSessionId());
            return !isNotValid;
        }
        return true;
    }

    public static enum MessageState {
        NEW,
        READ,
        UNPROCESSABLE;

    }

    public static enum Attributes {
        MSG_ID,
        RELAY_MSG_ID,
        SRC_SESSION_ID,
        TGT_SESSION_ID,
        SRC_NAME,
        TGT_NAME,
        SRC_INSTANCE_TYPE,
        MSG_STATE,
        PARTITION_NAME,
        RESOURCE_NAME,
        RESOURCE_GROUP_NAME,
        RESOURCE_TAG,
        FROM_STATE,
        TO_STATE,
        STATE_MODEL_DEF,
        CREATE_TIMESTAMP,
        COMPLETION_DUE_TIMESTAMP,
        READ_TIMESTAMP,
        EXECUTE_START_TIMESTAMP,
        MSG_TYPE,
        MSG_SUBTYPE,
        CORRELATION_ID,
        MESSAGE_RESULT,
        EXE_SESSION_ID,
        TIMEOUT,
        RETRY_COUNT,
        STATE_MODEL_FACTORY_NAME,
        BUCKET_SIZE,
        PARENT_MSG_ID,
        ClusterEventName,
        INNER_MESSAGE,
        RELAY_PARTICIPANTS,
        RELAY_TIME,
        RELAY_FROM,
        EXPIRY_PERIOD,
        SRC_CLUSTER;

    }

    public static enum MessageType {
        STATE_TRANSITION,
        STATE_TRANSITION_CANCELLATION,
        SCHEDULER_MSG,
        USER_DEFINE_MSG,
        CONTROLLER_MSG,
        TASK_REPLY,
        NO_OP,
        PARTICIPANT_ERROR_REPORT,
        PARTICIPANT_SESSION_CHANGE,
        PARTICIPANT_STATUS_CHANGE,
        CHAINED_MESSAGE,
        RELAYED_MESSAGE;

    }
}

