/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.PropertyType;
import org.apache.helix.api.exceptions.HelixConflictException;
import org.apache.helix.api.status.ClusterManagementMode;
import org.apache.helix.api.status.ClusterManagementModeRequest;
import org.apache.helix.api.topology.ClusterTopology;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.rebalancer.waged.WagedRebalancer;
import org.apache.helix.manager.zk.GenericZkHelixApiBuilder;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.model.CloudConfig;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.ClusterStatus;
import org.apache.helix.model.ConstraintItem;
import org.apache.helix.model.ControllerHistory;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.CustomizedStateConfig;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Message;
import org.apache.helix.model.ParticipantHistory;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.tools.DefaultIdealStateCalculator;
import org.apache.helix.util.ConfigStringUtil;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.RebalanceUtil;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.constant.RoutingDataReaderType;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.exception.ZkClientException;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.apache.helix.zookeeper.routing.RoutingDataManager;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.apache.helix.zookeeper.zkclient.NetworkUtil;
import org.apache.helix.zookeeper.zkclient.exception.ZkException;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKHelixAdmin
implements HelixAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(ZKHelixAdmin.class);
    public static final String CONNECTION_TIMEOUT = "helixAdmin.timeOutInSec";
    private static final String MAINTENANCE_ZNODE_ID = "maintenance";
    private static final int DEFAULT_SUPERCLUSTER_REPLICA = 3;
    private final RealmAwareZkClient _zkClient;
    private final ConfigAccessor _configAccessor;
    private final boolean _usesExternalZkClient;
    private static Logger logger = LoggerFactory.getLogger(ZKHelixAdmin.class);

    @Deprecated
    public ZKHelixAdmin(RealmAwareZkClient zkClient) {
        this._zkClient = zkClient;
        this._configAccessor = new ConfigAccessor(zkClient);
        this._usesExternalZkClient = true;
    }

    @Deprecated
    public ZKHelixAdmin(String zkAddress) {
        RealmAwareZkClient zkClient;
        int timeOutInSec = Integer.parseInt(System.getProperty(CONNECTION_TIMEOUT, "30"));
        RealmAwareZkClient.RealmAwareZkClientConfig clientConfig = new RealmAwareZkClient.RealmAwareZkClientConfig().setConnectInitTimeout((long)timeOutInSec * 1000L).setZkSerializer(new ZNRecordSerializer());
        if (Boolean.getBoolean("helix.multiZkEnabled") || zkAddress == null) {
            try {
                zkClient = new FederatedZkClient(new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder().build(), clientConfig);
            }
            catch (IllegalStateException | InvalidRoutingDataException e) {
                throw new HelixException("Not able to connect on multi-realm mode.", e);
            }
        } else {
            zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), clientConfig.createHelixZkClientConfig());
            zkClient.waitUntilConnected(timeOutInSec, TimeUnit.SECONDS);
        }
        this._zkClient = zkClient;
        this._configAccessor = new ConfigAccessor(this._zkClient);
        this._usesExternalZkClient = false;
    }

    private ZKHelixAdmin(RealmAwareZkClient zkClient, boolean usesExternalZkClient) {
        this._zkClient = zkClient;
        this._configAccessor = new ConfigAccessor(this._zkClient);
        this._usesExternalZkClient = usesExternalZkClient;
    }

    @Override
    public void addInstance(String clusterName, InstanceConfig instanceConfig) {
        logger.info("Add instance {} to cluster {}.", (Object)instanceConfig.getInstanceName(), (Object)clusterName);
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String instanceConfigsPath = PropertyPathBuilder.instanceConfig(clusterName);
        String nodeId = instanceConfig.getId();
        String instanceConfigPath = instanceConfigsPath + "/" + nodeId;
        if (this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("Node " + nodeId + " already exists in cluster " + clusterName);
        }
        ZKUtil.createChildren(this._zkClient, instanceConfigsPath, instanceConfig.getRecord());
        this._zkClient.createPersistent(PropertyPathBuilder.instanceMessage(clusterName, nodeId), true);
        this._zkClient.createPersistent(PropertyPathBuilder.instanceCurrentState(clusterName, nodeId), true);
        this._zkClient.createPersistent(PropertyPathBuilder.instanceTaskCurrentState(clusterName, nodeId), true);
        this._zkClient.createPersistent(PropertyPathBuilder.instanceCustomizedState(clusterName, nodeId), true);
        this._zkClient.createPersistent(PropertyPathBuilder.instanceError(clusterName, nodeId), true);
        this._zkClient.createPersistent(PropertyPathBuilder.instanceStatusUpdate(clusterName, nodeId), true);
        this._zkClient.createPersistent(PropertyPathBuilder.instanceHistory(clusterName, nodeId), true);
    }

    @Override
    public void dropInstance(String clusterName, InstanceConfig instanceConfig) {
        logger.info("Drop instance {} from cluster {}.", (Object)instanceConfig.getInstanceName(), (Object)clusterName);
        String instanceName = instanceConfig.getInstanceName();
        String instanceConfigPath = PropertyPathBuilder.instanceConfig(clusterName, instanceName);
        if (!this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("Node " + instanceName + " does not exist in config for cluster " + clusterName);
        }
        String instancePath = PropertyPathBuilder.instance(clusterName, instanceName);
        if (!this._zkClient.exists(instancePath)) {
            throw new HelixException("Node " + instanceName + " does not exist in instances for cluster " + clusterName);
        }
        String liveInstancePath = PropertyPathBuilder.liveInstance(clusterName, instanceName);
        if (this._zkClient.exists(liveInstancePath)) {
            throw new HelixException("Node " + instanceName + " is still alive for cluster " + clusterName + ", can't drop.");
        }
        String instanceConfigsPath = PropertyPathBuilder.instanceConfig(clusterName);
        ZKUtil.dropChildren(this._zkClient, instanceConfigsPath, instanceConfig.getRecord());
        this.dropInstancePathRecursively(instancePath, instanceConfig.getInstanceName());
    }

    private void dropInstancePathRecursively(String instancePath, String instanceName) {
        int retryCnt = 0;
        while (true) {
            try {
                this._zkClient.deleteRecursively(instancePath);
                return;
            }
            catch (ZkClientException e) {
                if (retryCnt < 3 && e.getCause() instanceof ZkException && e.getCause().getCause() instanceof KeeperException.NotEmptyException) {
                    logger.warn("Retrying dropping instance {} with exception {}", (Object)instanceName, (Object)e.getCause().getMessage());
                    ++retryCnt;
                    continue;
                }
                String errorMessage = "Failed to drop instance: " + instanceName + ". Retry times: " + retryCnt;
                logger.error(errorMessage, (Throwable)e);
                throw new HelixException(errorMessage, e);
            }
            break;
        }
    }

    @Override
    public void purgeOfflineInstances(String clusterName, long offlineDuration) {
        ArrayList failToPurgeInstances = new ArrayList();
        this.findTimeoutOfflineInstances(clusterName, offlineDuration).forEach(instance -> {
            try {
                this.purgeInstance(clusterName, (String)instance);
            }
            catch (HelixException e) {
                failToPurgeInstances.add(instance);
            }
        });
        if (failToPurgeInstances.size() > 0) {
            LOG.error("ZKHelixAdmin::purgeOfflineInstances(): failed to drop the following instances: " + failToPurgeInstances);
        }
    }

    private void purgeInstance(String clusterName, String instanceName) {
        logger.info("Purge instance {} from cluster {}.", (Object)instanceName, (Object)clusterName);
        String instanceConfigPath = PropertyPathBuilder.instanceConfig(clusterName, instanceName);
        this._zkClient.delete(instanceConfigPath);
        String instancePath = PropertyPathBuilder.instance(clusterName, instanceName);
        this.dropInstancePathRecursively(instancePath, instanceName);
    }

    @Override
    public InstanceConfig getInstanceConfig(String clusterName, String instanceName) {
        logger.info("Get instance config for instance {} from cluster {}.", (Object)instanceName, (Object)clusterName);
        String instanceConfigPath = PropertyPathBuilder.instanceConfig(clusterName, instanceName);
        if (!this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("instance" + instanceName + " does not exist in cluster " + clusterName);
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
    }

    @Override
    public boolean setInstanceConfig(String clusterName, String instanceName, InstanceConfig newInstanceConfig) {
        logger.info("Set instance config for instance {} to cluster {} with new InstanceConfig {}.", new Object[]{instanceName, clusterName, newInstanceConfig == null ? "NULL" : newInstanceConfig.toString()});
        String instanceConfigPath = PropertyPathBuilder.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceName);
        if (!this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("instance" + instanceName + " does not exist in cluster " + clusterName);
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey instanceConfigPropertyKey = accessor.keyBuilder().instanceConfig(instanceName);
        InstanceConfig currentInstanceConfig = (InstanceConfig)accessor.getProperty(instanceConfigPropertyKey);
        if (!newInstanceConfig.getHostName().equals(currentInstanceConfig.getHostName()) || !newInstanceConfig.getPort().equals(currentInstanceConfig.getPort())) {
            throw new HelixException("Hostname and port cannot be changed, current hostname: " + currentInstanceConfig.getHostName() + " and port: " + currentInstanceConfig.getPort() + " is different from new hostname: " + newInstanceConfig.getHostName() + "and new port: " + newInstanceConfig.getPort());
        }
        return accessor.setProperty(instanceConfigPropertyKey, newInstanceConfig);
    }

    @Override
    public void enableInstance(String clusterName, String instanceName, boolean enabled) {
        this.enableInstance(clusterName, instanceName, enabled, null, null);
    }

    @Override
    public void enableInstance(String clusterName, String instanceName, boolean enabled, InstanceConstants.InstanceDisabledType disabledType, String reason) {
        logger.info("{} instance {} in cluster {}.", new Object[]{enabled ? "Enable" : "Disable", instanceName, clusterName});
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        this.enableSingleInstance(clusterName, instanceName, enabled, baseAccessor, disabledType, reason);
        this.enableBatchInstances(clusterName, Collections.singletonList(instanceName), enabled, baseAccessor, disabledType, reason);
    }

    @Override
    public void enableInstance(String clusterName, List<String> instances, boolean enabled, InstanceConstants.InstanceDisabledType disabledType, String reason) {
        logger.info("Batch {} instances {} in cluster {}.", new Object[]{enabled ? "enable" : "disable", HelixUtil.serializeByComma(instances), clusterName});
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        if (enabled) {
            for (String instance : instances) {
                this.enableSingleInstance(clusterName, instance, enabled, baseAccessor, disabledType, reason);
            }
        }
        this.enableBatchInstances(clusterName, instances, enabled, baseAccessor, disabledType, reason);
    }

    @Override
    public void enableInstance(String clusterName, List<String> instances, boolean enabled) {
        this.enableInstance(clusterName, instances, enabled, null, null);
    }

    @Override
    public void enableResource(final String clusterName, final String resourceName, final boolean enabled) {
        logger.info("{} resource {} in cluster {}.", new Object[]{enabled ? "Enable" : "Disable", resourceName, clusterName});
        String path = PropertyPathBuilder.idealState(clusterName, resourceName);
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster " + clusterName + ", resource: " + resourceName + ", ideal-state does not exist");
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", resource: " + resourceName + ", ideal-state is null");
                }
                IdealState idealState = new IdealState(currentData);
                idealState.enable(enabled);
                return idealState.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void enablePartition(final boolean enabled, final String clusterName, final String instanceName, final String resourceName, final List<String> partitionNames) {
        logger.info("{} partitions {} for resource {} on instance {} in cluster {}.", new Object[]{enabled ? "Enable" : "Disable", HelixUtil.serializeByComma(partitionNames), resourceName, instanceName, clusterName});
        String path = PropertyPathBuilder.instanceConfig(clusterName, instanceName);
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", instance config does not exist");
        }
        String idealStatePath = PropertyPathBuilder.idealState(clusterName, resourceName);
        ZNRecord idealStateRecord = null;
        try {
            idealStateRecord = (ZNRecord)baseAccessor.get(idealStatePath, null, 0);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
        if (idealStateRecord == null) {
            logger.warn("Disable partitions: " + partitionNames + " but Cluster: " + clusterName + ", resource: " + resourceName + " does not exists. probably disable it during ERROR->DROPPED transtition");
        } else {
            IdealState idealState = new IdealState(idealStateRecord);
            for (String partitionName : partitionNames) {
                if (!(idealState.getRebalanceMode() == IdealState.RebalanceMode.SEMI_AUTO && idealState.getPreferenceList(partitionName) == null || idealState.getRebalanceMode() == IdealState.RebalanceMode.USER_DEFINED && idealState.getPreferenceList(partitionName) == null || idealState.getRebalanceMode() == IdealState.RebalanceMode.TASK && idealState.getPreferenceList(partitionName) == null) && (idealState.getRebalanceMode() != IdealState.RebalanceMode.CUSTOMIZED || idealState.getInstanceStateMap(partitionName) != null)) continue;
                logger.warn("Cluster: " + clusterName + ", resource: " + resourceName + ", partition: " + partitionName + ", partition does not exist in ideal state");
            }
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", participant config is null");
                }
                InstanceConfig instanceConfig = new InstanceConfig(currentData);
                for (String partitionName : partitionNames) {
                    instanceConfig.setInstanceEnabledForPartition(resourceName, partitionName, enabled);
                }
                return instanceConfig.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void enableCluster(String clusterName, boolean enabled) {
        this.enableCluster(clusterName, enabled, null);
    }

    @Override
    public void enableCluster(String clusterName, boolean enabled, String reason) {
        logger.info("{} cluster {} for reason {}.", new Object[]{enabled ? "Enable" : "Disable", clusterName, reason == null ? "NULL" : reason});
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (enabled) {
            accessor.removeProperty(keyBuilder.pause());
        } else {
            PauseSignal pauseSignal = new PauseSignal("pause");
            if (reason != null) {
                pauseSignal.setReason(reason);
            }
            if (!accessor.createPause(pauseSignal)) {
                throw new HelixException("Failed to create pause signal");
            }
        }
    }

    @Override
    @Deprecated
    public void enableMaintenanceMode(String clusterName, boolean enabled) {
        this.manuallyEnableMaintenanceMode(clusterName, enabled, null, null);
    }

    @Override
    public boolean isInMaintenanceMode(String clusterName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return accessor.getBaseDataAccessor().exists(keyBuilder.maintenance().getPath(), AccessOption.PERSISTENT);
    }

    @Override
    public void setClusterManagementMode(ClusterManagementModeRequest request) {
        ClusterManagementMode.Type mode = request.getMode();
        String clusterName = request.getClusterName();
        String reason = request.getReason();
        switch (mode) {
            case CLUSTER_FREEZE: {
                this.enableClusterPauseMode(clusterName, request.isCancelPendingST(), reason);
                break;
            }
            case NORMAL: {
                this.disableClusterPauseMode(clusterName);
                break;
            }
            default: {
                throw new IllegalArgumentException("ClusterManagementMode " + (Object)((Object)mode) + " is not supported");
            }
        }
    }

    @Override
    public ClusterManagementMode getClusterManagementMode(String clusterName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        ClusterStatus status = (ClusterStatus)accessor.getProperty(accessor.keyBuilder().clusterStatus());
        return status == null ? null : new ClusterManagementMode(status.getManagementMode(), status.getManagementModeStatus());
    }

    private void enableClusterPauseMode(String clusterName, boolean cancelPendingST, String reason) {
        String hostname = NetworkUtil.getLocalhostName();
        logger.info("Enable cluster pause mode for cluster: {}. CancelPendingST: {}. Reason: {}. From Host: {}", new Object[]{clusterName, cancelPendingST, reason, hostname});
        ZkBaseDataAccessor<ZNRecord> baseDataAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, baseDataAccessor);
        if (baseDataAccessor.exists(accessor.keyBuilder().pause().getPath(), AccessOption.PERSISTENT)) {
            throw new HelixConflictException(clusterName + " pause signal already exists");
        }
        ClusterConfig config = (ClusterConfig)accessor.getProperty(accessor.keyBuilder().clusterConfig());
        if (cancelPendingST && !config.isStateTransitionCancelEnabled()) {
            throw new HelixConflictException("State transition cancellation not enabled in " + clusterName);
        }
        PauseSignal pauseSignal = new PauseSignal();
        pauseSignal.setClusterPause(true);
        pauseSignal.setCancelPendingST(cancelPendingST);
        pauseSignal.setFromHost(hostname);
        pauseSignal.setTriggerTime(Instant.now().toEpochMilli());
        if (reason != null && !reason.isEmpty()) {
            pauseSignal.setReason(reason);
        }
        if (!accessor.createPause(pauseSignal)) {
            throw new HelixException("Failed to create pause signal");
        }
    }

    private void disableClusterPauseMode(String clusterName) {
        logger.info("Disable cluster pause mode for cluster: {}", (Object)clusterName);
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey pausePropertyKey = accessor.keyBuilder().pause();
        PauseSignal pauseSignal = (PauseSignal)accessor.getProperty(pausePropertyKey);
        if (pauseSignal == null || !pauseSignal.isClusterPause()) {
            throw new HelixException("Cluster pause mode is not enabled for cluster " + clusterName);
        }
        if (!accessor.removeProperty(pausePropertyKey)) {
            throw new HelixException("Failed to disable cluster pause mode for cluster: " + clusterName);
        }
    }

    @Override
    @Deprecated
    public void enableMaintenanceMode(String clusterName, boolean enabled, String reason) {
        this.manuallyEnableMaintenanceMode(clusterName, enabled, reason, null);
    }

    @Override
    public void autoEnableMaintenanceMode(String clusterName, boolean enabled, String reason, MaintenanceSignal.AutoTriggerReason internalReason) {
        this.processMaintenanceMode(clusterName, enabled, reason, internalReason, null, MaintenanceSignal.TriggeringEntity.CONTROLLER);
    }

    @Override
    public void manuallyEnableMaintenanceMode(String clusterName, boolean enabled, String reason, Map<String, String> customFields) {
        this.processMaintenanceMode(clusterName, enabled, reason, MaintenanceSignal.AutoTriggerReason.NOT_APPLICABLE, customFields, MaintenanceSignal.TriggeringEntity.USER);
    }

    private void processMaintenanceMode(String clusterName, boolean enabled, String reason, MaintenanceSignal.AutoTriggerReason internalReason, Map<String, String> customFields, MaintenanceSignal.TriggeringEntity triggeringEntity) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        logger.info("Cluster {} {} {} maintenance mode for reason {}.", new Object[]{clusterName, triggeringEntity == MaintenanceSignal.TriggeringEntity.CONTROLLER ? "automatically" : "manually", enabled ? "enters" : "exits", reason == null ? "NULL" : reason});
        long currentTime = System.currentTimeMillis();
        if (!enabled) {
            accessor.removeProperty(keyBuilder.maintenance());
        } else {
            MaintenanceSignal maintenanceSignal = new MaintenanceSignal(MAINTENANCE_ZNODE_ID);
            if (reason != null) {
                maintenanceSignal.setReason(reason);
            }
            maintenanceSignal.setTimestamp(currentTime);
            maintenanceSignal.setTriggeringEntity(triggeringEntity);
            switch (triggeringEntity) {
                case CONTROLLER: {
                    maintenanceSignal.setAutoTriggerReason(internalReason);
                    break;
                }
                case USER: 
                case UNKNOWN: {
                    if (customFields == null || customFields.isEmpty()) break;
                    Map<String, String> simpleFields = maintenanceSignal.getRecord().getSimpleFields();
                    for (Map.Entry<String, String> entry : customFields.entrySet()) {
                        if (simpleFields.containsKey(entry.getKey())) continue;
                        simpleFields.put(entry.getKey(), entry.getValue());
                    }
                    break;
                }
            }
            if (!accessor.createMaintenance(maintenanceSignal)) {
                throw new HelixException("Failed to create maintenance signal!");
            }
        }
        if (!accessor.getBaseDataAccessor().update(keyBuilder.controllerLeaderHistory().getPath(), oldRecord -> {
            try {
                if (oldRecord == null) {
                    oldRecord = new ZNRecord(PropertyType.HISTORY.toString());
                }
                return new ControllerHistory((ZNRecord)oldRecord).updateMaintenanceHistory(enabled, reason, currentTime, internalReason, customFields, triggeringEntity);
            }
            catch (IOException e) {
                logger.error("Failed to update maintenance history! Exception: {}", (Throwable)e);
                return oldRecord;
            }
        }, AccessOption.PERSISTENT)) {
            logger.error("Failed to write maintenance history to ZK!");
        }
    }

    @Override
    public void resetPartition(String clusterName, String instanceName, String resourceName, List<String> partitionNames) {
        Set<String> partitions;
        logger.info("Reset partitions {} for resource {} on instance {} in cluster {}.", new Object[]{partitionNames == null ? "NULL" : HelixUtil.serializeByComma(partitionNames), resourceName, instanceName, clusterName});
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        LiveInstance liveInstance = (LiveInstance)accessor.getProperty(keyBuilder.liveInstance(instanceName));
        if (liveInstance == null) {
            String instanceConfigPath = PropertyPathBuilder.instanceConfig(clusterName, instanceName);
            throw new HelixException(String.format((this._zkClient.exists(instanceConfigPath) ? ResetPartitionFailureReason.INSTANCE_NOT_ALIVE : ResetPartitionFailureReason.INSTANCE_NON_EXISTENT).getMessage(resourceName, partitionNames, instanceName, instanceName, clusterName), new Object[0]));
        }
        IdealState idealState = (IdealState)accessor.getProperty(keyBuilder.idealStates(resourceName));
        if (idealState == null) {
            throw new HelixException(String.format(ResetPartitionFailureReason.RESOURCE_NON_EXISTENT.getMessage(resourceName, partitionNames, instanceName, resourceName, clusterName), new Object[0]));
        }
        HashSet<String> resetPartitionNames = new HashSet<String>(partitionNames);
        Set<String> set = partitions = idealState.getRebalanceMode() == IdealState.RebalanceMode.CUSTOMIZED ? idealState.getRecord().getMapFields().keySet() : idealState.getRecord().getListFields().keySet();
        if (!partitions.containsAll(resetPartitionNames)) {
            throw new HelixException(String.format(ResetPartitionFailureReason.PARTITION_NON_EXISTENT.getMessage(resourceName, partitionNames, instanceName, partitionNames.toString(), clusterName), new Object[0]));
        }
        String sessionId = liveInstance.getEphemeralOwner();
        CurrentState curState = (CurrentState)accessor.getProperty(keyBuilder.currentState(instanceName, sessionId, resourceName));
        for (String partitionName : resetPartitionNames) {
            if (curState.getState(partitionName).equals(HelixDefinedState.ERROR.toString())) continue;
            throw new HelixException(String.format(ResetPartitionFailureReason.PARTITION_NOT_ERROR.getMessage(resourceName, partitionNames, instanceName, partitionNames.toString(), clusterName), new Object[0]));
        }
        String stateModelDef = idealState.getStateModelDefRef();
        StateModelDefinition stateModel = (StateModelDefinition)accessor.getProperty(keyBuilder.stateModelDef(stateModelDef));
        if (stateModel == null) {
            throw new HelixException(String.format(ResetPartitionFailureReason.STATE_MODEL_NON_EXISTENT.getMessage(resourceName, partitionNames, instanceName, stateModelDef, clusterName), new Object[0]));
        }
        List messages = accessor.getChildValues(keyBuilder.messages(instanceName), true);
        for (Message message : messages) {
            if (!Message.MessageType.STATE_TRANSITION.name().equalsIgnoreCase(message.getMsgType()) || !sessionId.equals(message.getTgtSessionId()) || !resourceName.equals(message.getResourceName()) || !resetPartitionNames.contains(message.getPartitionName())) continue;
            throw new HelixException(String.format("Can't reset state for %s.%s on %s, because a pending message %s exists for resource %s", resourceName, partitionNames, instanceName, message.toString(), message.getResourceName()));
        }
        String adminName = null;
        try {
            adminName = InetAddress.getLocalHost().getCanonicalHostName() + "-ADMIN";
        }
        catch (UnknownHostException e) {
            logger.info("Unable to get host name. Will set it to UNKNOWN, mostly ignorable", (Throwable)e);
            adminName = "UNKNOWN";
        }
        ArrayList<Message> resetMessages = new ArrayList<Message>();
        ArrayList<PropertyKey> messageKeys = new ArrayList<PropertyKey>();
        for (String partitionName : resetPartitionNames) {
            String msgId = UUID.randomUUID().toString();
            Message message = new Message(Message.MessageType.STATE_TRANSITION, msgId);
            message.setSrcName(adminName);
            message.setTgtName(instanceName);
            message.setMsgState(Message.MessageState.NEW);
            message.setPartitionName(partitionName);
            message.setResourceName(resourceName);
            message.setTgtSessionId(sessionId);
            message.setStateModelDef(stateModelDef);
            message.setFromState(HelixDefinedState.ERROR.toString());
            message.setToState(stateModel.getInitialState());
            message.setStateModelFactoryName(idealState.getStateModelFactoryName());
            if (idealState.getResourceGroupName() != null) {
                message.setResourceGroupName(idealState.getResourceGroupName());
            }
            if (idealState.getInstanceGroupTag() != null) {
                message.setResourceTag(idealState.getInstanceGroupTag());
            }
            resetMessages.add(message);
            messageKeys.add(keyBuilder.message(instanceName, message.getId()));
        }
        accessor.setChildren(messageKeys, resetMessages);
    }

    @Override
    public void resetInstance(String clusterName, List<String> instanceNames) {
        logger.info("Reset instances {} in cluster {}.", (Object)(instanceNames == null ? "NULL" : HelixUtil.serializeByComma(instanceNames)), (Object)clusterName);
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List extViews = accessor.getChildValues(keyBuilder.externalViews(), true);
        HashSet<String> resetInstanceNames = new HashSet<String>(instanceNames);
        for (String instanceName : resetInstanceNames) {
            ArrayList<String> resetPartitionNames = new ArrayList<String>();
            for (ExternalView extView : extViews) {
                Map<String, Map<String, String>> stateMap = extView.getRecord().getMapFields();
                for (String partitionName : stateMap.keySet()) {
                    Map<String, String> instanceStateMap = stateMap.get(partitionName);
                    if (!instanceStateMap.containsKey(instanceName) || !instanceStateMap.get(instanceName).equals(HelixDefinedState.ERROR.toString())) continue;
                    resetPartitionNames.add(partitionName);
                }
                this.resetPartition(clusterName, instanceName, extView.getResourceName(), resetPartitionNames);
            }
        }
    }

    @Override
    public void resetResource(String clusterName, List<String> resourceNames) {
        logger.info("Reset resources {} in cluster {}.", (Object)(resourceNames == null ? "NULL" : HelixUtil.serializeByComma(resourceNames)), (Object)clusterName);
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List extViews = accessor.getChildValues(keyBuilder.externalViews(), true);
        HashSet<String> resetResourceNames = new HashSet<String>(resourceNames);
        for (ExternalView extView : extViews) {
            if (!resetResourceNames.contains(extView.getResourceName())) continue;
            HashMap resetPartitionNames = new HashMap();
            Map<String, Map<String, String>> stateMap = extView.getRecord().getMapFields();
            for (String partitionName : stateMap.keySet()) {
                Map<String, String> instanceStateMap = stateMap.get(partitionName);
                for (String instanceName : instanceStateMap.keySet()) {
                    if (!instanceStateMap.get(instanceName).equals(HelixDefinedState.ERROR.toString())) continue;
                    if (!resetPartitionNames.containsKey(instanceName)) {
                        resetPartitionNames.put(instanceName, new ArrayList());
                    }
                    ((List)resetPartitionNames.get(instanceName)).add(partitionName);
                }
            }
            for (String instanceName : resetPartitionNames.keySet()) {
                this.resetPartition(clusterName, instanceName, extView.getResourceName(), (List)resetPartitionNames.get(instanceName));
            }
        }
    }

    @Override
    public boolean addCluster(String clusterName) {
        return this.addCluster(clusterName, false);
    }

    @Override
    public boolean addCluster(String clusterName, boolean recreateIfExists) {
        logger.info("Add cluster {}.", (Object)clusterName);
        String root = "/" + clusterName;
        if (this._zkClient.exists(root)) {
            if (recreateIfExists) {
                logger.warn("Root directory exists.Cleaning the root directory:" + root);
                this._zkClient.deleteRecursively(root);
            } else {
                logger.info("Cluster " + clusterName + " already exists");
                return true;
            }
        }
        try {
            this._zkClient.createPersistent(root, true);
        }
        catch (Exception e) {
            if (this._zkClient.exists(root)) {
                return true;
            }
            logger.error("Error creating cluster:" + clusterName, (Throwable)e);
            return false;
        }
        try {
            this.createZKPaths(clusterName);
        }
        catch (Exception e) {
            logger.error("Error creating cluster:" + clusterName, (Throwable)e);
            return false;
        }
        logger.info("Created cluster:" + clusterName);
        return true;
    }

    private void createZKPaths(String clusterName) {
        this._zkClient.createPersistent(PropertyPathBuilder.idealState(clusterName));
        String path = PropertyPathBuilder.clusterConfig(clusterName);
        this._zkClient.createPersistent(path, true);
        this._zkClient.writeData(path, new ZNRecord(clusterName));
        path = PropertyPathBuilder.instanceConfig(clusterName);
        this._zkClient.createPersistent(path);
        path = PropertyPathBuilder.resourceConfig(clusterName);
        this._zkClient.createPersistent(path);
        path = PropertyPathBuilder.customizedStateConfig(clusterName);
        this._zkClient.createPersistent(path);
        path = PropertyPathBuilder.propertyStore(clusterName);
        this._zkClient.createPersistent(path);
        this._zkClient.createPersistent(PropertyPathBuilder.liveInstance(clusterName));
        this._zkClient.createPersistent(PropertyPathBuilder.instance(clusterName));
        this._zkClient.createPersistent(PropertyPathBuilder.externalView(clusterName));
        this._zkClient.createPersistent(PropertyPathBuilder.stateModelDef(clusterName));
        this._zkClient.createPersistent(PropertyPathBuilder.controller(clusterName));
        path = PropertyPathBuilder.controllerHistory(clusterName);
        ZNRecord emptyHistory = new ZNRecord(PropertyType.HISTORY.toString());
        ArrayList<String> emptyList = new ArrayList<String>();
        emptyHistory.setListField(clusterName, emptyList);
        this._zkClient.createPersistent(path, emptyHistory);
        path = PropertyPathBuilder.controllerMessage(clusterName);
        this._zkClient.createPersistent(path);
        path = PropertyPathBuilder.controllerStatusUpdate(clusterName);
        this._zkClient.createPersistent(path);
        path = PropertyPathBuilder.controllerError(clusterName);
        this._zkClient.createPersistent(path);
    }

    @Override
    public List<String> getInstancesInCluster(String clusterName) {
        String memberInstancesPath = PropertyPathBuilder.instance(clusterName);
        return this._zkClient.getChildren(memberInstancesPath);
    }

    @Override
    public List<String> getInstancesInClusterWithTag(String clusterName, String tag) {
        String memberInstancesPath = PropertyPathBuilder.instance(clusterName);
        List<String> instances = this._zkClient.getChildren(memberInstancesPath);
        ArrayList<String> result = new ArrayList<String>();
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        for (String instanceName : instances) {
            InstanceConfig config = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
            if (config == null) {
                throw new IllegalStateException(String.format("Instance %s does not have a config, cluster might be in bad state", instanceName));
            }
            if (!config.containsTag(tag)) continue;
            result.add(instanceName);
        }
        return result;
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, IdealState.RebalanceMode.SEMI_AUTO.toString(), 0);
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String rebalancerMode) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, rebalancerMode, 0);
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String rebalancerMode, String rebalanceStrategy) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, rebalancerMode, rebalanceStrategy, 0, -1);
    }

    @Override
    public void addResource(String clusterName, String resourceName, IdealState idealstate) {
        logger.info("Add resource {} in cluster {}.", (Object)resourceName, (Object)clusterName);
        String stateModelRef = idealstate.getStateModelDefRef();
        String stateModelDefPath = PropertyPathBuilder.stateModelDef(clusterName, stateModelRef);
        if (!this._zkClient.exists(stateModelDefPath)) {
            throw new HelixException("State model " + stateModelRef + " not found in the cluster STATEMODELDEFS path");
        }
        String idealStatePath = PropertyPathBuilder.idealState(clusterName);
        String resourceIdealStatePath = idealStatePath + "/" + resourceName;
        if (this._zkClient.exists(resourceIdealStatePath)) {
            throw new HelixException("Skip the operation. Resource ideal state directory already exists:" + resourceIdealStatePath);
        }
        ZKUtil.createChildren(this._zkClient, idealStatePath, idealstate.getRecord());
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String rebalancerMode, int bucketSize) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, rebalancerMode, bucketSize, -1);
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String rebalancerMode, int bucketSize, int maxPartitionsPerInstance) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, rebalancerMode, "DEFAULT", bucketSize, maxPartitionsPerInstance);
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String rebalancerMode, String rebalanceStrategy, int bucketSize, int maxPartitionsPerInstance) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        IdealState idealState = new IdealState(resourceName);
        idealState.setNumPartitions(partitions);
        idealState.setStateModelDefRef(stateModelRef);
        IdealState.RebalanceMode mode = idealState.rebalanceModeFromString(rebalancerMode, IdealState.RebalanceMode.SEMI_AUTO);
        idealState.setRebalanceMode(mode);
        idealState.setRebalanceStrategy(rebalanceStrategy);
        idealState.setReplicas("0");
        idealState.setStateModelFactoryName("DEFAULT");
        if (maxPartitionsPerInstance > 0 && maxPartitionsPerInstance < Integer.MAX_VALUE) {
            idealState.setMaxPartitionsPerInstance(maxPartitionsPerInstance);
        }
        if (bucketSize > 0) {
            idealState.setBucketSize(bucketSize);
        }
        this.addResource(clusterName, resourceName, idealState);
    }

    @Override
    public List<String> getClusters() {
        List<String> zkToplevelPaths;
        if (Boolean.getBoolean("helix.multiZkEnabled") || this._zkClient instanceof FederatedZkClient) {
            String routingDataSourceEndpoint = this._zkClient.getRealmAwareZkConnectionConfig().getRoutingDataSourceEndpoint();
            Map<String, List<String>> realmToShardingKeys = routingDataSourceEndpoint == null || routingDataSourceEndpoint.isEmpty() ? RoutingDataManager.getInstance().getRawRoutingData() : RoutingDataManager.getInstance().getRawRoutingData(RoutingDataReaderType.lookUp(this._zkClient.getRealmAwareZkConnectionConfig().getRoutingDataSourceType()), routingDataSourceEndpoint);
            if (realmToShardingKeys == null || realmToShardingKeys.isEmpty()) {
                return Collections.emptyList();
            }
            zkToplevelPaths = realmToShardingKeys.values().stream().flatMap(Collection::stream).map(shardingKey -> shardingKey.substring(1)).collect(Collectors.toList());
        } else {
            zkToplevelPaths = this._zkClient.getChildren("/");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String pathName : zkToplevelPaths) {
            if (!ZKUtil.isClusterSetup(pathName, this._zkClient)) continue;
            result.add(pathName);
        }
        return result;
    }

    @Override
    public List<String> getResourcesInCluster(String clusterName) {
        return this._zkClient.getChildren(PropertyPathBuilder.idealState(clusterName));
    }

    @Override
    public List<String> getResourcesInClusterWithTag(String clusterName, String tag) {
        ArrayList<String> resourcesWithTag = new ArrayList<String>();
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        for (String resourceName : this.getResourcesInCluster(clusterName)) {
            IdealState is = (IdealState)accessor.getProperty(keyBuilder.idealStates(resourceName));
            if (is == null || is.getInstanceGroupTag() == null || !is.getInstanceGroupTag().equals(tag)) continue;
            resourcesWithTag.add(resourceName);
        }
        return resourcesWithTag;
    }

    @Override
    public IdealState getResourceIdealState(String clusterName, String resourceName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (IdealState)accessor.getProperty(keyBuilder.idealStates(resourceName));
    }

    @Override
    public void setResourceIdealState(String clusterName, String resourceName, IdealState idealState) {
        logger.info("Set IdealState for resource {} in cluster {} with new IdealState {}.", new Object[]{resourceName, clusterName, idealState == null ? "NULL" : idealState.toString()});
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.idealStates(resourceName), idealState);
    }

    @Override
    public void updateIdealState(String clusterName, String resourceName, IdealState idealState) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("updateIdealState failed. Cluster: " + clusterName + " is NOT setup properly.");
        }
        String zkPath = PropertyPathBuilder.idealState(clusterName, resourceName);
        if (!this._zkClient.exists(zkPath)) {
            throw new HelixException(String.format("updateIdealState failed. The IdealState for the given resource does not already exist. Resource name: %s", resourceName));
        }
        ZKUtil.createOrUpdate(this._zkClient, zkPath, idealState.getRecord(), true, true);
    }

    @Override
    public void removeFromIdealState(String clusterName, String resourceName, IdealState idealState) {
        String zkPath = PropertyPathBuilder.idealState(clusterName, resourceName);
        ZKUtil.subtract(this._zkClient, zkPath, idealState.getRecord());
    }

    @Override
    public ExternalView getResourceExternalView(String clusterName, String resourceName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (ExternalView)accessor.getProperty(keyBuilder.externalView(resourceName));
    }

    @Override
    public CustomizedView getResourceCustomizedView(String clusterName, String resourceName, String customizedStateType) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (CustomizedView)accessor.getProperty(keyBuilder.customizedView(customizedStateType, resourceName));
    }

    @Override
    public void addStateModelDef(String clusterName, String stateModelDef, StateModelDefinition stateModel) {
        this.addStateModelDef(clusterName, stateModelDef, stateModel, false);
    }

    @Override
    public void addStateModelDef(String clusterName, String stateModelDef, StateModelDefinition stateModel, boolean recreateIfExists) {
        logger.info("Add StateModelDef {} in cluster {} with StateModel {}.", new Object[]{stateModelDef, clusterName, stateModel == null ? "NULL" : stateModel.toString()});
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String stateModelDefPath = PropertyPathBuilder.stateModelDef(clusterName);
        String stateModelPath = stateModelDefPath + "/" + stateModelDef;
        if (this._zkClient.exists(stateModelPath)) {
            if (recreateIfExists) {
                logger.info("Operation.State Model directory exists:" + stateModelPath + ", remove and recreate.");
                this._zkClient.deleteRecursively(stateModelPath);
            } else {
                logger.info("Skip the operation. State Model directory exists:" + stateModelPath);
                return;
            }
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.stateModelDef(stateModelDef), stateModel);
    }

    @Override
    public void dropResource(String clusterName, String resourceName) {
        logger.info("Drop resource {} from cluster {}", (Object)resourceName, (Object)clusterName);
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("Cluster " + clusterName + " is not setup yet");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.removeProperty(keyBuilder.idealStates(resourceName));
        accessor.removeProperty(keyBuilder.resourceConfig(resourceName));
    }

    @Override
    public void addCloudConfig(String clusterName, CloudConfig cloudConfig) {
        logger.info("Add CloudConfig to cluster {}, CloudConfig is {}.", (Object)clusterName, (Object)cloudConfig.toString());
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        CloudConfig.Builder builder = new CloudConfig.Builder(cloudConfig);
        CloudConfig cloudConfigBuilder = builder.build();
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.cloudConfig(), cloudConfigBuilder);
    }

    @Override
    public void removeCloudConfig(String clusterName) {
        logger.info("Remove Cloud Config for cluster {}.", (Object)clusterName);
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.removeProperty(keyBuilder.cloudConfig());
    }

    @Override
    public ClusterTopology getClusterTopology(String clusterName) {
        HashMap<String, InstanceConfig> instanceConfigMap = new HashMap<String, InstanceConfig>();
        String path = PropertyPathBuilder.instanceConfig(clusterName);
        ZkBaseDataAccessor baseAccessor = new ZkBaseDataAccessor(this._zkClient);
        List znRecords = baseAccessor.getChildren(path, null, 0, 0, 0);
        for (ZNRecord record : znRecords) {
            if (record == null) continue;
            InstanceConfig instanceConfig = new InstanceConfig(record);
            instanceConfigMap.put(instanceConfig.getInstanceName(), instanceConfig);
        }
        path = PropertyPathBuilder.liveInstance(clusterName);
        List<String> liveNodes = baseAccessor.getChildNames(path, 0);
        ConfigAccessor configAccessor = new ConfigAccessor(this._zkClient);
        ClusterConfig clusterConfig = configAccessor.getClusterConfig(clusterName);
        return new ClusterTopology(liveNodes, instanceConfigMap, clusterConfig);
    }

    @Override
    public List<String> getStateModelDefs(String clusterName) {
        return this._zkClient.getChildren(PropertyPathBuilder.stateModelDef(clusterName));
    }

    @Override
    public StateModelDefinition getStateModelDef(String clusterName, String stateModelName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (StateModelDefinition)accessor.getProperty(keyBuilder.stateModelDef(stateModelName));
    }

    @Override
    public void dropCluster(String clusterName) {
        logger.info("Deleting cluster {}.", (Object)clusterName);
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String root = "/" + clusterName;
        if (accessor.getChildNames(keyBuilder.liveInstances()).size() > 0) {
            throw new HelixException("There are still live instances in the cluster, shut them down first.");
        }
        if (accessor.getProperty(keyBuilder.controllerLeader()) != null) {
            throw new HelixException("There are still LEADER in the cluster, shut them down first.");
        }
        this._zkClient.deleteRecursively(root);
    }

    @Override
    public void addClusterToGrandCluster(String clusterName, String grandCluster) {
        logger.info("Add cluster {} to grand cluster {}.", (Object)clusterName, (Object)grandCluster);
        if (!ZKUtil.isClusterSetup(grandCluster, this._zkClient)) {
            throw new HelixException("Grand cluster " + grandCluster + " is not setup yet");
        }
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("Cluster " + clusterName + " is not setup yet");
        }
        IdealState idealState = new IdealState(clusterName);
        idealState.setNumPartitions(1);
        idealState.setStateModelDefRef("LeaderStandby");
        idealState.setRebalanceMode(IdealState.RebalanceMode.FULL_AUTO);
        idealState.setRebalancerClassName(WagedRebalancer.class.getName());
        idealState.setReplicas(Integer.toString(3));
        idealState.getRecord().setListField(clusterName, new ArrayList<String>());
        List<String> controllers = this.getInstancesInCluster(grandCluster);
        if (controllers.size() == 0) {
            throw new HelixException("Grand cluster " + grandCluster + " has no instances");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(grandCluster, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.idealStates(idealState.getResourceName()), idealState);
        LOG.info("Cluster {} has been added to grand cluster {} with rebalance configuration {}.", new Object[]{clusterName, grandCluster, idealState.getRecord().getSimpleFields().toString()});
    }

    @Override
    public void setConfig(HelixConfigScope scope, Map<String, String> properties) {
        logger.info("Set configs with keys ");
        this._configAccessor.set(scope, properties);
    }

    @Override
    public Map<String, String> getConfig(HelixConfigScope scope, List<String> keys) {
        return this._configAccessor.get(scope, keys);
    }

    @Override
    public void addCustomizedStateConfig(String clusterName, CustomizedStateConfig customizedStateConfig) {
        logger.info("Add CustomizedStateConfig to cluster {}, CustomizedStateConfig is {}", (Object)clusterName, (Object)customizedStateConfig.toString());
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        CustomizedStateConfig.Builder builder = new CustomizedStateConfig.Builder(customizedStateConfig);
        CustomizedStateConfig customizedStateConfigFromBuilder = builder.build();
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.customizedStateConfig(), customizedStateConfigFromBuilder);
    }

    @Override
    public void removeCustomizedStateConfig(String clusterName) {
        logger.info("Remove CustomizedStateConfig from cluster {}.", (Object)clusterName);
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.removeProperty(keyBuilder.customizedStateConfig());
    }

    @Override
    public void addTypeToCustomizedStateConfig(String clusterName, String type) {
        logger.info("Add type {} to CustomizedStateConfig of cluster {}", (Object)type, (Object)clusterName);
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        CustomizedStateConfig.Builder builder = new CustomizedStateConfig.Builder();
        builder.addAggregationEnabledType(type);
        CustomizedStateConfig customizedStateConfigFromBuilder = builder.build();
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (!accessor.updateProperty(keyBuilder.customizedStateConfig(), customizedStateConfigFromBuilder)) {
            throw new HelixException("Failed to add customized state config type " + type + " to cluster" + clusterName);
        }
    }

    @Override
    public void removeTypeFromCustomizedStateConfig(String clusterName, String type) {
        logger.info("Remove type {} to CustomizedStateConfig of cluster {}", (Object)type, (Object)clusterName);
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        CustomizedStateConfig.Builder builder = new CustomizedStateConfig.Builder(this._configAccessor.getCustomizedStateConfig(clusterName));
        if (!builder.getAggregationEnabledTypes().contains(type)) {
            throw new HelixException("Type " + type + " is missing from the CustomizedStateConfig of cluster " + clusterName);
        }
        builder.removeAggregationEnabledType(type);
        CustomizedStateConfig customizedStateConfigFromBuilder = builder.build();
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.customizedStateConfig(), customizedStateConfigFromBuilder);
    }

    @Override
    public List<String> getConfigKeys(HelixConfigScope scope) {
        return this._configAccessor.getKeys(scope);
    }

    @Override
    public void removeConfig(HelixConfigScope scope, List<String> keys) {
        this._configAccessor.remove(scope, keys);
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica) {
        this.rebalance(clusterName, resourceName, replica, resourceName, "");
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica, String keyPrefix, String group) {
        LinkedList<String> instanceNames = new LinkedList();
        if (keyPrefix == null || keyPrefix.length() == 0) {
            keyPrefix = resourceName;
        }
        if (group != null && group.length() > 0) {
            instanceNames = this.getInstancesInClusterWithTag(clusterName, group);
        }
        if (instanceNames.size() == 0) {
            logger.info("No tags found for resource " + resourceName + ", use all instances");
            instanceNames = this.getInstancesInCluster(clusterName);
            group = "";
        } else {
            logger.info("Found instances with tag for " + resourceName + " " + instanceNames);
        }
        this.rebalance(clusterName, resourceName, replica, keyPrefix, instanceNames, group);
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica, List<String> instances) {
        this.rebalance(clusterName, resourceName, replica, resourceName, instances, "");
    }

    void rebalance(String clusterName, String resourceName, int replica, String keyPrefix, List<String> instanceNames, String groupId) {
        logger.info("Rebalance resource {} with replica {} in cluster {}.", new Object[]{resourceName, replica, clusterName});
        Collections.sort(instanceNames);
        IdealState idealState = this.getResourceIdealState(clusterName, resourceName);
        if (idealState == null) {
            throw new HelixException("Resource: " + resourceName + " has NOT been added yet");
        }
        if (groupId != null && groupId.length() > 0) {
            idealState.setInstanceGroupTag(groupId);
        }
        idealState.setReplicas(Integer.toString(replica));
        int partitions = idealState.getNumPartitions();
        String stateModelName = idealState.getStateModelDefRef();
        StateModelDefinition stateModDef = this.getStateModelDef(clusterName, stateModelName);
        if (stateModDef == null) {
            throw new HelixException("cannot find state model: " + stateModelName);
        }
        List<String> statePriorityList = stateModDef.getStatesPriorityList();
        String masterStateValue = null;
        String slaveStateValue = null;
        --replica;
        for (String state : statePriorityList) {
            String count = stateModDef.getNumInstancesPerState(state);
            if (count.equals("1")) {
                if (masterStateValue != null) {
                    throw new HelixException("Invalid or unsupported state model definition");
                }
                masterStateValue = state;
                continue;
            }
            if (count.equalsIgnoreCase("R")) {
                if (slaveStateValue != null) {
                    throw new HelixException("Invalid or unsupported state model definition");
                }
                slaveStateValue = state;
                continue;
            }
            if (!count.equalsIgnoreCase("N")) continue;
            if (masterStateValue != null || slaveStateValue != null) {
                throw new HelixException("Invalid or unsupported state model definition");
            }
            replica = instanceNames.size() - 1;
            masterStateValue = slaveStateValue = state;
        }
        if (masterStateValue == null && slaveStateValue == null) {
            throw new HelixException("Invalid or unsupported state model definition");
        }
        if (masterStateValue == null) {
            masterStateValue = slaveStateValue;
        }
        if (idealState.getRebalanceMode() != IdealState.RebalanceMode.FULL_AUTO && idealState.getRebalanceMode() != IdealState.RebalanceMode.USER_DEFINED) {
            ZNRecord newIdealState = DefaultIdealStateCalculator.calculateIdealState(instanceNames, partitions, replica, keyPrefix, masterStateValue, slaveStateValue);
            if (idealState.getRebalanceMode() == IdealState.RebalanceMode.SEMI_AUTO) {
                idealState.getRecord().setListFields(newIdealState.getListFields());
                idealState.getRecord().setMapFields(newIdealState.getMapFields());
            }
            if (idealState.getRebalanceMode() == IdealState.RebalanceMode.CUSTOMIZED) {
                idealState.getRecord().setMapFields(newIdealState.getMapFields());
            }
        } else {
            for (int i = 0; i < partitions; ++i) {
                String partitionName = keyPrefix + "_" + i;
                idealState.getRecord().setMapField(partitionName, new HashMap<String, String>());
                idealState.getRecord().setListField(partitionName, new ArrayList<String>());
            }
        }
        this.setResourceIdealState(clusterName, resourceName, idealState);
    }

    @Override
    public void addIdealState(String clusterName, String resourceName, String idealStateFile) throws IOException {
        logger.info("Add IdealState for resource {} to cluster {} by file name {}.", new Object[]{resourceName, clusterName, idealStateFile});
        ZNRecord idealStateRecord = (ZNRecord)new ZNRecordSerializer().deserialize(ZKHelixAdmin.readFile(idealStateFile));
        if (idealStateRecord.getId() == null || !idealStateRecord.getId().equals(resourceName)) {
            throw new IllegalArgumentException("ideal state must have same id as resource name");
        }
        this.setResourceIdealState(clusterName, resourceName, new IdealState(idealStateRecord));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(String filePath) throws IOException {
        File file = new File(filePath);
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        try (FilterInputStream dis = null;){
            dis = new DataInputStream(new FileInputStream(file));
            int numRead = 0;
            for (int read = 0; read < bytes.length && (numRead = ((DataInputStream)dis).read(bytes, read, bytes.length - read)) >= 0; read += numRead) {
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    @Override
    public void addStateModelDef(String clusterName, String stateModelDefName, String stateModelDefFile) throws IOException {
        ZNRecord record = (ZNRecord)new ZNRecordSerializer().deserialize(ZKHelixAdmin.readFile(stateModelDefFile));
        if (record == null || record.getId() == null || !record.getId().equals(stateModelDefName)) {
            throw new IllegalArgumentException("state model definition must have same id as state model def name");
        }
        this.addStateModelDef(clusterName, stateModelDefName, new StateModelDefinition(record), false);
    }

    @Override
    public void setConstraint(String clusterName, final ClusterConstraints.ConstraintType constraintType, final String constraintId, final ConstraintItem constraintItem) {
        logger.info("Set constraint type {} with constraint id {} for cluster {}.", new Object[]{constraintType, constraintId, clusterName});
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        String path = keyBuilder.constraint(constraintType.toString()).getPath();
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                ClusterConstraints constraints = currentData == null ? new ClusterConstraints(constraintType) : new ClusterConstraints(currentData);
                constraints.addConstraintItem(constraintId, constraintItem);
                return constraints.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void removeConstraint(String clusterName, ClusterConstraints.ConstraintType constraintType, final String constraintId) {
        logger.info("Remove constraint type {} with constraint id {} for cluster {}.", new Object[]{constraintType, constraintId, clusterName});
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        String path = keyBuilder.constraint(constraintType.toString()).getPath();
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData != null) {
                    ClusterConstraints constraints = new ClusterConstraints(currentData);
                    constraints.removeConstraintItem(constraintId);
                    return constraints.getRecord();
                }
                return null;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public ClusterConstraints getConstraints(String clusterName, ClusterConstraints.ConstraintType constraintType) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        return (ClusterConstraints)accessor.getProperty(keyBuilder.constraint(constraintType.toString()));
    }

    @Override
    public void rebalance(String clusterName, IdealState currentIdealState, List<String> instanceNames) {
        logger.info("Rebalance resource {} in cluster {} with IdealState {}.", new Object[]{currentIdealState.getResourceName(), clusterName, currentIdealState == null ? "NULL" : currentIdealState.toString()});
        HashSet<String> activeInstances = new HashSet<String>();
        for (String partition : currentIdealState.getPartitionSet()) {
            activeInstances.addAll(currentIdealState.getRecord().getListField(partition));
        }
        instanceNames.removeAll(activeInstances);
        Map<String, Object> previousIdealState = RebalanceUtil.buildInternalIdealState(currentIdealState);
        Map<String, Object> balancedRecord = DefaultIdealStateCalculator.calculateNextIdealState(instanceNames, previousIdealState);
        StateModelDefinition stateModDef = this.getStateModelDef(clusterName, currentIdealState.getStateModelDefRef());
        if (stateModDef == null) {
            throw new HelixException("cannot find state model: " + currentIdealState.getStateModelDefRef());
        }
        String[] states = RebalanceUtil.parseStates(clusterName, stateModDef);
        ZNRecord newIdealStateRecord = DefaultIdealStateCalculator.convertToZNRecord(balancedRecord, currentIdealState.getResourceName(), states[0], states[1]);
        HashSet<String> partitionSet = new HashSet<String>();
        partitionSet.addAll(newIdealStateRecord.getMapFields().keySet());
        partitionSet.addAll(newIdealStateRecord.getListFields().keySet());
        Map reversePartitionIndex = (Map)balancedRecord.get("reversePartitionIndex");
        for (String partition : partitionSet) {
            String originPartitionName;
            if (!reversePartitionIndex.containsKey(partition) || partition.equals(originPartitionName = (String)reversePartitionIndex.get(partition))) continue;
            newIdealStateRecord.getMapFields().put(originPartitionName, newIdealStateRecord.getMapField(partition));
            newIdealStateRecord.getMapFields().remove(partition);
            newIdealStateRecord.getListFields().put(originPartitionName, newIdealStateRecord.getListField(partition));
            newIdealStateRecord.getListFields().remove(partition);
        }
        newIdealStateRecord.getSimpleFields().putAll(currentIdealState.getRecord().getSimpleFields());
        IdealState newIdealState = new IdealState(newIdealStateRecord);
        this.setResourceIdealState(clusterName, newIdealStateRecord.getId(), newIdealState);
    }

    @Override
    public void addInstanceTag(String clusterName, String instanceName, String tag) {
        logger.info("Add instance tag {} for instance {} in cluster {}.", new Object[]{tag, instanceName, clusterName});
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        if (!ZKUtil.isInstanceSetup(this._zkClient, clusterName, instanceName, InstanceType.PARTICIPANT)) {
            throw new HelixException("cluster " + clusterName + " instance " + instanceName + " is not setup yet");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        InstanceConfig config = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
        config.addTag(tag);
        accessor.setProperty(keyBuilder.instanceConfig(instanceName), config);
    }

    @Override
    public void removeInstanceTag(String clusterName, String instanceName, String tag) {
        logger.info("Remove instance tag {} for instance {} in cluster {}.", new Object[]{tag, instanceName, clusterName});
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        if (!ZKUtil.isInstanceSetup(this._zkClient, clusterName, instanceName, InstanceType.PARTICIPANT)) {
            throw new HelixException("cluster " + clusterName + " instance " + instanceName + " is not setup yet");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        InstanceConfig config = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
        config.removeTag(tag);
        accessor.setProperty(keyBuilder.instanceConfig(instanceName), config);
    }

    @Override
    public void setInstanceZoneId(String clusterName, String instanceName, String zoneId) {
        logger.info("Set instance zoneId {} for instance {} in cluster {}.", new Object[]{zoneId, instanceName, clusterName});
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        if (!ZKUtil.isInstanceSetup(this._zkClient, clusterName, instanceName, InstanceType.PARTICIPANT)) {
            throw new HelixException("cluster " + clusterName + " instance " + instanceName + " is not setup yet");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        InstanceConfig config = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
        config.setZoneId(zoneId);
        accessor.setProperty(keyBuilder.instanceConfig(instanceName), config);
    }

    @Override
    public void enableBatchMessageMode(String clusterName, boolean enabled) {
        logger.info("{} batch message mode for cluster {}.", (Object)(enabled ? "Enable" : "Disable"), (Object)clusterName);
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        ConfigAccessor accessor = new ConfigAccessor(this._zkClient);
        ClusterConfig clusterConfig = accessor.getClusterConfig(clusterName);
        clusterConfig.setBatchMessageMode(enabled);
        accessor.setClusterConfig(clusterName, clusterConfig);
    }

    @Override
    public void enableBatchMessageMode(String clusterName, String resourceName, boolean enabled) {
        logger.info("{} batch message mode for resource {} in cluster {}.", new Object[]{enabled ? "Enable" : "Disable", resourceName, clusterName});
        IdealState idealState = this.getResourceIdealState(clusterName, resourceName);
        if (idealState == null) {
            throw new HelixException("Cluster " + clusterName + ", resource: " + resourceName + ", ideal-state does not exist");
        }
        idealState.setBatchMessageMode(enabled);
        this.setResourceIdealState(clusterName, resourceName, idealState);
    }

    private void enableSingleInstance(final String clusterName, final String instanceName, final boolean enabled, BaseDataAccessor<ZNRecord> baseAccessor, final InstanceConstants.InstanceDisabledType disabledType, final String reason) {
        String path = PropertyPathBuilder.instanceConfig(clusterName, instanceName);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster " + clusterName + ", instance: " + instanceName + ", instance config does not exist");
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", participant config is null");
                }
                InstanceConfig config = new InstanceConfig(currentData);
                config.setInstanceEnabled(enabled);
                if (!enabled) {
                    config.resetInstanceDisabledTypeAndReason();
                    if (reason != null) {
                        config.setInstanceDisabledReason(reason);
                    }
                    if (disabledType != null) {
                        config.setInstanceDisabledType(disabledType);
                    }
                }
                return config.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    private void enableBatchInstances(final String clusterName, final List<String> instances, final boolean enabled, BaseDataAccessor<ZNRecord> baseAccessor, final InstanceConstants.InstanceDisabledType disabledType, final String reason) {
        String path = PropertyPathBuilder.clusterConfig(clusterName);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster " + clusterName + ": cluster config does not exist");
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ": cluster config is null");
                }
                ClusterConfig clusterConfig = new ClusterConfig(currentData);
                TreeMap<String, String> disabledInstances = new TreeMap<String, String>();
                if (clusterConfig.getDisabledInstances() != null) {
                    disabledInstances.putAll(clusterConfig.getDisabledInstances());
                }
                if (enabled) {
                    disabledInstances.keySet().removeAll(instances);
                } else {
                    for (String disabledInstance : instances) {
                        disabledInstances.put(disabledInstance, ZKHelixAdmin.assembleInstanceBatchedDisabledInfo(disabledType, reason));
                    }
                }
                clusterConfig.setDisabledInstances(disabledInstances);
                return clusterConfig.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    public static String assembleInstanceBatchedDisabledInfo(InstanceConstants.InstanceDisabledType disabledType, String reason) {
        TreeMap<String, String> disableInfo = new TreeMap<String, String>();
        disableInfo.put(ClusterConfig.ClusterConfigProperty.HELIX_ENABLED_DISABLE_TIMESTAMP.toString(), String.valueOf(System.currentTimeMillis()));
        if (disabledType != null) {
            disableInfo.put(ClusterConfig.ClusterConfigProperty.HELIX_DISABLED_TYPE.toString(), disabledType.toString());
        }
        if (reason != null) {
            disableInfo.put(ClusterConfig.ClusterConfigProperty.HELIX_DISABLED_REASON.toString(), reason);
        }
        return ConfigStringUtil.concatenateMapping(disableInfo);
    }

    @Override
    public Map<String, String> getBatchDisabledInstances(String clusterName) {
        ConfigAccessor accessor = new ConfigAccessor(this._zkClient);
        return accessor.getClusterConfig(clusterName).getDisabledInstances();
    }

    @Override
    public List<String> getInstancesByDomain(String clusterName, String domain) {
        ArrayList<String> instances = new ArrayList<String>();
        String path = PropertyPathBuilder.instanceConfig(clusterName);
        ZkBaseDataAccessor baseAccessor = new ZkBaseDataAccessor(this._zkClient);
        List znRecords = baseAccessor.getChildren(path, null, 0, 0, 0);
        for (ZNRecord record : znRecords) {
            InstanceConfig instanceConfig;
            if (record == null || !(instanceConfig = new InstanceConfig(record)).isInstanceInDomain(domain)) continue;
            instances.add(instanceConfig.getInstanceName());
        }
        return instances;
    }

    @Override
    public void close() {
        if (this._zkClient != null && !this._usesExternalZkClient) {
            this._zkClient.close();
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public boolean addResourceWithWeight(String clusterName, IdealState idealState, ResourceConfig resourceConfig) {
        if (clusterName == null || clusterName.isEmpty()) {
            throw new HelixException("Cluster name is null or empty!");
        }
        if (idealState == null || !idealState.isValid()) {
            throw new HelixException("IdealState is null or invalid!");
        }
        if (resourceConfig == null || !resourceConfig.isValid()) {
            throw new HelixException("ResourceConfig is null or invalid!");
        }
        if (!idealState.getResourceName().equals(resourceConfig.getResourceName())) {
            throw new HelixException("Resource names in IdealState and ResourceConfig are different!");
        }
        if (!this.validateWeightForResourceConfig(this._configAccessor.getClusterConfig(clusterName), resourceConfig, idealState)) {
            throw new HelixException(String.format("Could not add resource %s with weight! Failed to validate the ResourceConfig!", idealState.getResourceName()));
        }
        this._configAccessor.setResourceConfig(clusterName, resourceConfig.getResourceName(), resourceConfig);
        this.setResourceIdealState(clusterName, idealState.getResourceName(), idealState);
        this.rebalance(clusterName, idealState.getResourceName(), Integer.parseInt(idealState.getReplicas()), idealState.getResourceName(), idealState.getInstanceGroupTag());
        return true;
    }

    @Override
    public boolean enableWagedRebalance(String clusterName, List<String> resourceNames) {
        boolean[] success;
        if (clusterName == null || clusterName.isEmpty()) {
            throw new HelixException("Cluster name is invalid!");
        }
        if (resourceNames == null || resourceNames.isEmpty()) {
            throw new HelixException("Resource name list is invalid!");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        ArrayList<IdealState> enabledIdealStates = new ArrayList<IdealState>();
        ArrayList<PropertyKey> enabledIdealStateKeys = new ArrayList<PropertyKey>();
        HashSet<String> enabledResourceNames = new HashSet<String>();
        List idealStates = accessor.getChildValues(keyBuilder.idealStates(), true);
        for (IdealState idealState : idealStates) {
            if (idealState == null || !resourceNames.contains(idealState.getResourceName())) continue;
            idealState.setRebalancerClassName(WagedRebalancer.class.getName());
            idealState.setRebalanceMode(IdealState.RebalanceMode.FULL_AUTO);
            enabledIdealStates.add(idealState);
            enabledIdealStateKeys.add(keyBuilder.idealStates(idealState.getResourceName()));
            enabledResourceNames.add(idealState.getResourceName());
        }
        List resourcesNotFound = resourceNames.stream().filter(resourceName -> !enabledResourceNames.contains(resourceName)).collect(Collectors.toList());
        if (!resourcesNotFound.isEmpty()) {
            throw new HelixException(String.format("Some resources do not have IdealStates: %s", resourcesNotFound));
        }
        for (boolean s : success = accessor.setChildren(enabledIdealStateKeys, enabledIdealStates)) {
            if (s) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Boolean> validateResourcesForWagedRebalance(String clusterName, List<String> resourceNames) {
        if (clusterName == null || clusterName.isEmpty()) {
            throw new HelixException("Cluster name is invalid!");
        }
        if (resourceNames == null || resourceNames.isEmpty()) {
            throw new HelixException("Resource name list is invalid!");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List<String> instances = accessor.getChildNames(keyBuilder.instanceConfigs());
        if (this.validateInstancesForWagedRebalance(clusterName, instances).containsValue(false)) {
            throw new HelixException(String.format("Instance capacities haven't been configured properly for cluster %s", clusterName));
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ClusterConfig clusterConfig = this._configAccessor.getClusterConfig(clusterName);
        for (String resourceName : resourceNames) {
            IdealState idealState = this.getResourceIdealState(clusterName, resourceName);
            if (idealState == null || !idealState.isValid()) {
                result.put(resourceName, false);
                continue;
            }
            ResourceConfig resourceConfig = this._configAccessor.getResourceConfig(clusterName, resourceName);
            result.put(resourceName, this.validateWeightForResourceConfig(clusterConfig, resourceConfig, idealState));
        }
        return result;
    }

    @Override
    public Map<String, Boolean> validateInstancesForWagedRebalance(String clusterName, List<String> instanceNames) {
        if (clusterName == null || clusterName.isEmpty()) {
            throw new HelixException("Cluster name is invalid!");
        }
        if (instanceNames == null || instanceNames.isEmpty()) {
            throw new HelixException("Instance name list is invalid!");
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ClusterConfig clusterConfig = this._configAccessor.getClusterConfig(clusterName);
        for (String instanceName : instanceNames) {
            InstanceConfig instanceConfig = this._configAccessor.getInstanceConfig(clusterName, instanceName);
            if (instanceConfig == null || !instanceConfig.isValid()) {
                result.put(instanceName, false);
                continue;
            }
            WagedValidationUtil.validateAndGetInstanceCapacity(clusterConfig, instanceConfig);
            result.put(instanceName, true);
        }
        return result;
    }

    private boolean validateWeightForResourceConfig(ClusterConfig clusterConfig, ResourceConfig resourceConfig, IdealState idealState) {
        Map<String, Map<String, Integer>> capacityMap;
        if (resourceConfig == null) {
            if (clusterConfig.getDefaultPartitionWeightMap().isEmpty()) {
                logger.error("ResourceConfig for {} is null, and there are no default weights set in ClusterConfig!", (Object)idealState.getResourceName());
                return false;
            }
            if (clusterConfig.getDefaultPartitionWeightMap().keySet().containsAll(clusterConfig.getInstanceCapacityKeys())) {
                return true;
            }
            logger.error("ResourceConfig for {} is null, and ClusterConfig's default partition weight map doesn't have all the required keys!", (Object)idealState.getResourceName());
            return false;
        }
        try {
            capacityMap = resourceConfig.getPartitionCapacityMap();
        }
        catch (IOException ex) {
            logger.error("Invalid partition capacity configuration of resource: {}", (Object)idealState.getResourceName(), (Object)ex);
            return false;
        }
        HashSet<String> capacityMapSet = new HashSet<String>(capacityMap.keySet());
        boolean hasDefaultCapacity = capacityMapSet.contains("DEFAULT");
        capacityMapSet.remove("DEFAULT");
        if (capacityMapSet.size() != idealState.getNumPartitions() && !hasDefaultCapacity) {
            logger.error("ResourceConfig for {} does not have all partitions defined in PartitionCapacityMap!", (Object)idealState.getResourceName());
            return false;
        }
        capacityMap.keySet().forEach(partitionName -> WagedValidationUtil.validateAndGetPartitionCapacity(partitionName, resourceConfig, capacityMap, clusterConfig));
        return true;
    }

    private Set<String> findTimeoutOfflineInstances(String clusterName, long offlineDuration) {
        if (offlineDuration == -1L && (offlineDuration = this._configAccessor.getClusterConfig(clusterName).getOfflineDurationForPurge()) == -1L) {
            return Collections.emptySet();
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List<String> instanceConfigNames = accessor.getChildNames(keyBuilder.instanceConfigs());
        List<String> instancePathNames = accessor.getChildNames(keyBuilder.instances());
        List<String> liveNodes = accessor.getChildNames(keyBuilder.liveInstances());
        HashSet<String> offlineInstanceNames = new HashSet<String>(instancePathNames);
        liveNodes.forEach(offlineInstanceNames::remove);
        long finalOfflineDuration = offlineDuration;
        offlineInstanceNames.removeIf(instanceName -> {
            ParticipantHistory participantHistory = (ParticipantHistory)accessor.getProperty(keyBuilder.participantHistory((String)instanceName));
            if (participantHistory == null && instanceConfigNames.contains(instanceName)) {
                return true;
            }
            return participantHistory != null && (participantHistory.getLastOfflineTime() == ParticipantHistory.ONLINE || System.currentTimeMillis() - participantHistory.getLastOfflineTime() < finalOfflineDuration);
        });
        return offlineInstanceNames;
    }

    public static class Builder
    extends GenericZkHelixApiBuilder<Builder> {
        public ZKHelixAdmin build() {
            this.validate();
            return new ZKHelixAdmin(this.createZkClient(this._realmMode, this._realmAwareZkConnectionConfig, this._realmAwareZkClientConfig, this._zkAddress), false);
        }
    }

    private static enum ResetPartitionFailureReason {
        INSTANCE_NOT_ALIVE("%s is not alive in cluster %s"),
        INSTANCE_NON_EXISTENT("%s does not exist in cluster %s"),
        RESOURCE_NON_EXISTENT("resource %s is not added to cluster %s"),
        PARTITION_NON_EXISTENT("not all %s exist in cluster %s"),
        PARTITION_NOT_ERROR("%s is NOT found in cluster %s or not in ERROR state"),
        STATE_MODEL_NON_EXISTENT("%s is NOT found in cluster %s");

        private String message;

        private ResetPartitionFailureReason(String message) {
            this.message = message;
        }

        public String getMessage(String resourceName, List<String> partitionNames, String instanceName, String errorStateEntity, String clusterName) {
            return String.format("Can't reset state for %s.%s on %s, because " + this.message, resourceName, partitionNames, instanceName, errorStateEntity, clusterName);
        }
    }
}

