/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.dataproviders;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.api.rebalancer.constraint.AbnormalStateResolver;
import org.apache.helix.common.caches.CurrentStateCache;
import org.apache.helix.common.caches.InstanceMessagesCache;
import org.apache.helix.common.caches.PropertyCache;
import org.apache.helix.common.caches.TaskCurrentStateCache;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.rebalancer.constraint.MonitoredAbnormalResolver;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Message;
import org.apache.helix.model.ParticipantHistory;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.util.HelixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseControllerDataProvider
implements ControlContextProvider {
    private static final Logger logger = LoggerFactory.getLogger(BaseControllerDataProvider.class);
    private static final List<HelixConstants.ChangeType> _noFullRefreshProperty = Arrays.asList(HelixConstants.ChangeType.EXTERNAL_VIEW, HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW);
    private String _clusterName = "UNKNOWN_CLUSTER";
    private String _pipelineName = "UNKNOWN_PIPELINE";
    private String _clusterEventId = "NO_ID";
    private ClusterConfig _clusterConfig;
    private boolean _updateInstanceOfflineTime = true;
    private MaintenanceSignal _maintenanceSignal;
    private PauseSignal _pauseSignal;
    private boolean _isMaintenanceModeEnabled;
    private boolean _hasMaintenanceSignalChanged;
    private ExecutorService _asyncTasksThreadPool;
    protected Map<HelixConstants.ChangeType, AtomicBoolean> _propertyDataChangedMap;
    private final PropertyCache<ResourceConfig> _resourceConfigCache;
    private final PropertyCache<InstanceConfig> _instanceConfigCache;
    private final PropertyCache<LiveInstance> _liveInstanceCache;
    private final PropertyCache<IdealState> _idealStateCache;
    private final PropertyCache<ClusterConstraints> _clusterConstraintsCache;
    private final PropertyCache<StateModelDefinition> _stateModelDefinitionCache;
    private CurrentStateCache _currentStateCache;
    protected TaskCurrentStateCache _taskCurrentStateCache;
    private InstanceMessagesCache _instanceMessagesCache;
    private Map<String, Long> _instanceOfflineTimeMap;
    private Map<String, Map<String, String>> _idealStateRuleMap;
    private Map<String, Map<String, Set<String>>> _disabledInstanceForPartitionMap = new HashMap<String, Map<String, Set<String>>>();
    private Set<String> _disabledInstanceSet = new HashSet<String>();
    private final Map<String, MonitoredAbnormalResolver> _abnormalStateResolverMap = new HashMap<String, MonitoredAbnormalResolver>();
    private Set<String> _timedOutInstanceDuringMaintenance = new HashSet<String>();
    private Map<String, LiveInstance> _liveInstanceExcludeTimedOutForMaintenance = new HashMap<String, LiveInstance>();

    public BaseControllerDataProvider() {
        this("UNKNOWN_CLUSTER", "UNKNOWN_PIPELINE");
    }

    public BaseControllerDataProvider(String clusterName, String pipelineName) {
        this._clusterName = clusterName;
        this._pipelineName = pipelineName;
        this._propertyDataChangedMap = new ConcurrentHashMap<HelixConstants.ChangeType, AtomicBoolean>();
        for (HelixConstants.ChangeType type : HelixConstants.ChangeType.values()) {
            this._propertyDataChangedMap.put(type, new AtomicBoolean(true));
        }
        this._resourceConfigCache = new PropertyCache<ResourceConfig>(this, "ResourceConfig", new PropertyCache.PropertyCacheKeyFuncs<ResourceConfig>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().resourceConfigs();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().resourceConfig(objName);
            }

            @Override
            public String getObjName(ResourceConfig obj) {
                return obj.getResourceName();
            }
        }, true);
        this._liveInstanceCache = new PropertyCache<LiveInstance>(this, "LiveInstance", new PropertyCache.PropertyCacheKeyFuncs<LiveInstance>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().liveInstances();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().liveInstance(objName);
            }

            @Override
            public String getObjName(LiveInstance obj) {
                return obj.getInstanceName();
            }
        }, true);
        this._instanceConfigCache = new PropertyCache<InstanceConfig>(this, "InstanceConfig", new PropertyCache.PropertyCacheKeyFuncs<InstanceConfig>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().instanceConfigs();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().instanceConfig(objName);
            }

            @Override
            public String getObjName(InstanceConfig obj) {
                return obj.getInstanceName();
            }
        }, true);
        this._idealStateCache = new PropertyCache<IdealState>(this, "IdealState", new PropertyCache.PropertyCacheKeyFuncs<IdealState>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().idealStates();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().idealStates(objName);
            }

            @Override
            public String getObjName(IdealState obj) {
                return obj.getResourceName();
            }
        }, true);
        this._clusterConstraintsCache = new PropertyCache<ClusterConstraints>(this, "ClusterConstraint", new PropertyCache.PropertyCacheKeyFuncs<ClusterConstraints>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().constraints();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().constraint(objName);
            }

            @Override
            public String getObjName(ClusterConstraints obj) {
                return obj.getId();
            }
        }, false);
        this._stateModelDefinitionCache = new PropertyCache<StateModelDefinition>(this, "StateModelDefinition", new PropertyCache.PropertyCacheKeyFuncs<StateModelDefinition>(){

            @Override
            public PropertyKey getRootKey(HelixDataAccessor accessor) {
                return accessor.keyBuilder().stateModelDefs();
            }

            @Override
            public PropertyKey getObjPropertyKey(HelixDataAccessor accessor, String objName) {
                return accessor.keyBuilder().stateModelDef(objName);
            }

            @Override
            public String getObjName(StateModelDefinition obj) {
                return obj.getId();
            }
        }, false);
        this._currentStateCache = new CurrentStateCache(this);
        this._taskCurrentStateCache = new TaskCurrentStateCache(this);
        this._instanceMessagesCache = new InstanceMessagesCache(this._clusterName);
    }

    private void refreshClusterConfig(HelixDataAccessor accessor, Set<HelixConstants.ChangeType> refreshedType) {
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CLUSTER_CONFIG).getAndSet(false)) {
            this._clusterConfig = (ClusterConfig)accessor.getProperty(accessor.keyBuilder().clusterConfig());
            refreshedType.add(HelixConstants.ChangeType.CLUSTER_CONFIG);
            this.refreshAbnormalStateResolverMap(this._clusterConfig);
        } else {
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("No ClusterConfig change for cluster %s, pipeline %s", this._clusterName, this.getPipelineName()));
        }
    }

    private void refreshIdealState(HelixDataAccessor accessor, Set<HelixConstants.ChangeType> refreshedType) {
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.IDEAL_STATE).getAndSet(false)) {
            this._idealStateCache.refresh(accessor);
            refreshedType.add(HelixConstants.ChangeType.IDEAL_STATE);
        } else {
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("No ideal state change for %s cluster, %s pipeline", this._clusterName, this.getPipelineName()));
        }
    }

    private void refreshLiveInstances(HelixDataAccessor accessor, Set<HelixConstants.ChangeType> refreshedType) {
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.LIVE_INSTANCE).getAndSet(false)) {
            this._liveInstanceCache.refresh(accessor);
            this._updateInstanceOfflineTime = true;
            refreshedType.add(HelixConstants.ChangeType.LIVE_INSTANCE);
        } else {
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("No live instance change for %s cluster, %s pipeline", this._clusterName, this.getPipelineName()));
        }
    }

    private void refreshInstanceConfigs(HelixDataAccessor accessor, Set<HelixConstants.ChangeType> refreshedType) {
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.INSTANCE_CONFIG).getAndSet(false)) {
            this._instanceConfigCache.refresh(accessor);
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("Reloaded InstanceConfig for cluster %s, %s pipeline. Keys: %s", this._clusterName, this.getPipelineName(), this._instanceConfigCache.getPropertyMap().keySet()));
            refreshedType.add(HelixConstants.ChangeType.INSTANCE_CONFIG);
        } else {
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("No instance config change for %s cluster, %s pipeline", this._clusterName, this.getPipelineName()));
        }
    }

    private void refreshResourceConfig(HelixDataAccessor accessor, Set<HelixConstants.ChangeType> refreshedType) {
        if (this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.RESOURCE_CONFIG).getAndSet(false)) {
            this._resourceConfigCache.refresh(accessor);
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("Reloaded ResourceConfig for cluster %s, %s pipeline. Cnt: %s", this._clusterName, this.getPipelineName(), this._resourceConfigCache.getPropertyMap().keySet().size()));
            refreshedType.add(HelixConstants.ChangeType.RESOURCE_CONFIG);
        } else {
            LogUtil.logInfo(logger, this.getClusterEventId(), String.format("No resource config change for %s cluster, %s pipeline", this._clusterName, this.getPipelineName()));
        }
    }

    private void refreshManagementSignals(HelixDataAccessor accessor) {
        this._maintenanceSignal = (MaintenanceSignal)accessor.getProperty(accessor.keyBuilder().maintenance());
        this._pauseSignal = (PauseSignal)accessor.getProperty(accessor.keyBuilder().pause());
        this._isMaintenanceModeEnabled = this._maintenanceSignal != null;
        this._hasMaintenanceSignalChanged = false;
        if (!this._isMaintenanceModeEnabled) {
            this._timedOutInstanceDuringMaintenance.clear();
            this._liveInstanceExcludeTimedOutForMaintenance.clear();
        }
    }

    private void timeoutNodesDuringMaintenance(HelixDataAccessor accessor, ClusterConfig clusterConfig, boolean isMaintenanceModeEnabled) {
        long timeOutWindow = -1L;
        if (clusterConfig != null) {
            timeOutWindow = clusterConfig.getOfflineNodeTimeOutForMaintenanceMode();
        }
        if (timeOutWindow >= 0L && isMaintenanceModeEnabled) {
            for (String instance : this._liveInstanceCache.getPropertyMap().keySet()) {
                if (this._timedOutInstanceDuringMaintenance.contains(instance) || this._liveInstanceExcludeTimedOutForMaintenance.containsKey(instance) || !this.isInstanceTimedOutDuringMaintenance(accessor, instance, timeOutWindow)) continue;
                this._timedOutInstanceDuringMaintenance.add(instance);
            }
        }
        if (isMaintenanceModeEnabled) {
            this._liveInstanceExcludeTimedOutForMaintenance = this._liveInstanceCache.getPropertyMap().entrySet().stream().filter(e -> !this._timedOutInstanceDuringMaintenance.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    private void updateIdealRuleMap(ClusterConfig clusterConfig) {
        if (clusterConfig != null) {
            this._idealStateRuleMap = clusterConfig.getIdealStateRules();
        } else {
            this._idealStateRuleMap = new HashMap<String, Map<String, String>>();
            LogUtil.logWarn(logger, this.getClusterEventId(), String.format("Cluster config is null for %s cluster, %s pipeline", this.getClusterName(), this.getPipelineName()));
        }
    }

    public synchronized void refresh(HelixDataAccessor accessor) {
        this.doRefresh(accessor);
    }

    protected synchronized Set<HelixConstants.ChangeType> doRefresh(HelixDataAccessor accessor) {
        HashSet<HelixConstants.ChangeType> refreshedTypes = new HashSet<HelixConstants.ChangeType>();
        this.refreshClusterConfig(accessor, refreshedTypes);
        this.refreshIdealState(accessor, refreshedTypes);
        this.refreshLiveInstances(accessor, refreshedTypes);
        this.refreshInstanceConfigs(accessor, refreshedTypes);
        this.refreshResourceConfig(accessor, refreshedTypes);
        this._stateModelDefinitionCache.refresh(accessor);
        this._clusterConstraintsCache.refresh(accessor);
        this.refreshManagementSignals(accessor);
        this.timeoutNodesDuringMaintenance(accessor, this._clusterConfig, this._isMaintenanceModeEnabled);
        this.updateOfflineInstanceHistory(accessor);
        this._instanceMessagesCache.refresh(accessor, this._liveInstanceCache.getPropertyMap());
        this._currentStateCache.refresh(accessor, this._liveInstanceCache.getPropertyMap());
        this._instanceMessagesCache.updateRelayMessages(this._liveInstanceCache.getPropertyMap(), this._currentStateCache.getParticipantStatesMap());
        this.updateIdealRuleMap(this.getClusterConfig());
        this.updateDisabledInstances(this.getInstanceConfigMap().values(), this.getClusterConfig());
        return refreshedTypes;
    }

    protected void dumpDebugInfo() {
        if (logger.isDebugEnabled()) {
            LogUtil.logDebug(logger, this.getClusterEventId(), "# of StateModelDefinition read from zk: " + this.getStateModelDefMap().size());
            LogUtil.logDebug(logger, this.getClusterEventId(), "# of ConstraintMap read from zk: " + this.getConstraintMap().size());
            LogUtil.logDebug(logger, this.getClusterEventId(), "LiveInstances: " + this.getLiveInstances().keySet());
            for (LiveInstance instance : this.getLiveInstances().values()) {
                LogUtil.logDebug(logger, this.getClusterEventId(), "live instance: " + instance.getInstanceName() + " " + instance.getEphemeralOwner());
            }
            LogUtil.logDebug(logger, this.getClusterEventId(), "IdealStates: " + this.getIdealStates().keySet());
            LogUtil.logDebug(logger, this.getClusterEventId(), "ResourceConfigs: " + this.getResourceConfigMap().keySet());
            LogUtil.logDebug(logger, this.getClusterEventId(), "InstanceConfigs: " + this.getInstanceConfigMap().keySet());
            LogUtil.logDebug(logger, this.getClusterEventId(), "ClusterConfigs: " + this.getClusterConfig());
        }
    }

    public ClusterConfig getClusterConfig() {
        return this._clusterConfig;
    }

    public void setClusterConfig(ClusterConfig clusterConfig) {
        this._clusterConfig = clusterConfig;
        this.refreshAbnormalStateResolverMap(this._clusterConfig);
        this.updateIdealRuleMap(this._clusterConfig);
        this.updateDisabledInstances(this.getInstanceConfigMap().values(), this._clusterConfig);
    }

    @Override
    public String getClusterName() {
        return this._clusterConfig == null ? this._clusterName : this._clusterConfig.getClusterName();
    }

    @Override
    public String getPipelineName() {
        return this._pipelineName;
    }

    @Override
    public String getClusterEventId() {
        return this._clusterEventId;
    }

    @Override
    public void setClusterEventId(String clusterEventId) {
        this._clusterEventId = clusterEventId;
    }

    public Map<String, Long> getInstanceOfflineTimeMap() {
        return this._instanceOfflineTimeMap;
    }

    public Map<String, IdealState> getIdealStates() {
        return this._idealStateCache.getPropertyMap();
    }

    public synchronized void setIdealStates(List<IdealState> idealStates) {
        this._idealStateCache.setPropertyMap(HelixProperty.convertListToMap(idealStates));
    }

    public Map<String, Map<String, String>> getIdealStateRules() {
        return this._idealStateRuleMap;
    }

    public Map<String, LiveInstance> getLiveInstances() {
        if (this.isMaintenanceModeEnabled()) {
            return this._liveInstanceExcludeTimedOutForMaintenance;
        }
        return this._liveInstanceCache.getPropertyMap();
    }

    public Set<String> getAllInstances() {
        return this._instanceConfigCache.getPropertyMap().keySet();
    }

    public Set<String> getEnabledLiveInstances() {
        HashSet<String> enabledLiveInstances = new HashSet<String>(this.getLiveInstances().keySet());
        enabledLiveInstances.removeAll(this.getDisabledInstances());
        return enabledLiveInstances;
    }

    public Set<String> getEnabledInstances() {
        HashSet<String> enabledNodes = new HashSet<String>(this.getAllInstances());
        enabledNodes.removeAll(this.getDisabledInstances());
        return enabledNodes;
    }

    public Set<String> getEnabledLiveInstancesWithTag(String instanceTag) {
        HashSet<String> enabledLiveInstancesWithTag = new HashSet<String>(this.getLiveInstances().keySet());
        Set<String> instancesWithTag = this.getInstancesWithTag(instanceTag);
        enabledLiveInstancesWithTag.retainAll(instancesWithTag);
        enabledLiveInstancesWithTag.removeAll(this.getDisabledInstances());
        return enabledLiveInstancesWithTag;
    }

    public Set<String> getInstancesWithTag(String instanceTag) {
        HashSet<String> taggedInstances = new HashSet<String>();
        for (String instance : this._instanceConfigCache.getPropertyMap().keySet()) {
            InstanceConfig instanceConfig = this._instanceConfigCache.getPropertyByName(instance);
            if (instanceConfig == null || !instanceConfig.containsTag(instanceTag)) continue;
            taggedInstances.add(instance);
        }
        return taggedInstances;
    }

    public Set<String> getDisabledInstancesForPartition(String resource, String partition) {
        HashSet<String> disabledInstancesForPartition = new HashSet<String>(this._disabledInstanceSet);
        if (this._disabledInstanceForPartitionMap.containsKey(resource) && this._disabledInstanceForPartitionMap.get(resource).containsKey(partition)) {
            disabledInstancesForPartition.addAll((Collection<String>)this._disabledInstanceForPartitionMap.get(resource).get(partition));
        }
        return disabledInstancesForPartition;
    }

    public Set<String> getDisabledInstances() {
        return Collections.unmodifiableSet(this._disabledInstanceSet);
    }

    public synchronized void setLiveInstances(List<LiveInstance> liveInstances) {
        this._liveInstanceCache.setPropertyMap(HelixProperty.convertListToMap(liveInstances));
        this._updateInstanceOfflineTime = true;
    }

    public Map<String, CurrentState> getCurrentState(String instanceName, String clientSessionId) {
        return this.getCurrentState(instanceName, clientSessionId, false);
    }

    public Map<String, CurrentState> getCurrentState(String instanceName, String clientSessionId, boolean isTaskPipeline) {
        Map regularCurrentStates = this._currentStateCache.getParticipantState(instanceName, clientSessionId);
        if (isTaskPipeline) {
            HashMap mergedCurrentStates = new HashMap();
            mergedCurrentStates.putAll(this._taskCurrentStateCache.getParticipantState(instanceName, clientSessionId));
            mergedCurrentStates.putAll(regularCurrentStates);
            return Collections.unmodifiableMap(mergedCurrentStates);
        }
        return regularCurrentStates.entrySet().stream().filter(entry -> !"Task".equals(((CurrentState)entry.getValue()).getStateModelDefRef())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Message> getMessages(String instanceName) {
        return this._instanceMessagesCache.getMessages(instanceName);
    }

    public Map<String, Collection<Message>> getAllInstancesMessages() {
        return this.getAllInstances().stream().collect(Collectors.toMap(instance -> instance, instance -> this.getMessages((String)instance).values()));
    }

    @VisibleForTesting
    public Map<String, Map<String, Message>> getStaleMessages() {
        return this._instanceMessagesCache.getStaleMessageCache();
    }

    public Set<Message> getStaleMessagesByInstance(String instanceName) {
        return this._instanceMessagesCache.getStaleMessagesByInstance(instanceName);
    }

    public void addStaleMessage(String instanceName, Message staleMessage) {
        this._instanceMessagesCache.addStaleMessage(instanceName, staleMessage);
    }

    public Map<String, Message> getRelayMessages(String instanceName) {
        return this._instanceMessagesCache.getRelayMessages(instanceName);
    }

    public void cacheMessages(Collection<Message> messages) {
        this._instanceMessagesCache.cacheMessages(messages);
    }

    public StateModelDefinition getStateModelDef(String stateModelDefRef) {
        return this._stateModelDefinitionCache.getPropertyByName(stateModelDefRef);
    }

    public Map<String, StateModelDefinition> getStateModelDefMap() {
        return this._stateModelDefinitionCache.getPropertyMap();
    }

    public IdealState getIdealState(String resourceName) {
        return this._idealStateCache.getPropertyByName(resourceName);
    }

    public Map<String, InstanceConfig> getInstanceConfigMap() {
        return this._instanceConfigCache.getPropertyMap();
    }

    public void setInstanceConfigMap(Map<String, InstanceConfig> instanceConfigMap) {
        this._instanceConfigCache.setPropertyMap(instanceConfigMap);
        this.updateDisabledInstances(instanceConfigMap.values(), this.getClusterConfig());
    }

    public Map<String, ResourceConfig> getResourceConfigMap() {
        return this._resourceConfigCache.getPropertyMap();
    }

    public void setResourceConfigMap(Map<String, ResourceConfig> resourceConfigMap) {
        this._resourceConfigCache.setPropertyMap(resourceConfigMap);
    }

    public ResourceConfig getResourceConfig(String resource) {
        return this._resourceConfigCache.getPropertyByName(resource);
    }

    public ClusterConstraints getConstraint(ClusterConstraints.ConstraintType type) {
        return this._clusterConstraintsCache.getPropertyByName(type.name());
    }

    public Map<String, ClusterConstraints> getConstraintMap() {
        return this._clusterConstraintsCache.getPropertyMap();
    }

    public void notifyDataChange(HelixConstants.ChangeType changeType) {
        this._propertyDataChangedMap.get((Object)changeType).set(true);
    }

    public void notifyDataChange(HelixConstants.ChangeType changeType, String pathChanged) {
        this.notifyDataChange(changeType);
    }

    private void updateOfflineInstanceHistory(HelixDataAccessor accessor) {
        if (!this._updateInstanceOfflineTime) {
            return;
        }
        ArrayList<String> offlineNodes = new ArrayList<String>(this._instanceConfigCache.getPropertyMap().keySet());
        offlineNodes.removeAll(this._liveInstanceCache.getPropertyMap().keySet());
        this._instanceOfflineTimeMap = new HashMap<String, Long>();
        for (String instance : offlineNodes) {
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            PropertyKey propertyKey = keyBuilder.participantHistory(instance);
            ParticipantHistory history = (ParticipantHistory)accessor.getProperty(propertyKey);
            if (history == null) {
                history = new ParticipantHistory(instance);
            }
            if (history.getLastOfflineTime() == ParticipantHistory.ONLINE) {
                history.reportOffline();
                if (!accessor.setProperty(propertyKey, history)) {
                    LogUtil.logError(logger, this.getClusterEventId(), "Fails to persist participant online history back to ZK!");
                }
            }
            this._instanceOfflineTimeMap.put(instance, history.getLastOfflineTime());
        }
        this._updateInstanceOfflineTime = false;
    }

    private void updateDisabledInstances(Collection<InstanceConfig> instanceConfigs, ClusterConfig clusterConfig) {
        this._disabledInstanceForPartitionMap.clear();
        this._disabledInstanceSet.clear();
        for (InstanceConfig config : instanceConfigs) {
            Map<String, List<String>> disabledPartitionMap = config.getDisabledPartitionsMap();
            if (!config.getInstanceEnabled()) {
                this._disabledInstanceSet.add(config.getInstanceName());
            }
            for (String resource : disabledPartitionMap.keySet()) {
                if (!this._disabledInstanceForPartitionMap.containsKey(resource)) {
                    this._disabledInstanceForPartitionMap.put(resource, new HashMap());
                }
                for (String partition : disabledPartitionMap.get(resource)) {
                    if (!this._disabledInstanceForPartitionMap.get(resource).containsKey(partition)) {
                        this._disabledInstanceForPartitionMap.get(resource).put(partition, new HashSet());
                    }
                    this._disabledInstanceForPartitionMap.get(resource).get(partition).add(config.getInstanceName());
                }
            }
        }
        if (clusterConfig != null && clusterConfig.getDisabledInstances() != null) {
            this._disabledInstanceSet.addAll(clusterConfig.getDisabledInstances().keySet());
        }
    }

    private boolean isInstanceTimedOutDuringMaintenance(HelixDataAccessor accessor, String instance, long timeOutWindow) {
        long onlineWindowRight;
        ParticipantHistory history = (ParticipantHistory)accessor.getProperty(accessor.keyBuilder().participantHistory(instance));
        List<Long> onlineTimestamps = history.getOnlineTimestampsAsMilliseconds();
        List<Long> offlineTimestamps = history.getOfflineTimestampsAsMilliseconds();
        onlineTimestamps.add(System.currentTimeMillis());
        int offlineTimestampIndex = offlineTimestamps.size() - 1;
        for (int onlineTimestampIndex = onlineTimestamps.size() - 1; onlineTimestampIndex >= 0 && offlineTimestampIndex >= 0 && (onlineWindowRight = onlineTimestamps.get(onlineTimestampIndex).longValue()) > this._maintenanceSignal.getTimestamp(); --onlineTimestampIndex) {
            long onlineWindowLeft = 0L;
            if (onlineTimestampIndex > 0) {
                onlineWindowLeft = onlineTimestamps.get(onlineTimestampIndex - 1);
            }
            if (offlineTimestamps.get(offlineTimestampIndex) <= onlineWindowLeft) continue;
            while (offlineTimestampIndex >= 0 && offlineTimestamps.get(offlineTimestampIndex) > onlineWindowLeft) {
                --offlineTimestampIndex;
            }
            long offlineTimeStamp = offlineTimestamps.get(offlineTimestampIndex + 1);
            if (onlineWindowRight - offlineTimeStamp <= timeOutWindow) continue;
            LogUtil.logWarn(logger, this.getClusterEventId(), String.format("During maintenance mode, instance %s is timed-out due to its offline time. Online time: %s, Offline time: %s, Timeout window: %s", instance, onlineWindowRight, offlineTimeStamp, timeOutWindow));
            return true;
        }
        return false;
    }

    public void requireFullRefresh() {
        for (HelixConstants.ChangeType type : HelixConstants.ChangeType.values()) {
            if (_noFullRefreshProperty.contains((Object)type)) continue;
            this._propertyDataChangedMap.get((Object)type).set(true);
        }
    }

    public ExecutorService getAsyncTasksThreadPool() {
        return this._asyncTasksThreadPool;
    }

    public void setAsyncTasksThreadPool(ExecutorService asyncTasksThreadPool) {
        this._asyncTasksThreadPool = asyncTasksThreadPool;
    }

    public MonitoredAbnormalResolver getAbnormalStateResolver(String stateModel) {
        return this._abnormalStateResolverMap.getOrDefault(stateModel, MonitoredAbnormalResolver.DUMMY_STATE_RESOLVER);
    }

    private void refreshAbnormalStateResolverMap(ClusterConfig clusterConfig) {
        if (clusterConfig == null) {
            logger.debug("Skip refreshing abnormal state resolvers because the ClusterConfig is missing");
            return;
        }
        Map<String, String> resolverMap = clusterConfig.getAbnormalStateResolverMap();
        logger.info("Start loading the abnormal state resolvers with configuration {}", resolverMap);
        HashMap<String, MonitoredAbnormalResolver> removingResolverWraps = new HashMap<String, MonitoredAbnormalResolver>(this._abnormalStateResolverMap);
        removingResolverWraps.keySet().removeAll(resolverMap.keySet());
        for (MonitoredAbnormalResolver monitoredAbnormalResolver : removingResolverWraps.values()) {
            monitoredAbnormalResolver.close();
        }
        this._abnormalStateResolverMap.keySet().retainAll(resolverMap.keySet());
        for (String stateModel : resolverMap.keySet()) {
            MonitoredAbnormalResolver currentMonitoredResolver;
            String resolverClassName = resolverMap.get(stateModel);
            if (resolverClassName == null || resolverClassName.isEmpty() || (currentMonitoredResolver = this._abnormalStateResolverMap.get(stateModel)) != null && resolverClassName.equals(currentMonitoredResolver.getResolverClass().getName())) continue;
            if (currentMonitoredResolver != null) {
                currentMonitoredResolver.close();
            }
            try {
                AbnormalStateResolver newResolver = (AbnormalStateResolver)AbnormalStateResolver.class.cast(HelixUtil.loadClass(this.getClass(), resolverClassName).newInstance());
                this._abnormalStateResolverMap.put(stateModel, new MonitoredAbnormalResolver(newResolver, this._clusterName, stateModel));
            }
            catch (Exception e) {
                throw new HelixException(String.format("Failed to instantiate the abnormal state resolver %s for state model %s", resolverClassName, stateModel));
            }
        }
        logger.info("Finish loading the abnormal state resolvers {}", this._abnormalStateResolverMap);
    }

    public boolean isMaintenanceModeEnabled() {
        return this._isMaintenanceModeEnabled;
    }

    public void enableMaintenanceMode() {
        this._isMaintenanceModeEnabled = true;
    }

    public boolean hasMaintenanceSignalChanged() {
        return this._hasMaintenanceSignalChanged;
    }

    public void setMaintenanceSignalChanged() {
        this._hasMaintenanceSignalChanged = true;
    }

    public MaintenanceSignal getMaintenanceSignal() {
        return this._maintenanceSignal;
    }

    public PauseSignal getPauseSignal() {
        return this._pauseSignal;
    }

    protected StringBuilder genCacheContentStringBuilder() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("liveInstaceMap: %s", this._liveInstanceCache.getPropertyMap())).append("\n");
        sb.append(String.format("idealStateMap: %s", this._idealStateCache.getPropertyMap())).append("\n");
        sb.append(String.format("stateModelDefMap: %s", this._stateModelDefinitionCache.getPropertyMap())).append("\n");
        sb.append(String.format("instanceConfigMap: %s", this._instanceConfigCache.getPropertyMap())).append("\n");
        sb.append(String.format("resourceConfigMap: %s", this._resourceConfigCache.getPropertyMap())).append("\n");
        sb.append(String.format("messageCache: %s", this._instanceMessagesCache)).append("\n");
        sb.append(String.format("currentStateCache: %s", this._currentStateCache)).append("\n");
        sb.append(String.format("clusterConfig: %s", this._clusterConfig)).append("\n");
        return sb;
    }

    protected PropertyCache<LiveInstance> getLiveInstanceCache() {
        return this._liveInstanceCache;
    }

    public String toString() {
        return this.genCacheContentStringBuilder().toString();
    }
}

