/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.event.helix;

import java.util.List;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.util.InstanceValidationUtil;

public class DefaultCloudEventCallbackImpl {
    private final String _reason = "Cloud event callback %s in class %s triggered in listener HelixManager %s, at time %s .";
    protected final String _className = this.getClass().getSimpleName();

    public void disableInstance(HelixManager manager, Object eventInfo) {
        if (InstanceValidationUtil.isEnabled(manager.getHelixDataAccessor(), manager.getInstanceName())) {
            manager.getClusterManagmentTool().enableInstance(manager.getClusterName(), manager.getInstanceName(), false, InstanceConstants.InstanceDisabledType.CLOUD_EVENT, String.format("Cloud event callback %s in class %s triggered in listener HelixManager %s, at time %s .", "disableInstance", this._className, manager, System.currentTimeMillis()));
        }
    }

    public void enableInstance(HelixManager manager, Object eventInfo) {
        String instanceName = manager.getInstanceName();
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        if (InstanceValidationUtil.getInstanceHelixDisabledType(accessor, instanceName).equals(InstanceConstants.InstanceDisabledType.CLOUD_EVENT.name())) {
            manager.getClusterManagmentTool().enableInstance(manager.getClusterName(), instanceName, true);
        }
    }

    public void enterMaintenanceMode(HelixManager manager, Object eventInfo) {
        if (!manager.getClusterManagmentTool().isInMaintenanceMode(manager.getClusterName())) {
            manager.getClusterManagmentTool().manuallyEnableMaintenanceMode(manager.getClusterName(), true, String.format("Cloud event callback %s in class %s triggered in listener HelixManager %s, at time %s .", "enterMaintenanceMode", this._className, manager, System.currentTimeMillis()), null);
        }
    }

    public void exitMaintenanceMode(HelixManager manager, Object eventInfo) {
        List<String> instances = manager.getClusterManagmentTool().getInstancesInCluster(manager.getClusterName());
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        if (instances.stream().noneMatch(instance -> InstanceValidationUtil.getInstanceHelixDisabledType(accessor, instance).equals(InstanceConstants.InstanceDisabledType.CLOUD_EVENT.name()) && InstanceValidationUtil.isAlive(accessor, instance))) {
            manager.getClusterManagmentTool().manuallyEnableMaintenanceMode(manager.getClusterName(), false, String.format("Cloud event callback %s in class %s triggered in listener HelixManager %s, at time %s .", "exitMaintenanceMode", this._className, manager, System.currentTimeMillis()), null);
        }
    }
}

