/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.event.helix;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.helix.HelixManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventCallbackProperty {
    private static final Logger LOG = LoggerFactory.getLogger((String)CloudEventCallbackProperty.class.getName());
    private Set<HelixOperation> _enabledHelixOperation = new HashSet<HelixOperation>();
    private Map<UserDefinedCallbackType, BiConsumer<HelixManager, Object>> _userDefinedCallbackMap = new HashMap<UserDefinedCallbackType, BiConsumer<HelixManager, Object>>();
    private final Map<String, String> _userArgs;

    public CloudEventCallbackProperty(Map<String, String> userArgs) {
        this._userArgs = userArgs;
    }

    public void setHelixOperationEnabled(HelixOperation operation, boolean enabled) {
        if (enabled) {
            this._enabledHelixOperation.add(operation);
        } else {
            this._enabledHelixOperation.remove((Object)operation);
        }
    }

    public void registerUserDefinedCallback(UserDefinedCallbackType callbackType, BiConsumer<HelixManager, Object> callback) {
        LOG.info("Registering callback {} as {} type user defined callback...", callback, (Object)callbackType.name());
        this._userDefinedCallbackMap.put(callbackType, callback);
    }

    public void unregisterUserDefinedCallback(UserDefinedCallbackType callbackType) {
        LOG.info("Unregistering {} type user defined callback...", (Object)callbackType.name());
        this._userDefinedCallbackMap.remove((Object)callbackType);
    }

    public Map<String, String> getUserArgs() {
        return this._userArgs == null ? Collections.emptyMap() : Collections.unmodifiableMap(this._userArgs);
    }

    public Map<UserDefinedCallbackType, BiConsumer<HelixManager, Object>> getUserDefinedCallbackMap() {
        return this._userDefinedCallbackMap;
    }

    public Set<HelixOperation> getEnabledHelixOperation() {
        return this._enabledHelixOperation;
    }

    public static enum UserDefinedCallbackType {
        PRE_ON_PAUSE,
        POST_ON_PAUSE,
        PRE_ON_RESUME,
        POST_ON_RESUME;

    }

    public static enum HelixOperation {
        ENABLE_DISABLE_INSTANCE,
        MAINTENANCE_MODE;

    }

    public static class UserArgsInputKey {
        public static final String CALLBACK_IMPL_CLASS_NAME = "callbackImplClassName";
    }
}

