/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.service;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.RESTConfig;
import org.apache.helix.rest.client.CustomRestClient;
import org.apache.helix.rest.client.CustomRestClientFactory;
import org.apache.helix.rest.common.HelixDataAccessorWrapper;
import org.apache.helix.rest.server.json.instance.InstanceInfo;
import org.apache.helix.rest.server.json.instance.StoppableCheck;
import org.apache.helix.rest.server.service.InstanceService;
import org.apache.helix.util.InstanceValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceServiceImpl
implements InstanceService {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceServiceImpl.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ExecutorService POOL = Executors.newCachedThreadPool();
    private static final String CUSTOM_INSTANCE_CHECK_HTTP_REQUESTS_ERROR_TOTAL = MetricRegistry.name(InstanceService.class, (String[])new String[]{"custom_instance_check_http_requests_error_total"});
    private static final String CUSTOM_INSTANCE_CHECK_HTTP_REQUESTS_DURATION = MetricRegistry.name(InstanceService.class, (String[])new String[]{"custom_instance_check_http_requests_duration"});
    private final HelixDataAccessorWrapper _dataAccessor;
    private final ConfigAccessor _configAccessor;
    private final CustomRestClient _customRestClient;
    private final String _namespace;
    private final boolean _skipZKRead;
    private final boolean _continueOnFailures;

    @Deprecated
    public InstanceServiceImpl(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor) {
        this(dataAccessor, configAccessor, false);
    }

    @Deprecated
    public InstanceServiceImpl(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor, boolean skipZKRead) {
        this(dataAccessor, configAccessor, skipZKRead, "default");
    }

    public InstanceServiceImpl(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor, boolean skipZKRead, String namespace) {
        this(dataAccessor, configAccessor, CustomRestClientFactory.get(), skipZKRead, false, namespace);
    }

    public InstanceServiceImpl(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor, boolean skipZKRead, boolean continueOnFailures, String namespace) {
        this(dataAccessor, configAccessor, CustomRestClientFactory.get(), skipZKRead, continueOnFailures, namespace);
    }

    @VisibleForTesting
    InstanceServiceImpl(ZKHelixDataAccessor dataAccessor, ConfigAccessor configAccessor, CustomRestClient customRestClient, boolean skipZKRead, boolean continueOnFailures, String namespace) {
        this._dataAccessor = new HelixDataAccessorWrapper(dataAccessor, customRestClient, namespace);
        this._configAccessor = configAccessor;
        this._customRestClient = customRestClient;
        this._skipZKRead = skipZKRead;
        this._continueOnFailures = continueOnFailures;
        this._namespace = namespace;
    }

    @Override
    public InstanceInfo getInstanceInfo(String clusterId, String instanceName, List<InstanceService.HealthCheck> healthChecks) {
        InstanceInfo.Builder instanceInfoBuilder = new InstanceInfo.Builder(instanceName);
        InstanceConfig instanceConfig = (InstanceConfig)this._dataAccessor.getProperty(this._dataAccessor.keyBuilder().instanceConfig(instanceName));
        LiveInstance liveInstance = (LiveInstance)this._dataAccessor.getProperty(this._dataAccessor.keyBuilder().liveInstance(instanceName));
        if (instanceConfig != null) {
            instanceInfoBuilder.instanceConfig(instanceConfig.getRecord());
        } else {
            LOG.warn("Missing instance config for {}", (Object)instanceName);
        }
        if (liveInstance != null) {
            instanceInfoBuilder.liveInstance(liveInstance.getRecord());
            String sessionId = liveInstance.getEphemeralOwner();
            List<String> resourceNames = this._dataAccessor.getChildNames(this._dataAccessor.keyBuilder().currentStates(instanceName, sessionId));
            instanceInfoBuilder.resources(resourceNames);
            ArrayList<String> partitions = new ArrayList<String>();
            for (String resourceName : resourceNames) {
                CurrentState currentState = (CurrentState)this._dataAccessor.getProperty(this._dataAccessor.keyBuilder().currentState(instanceName, sessionId, resourceName));
                if (currentState != null && currentState.getPartitionStateMap() != null) {
                    partitions.addAll(currentState.getPartitionStateMap().keySet());
                    continue;
                }
                LOG.warn("Current state is either null or partitionStateMap is missing. InstanceName: {}, SessionId: {}, ResourceName: {}", new Object[]{instanceName, sessionId, resourceName});
            }
            instanceInfoBuilder.partitions(partitions);
        } else {
            LOG.warn("Missing live instance for {}", (Object)instanceName);
        }
        try {
            Map<String, Boolean> healthStatus = this.getInstanceHealthStatus(clusterId, instanceName, healthChecks);
            instanceInfoBuilder.healthStatus(healthStatus);
        }
        catch (HelixException ex) {
            LOG.error("Exception while getting health status. Cluster: {}, Instance: {}, reporting health status as unHealth", new Object[]{clusterId, instanceName, ex});
            instanceInfoBuilder.healthStatus(false);
        }
        return instanceInfoBuilder.build();
    }

    @Override
    public StoppableCheck getInstanceStoppableCheck(String clusterId, String instanceName, String jsonContent) throws IOException {
        return this.batchGetInstancesStoppableChecks(clusterId, (List<String>)ImmutableList.of((Object)instanceName), jsonContent).get(instanceName);
    }

    @Override
    public Map<String, StoppableCheck> batchGetInstancesStoppableChecks(String clusterId, List<String> instances, String jsonContent) throws IOException {
        HashMap<String, StoppableCheck> finalStoppableChecks = new HashMap<String, StoppableCheck>();
        Map<String, Future<StoppableCheck>> helixInstanceChecks = instances.stream().collect(Collectors.toMap(Function.identity(), instance -> POOL.submit(() -> this.performHelixOwnInstanceCheck(clusterId, (String)instance))));
        List<String> instancesForCustomInstanceLevelChecks = this.filterInstancesForNextCheck(helixInstanceChecks, finalStoppableChecks);
        if (instancesForCustomInstanceLevelChecks.isEmpty()) {
            return finalStoppableChecks;
        }
        RESTConfig restConfig = this._configAccessor.getRESTConfig(clusterId);
        if (restConfig == null) {
            String errorMessage = String.format("The cluster %s hasn't enabled client side health checks yet, thus the stoppable check result is inaccurate", clusterId);
            LOG.error(errorMessage);
            throw new HelixException(errorMessage);
        }
        Map<String, String> customPayLoads = this.getCustomPayLoads(jsonContent);
        Map<String, Future<StoppableCheck>> customInstanceLevelChecks = instancesForCustomInstanceLevelChecks.stream().collect(Collectors.toMap(Function.identity(), instance -> POOL.submit(() -> this.performCustomInstanceCheck(clusterId, (String)instance, restConfig.getBaseUrl(instance), customPayLoads))));
        List<String> instancesForCustomPartitionLevelChecks = this.filterInstancesForNextCheck(customInstanceLevelChecks, finalStoppableChecks);
        if (!instancesForCustomPartitionLevelChecks.isEmpty()) {
            Map<String, StoppableCheck> instancePartitionLevelChecks = this.performPartitionsCheck(instancesForCustomPartitionLevelChecks, restConfig, customPayLoads);
            for (Map.Entry<String, StoppableCheck> instancePartitionStoppableCheckEntry : instancePartitionLevelChecks.entrySet()) {
                String instance2 = instancePartitionStoppableCheckEntry.getKey();
                StoppableCheck stoppableCheck = instancePartitionStoppableCheckEntry.getValue();
                this.addStoppableCheck(finalStoppableChecks, instance2, stoppableCheck);
            }
        }
        return finalStoppableChecks;
    }

    private void addStoppableCheck(Map<String, StoppableCheck> stoppableChecks, String instance, StoppableCheck stoppableCheck) {
        if (!stoppableChecks.containsKey(instance)) {
            stoppableChecks.put(instance, stoppableCheck);
        } else {
            stoppableChecks.get(instance).add(stoppableCheck);
        }
    }

    private List<String> filterInstancesForNextCheck(Map<String, Future<StoppableCheck>> futureStoppableCheckByInstance, Map<String, StoppableCheck> finalStoppableCheckByInstance) {
        ArrayList<String> instancesForNextCheck = new ArrayList<String>();
        for (Map.Entry<String, Future<StoppableCheck>> entry : futureStoppableCheckByInstance.entrySet()) {
            String instance = entry.getKey();
            try {
                StoppableCheck stoppableCheck = entry.getValue().get();
                if (!stoppableCheck.isStoppable()) {
                    this.addStoppableCheck(finalStoppableCheckByInstance, instance, stoppableCheck);
                }
                if (!stoppableCheck.isStoppable() && !this._continueOnFailures) continue;
                instancesForNextCheck.add(instance);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Failed to get StoppableChecks in parallel. Instance: {}", (Object)instance, (Object)e);
            }
        }
        return instancesForNextCheck;
    }

    private StoppableCheck performHelixOwnInstanceCheck(String clusterId, String instanceName) {
        LOG.info("Perform helix own custom health checks for {}/{}", (Object)clusterId, (Object)instanceName);
        Map<String, Boolean> helixStoppableCheck = this.getInstanceHealthStatus(clusterId, instanceName, InstanceService.HealthCheck.STOPPABLE_CHECK_LIST);
        return new StoppableCheck(helixStoppableCheck, StoppableCheck.Category.HELIX_OWN_CHECK);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StoppableCheck performCustomInstanceCheck(String clusterId, String instanceName, String baseUrl, Map<String, String> customPayLoads) {
        LOG.info("Perform instance level client side health checks for {}/{}", (Object)clusterId, (Object)instanceName);
        MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)this._namespace);
        try (Timer.Context timer = metrics.timer(CUSTOM_INSTANCE_CHECK_HTTP_REQUESTS_DURATION).time();){
            Map<String, Boolean> instanceStoppableCheck = this._customRestClient.getInstanceStoppableCheck(baseUrl, customPayLoads);
            StoppableCheck stoppableCheck = new StoppableCheck(instanceStoppableCheck, StoppableCheck.Category.CUSTOM_INSTANCE_CHECK);
            return stoppableCheck;
        }
        catch (IOException ex) {
            LOG.error("Custom client side instance level health check for {}/{} failed.", new Object[]{clusterId, instanceName, ex});
            metrics.counter(CUSTOM_INSTANCE_CHECK_HTTP_REQUESTS_ERROR_TOTAL).inc();
            return new StoppableCheck(false, Collections.singletonList(instanceName), StoppableCheck.Category.CUSTOM_INSTANCE_CHECK);
        }
    }

    private Map<String, StoppableCheck> performPartitionsCheck(List<String> instances, RESTConfig restConfig, Map<String, String> customPayLoads) {
        Map<String, Map<String, Boolean>> allPartitionsHealthOnLiveInstance = this._dataAccessor.getAllPartitionsHealthOnLiveInstance(restConfig, customPayLoads, this._skipZKRead);
        List externalViews = this._dataAccessor.getChildValues(this._dataAccessor.keyBuilder().externalViews(), true);
        HashMap<String, StoppableCheck> instanceStoppableChecks = new HashMap<String, StoppableCheck>();
        for (String instanceName : instances) {
            Map unHealthyPartitions = InstanceValidationUtil.perPartitionHealthCheck((List)externalViews, allPartitionsHealthOnLiveInstance, (String)instanceName, (HelixDataAccessor)this._dataAccessor);
            ArrayList<String> unHealthyPartitionsList = new ArrayList<String>();
            for (String partitionName : unHealthyPartitions.keySet()) {
                for (String reason : (List)unHealthyPartitions.get(partitionName)) {
                    unHealthyPartitionsList.add(reason.toUpperCase() + ":" + partitionName);
                }
            }
            StoppableCheck stoppableCheck = new StoppableCheck(unHealthyPartitionsList.isEmpty(), unHealthyPartitionsList, StoppableCheck.Category.CUSTOM_PARTITION_CHECK);
            instanceStoppableChecks.put(instanceName, stoppableCheck);
        }
        return instanceStoppableChecks;
    }

    private Map<String, String> getCustomPayLoads(String jsonContent) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        JsonNode jsonNode = OBJECT_MAPPER.readTree(jsonContent);
        jsonNode.fields().forEachRemaining(kv -> result.put((String)kv.getKey(), ((JsonNode)kv.getValue()).asText()));
        return result;
    }

    @VisibleForTesting
    protected Map<String, Boolean> getInstanceHealthStatus(String clusterId, String instanceName, List<InstanceService.HealthCheck> healthChecks) {
        HashMap<String, Boolean> healthStatus = new HashMap<String, Boolean>();
        block12: for (InstanceService.HealthCheck healthCheck : healthChecks) {
            switch (healthCheck) {
                case INVALID_CONFIG: {
                    boolean validConfig;
                    try {
                        validConfig = InstanceValidationUtil.hasValidConfig((HelixDataAccessor)this._dataAccessor, (String)clusterId, (String)instanceName);
                    }
                    catch (HelixException e) {
                        validConfig = false;
                        LOG.warn("Cluster {} instance {} doesn't have valid config: {}", new Object[]{clusterId, instanceName, e.getMessage()});
                    }
                    healthStatus.put(InstanceService.HealthCheck.INVALID_CONFIG.name(), validConfig);
                    if (validConfig) continue block12;
                    return healthStatus;
                }
                case INSTANCE_NOT_ENABLED: {
                    healthStatus.put(InstanceService.HealthCheck.INSTANCE_NOT_ENABLED.name(), InstanceValidationUtil.isEnabled((HelixDataAccessor)this._dataAccessor, (String)instanceName));
                    continue block12;
                }
                case INSTANCE_NOT_ALIVE: {
                    healthStatus.put(InstanceService.HealthCheck.INSTANCE_NOT_ALIVE.name(), InstanceValidationUtil.isAlive((HelixDataAccessor)this._dataAccessor, (String)instanceName));
                    continue block12;
                }
                case INSTANCE_NOT_STABLE: {
                    boolean isStable = InstanceValidationUtil.isInstanceStable((HelixDataAccessor)this._dataAccessor, (String)instanceName);
                    healthStatus.put(InstanceService.HealthCheck.INSTANCE_NOT_STABLE.name(), isStable);
                    continue block12;
                }
                case HAS_ERROR_PARTITION: {
                    healthStatus.put(InstanceService.HealthCheck.HAS_ERROR_PARTITION.name(), !InstanceValidationUtil.hasErrorPartitions((HelixDataAccessor)this._dataAccessor, (String)clusterId, (String)instanceName));
                    continue block12;
                }
                case HAS_DISABLED_PARTITION: {
                    healthStatus.put(InstanceService.HealthCheck.HAS_DISABLED_PARTITION.name(), !InstanceValidationUtil.hasDisabledPartitions((HelixDataAccessor)this._dataAccessor, (String)clusterId, (String)instanceName));
                    continue block12;
                }
                case EMPTY_RESOURCE_ASSIGNMENT: {
                    healthStatus.put(InstanceService.HealthCheck.EMPTY_RESOURCE_ASSIGNMENT.name(), InstanceValidationUtil.hasResourceAssigned((HelixDataAccessor)this._dataAccessor, (String)clusterId, (String)instanceName));
                    continue block12;
                }
                case MIN_ACTIVE_REPLICA_CHECK_FAILED: {
                    healthStatus.put(InstanceService.HealthCheck.MIN_ACTIVE_REPLICA_CHECK_FAILED.name(), InstanceValidationUtil.siblingNodesActiveReplicaCheck((HelixDataAccessor)this._dataAccessor, (String)instanceName));
                    continue block12;
                }
            }
            LOG.error("Unsupported health check: {}", (Object)healthCheck);
        }
        return healthStatus;
    }
}

