/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.HelixException;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.rest.server.resources.helix.JobAccessor;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters/{clusterId}/workflows")
public class WorkflowAccessor
extends AbstractHelixResource {
    private static Logger _logger = LoggerFactory.getLogger((String)WorkflowAccessor.class.getName());

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    public Response getWorkflows(@PathParam(value="clusterId") String clusterId) {
        TaskDriver taskDriver = this.getTaskDriver(clusterId);
        Map workflowConfigMap = taskDriver.getWorkflows();
        HashMap dataMap = new HashMap();
        dataMap.put(WorkflowProperties.Workflows.name(), new ArrayList(workflowConfigMap.keySet()));
        return this.JSONRepresentation(dataMap);
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{workflowId}")
    public Response getWorkflow(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId) {
        TaskDriver taskDriver = this.getTaskDriver(clusterId);
        WorkflowConfig workflowConfig = taskDriver.getWorkflowConfig(workflowId);
        WorkflowContext workflowContext = taskDriver.getWorkflowContext(workflowId);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        TextNode id = JsonNodeFactory.instance.textNode(workflowId);
        root.put(AbstractResource.Properties.id.name(), (JsonNode)id);
        ObjectNode workflowConfigNode = JsonNodeFactory.instance.objectNode();
        ObjectNode workflowContextNode = JsonNodeFactory.instance.objectNode();
        if (workflowConfig != null) {
            this.getWorkflowConfigNode(workflowConfigNode, workflowConfig.getRecord());
        }
        if (workflowContext != null) {
            this.getWorkflowContextNode(workflowContextNode, workflowContext.getRecord());
        }
        root.put(WorkflowProperties.WorkflowConfig.name(), (JsonNode)workflowConfigNode);
        root.put(WorkflowProperties.WorkflowContext.name(), (JsonNode)workflowContextNode);
        JobDag jobDag = workflowConfig.getJobDag();
        ArrayNode jobs = (ArrayNode)OBJECT_MAPPER.valueToTree((Object)jobDag.getAllNodes());
        ObjectNode parentJobs = (ObjectNode)OBJECT_MAPPER.valueToTree((Object)jobDag.getChildrenToParents());
        root.put(WorkflowProperties.Jobs.name(), (JsonNode)jobs);
        root.put(WorkflowProperties.ParentJobs.name(), (JsonNode)parentJobs);
        root.put(WorkflowProperties.LastScheduledTask.name(), OBJECT_MAPPER.valueToTree((Object)taskDriver.getLastScheduledTaskExecutionInfo(workflowId)));
        return this.JSONRepresentation(root);
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="{workflowId}")
    public Response createWorkflow(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId, String content) {
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            JsonNode root = OBJECT_MAPPER.readTree(content);
            Map cfgMap = (Map)OBJECT_MAPPER.readValue(root.get(WorkflowProperties.WorkflowConfig.name()).toString(), (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, String.class));
            WorkflowConfig workflowConfig = WorkflowConfig.Builder.fromMap((Map)cfgMap).build();
            if (workflowConfig.isJobQueue()) {
                driver.start((Workflow)new JobQueue.Builder(workflowId).setWorkflowConfig(workflowConfig).build());
                return this.OK();
            }
            Workflow.Builder workflow = new Workflow.Builder(workflowId);
            workflow.setWorkflowConfig(workflowConfig);
            if (root.get(WorkflowProperties.Jobs.name()) != null) {
                Map<String, JobConfig.Builder> jobConfigs = this.getJobConfigs((ArrayNode)root.get(WorkflowProperties.Jobs.name()));
                for (Map.Entry<String, JobConfig.Builder> entry : jobConfigs.entrySet()) {
                    workflow.addJob(entry.getKey(), entry.getValue());
                }
            }
            if (root.get(WorkflowProperties.ParentJobs.name()) != null) {
                Map parentJobs = (Map)OBJECT_MAPPER.readValue(root.get(WorkflowProperties.ParentJobs.name()).toString(), (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, List.class));
                for (Map.Entry<String, Object> entry : parentJobs.entrySet()) {
                    String parentJob = entry.getKey();
                    for (String childJob : (List)entry.getValue()) {
                        workflow.addParentChildDependency(parentJob, childJob);
                    }
                }
            }
            driver.start(workflow.build());
        }
        catch (IOException e) {
            return this.badRequest(String.format("Invalid input of Workflow %s for reason : %s", workflowId, e.getMessage()));
        }
        catch (HelixException e) {
            return this.badRequest(String.format("Failed to create workflow %s for reason : %s", workflowId, e.getMessage()));
        }
        return this.OK();
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="{workflowId}")
    public Response deleteWorkflow(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId, @QueryParam(value="force") @DefaultValue(value="false") String forceDelete) {
        boolean force = Boolean.valueOf(forceDelete);
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            driver.delete(workflowId, force);
        }
        catch (HelixException e) {
            return this.badRequest(String.format("Failed to delete workflow %s for reason : %s", workflowId, e.getMessage()));
        }
        return this.OK();
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{workflowId}")
    public Response updateWorkflow(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId, @QueryParam(value="command") String command) {
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            TaskCommand cmd = TaskCommand.valueOf(command);
            switch (cmd) {
                case stop: {
                    driver.stop(workflowId);
                    break;
                }
                case resume: {
                    driver.resume(workflowId);
                    break;
                }
                case clean: {
                    driver.cleanupQueue(workflowId);
                    break;
                }
                default: {
                    return this.badRequest(String.format("Invalid command : %s", command));
                }
            }
        }
        catch (HelixException e) {
            return this.badRequest(String.format("Failed to execute operation %s for reason : %s", command, e.getMessage()));
        }
        catch (Exception e) {
            return this.serverError(e);
        }
        return this.OK();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{workflowId}/configs")
    public Response getWorkflowConfig(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId) {
        TaskDriver taskDriver = this.getTaskDriver(clusterId);
        WorkflowConfig workflowConfig = taskDriver.getWorkflowConfig(workflowId);
        ObjectNode workflowConfigNode = JsonNodeFactory.instance.objectNode();
        if (workflowConfig != null) {
            this.getWorkflowConfigNode(workflowConfigNode, workflowConfig.getRecord());
        }
        return this.JSONRepresentation(workflowConfigNode);
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{workflowId}/configs")
    public Response updateWorkflowConfig(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId, String content) {
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            ZNRecord record = WorkflowAccessor.toZNRecord(content);
            WorkflowConfig workflowConfig = driver.getWorkflowConfig(workflowId);
            if (workflowConfig == null) {
                return this.badRequest(String.format("WorkflowConfig for workflow %s does not exists!", workflowId));
            }
            workflowConfig.getRecord().update(record);
            driver.updateWorkflow(workflowId, workflowConfig);
        }
        catch (HelixException e) {
            return this.badRequest(String.format("Failed to update WorkflowConfig for workflow %s", workflowId));
        }
        catch (Exception e) {
            return this.badRequest(String.format("Invalid WorkflowConfig for workflow %s", workflowId));
        }
        return this.OK();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{workflowId}/userContent")
    public Response getWorkflowUserContent(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId) {
        TaskDriver taskDriver = this.getTaskDriver(clusterId);
        try {
            Map contentStore = taskDriver.getWorkflowUserContentMap(workflowId);
            if (contentStore == null) {
                return this.notFound(String.format("Unable to find content store. Workflow (%s) does not exist.", workflowId));
            }
            return this.JSONRepresentation(contentStore);
        }
        catch (ZkNoNodeException e) {
            return this.notFound("Unable to find content store");
        }
        catch (Exception e) {
            return this.serverError(e);
        }
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{workflowId}/userContent")
    public Response updateWorkflowUserContent(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId, @QueryParam(value="command") String commandStr, String content) {
        AbstractResource.Command cmd;
        Map contentMap = Collections.emptyMap();
        try {
            contentMap = (Map)OBJECT_MAPPER.readValue(content, (TypeReference)new TypeReference<Map<String, String>>(){});
            cmd = AbstractResource.Command.valueOf(commandStr);
        }
        catch (IOException e) {
            return this.badRequest(String.format("Content %s cannot be deserialized to Map<String, String>. Err: %s", content, e.getMessage()));
        }
        catch (IllegalArgumentException ie) {
            return this.badRequest(String.format("Invalid command: %s. Err: %s", commandStr, ie.getMessage()));
        }
        catch (NullPointerException npe) {
            cmd = AbstractResource.Command.update;
        }
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            switch (cmd) {
                case update: {
                    driver.addOrUpdateWorkflowUserContentMap(workflowId, contentMap);
                    return this.OK();
                }
            }
            return this.badRequest(String.format("Command \"%s\" is not supported!", new Object[]{cmd}));
        }
        catch (NullPointerException npe) {
            return this.notFound(String.format("Unable to find content store. Workflow (%s) does not exist.", workflowId));
        }
        catch (Exception e) {
            _logger.error("Failed to update user content store", (Throwable)e);
            return this.serverError(e);
        }
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{workflowId}/context")
    public Response getWorkflowContext(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowId") String workflowId) {
        TaskDriver taskDriver = this.getTaskDriver(clusterId);
        WorkflowContext workflowContext = taskDriver.getWorkflowContext(workflowId);
        ObjectNode workflowContextNode = JsonNodeFactory.instance.objectNode();
        if (workflowContext != null) {
            this.getWorkflowContextNode(workflowContextNode, workflowContext.getRecord());
        }
        return this.JSONRepresentation(workflowContextNode);
    }

    private void getWorkflowConfigNode(ObjectNode workflowConfigNode, ZNRecord record) {
        for (Map.Entry entry : record.getSimpleFields().entrySet()) {
            if (((String)entry.getKey()).equals(WorkflowConfig.WorkflowConfigProperty.Dag)) continue;
            workflowConfigNode.put((String)entry.getKey(), (JsonNode)JsonNodeFactory.instance.textNode((String)entry.getValue()));
        }
    }

    private void getWorkflowContextNode(ObjectNode workflowContextNode, ZNRecord record) {
        if (record.getMapFields() != null) {
            for (String string : record.getMapFields().keySet()) {
                JsonNode node = OBJECT_MAPPER.valueToTree((Object)record.getMapField(string));
                workflowContextNode.put(string, node);
            }
        }
        if (record.getSimpleFields() != null) {
            for (Map.Entry entry : record.getSimpleFields().entrySet()) {
                workflowContextNode.put((String)entry.getKey(), (JsonNode)JsonNodeFactory.instance.textNode((String)entry.getValue()));
            }
        }
    }

    private Map<String, JobConfig.Builder> getJobConfigs(ArrayNode root) throws HelixException, IOException {
        HashMap<String, JobConfig.Builder> jobConfigsMap = new HashMap<String, JobConfig.Builder>();
        Iterator it = root.elements();
        while (it.hasNext()) {
            JsonNode job = (JsonNode)it.next();
            ZNRecord record = null;
            try {
                record = WorkflowAccessor.toZNRecord(job.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (record == null || record.getSimpleFields().isEmpty()) {
                Map cfgMap = (Map)OBJECT_MAPPER.readValue(job.toString(), (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, String.class));
                jobConfigsMap.put(job.get(AbstractResource.Properties.id.name()).textValue(), JobAccessor.getJobConfig(cfgMap));
                continue;
            }
            jobConfigsMap.put(job.get(AbstractResource.Properties.id.name()).textValue(), JobAccessor.getJobConfig(record));
        }
        return jobConfigsMap;
    }

    public static enum TaskCommand {
        stop,
        resume,
        clean;

    }

    public static enum WorkflowProperties {
        Workflows,
        WorkflowConfig,
        WorkflowContext,
        Jobs,
        ParentJobs,
        LastScheduledTask;

    }
}

