/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.HelixException;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters/{clusterId}/workflows/{workflowName}/jobs")
public class JobAccessor
extends AbstractHelixResource {
    private static Logger _logger = LoggerFactory.getLogger((String)JobAccessor.class.getName());

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    public Response getJobs(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName) {
        TaskDriver driver = this.getTaskDriver(clusterId);
        WorkflowConfig workflowConfig = driver.getWorkflowConfig(workflowName);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        if (workflowConfig == null) {
            return this.badRequest(String.format("Workflow %s is not found!", workflowName));
        }
        Set jobs = workflowConfig.getJobDag().getAllNodes();
        root.put(AbstractResource.Properties.id.name(), JobProperties.Jobs.name());
        ArrayNode jobsNode = root.putArray(JobProperties.Jobs.name());
        if (jobs != null) {
            jobsNode.addAll((ArrayNode)OBJECT_MAPPER.valueToTree((Object)jobs));
        }
        return this.JSONRepresentation(root);
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{jobName}")
    public Response getJob(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName) {
        TaskDriver driver = this.getTaskDriver(clusterId);
        HashMap<String, ZNRecord> jobMap = new HashMap<String, ZNRecord>();
        JobConfig jobConfig = driver.getJobConfig(jobName);
        if (jobConfig == null) {
            return this.badRequest(String.format("Job config for %s does not exists", jobName));
        }
        jobMap.put(JobProperties.JobConfig.name(), jobConfig.getRecord());
        JobContext jobContext = driver.getJobContext(jobName);
        jobMap.put(JobProperties.JobContext.name(), null);
        if (jobContext != null) {
            jobMap.put(JobProperties.JobContext.name(), jobContext.getRecord());
        }
        return this.JSONRepresentation(jobMap);
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="{jobName}")
    public Response addJob(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName, String content) {
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            ZNRecord record = JobAccessor.toZNRecord(content);
            JobConfig.Builder jobConfig = JobAccessor.getJobConfig(record);
            driver.enqueueJob(workflowName, jobName, jobConfig);
        }
        catch (HelixException e) {
            return this.badRequest(String.format("Failed to enqueue job %s for reason : %s", jobName, e.getMessage()));
        }
        catch (IOException e) {
            return this.badRequest(String.format("Invalid input for Job Config of Job : %s", jobName));
        }
        return this.OK();
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="{jobName}")
    public Response deleteJob(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName, @QueryParam(value="force") @DefaultValue(value="false") String forceDelete) {
        boolean force = Boolean.parseBoolean(forceDelete);
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            driver.deleteJob(workflowName, jobName, force);
        }
        catch (Exception e) {
            return this.badRequest(e.getMessage());
        }
        return this.OK();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{jobName}/configs")
    public Response getJobConfig(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName) {
        TaskDriver driver = this.getTaskDriver(clusterId);
        JobConfig jobConfig = driver.getJobConfig(jobName);
        if (jobConfig != null) {
            return this.JSONRepresentation(jobConfig.getRecord());
        }
        return this.badRequest("Job config for " + jobName + " does not exists");
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{jobName}/context")
    public Response getJobContext(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName) {
        TaskDriver driver = this.getTaskDriver(clusterId);
        JobContext jobContext = driver.getJobContext(jobName);
        if (jobContext != null) {
            return this.JSONRepresentation(jobContext.getRecord());
        }
        return this.badRequest("Job context for " + jobName + " does not exists");
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="{jobName}/userContent")
    public Response getJobUserContent(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName) {
        TaskDriver taskDriver = this.getTaskDriver(clusterId);
        try {
            Map contentStore = taskDriver.getJobUserContentMap(workflowName, jobName);
            if (contentStore == null) {
                return this.notFound(String.format("Unable to find content store. Workflow (%s) or Job (%s) does not exist.", workflowName, jobName));
            }
            return this.JSONRepresentation(contentStore);
        }
        catch (ZkNoNodeException e) {
            return this.notFound("Unable to find content store");
        }
        catch (Exception e) {
            return this.serverError(e);
        }
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="{jobName}/userContent")
    public Response updateJobUserContent(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName, @QueryParam(value="command") String commandStr, String content) {
        AbstractResource.Command cmd;
        Map contentMap = Collections.emptyMap();
        try {
            contentMap = (Map)OBJECT_MAPPER.readValue(content, (TypeReference)new TypeReference<Map<String, String>>(){});
            cmd = commandStr == null || commandStr.isEmpty() ? AbstractResource.Command.update : AbstractResource.Command.valueOf(commandStr);
        }
        catch (IOException e) {
            return this.badRequest(String.format("Content %s cannot be deserialized to Map<String, String>. Err: %s", content, e.getMessage()));
        }
        catch (IllegalArgumentException ie) {
            return this.badRequest(String.format("Invalid command: %s. Err: %s", commandStr, ie.getMessage()));
        }
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            switch (cmd) {
                case update: {
                    driver.addOrUpdateJobUserContentMap(workflowName, jobName, contentMap);
                    return this.OK();
                }
            }
            return this.badRequest(String.format("Command \"%s\" is not supported!", new Object[]{cmd}));
        }
        catch (NullPointerException npe) {
            return this.notFound(String.format("Unable to find content store. Workflow (%s) or Job (%s) does not exist.", workflowName, jobName));
        }
        catch (Exception e) {
            _logger.error("Failed to update user content store", (Throwable)e);
            return this.serverError(e);
        }
    }

    protected static JobConfig.Builder getJobConfig(Map<String, String> cfgMap) {
        new JobConfig.Builder();
        return JobConfig.Builder.fromMap(cfgMap);
    }

    protected static JobConfig.Builder getJobConfig(ZNRecord record) {
        new JobConfig.Builder();
        JobConfig.Builder jobConfig = JobConfig.Builder.fromMap((Map)record.getSimpleFields());
        jobConfig.addTaskConfigMap(JobAccessor.getTaskConfigMap(record.getMapFields()));
        return jobConfig;
    }

    private static Map<String, TaskConfig> getTaskConfigMap(Map<String, Map<String, String>> taskConfigs) {
        HashMap<String, TaskConfig> taskConfigsMap = new HashMap<String, TaskConfig>();
        if (taskConfigs == null || taskConfigs.isEmpty()) {
            return Collections.emptyMap();
        }
        for (Map<String, String> taskConfigMap : taskConfigs.values()) {
            if (!taskConfigMap.containsKey(JobProperties.TASK_COMMAND.name())) continue;
            TaskConfig taskConfig = new TaskConfig(taskConfigMap.get(JobProperties.TASK_COMMAND.name()), taskConfigMap);
            taskConfigsMap.put(taskConfig.getId(), taskConfig);
        }
        return taskConfigsMap;
    }

    public static enum JobProperties {
        Jobs,
        JobConfig,
        JobContext,
        TASK_COMMAND;

    }
}

