/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.util;

import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class ZNRecordUtil {
    public static boolean shouldCompress(ZNRecord record, int serializedLength) {
        if (record.getBooleanField("enableCompression", false)) {
            return true;
        }
        boolean autoCompressEnabled = Boolean.parseBoolean(System.getProperty("zk.serializer.znrecord.auto-compress.enabled", "true"));
        return autoCompressEnabled && serializedLength > ZNRecordUtil.getSerializerWriteSizeLimit();
    }

    public static int getSerializerWriteSizeLimit() {
        Integer writeSizeLimit = Integer.getInteger("zk.serializer.znrecord.write.size.limit.bytes");
        if (writeSizeLimit == null || writeSizeLimit <= 0) {
            return 1024000;
        }
        return writeSizeLimit;
    }
}

