/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import org.apache.helix.model.CurrentState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;

class CurStateCarryOverUpdater
implements DataUpdater<ZNRecord> {
    final String _curSessionId;
    final String _initState;
    final CurrentState _lastCurState;

    public CurStateCarryOverUpdater(String curSessionId, String initState, CurrentState lastCurState) {
        if (curSessionId == null || initState == null || lastCurState == null) {
            throw new IllegalArgumentException("missing curSessionId|initState|lastCurState for carry-over");
        }
        this._curSessionId = curSessionId;
        this._initState = initState;
        this._lastCurState = lastCurState;
    }

    @Override
    public ZNRecord update(ZNRecord currentData) {
        CurrentState curState;
        if (currentData == null) {
            curState = new CurrentState(this._lastCurState.getId());
            curState.getRecord().setSimpleFields(this._lastCurState.getRecord().getSimpleFields());
            curState.setSessionId(this._curSessionId);
        } else {
            curState = new CurrentState(currentData);
        }
        for (String partitionName : this._lastCurState.getPartitionStateMap().keySet()) {
            if (curState.getState(partitionName) != null) continue;
            curState.setState(partitionName, this._initState);
        }
        return curState.getRecord();
    }
}

