/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManagerProperty;
import org.apache.helix.model.CloudConfig;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelixPropertyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HelixPropertyFactory.class);
    private static final String HELIX_PARTICIPANT_PROPERTY_FILE = "helix-manager.properties";

    public static HelixPropertyFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public HelixManagerProperty getHelixManagerProperty(String zkAddress, String clusterName) {
        CloudConfig cloudConfig = this.getCloudConfig(zkAddress, clusterName);
        Properties properties = new Properties();
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(HELIX_PARTICIPANT_PROPERTY_FILE);
            properties.load(stream);
        }
        catch (IOException e) {
            String errMsg = String.format("failed to open Helix participant properties file: %s", HELIX_PARTICIPANT_PROPERTY_FILE);
            throw new IllegalArgumentException(errMsg, e);
        }
        LOG.info("HelixPropertyFactory successfully loaded helix participant properties: {}", (Object)properties);
        return new HelixManagerProperty(properties, cloudConfig);
    }

    private static CloudConfig buildEmptyCloudConfig() {
        return new CloudConfig.Builder().setCloudEnabled(false).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloudConfig getCloudConfig(String zkAddress, String clusterName) {
        CloudConfig cloudConfig;
        RealmAwareZkClient dedicatedZkClient = null;
        try {
            Object connectionConfig;
            if (Boolean.getBoolean("helix.multiZkEnabled") || zkAddress == null) {
                try {
                    connectionConfig = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder().setRealmMode(RealmAwareZkClient.RealmMode.SINGLE_REALM).setZkRealmShardingKey("/" + clusterName).build();
                    dedicatedZkClient = DedicatedZkClientFactory.getInstance().buildZkClient((RealmAwareZkClient.RealmAwareZkConnectionConfig)connectionConfig);
                }
                catch (IOException | InvalidRoutingDataException e) {
                    throw new HelixException("Not able to connect on multi-ZK mode!", e);
                }
            } else {
                connectionConfig = new HelixZkClient.ZkConnectionConfig(zkAddress);
                dedicatedZkClient = DedicatedZkClientFactory.getInstance().buildZkClient((HelixZkClient.ZkConnectionConfig)connectionConfig);
            }
            dedicatedZkClient.setZkSerializer(new ZNRecordSerializer());
            ConfigAccessor configAccessor = new ConfigAccessor(dedicatedZkClient);
            try {
                cloudConfig = configAccessor.getCloudConfig(clusterName) == null ? HelixPropertyFactory.buildEmptyCloudConfig() : configAccessor.getCloudConfig(clusterName);
            }
            catch (HelixException e) {
                cloudConfig = HelixPropertyFactory.buildEmptyCloudConfig();
            }
        }
        finally {
            if (dedicatedZkClient != null && !dedicatedZkClient.isClosed()) {
                dedicatedZkClient.close();
            }
        }
        return cloudConfig;
    }

    private static class SingletonHelper {
        private static final HelixPropertyFactory INSTANCE = new HelixPropertyFactory();

        private SingletonHelper() {
        }
    }
}

