/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.task.JobDag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeJobDag
extends JobDag {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeJobDag.class);
    private static final int DEFAULT_NUM_PARALLEL_JOBS = 1;
    private ArrayDeque<String> _readyJobList;
    private Set<String> _inflightJobList;
    private boolean _hasDagChanged;
    private Map<String, Set<String>> _successorMap;
    private Map<String, Set<String>> _predecessorMap;
    private boolean _isJobQueue;
    private int _numParallelJobs;
    private String _lastJob;
    private int _version;

    public RuntimeJobDag() {
        this._readyJobList = new ArrayDeque();
        this._inflightJobList = new HashSet<String>();
        this._hasDagChanged = true;
        this._version = 0;
    }

    public RuntimeJobDag(JobDag jobDag, boolean isJobQueue, int numParallelJobs, int version) {
        this._childrenToParents = jobDag.getChildrenToParents();
        this._parentsToChildren = jobDag.getParentsToChildren();
        this._allNodes = jobDag.getAllNodes();
        this._isJobQueue = isJobQueue;
        this._numParallelJobs = numParallelJobs <= 0 ? 1 : numParallelJobs;
        this._version = version;
        this.generateJobList();
    }

    public int getVersion() {
        return this._version;
    }

    @Override
    public void addParentToChild(String parent, String child) {
        this._hasDagChanged = true;
        super.addParentToChild(parent, child);
    }

    @Override
    public void addNode(String node) {
        this._hasDagChanged = true;
        super.addNode(node);
    }

    @Override
    public void removeNode(String job, boolean maintainDependency) {
        this._hasDagChanged = true;
        super.removeNode(job, maintainDependency);
    }

    public boolean hasNextJob() {
        if (this._hasDagChanged) {
            this.generateJobList();
        }
        return !this._readyJobList.isEmpty();
    }

    @Override
    public String getNextJob() {
        if (this._hasDagChanged) {
            this.generateJobList();
        }
        if (this._readyJobList.isEmpty()) {
            return null;
        }
        String nextJob = this._readyJobList.poll();
        this._inflightJobList.add(nextJob);
        this._lastJob = nextJob;
        return nextJob;
    }

    public boolean finishJob(String job) {
        if (this._hasDagChanged) {
            LOG.warn("Job DAG has been modified; Cannot finish job: {}", (Object)job);
            return false;
        }
        if (!this._inflightJobList.remove(job)) {
            LOG.warn("Job: {} has either finished already, never been scheduled, or been removed from DAG", (Object)job);
        }
        if (this._isJobQueue) {
            while (this._lastJob != null && this._parentsToChildren.containsKey(this._lastJob)) {
                String nextJob = (String)((Set)this._parentsToChildren.get(this._lastJob)).iterator().next();
                if (!this._readyJobList.contains(nextJob)) {
                    this._readyJobList.offer(nextJob);
                    break;
                }
                this._lastJob = nextJob;
            }
        } else if (this._successorMap.containsKey(job)) {
            for (String successor : this._successorMap.get(job)) {
                if (!this._predecessorMap.containsKey(successor)) continue;
                Set<String> predecessors = this._predecessorMap.get(successor);
                predecessors.remove(job);
                if (!predecessors.isEmpty()) continue;
                this._readyJobList.offer(successor);
            }
        }
        this._successorMap.remove(job);
        return true;
    }

    public void generateJobList() {
        this.resetJobListAndDependencyMaps();
        this.computeIndependentNodes();
        this._readyJobList.addAll(this._independentNodes);
        if (this._isJobQueue && this._readyJobList.size() > 0) {
            for (int i = 1; i < this._numParallelJobs; ++i) {
                if (!this._parentsToChildren.containsKey(this._readyJobList.peekLast())) continue;
                this._readyJobList.offer((String)((Set)this._parentsToChildren.get(this._readyJobList.peekLast())).iterator().next());
            }
        }
        this._hasDagChanged = false;
    }

    private void resetJobListAndDependencyMaps() {
        this._readyJobList = new ArrayDeque();
        this._inflightJobList = new HashSet<String>();
        this._successorMap = new HashMap<String, Set<String>>();
        this._predecessorMap = new HashMap<String, Set<String>>();
        for (Map.Entry entry : this._parentsToChildren.entrySet()) {
            this._successorMap.put((String)entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        for (Map.Entry entry : this._childrenToParents.entrySet()) {
            this._predecessorMap.put((String)entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
    }

    public Set<String> getInflightJobList() {
        return new HashSet<String>(this._inflightJobList);
    }
}

