/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.HelixException;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskAssignmentCalculator;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.util.JenkinsHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTaskAssignmentCalculator
extends TaskAssignmentCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(GenericTaskAssignmentCalculator.class);

    @Override
    public Set<Integer> getAllTaskPartitions(JobConfig jobCfg, JobContext jobCtx, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Map<String, IdealState> idealStateMap) {
        Map<String, TaskConfig> taskMap = jobCfg.getTaskConfigMap();
        Map<String, Integer> taskIdMap = jobCtx.getTaskIdPartitionMap();
        for (TaskConfig taskCfg : taskMap.values()) {
            String taskId = taskCfg.getId();
            int nextPartition = jobCtx.getPartitionSet().size();
            if (taskIdMap.containsKey(taskId)) continue;
            jobCtx.setTaskIdForPartition(nextPartition, taskId);
        }
        return jobCtx.getPartitionSet();
    }

    @Override
    @Deprecated
    public Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput currStateOutput, ResourceAssignment prevAssignment, Collection<String> instances, JobConfig jobCfg, JobContext jobContext, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Set<Integer> partitionSet, Map<String, IdealState> idealStateMap) {
        return this.getTaskAssignment(currStateOutput, instances, jobCfg, jobContext, workflowCfg, workflowCtx, partitionSet, idealStateMap);
    }

    @Override
    public Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput currStateOutput, Collection<String> instances, JobConfig jobCfg, JobContext jobContext, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Set<Integer> partitionSet, Map<String, IdealState> idealStateMap) {
        if (jobCfg.getTargetResource() != null) {
            LOG.error("Target resource is not null, should call FixedTaskAssignmentCalculator, target resource : {}", (Object)jobCfg.getTargetResource());
            return new HashMap<String, SortedSet<Integer>>();
        }
        ArrayList partitionNums = Lists.newArrayList(partitionSet);
        Collections.sort(partitionNums);
        String resourceId = jobCfg.getJobId();
        ArrayList allNodes = Lists.newArrayList(instances);
        ConsistentHashingPlacement placement = new ConsistentHashingPlacement(allNodes);
        return placement.computeMapping(jobCfg, jobContext, partitionNums, resourceId);
    }

    private class ConsistentHashingPlacement {
        private JenkinsHash _hashFunction = new JenkinsHash();
        private ConsistentHashSelector _selector;
        private int _numInstances;

        public ConsistentHashingPlacement(List<String> potentialInstances) {
            this._selector = new ConsistentHashSelector(potentialInstances);
            this._numInstances = potentialInstances.size();
        }

        public Map<String, SortedSet<Integer>> computeMapping(JobConfig jobConfig, JobContext jobContext, List<Integer> partitions, String resourceId) {
            if (this._numInstances == 0) {
                return new HashMap<String, SortedSet<Integer>>();
            }
            HashMap taskAssignment = Maps.newHashMap();
            for (int partition : partitions) {
                long hashedValue = new String(resourceId + "_" + partition).hashCode();
                int numAttempts = jobContext.getPartitionNumAttempts(partition);
                int maxAttempts = jobConfig.getMaxAttemptsPerTask();
                int shiftTimes = jobConfig.getMaxAttemptsPerTask() < this._numInstances ? (numAttempts == -1 ? 0 : numAttempts) : (maxAttempts == 0 ? 0 : jobContext.getPartitionNumAttempts(partition) / (maxAttempts / this._numInstances));
                for (int i = 0; i <= shiftTimes; ++i) {
                    hashedValue = this._hashFunction.hash(hashedValue);
                }
                String selectedInstance = this.select(hashedValue);
                if (selectedInstance == null) continue;
                if (!taskAssignment.containsKey(selectedInstance)) {
                    taskAssignment.put(selectedInstance, new TreeSet());
                }
                ((SortedSet)taskAssignment.get(selectedInstance)).add(partition);
            }
            return taskAssignment;
        }

        private String select(long data) throws HelixException {
            return this._selector.get(data);
        }

        private class ConsistentHashSelector {
            private static final int DEFAULT_TOKENS_PER_INSTANCE = 1000;
            private final SortedMap<Long, String> circle = new TreeMap<Long, String>();
            protected int instanceSize = 0;

            public ConsistentHashSelector(List<String> instances) {
                for (String instance : instances) {
                    long tokenCount = 1000L;
                    this.add(instance, tokenCount);
                    ++this.instanceSize;
                }
            }

            public void add(String instance, long numberOfReplicas) {
                int i = 0;
                while ((long)i < numberOfReplicas) {
                    this.circle.put(ConsistentHashingPlacement.this._hashFunction.hash(instance.hashCode(), i), instance);
                    ++i;
                }
            }

            public void remove(String instance, long numberOfReplicas) {
                int i = 0;
                while ((long)i < numberOfReplicas) {
                    this.circle.remove(ConsistentHashingPlacement.this._hashFunction.hash(instance.hashCode(), i));
                    ++i;
                }
            }

            public String get(long data) {
                if (this.circle.isEmpty()) {
                    return null;
                }
                long hash = ConsistentHashingPlacement.this._hashFunction.hash(data);
                if (!this.circle.containsKey(hash)) {
                    SortedMap<Long, String> tailMap = this.circle.tailMap(hash);
                    hash = tailMap.isEmpty() ? this.circle.firstKey().longValue() : tailMap.firstKey().longValue();
                }
                return (String)this.circle.get(hash);
            }
        }
    }
}

