/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixException;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.model.ResourceAssignment;

public class ClusterContext {
    private final int _estimatedMaxPartitionCount;
    private final int _estimatedMaxTopStateCount;
    private final Map<String, Integer> _estimatedMaxPartitionByResource = new HashMap<String, Integer>();
    private final float _estimatedMaxUtilization;
    private final float _estimatedTopStateMaxUtilization;
    private Map<String, Map<String, Set<String>>> _assignmentForFaultZoneMap = new HashMap<String, Map<String, Set<String>>>();
    private final Map<String, ResourceAssignment> _baselineAssignment;
    private final Map<String, ResourceAssignment> _bestPossibleAssignment;

    ClusterContext(Set<AssignableReplica> replicaSet, Set<AssignableNode> nodeSet, Map<String, ResourceAssignment> baselineAssignment, Map<String, ResourceAssignment> bestPossibleAssignment) {
        int instanceCount = nodeSet.size();
        int totalReplicas = 0;
        int totalTopStateReplicas = 0;
        HashMap<String, Integer> totalUsage = new HashMap<String, Integer>();
        HashMap<String, Integer> totalTopStateUsage = new HashMap<String, Integer>();
        HashMap<String, Integer> totalCapacity = new HashMap<String, Integer>();
        for (Map.Entry<String, List<AssignableReplica>> entry : replicaSet.stream().collect(Collectors.groupingBy(AssignableReplica::getResourceName)).entrySet()) {
            int replicas = entry.getValue().size();
            totalReplicas += replicas;
            int replicaCnt = Math.max(1, this.estimateAvgReplicaCount(replicas, instanceCount));
            this._estimatedMaxPartitionByResource.put(entry.getKey(), replicaCnt);
            for (AssignableReplica replica : entry.getValue()) {
                if (replica.isReplicaTopState()) {
                    ++totalTopStateReplicas;
                    replica.getCapacity().entrySet().stream().forEach(capacityEntry -> totalTopStateUsage.compute((String)capacityEntry.getKey(), (k, v) -> v == null ? (Integer)capacityEntry.getValue() : Integer.valueOf(v + (Integer)capacityEntry.getValue())));
                }
                replica.getCapacity().entrySet().stream().forEach(capacityEntry -> totalUsage.compute((String)capacityEntry.getKey(), (k, v) -> v == null ? (Integer)capacityEntry.getValue() : Integer.valueOf(v + (Integer)capacityEntry.getValue())));
            }
        }
        nodeSet.stream().forEach(node -> node.getMaxCapacity().entrySet().stream().forEach(capacityEntry -> totalCapacity.compute((String)capacityEntry.getKey(), (k, v) -> v == null ? (Integer)capacityEntry.getValue() : Integer.valueOf(v + (Integer)capacityEntry.getValue()))));
        if (totalCapacity.isEmpty()) {
            this._estimatedMaxUtilization = 1.0f;
            this._estimatedTopStateMaxUtilization = 1.0f;
        } else {
            this._estimatedMaxUtilization = this.estimateMaxUtilization(totalCapacity, totalUsage);
            this._estimatedTopStateMaxUtilization = this.estimateMaxUtilization(totalCapacity, totalTopStateUsage);
        }
        this._estimatedMaxPartitionCount = this.estimateAvgReplicaCount(totalReplicas, instanceCount);
        this._estimatedMaxTopStateCount = this.estimateAvgReplicaCount(totalTopStateReplicas, instanceCount);
        this._baselineAssignment = baselineAssignment;
        this._bestPossibleAssignment = bestPossibleAssignment;
    }

    public Map<String, ResourceAssignment> getBaselineAssignment() {
        return this._baselineAssignment == null || this._baselineAssignment.isEmpty() ? Collections.emptyMap() : this._baselineAssignment;
    }

    public Map<String, ResourceAssignment> getBestPossibleAssignment() {
        return this._bestPossibleAssignment == null || this._bestPossibleAssignment.isEmpty() ? Collections.emptyMap() : this._bestPossibleAssignment;
    }

    public Map<String, Map<String, Set<String>>> getAssignmentForFaultZoneMap() {
        return this._assignmentForFaultZoneMap;
    }

    public int getEstimatedMaxPartitionCount() {
        return this._estimatedMaxPartitionCount;
    }

    public int getEstimatedMaxPartitionByResource(String resourceName) {
        return this._estimatedMaxPartitionByResource.get(resourceName);
    }

    public int getEstimatedMaxTopStateCount() {
        return this._estimatedMaxTopStateCount;
    }

    public float getEstimatedMaxUtilization() {
        return this._estimatedMaxUtilization;
    }

    public float getEstimatedTopStateMaxUtilization() {
        return this._estimatedTopStateMaxUtilization;
    }

    public Set<String> getPartitionsForResourceAndFaultZone(String resourceName, String faultZoneId) {
        return this._assignmentForFaultZoneMap.getOrDefault(faultZoneId, Collections.emptyMap()).getOrDefault(resourceName, Collections.emptySet());
    }

    void addPartitionToFaultZone(String faultZoneId, String resourceName, String partition) {
        if (!this._assignmentForFaultZoneMap.computeIfAbsent(faultZoneId, k -> new HashMap()).computeIfAbsent(resourceName, k -> new HashSet()).add(partition)) {
            throw new HelixException(String.format("Resource %s already has a replica from partition %s in fault zone %s", resourceName, partition, faultZoneId));
        }
    }

    boolean removePartitionFromFaultZone(String faultZoneId, String resourceName, String partition) {
        return this._assignmentForFaultZoneMap.getOrDefault(faultZoneId, Collections.emptyMap()).getOrDefault(resourceName, Collections.emptySet()).remove(partition);
    }

    void setAssignmentForFaultZoneMap(Map<String, Map<String, Set<String>>> assignmentForFaultZoneMap) {
        this._assignmentForFaultZoneMap = assignmentForFaultZoneMap;
    }

    private int estimateAvgReplicaCount(int replicaCount, int instanceCount) {
        return (int)Math.floor((float)replicaCount / (float)instanceCount);
    }

    private float estimateMaxUtilization(Map<String, Integer> totalCapacity, Map<String, Integer> totalUsage) {
        float estimatedMaxUsage = 0.0f;
        for (String capacityKey : totalCapacity.keySet()) {
            int maxCapacity = totalCapacity.get(capacityKey);
            int usage = totalUsage.getOrDefault(capacityKey, 0);
            float utilization = maxCapacity == 0 ? 1.0f : (float)usage / (float)maxCapacity;
            estimatedMaxUsage = Math.max(estimatedMaxUsage, utilization);
        }
        return estimatedMaxUsage;
    }
}

