/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.callback;

import org.apache.helix.zookeeper.zkclient.metric.ZkClientMonitor;

public class ZkAsyncCallMonitorContext {
    private final long _startTimeMilliSec;
    private final ZkClientMonitor _monitor;
    private final boolean _isRead;
    private int _bytes;

    public ZkAsyncCallMonitorContext(ZkClientMonitor monitor, long startTimeMilliSec, int bytes, boolean isRead) {
        this._monitor = monitor;
        this._startTimeMilliSec = startTimeMilliSec;
        this._bytes = bytes;
        this._isRead = isRead;
    }

    void setBytes(int bytes) {
        this._bytes = bytes;
    }

    void recordAccess(String path) {
        if (this._monitor != null) {
            if (this._isRead) {
                this._monitor.recordAsync(path, this._bytes, this._startTimeMilliSec, ZkClientMonitor.AccessType.READ);
            } else {
                this._monitor.recordAsync(path, this._bytes, this._startTimeMilliSec, ZkClientMonitor.AccessType.WRITE);
            }
        }
    }

    void recordFailure(String path) {
        if (this._monitor != null) {
            if (this._isRead) {
                this._monitor.recordAsyncFailure(path, ZkClientMonitor.AccessType.READ);
            } else {
                this._monitor.recordAsyncFailure(path, ZkClientMonitor.AccessType.WRITE);
            }
        }
    }
}

