/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.UsageSoftConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class MaxCapacityUsageInstanceConstraint
extends UsageSoftConstraint {
    MaxCapacityUsageInstanceConstraint() {
    }

    @Override
    protected double getAssignmentScore(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        float estimatedMaxUtilization = clusterContext.getEstimatedMaxUtilization();
        float projectedHighestUtilization = node.getProjectedHighestUtilization(replica.getCapacity());
        return this.computeUtilizationScore(estimatedMaxUtilization, projectedHighestUtilization);
    }
}

