/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.helix.HelixManagerProperties;
import org.apache.helix.controller.rebalancer.waged.RebalanceAlgorithm;
import org.apache.helix.controller.rebalancer.waged.constraints.ConstraintBasedAlgorithm;
import org.apache.helix.controller.rebalancer.waged.constraints.FaultZoneAwareConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.InstancePartitionsCountConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.MaxCapacityUsageInstanceConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.NodeCapacityConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.NodeMaxPartitionLimitConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.PartitionMovementConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.ReplicaActivateConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.ResourcePartitionAntiAffinityConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.ResourceTopStateAntiAffinityConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.SamePartitionOnInstanceConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.SoftConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.ValidGroupTagConstraint;
import org.apache.helix.model.ClusterConfig;

public class ConstraintBasedAlgorithmFactory {
    private static final Map<String, Float> MODEL = new HashMap<String, Float>(){
        {
            this.put(PartitionMovementConstraint.class.getSimpleName(), Float.valueOf(2.0f));
            this.put(InstancePartitionsCountConstraint.class.getSimpleName(), Float.valueOf(1.0f));
            this.put(ResourcePartitionAntiAffinityConstraint.class.getSimpleName(), Float.valueOf(1.0f));
            this.put(ResourceTopStateAntiAffinityConstraint.class.getSimpleName(), Float.valueOf(3.0f));
            this.put(MaxCapacityUsageInstanceConstraint.class.getSimpleName(), Float.valueOf(5.0f));
        }
    };

    public static RebalanceAlgorithm getInstance(Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> preferences) {
        ImmutableList hardConstraints = ImmutableList.of((Object)new FaultZoneAwareConstraint(), (Object)new NodeCapacityConstraint(), (Object)new ReplicaActivateConstraint(), (Object)new NodeMaxPartitionLimitConstraint(), (Object)new ValidGroupTagConstraint(), (Object)new SamePartitionOnInstanceConstraint());
        int evennessPreference = preferences.getOrDefault((Object)ClusterConfig.GlobalRebalancePreferenceKey.EVENNESS, 1);
        int movementPreference = preferences.getOrDefault((Object)ClusterConfig.GlobalRebalancePreferenceKey.LESS_MOVEMENT, 1);
        ImmutableList softConstraints = ImmutableList.of((Object)new PartitionMovementConstraint(), (Object)new InstancePartitionsCountConstraint(), (Object)new ResourcePartitionAntiAffinityConstraint(), (Object)new ResourceTopStateAntiAffinityConstraint(), (Object)new MaxCapacityUsageInstanceConstraint());
        ImmutableMap softConstraintsWithWeight = Maps.toMap((Iterable)softConstraints, key -> {
            String name = key.getClass().getSimpleName();
            float weight = MODEL.get(name).floatValue();
            return Float.valueOf(name.equals(PartitionMovementConstraint.class.getSimpleName()) ? (float)movementPreference * weight : (float)evennessPreference * weight);
        });
        return new ConstraintBasedAlgorithm((List<HardConstraint>)hardConstraints, (Map<SoftConstraint, Float>)softConstraintsWithWeight);
    }

    static {
        Properties properties = new HelixManagerProperties("soft-constraint-weight.properties").getProperties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(constraintName, weight) -> MODEL.put(String.valueOf(constraintName), Float.valueOf(String.valueOf(weight)))));
    }
}

