/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.zookeeper;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.msdcommon.util.ZkValidationUtil;
import org.apache.helix.rest.common.ContextPropertyKeys;
import org.apache.helix.rest.server.ServerContext;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/zookeeper")
public class ZooKeeperAccessor
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger((String)ZooKeeperAccessor.class.getName());
    private BaseDataAccessor<byte[]> _zkBaseDataAccessor;

    @GET
    @Path(value="{path: .+}")
    public Response get(@PathParam(value="path") String path, @QueryParam(value="command") String commandStr) {
        ZooKeeperCommand cmd = this.getZooKeeperCommandIfPresent(commandStr);
        if (cmd == null) {
            return this.badRequest("Invalid ZooKeeper command: " + commandStr);
        }
        ServerContext _serverContext = (ServerContext)this._application.getProperties().get(ContextPropertyKeys.SERVER_CONTEXT.name());
        this._zkBaseDataAccessor = _serverContext.getByteArrayZkBaseDataAccessor();
        path = "/" + path;
        if (!ZkValidationUtil.isPathValid((String)path)) {
            String errMsg = "The given path is not a valid ZooKeeper path: " + path;
            LOG.info(errMsg);
            return this.badRequest(errMsg);
        }
        switch (cmd) {
            case exists: {
                return this.exists(this._zkBaseDataAccessor, path);
            }
            case getBinaryData: {
                return this.getBinaryData(this._zkBaseDataAccessor, path);
            }
            case getStringData: {
                return this.getStringData(this._zkBaseDataAccessor, path);
            }
            case getChildren: {
                return this.getChildren(this._zkBaseDataAccessor, path);
            }
            case getStat: {
                return this.getStat(this._zkBaseDataAccessor, path);
            }
        }
        String errMsg = "Unsupported command: " + commandStr;
        LOG.error(errMsg);
        return this.badRequest(errMsg);
    }

    private Response exists(BaseDataAccessor<byte[]> zkBaseDataAccessor, String path) {
        ImmutableMap result = ImmutableMap.of((Object)ZooKeeperCommand.exists.name(), (Object)zkBaseDataAccessor.exists(path, AccessOption.PERSISTENT));
        return this.JSONRepresentation(result);
    }

    private Response getBinaryData(BaseDataAccessor<byte[]> zkBaseDataAccessor, String path) {
        Stat stat = new Stat();
        byte[] bytes = this.readBinaryDataFromZK(zkBaseDataAccessor, path, stat);
        ImmutableMap binaryResult = ImmutableMap.of((Object)ZooKeeperCommand.getBinaryData.name(), (Object)bytes, (Object)ZooKeeperCommand.getStat.name(), (Object)ZKUtil.fromStatToMap((Stat)stat));
        return this.JSONRepresentation(binaryResult);
    }

    private Response getStringData(BaseDataAccessor<byte[]> zkBaseDataAccessor, String path) {
        Stat stat = new Stat();
        byte[] bytes = this.readBinaryDataFromZK(zkBaseDataAccessor, path, stat);
        ImmutableMap stringResult = ImmutableMap.of((Object)ZooKeeperCommand.getStringData.name(), (Object)new String(bytes), (Object)ZooKeeperCommand.getStat.name(), (Object)ZKUtil.fromStatToMap((Stat)stat));
        return this.JSONRepresentation(stringResult);
    }

    private byte[] readBinaryDataFromZK(BaseDataAccessor<byte[]> zkBaseDataAccessor, String path, Stat stat) {
        if (zkBaseDataAccessor.exists(path, AccessOption.PERSISTENT)) {
            return (byte[])zkBaseDataAccessor.get(path, stat, AccessOption.PERSISTENT);
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("The ZNode at path %s does not exist!", path)).build());
    }

    private Response getChildren(BaseDataAccessor<byte[]> zkBaseDataAccessor, String path) {
        if (zkBaseDataAccessor.exists(path, AccessOption.PERSISTENT)) {
            ImmutableMap result = ImmutableMap.of((Object)ZooKeeperCommand.getChildren.name(), (Object)zkBaseDataAccessor.getChildNames(path, AccessOption.PERSISTENT));
            return this.JSONRepresentation(result);
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("The ZNode at path %s does not exist", path)).build());
    }

    private Response getStat(BaseDataAccessor<byte[]> zkBaseDataAccessor, String path) {
        Stat stat = zkBaseDataAccessor.getStat(path, AccessOption.PERSISTENT);
        if (stat == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("The ZNode at path %s does not exist!", path)).build());
        }
        Map result = ZKUtil.fromStatToMap((Stat)stat);
        result.put("path", path);
        return this.JSONRepresentation(result);
    }

    private ZooKeeperCommand getZooKeeperCommandIfPresent(String command) {
        return (ZooKeeperCommand)((Object)Enums.getIfPresent(ZooKeeperCommand.class, (String)command).orNull());
    }

    public static enum ZooKeeperCommand {
        exists,
        getBinaryData,
        getStringData,
        getChildren,
        getStat;

    }
}

