/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters/{clusterId}/workflows/{workflowName}/jobs/{jobName}/tasks")
public class TaskAccessor
extends AbstractHelixResource {
    private static Logger _logger = LoggerFactory.getLogger((String)TaskAccessor.class.getName());

    @GET
    @Path(value="{taskPartitionId}/userContent")
    public Response getTaskUserContent(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName, @PathParam(value="taskPartitionId") String taskPartitionid) {
        TaskDriver taskDriver = this.getTaskDriver(clusterId);
        try {
            Map contentStore = taskDriver.getTaskUserContentMap(workflowName, jobName, taskPartitionid);
            if (contentStore == null) {
                return this.notFound(String.format("Unable to find content store. Workflow (%s) or Job (%s) or Task content store (%s) not created yet.", workflowName, jobName, taskPartitionid));
            }
            return this.JSONRepresentation(contentStore);
        }
        catch (ZkNoNodeException e) {
            return this.notFound(String.format("Unable to find content store. Workflow (%s) or Job (%s) not created yet.", workflowName, jobName));
        }
        catch (Exception e) {
            return this.serverError(e);
        }
    }

    @POST
    @Path(value="{taskPartitionId}/userContent")
    public Response updateTaskUserContent(@PathParam(value="clusterId") String clusterId, @PathParam(value="workflowName") String workflowName, @PathParam(value="jobName") String jobName, @PathParam(value="taskPartitionId") String taskPartitionid, @QueryParam(value="command") String commandStr, String content) {
        AbstractResource.Command cmd;
        Map contentMap = Collections.emptyMap();
        try {
            contentMap = (Map)OBJECT_MAPPER.readValue(content, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            return this.badRequest(String.format("Content %s cannot be deserialized to Map<String, String>. Err: %s", content, e.getMessage()));
        }
        try {
            cmd = commandStr == null || commandStr.isEmpty() ? AbstractResource.Command.update : AbstractResource.Command.valueOf(commandStr);
        }
        catch (IllegalArgumentException ie) {
            return this.badRequest(String.format("Invalid command: %s. Err: %s", commandStr, ie.getMessage()));
        }
        TaskDriver driver = this.getTaskDriver(clusterId);
        try {
            switch (cmd) {
                case update: {
                    driver.addOrUpdateTaskUserContentMap(workflowName, jobName, taskPartitionid, contentMap);
                    return this.OK();
                }
            }
            return this.badRequest(String.format("Command \"%s\" is not supported!", new Object[]{cmd}));
        }
        catch (NullPointerException npe) {
            return this.notFound(String.format("Workflow (%s) or job (%s) does not exist", workflowName, jobName));
        }
        catch (Exception e) {
            _logger.error("Failed to update user content store", (Throwable)e);
            return this.serverError(e);
        }
    }
}

