/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters/{clusterId}/resources")
public class ResourceAccessor
extends AbstractHelixResource {
    private static final Logger _logger = LoggerFactory.getLogger(ResourceAccessor.class);

    @GET
    public Response getResources(@PathParam(value="clusterId") String clusterId) {
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put(AbstractResource.Properties.id.name(), (JsonNode)JsonNodeFactory.instance.textNode(clusterId));
        RealmAwareZkClient zkClient = this.getRealmAwareZkClient();
        ArrayNode idealStatesNode = root.putArray(ResourceProperties.idealStates.name());
        ArrayNode externalViewsNode = root.putArray(ResourceProperties.externalViews.name());
        List idealStates = zkClient.getChildren(PropertyPathBuilder.idealState((String)clusterId));
        List externalViews = zkClient.getChildren(PropertyPathBuilder.externalView((String)clusterId));
        if (idealStates == null) {
            return this.notFound();
        }
        idealStatesNode.addAll((ArrayNode)OBJECT_MAPPER.valueToTree((Object)idealStates));
        if (externalViews != null) {
            externalViewsNode.addAll((ArrayNode)OBJECT_MAPPER.valueToTree((Object)externalViews));
        }
        return this.JSONRepresentation(root);
    }

    @GET
    @Path(value="health")
    public Response getResourceHealth(@PathParam(value="clusterId") String clusterId) {
        RealmAwareZkClient zkClient = this.getRealmAwareZkClient();
        List resourcesInIdealState = zkClient.getChildren(PropertyPathBuilder.idealState((String)clusterId));
        List resourcesInExternalView = zkClient.getChildren(PropertyPathBuilder.externalView((String)clusterId));
        HashMap<String, String> resourceHealthResult = new HashMap<String, String>();
        for (String resourceName : resourcesInIdealState) {
            if (resourcesInExternalView.contains(resourceName)) {
                Map<String, String> partitionHealth = this.computePartitionHealth(clusterId, resourceName);
                if (partitionHealth.isEmpty() || partitionHealth.values().contains(HealthStatus.UNHEALTHY.name())) {
                    resourceHealthResult.put(resourceName, HealthStatus.UNHEALTHY.name());
                    continue;
                }
                if (partitionHealth.values().contains(HealthStatus.PARTIAL_HEALTHY.name())) {
                    resourceHealthResult.put(resourceName, HealthStatus.PARTIAL_HEALTHY.name());
                    continue;
                }
                resourceHealthResult.put(resourceName, HealthStatus.HEALTHY.name());
                continue;
            }
            resourceHealthResult.put(resourceName, HealthStatus.UNHEALTHY.name());
        }
        return this.JSONRepresentation(resourceHealthResult);
    }

    @GET
    @Path(value="{resourceName}/health")
    public Response getPartitionHealth(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName) {
        return this.JSONRepresentation(this.computePartitionHealth(clusterId, resourceName));
    }

    @GET
    @Path(value="{resourceName}")
    public Response getResource(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName, @DefaultValue(value="getResource") @QueryParam(value="command") String command) {
        AbstractResource.Command cmd;
        try {
            cmd = AbstractResource.Command.valueOf(command);
        }
        catch (Exception e) {
            return this.badRequest("Invalid command : " + command);
        }
        ConfigAccessor accessor = this.getConfigAccessor();
        HelixAdmin admin = this.getHelixAdmin();
        switch (cmd) {
            case getResource: {
                ResourceConfig resourceConfig = accessor.getResourceConfig(clusterId, resourceName);
                IdealState idealState = admin.getResourceIdealState(clusterId, resourceName);
                ExternalView externalView = admin.getResourceExternalView(clusterId, resourceName);
                HashMap<String, ZNRecord> resourceMap = new HashMap<String, ZNRecord>();
                if (idealState == null) {
                    return this.notFound();
                }
                resourceMap.put(ResourceProperties.idealState.name(), idealState.getRecord());
                resourceMap.put(ResourceProperties.resourceConfig.name(), null);
                resourceMap.put(ResourceProperties.externalView.name(), null);
                if (resourceConfig != null) {
                    resourceMap.put(ResourceProperties.resourceConfig.name(), resourceConfig.getRecord());
                }
                if (externalView != null) {
                    resourceMap.put(ResourceProperties.externalView.name(), externalView.getRecord());
                }
                return this.JSONRepresentation(resourceMap);
            }
            case validateWeight: {
                Map validationResultMap;
                try {
                    validationResultMap = admin.validateResourcesForWagedRebalance(clusterId, Collections.singletonList(resourceName));
                }
                catch (HelixException e) {
                    return this.badRequest(e.getMessage());
                }
                return this.JSONRepresentation(validationResultMap);
            }
        }
        _logger.error("Unsupported command :" + command);
        return this.badRequest("Unsupported command :" + command);
    }

    @PUT
    @Path(value="{resourceName}")
    public Response addResource(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName, @DefaultValue(value="-1") @QueryParam(value="numPartitions") int numPartitions, @DefaultValue(value="") @QueryParam(value="stateModelRef") String stateModelRef, @DefaultValue(value="SEMI_AUTO") @QueryParam(value="rebalancerMode") String rebalancerMode, @DefaultValue(value="DEFAULT") @QueryParam(value="rebalanceStrategy") String rebalanceStrategy, @DefaultValue(value="0") @QueryParam(value="bucketSize") int bucketSize, @DefaultValue(value="-1") @QueryParam(value="maxPartitionsPerInstance") int maxPartitionsPerInstance, @DefaultValue(value="addResource") @QueryParam(value="command") String command, String content) {
        AbstractResource.Command cmd;
        try {
            cmd = AbstractResource.Command.valueOf(command);
        }
        catch (Exception e) {
            return this.badRequest("Invalid command : " + command);
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            switch (cmd) {
                case addResource: {
                    if (content.length() != 0) {
                        ZNRecord record;
                        try {
                            record = ResourceAccessor.toZNRecord(content);
                        }
                        catch (IOException e) {
                            _logger.error("Failed to deserialize user's input " + content + ", Exception: " + e);
                            return this.badRequest("Input is not a valid ZNRecord!");
                        }
                        if (record.getSimpleFields() != null) {
                            admin.addResource(clusterId, resourceName, new IdealState(record));
                        }
                        break;
                    }
                    admin.addResource(clusterId, resourceName, numPartitions, stateModelRef, rebalancerMode, rebalanceStrategy, bucketSize, maxPartitionsPerInstance);
                    break;
                }
                case addWagedResource: {
                    Map input;
                    if (content == null || content.length() == 0) {
                        _logger.error("Input is null or empty!");
                        return this.badRequest("Input is null or empty!");
                    }
                    try {
                        TypeReference<Map<String, ZNRecord>> typeRef = new TypeReference<Map<String, ZNRecord>>(){};
                        input = (Map)OBJECT_MAPPER.readValue(content, (TypeReference)typeRef);
                    }
                    catch (IOException e) {
                        _logger.error("Failed to deserialize user's input {}, Exception: {}", (Object)content, (Object)e);
                        return this.badRequest("Input is not a valid map of String-ZNRecord pairs!");
                    }
                    ZNRecord idealStateRecord = (ZNRecord)input.get(ResourceProperties.idealState.name());
                    ZNRecord resourceConfigRecord = (ZNRecord)input.get(ResourceProperties.resourceConfig.name());
                    if (idealStateRecord == null || resourceConfigRecord == null) {
                        _logger.error("Input does not contain both IdealState and ResourceConfig!");
                        return this.badRequest("Input does not contain both IdealState and ResourceConfig!");
                    }
                    try {
                        admin.addResourceWithWeight(clusterId, new IdealState(idealStateRecord), new ResourceConfig(resourceConfigRecord));
                        break;
                    }
                    catch (HelixException e) {
                        String errMsg = String.format("Failed to add resource %s with weight in cluster %s!", idealStateRecord.getId(), clusterId);
                        _logger.error(errMsg, (Throwable)e);
                        return this.badRequest(errMsg);
                    }
                }
                default: {
                    _logger.error("Unsupported command :" + command);
                    return this.badRequest("Unsupported command :" + command);
                }
            }
        }
        catch (Exception e) {
            _logger.error("Error in adding a resource: " + resourceName, (Throwable)e);
            return this.serverError(e);
        }
        return this.OK();
    }

    @POST
    @Path(value="{resourceName}")
    public Response updateResource(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName, @QueryParam(value="command") String command, @DefaultValue(value="-1") @QueryParam(value="replicas") int replicas, @DefaultValue(value="") @QueryParam(value="keyPrefix") String keyPrefix, @DefaultValue(value="") @QueryParam(value="group") String group) {
        AbstractResource.Command cmd;
        try {
            cmd = AbstractResource.Command.valueOf(command);
        }
        catch (Exception e) {
            return this.badRequest("Invalid command : " + command);
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            switch (cmd) {
                case enable: {
                    admin.enableResource(clusterId, resourceName, true);
                    break;
                }
                case disable: {
                    admin.enableResource(clusterId, resourceName, false);
                    break;
                }
                case rebalance: {
                    if (replicas == -1) {
                        return this.badRequest("Number of replicas is needed for rebalancing!");
                    }
                    keyPrefix = keyPrefix.length() == 0 ? resourceName : keyPrefix;
                    admin.rebalance(clusterId, resourceName, replicas, keyPrefix, group);
                    break;
                }
                case enableWagedRebalance: {
                    try {
                        admin.enableWagedRebalance(clusterId, Collections.singletonList(resourceName));
                        break;
                    }
                    catch (HelixException e) {
                        return this.badRequest(e.getMessage());
                    }
                }
                default: {
                    _logger.error("Unsupported command :" + command);
                    return this.badRequest("Unsupported command :" + command);
                }
            }
        }
        catch (Exception e) {
            _logger.error("Failed in updating resource : " + resourceName, (Throwable)e);
            return this.badRequest(e.getMessage());
        }
        return this.OK();
    }

    @DELETE
    @Path(value="{resourceName}")
    public Response deleteResource(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName) {
        HelixAdmin admin = this.getHelixAdmin();
        try {
            admin.dropResource(clusterId, resourceName);
        }
        catch (Exception e) {
            _logger.error("Error in deleting a resource: " + resourceName, (Throwable)e);
            return this.serverError();
        }
        return this.OK();
    }

    @GET
    @Path(value="{resourceName}/configs")
    public Response getResourceConfig(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName) {
        ConfigAccessor accessor = this.getConfigAccessor();
        ResourceConfig resourceConfig = accessor.getResourceConfig(clusterId, resourceName);
        if (resourceConfig != null) {
            return this.JSONRepresentation(resourceConfig.getRecord());
        }
        return this.notFound();
    }

    @POST
    @Path(value="{resourceName}/configs")
    public Response updateResourceConfig(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName, @QueryParam(value="command") String commandStr, String content) {
        ZNRecord record;
        AbstractResource.Command command;
        if (commandStr == null || commandStr.isEmpty()) {
            command = AbstractResource.Command.update;
        } else {
            try {
                command = this.getCommand(commandStr);
            }
            catch (HelixException ex) {
                return this.badRequest(ex.getMessage());
            }
        }
        try {
            record = ResourceAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            _logger.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        ResourceConfig resourceConfig = new ResourceConfig(record);
        ConfigAccessor configAccessor = this.getConfigAccessor();
        try {
            switch (command) {
                case update: {
                    configAccessor.updateResourceConfig(clusterId, resourceName, resourceConfig);
                    break;
                }
                case delete: {
                    HelixConfigScope resourceScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(clusterId).forResource(resourceName).build();
                    configAccessor.remove(resourceScope, record);
                    break;
                }
                default: {
                    return this.badRequest(String.format("Unsupported command: %s", new Object[]{command}));
                }
            }
        }
        catch (HelixException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (Exception ex) {
            _logger.error(String.format("Error in update resource config for resource: %s", resourceName), (Throwable)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @GET
    @Path(value="{resourceName}/idealState")
    public Response getResourceIdealState(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName) {
        HelixAdmin admin = this.getHelixAdmin();
        IdealState idealState = admin.getResourceIdealState(clusterId, resourceName);
        if (idealState != null) {
            return this.JSONRepresentation(idealState.getRecord());
        }
        return this.notFound();
    }

    @POST
    @Path(value="{resourceName}/idealState")
    public Response updateResourceIdealState(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName, @QueryParam(value="command") String commandStr, String content) {
        ZNRecord record;
        AbstractResource.Command command;
        if (commandStr == null || commandStr.isEmpty()) {
            command = AbstractResource.Command.update;
        } else {
            try {
                command = this.getCommand(commandStr);
            }
            catch (HelixException ex) {
                return this.badRequest(ex.getMessage());
            }
        }
        try {
            record = ResourceAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            _logger.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        IdealState idealState = new IdealState(record);
        HelixAdmin helixAdmin = this.getHelixAdmin();
        try {
            switch (command) {
                case update: {
                    helixAdmin.updateIdealState(clusterId, resourceName, idealState);
                    break;
                }
                case delete: {
                    helixAdmin.removeFromIdealState(clusterId, resourceName, idealState);
                    break;
                }
                default: {
                    return this.badRequest(String.format("Unsupported command: %s", new Object[]{command}));
                }
            }
        }
        catch (HelixException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (Exception ex) {
            _logger.error(String.format("Failed to update the IdealState for resource: %s", resourceName), (Throwable)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @GET
    @Path(value="{resourceName}/externalView")
    public Response getResourceExternalView(@PathParam(value="clusterId") String clusterId, @PathParam(value="resourceName") String resourceName) {
        HelixAdmin admin = this.getHelixAdmin();
        ExternalView externalView = admin.getResourceExternalView(clusterId, resourceName);
        if (externalView != null) {
            return this.JSONRepresentation(externalView.getRecord());
        }
        return this.notFound();
    }

    private Map<String, String> computePartitionHealth(String clusterId, String resourceName) {
        HelixAdmin admin = this.getHelixAdmin();
        IdealState idealState = admin.getResourceIdealState(clusterId, resourceName);
        ExternalView externalView = admin.getResourceExternalView(clusterId, resourceName);
        StateModelDefinition stateModelDef = admin.getStateModelDef(clusterId, idealState.getStateModelDefRef());
        String initialState = stateModelDef.getInitialState();
        List statesPriorityList = stateModelDef.getStatesPriorityList();
        statesPriorityList = statesPriorityList.subList(0, statesPriorityList.indexOf(initialState));
        int minActiveReplicas = idealState.getMinActiveReplicas();
        HashMap<String, String> partitionHealthResult = new HashMap<String, String>();
        Set allPartitionNames = idealState.getPartitionSet();
        if (!allPartitionNames.isEmpty()) {
            for (String partitionName : allPartitionNames) {
                int replicaCount = idealState.getReplicaCount(idealState.getPreferenceList(partitionName).size());
                LinkedHashMap expectedStateCountMap = stateModelDef.getStateCountMap(replicaCount, replicaCount);
                Map stateMapInExternalView = externalView.getStateMap(partitionName);
                List allReplicaStatesInExternalView = stateMapInExternalView != null && !stateMapInExternalView.isEmpty() ? stateMapInExternalView.values() : Collections.emptyList();
                int numActiveReplicasInExternalView = 0;
                HealthStatus status = HealthStatus.HEALTHY;
                for (int statePriorityIndex = 0; statePriorityIndex < statesPriorityList.size(); ++statePriorityIndex) {
                    String currentState = (String)statesPriorityList.get(statePriorityIndex);
                    int currentStateCountInIdealState = (Integer)expectedStateCountMap.get(currentState);
                    int currentStateCountInExternalView = Collections.frequency(allReplicaStatesInExternalView, currentState);
                    numActiveReplicasInExternalView += currentStateCountInExternalView;
                    if (statePriorityIndex == 0 && currentStateCountInExternalView != currentStateCountInIdealState) {
                        status = HealthStatus.UNHEALTHY;
                        break;
                    }
                    if (currentStateCountInExternalView >= currentStateCountInIdealState) continue;
                    status = HealthStatus.PARTIAL_HEALTHY;
                }
                if (numActiveReplicasInExternalView < minActiveReplicas) {
                    status = HealthStatus.UNHEALTHY;
                }
                partitionHealthResult.put(partitionName, status.name());
            }
        }
        return partitionHealthResult;
    }

    public static enum HealthStatus {
        HEALTHY,
        PARTIAL_HEALTHY,
        UNHEALTHY;

    }

    public static enum ResourceProperties {
        idealState,
        idealStates,
        externalView,
        externalViews,
        resourceConfig;

    }
}

