/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.InstanceType;
import org.apache.helix.manager.zk.ByteArraySerializer;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.rest.metadatastore.ZkMetadataStoreDirectory;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.apache.helix.zookeeper.util.HttpRoutingDataReader;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContext
implements IZkDataListener,
IZkChildListener,
IZkStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServerContext.class);
    private final String _zkAddr;
    private boolean _isMultiZkEnabled;
    private final String _msdsEndpoint;
    private volatile RealmAwareZkClient _zkClient;
    private volatile ZKHelixAdmin _zkHelixAdmin;
    private volatile ClusterSetup _clusterSetup;
    private volatile ConfigAccessor _configAccessor;
    private volatile ZkBaseDataAccessor<byte[]> _byteArrayZkBaseDataAccessor;
    private final Map<String, HelixDataAccessor> _helixDataAccessorPool;
    private final Map<String, TaskDriver> _taskDriverPool;
    private ZkMetadataStoreDirectory _zkMetadataStoreDirectory;
    private RealmAwareZkClient _zkClientForListener;

    public ServerContext(String zkAddr) {
        this(zkAddr, false, null);
    }

    public ServerContext(String zkAddr, boolean isMultiZkEnabled, String msdsEndpoint) {
        this._zkAddr = zkAddr;
        this._isMultiZkEnabled = isMultiZkEnabled;
        this._msdsEndpoint = msdsEndpoint;
        this._helixDataAccessorPool = new ConcurrentHashMap<String, HelixDataAccessor>();
        this._taskDriverPool = new ConcurrentHashMap<String, TaskDriver>();
        this._zkMetadataStoreDirectory = ZkMetadataStoreDirectory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmAwareZkClient getRealmAwareZkClient() {
        if (this._zkClient == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._zkClient == null) {
                    if (this._isMultiZkEnabled || Boolean.parseBoolean(System.getProperty("helix.multiZkEnabled"))) {
                        try {
                            if (this._zkClientForListener == null) {
                                this._zkClientForListener = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(this._zkAddr), new HelixZkClient.ZkClientConfig().setZkSerializer((ZkSerializer)new ZNRecordSerializer()));
                            }
                            this._zkClientForListener.unsubscribeAll();
                            this._zkClientForListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
                            LOG.info("ServerContext: subscribed to routing data in routing ZK at {}!", (Object)this._zkAddr);
                            RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder connectionConfigBuilder = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder();
                            if (this._msdsEndpoint != null && !this._msdsEndpoint.isEmpty()) {
                                connectionConfigBuilder.setMsdsEndpoint(this._msdsEndpoint);
                            }
                            this._zkClient = new FederatedZkClient(connectionConfigBuilder.build(), new RealmAwareZkClient.RealmAwareZkClientConfig().setZkSerializer((ZkSerializer)new ZNRecordSerializer()));
                            LOG.info("ServerContext: FederatedZkClient created successfully!");
                        }
                        catch (IOException | IllegalStateException | InvalidRoutingDataException e) {
                            throw new HelixException("Failed to create FederatedZkClient!", e);
                        }
                    } else {
                        HelixZkClient.ZkClientConfig clientConfig = new HelixZkClient.ZkClientConfig();
                        clientConfig.setZkSerializer((ZkSerializer)new ZNRecordSerializer());
                        this._zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(this._zkAddr), clientConfig);
                    }
                }
            }
        }
        return this._zkClient;
    }

    @Deprecated
    public ZkClient getZkClient() {
        return (ZkClient)this.getRealmAwareZkClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelixAdmin getHelixAdmin() {
        if (this._zkHelixAdmin == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._zkHelixAdmin == null) {
                    this._zkHelixAdmin = new ZKHelixAdmin(this.getRealmAwareZkClient());
                }
            }
        }
        return this._zkHelixAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterSetup getClusterSetup() {
        if (this._clusterSetup == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._clusterSetup == null) {
                    this._clusterSetup = new ClusterSetup(this.getRealmAwareZkClient(), this.getHelixAdmin());
                }
            }
        }
        return this._clusterSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDriver getTaskDriver(String clusterName) {
        TaskDriver taskDriver = this._taskDriverPool.get(clusterName);
        if (taskDriver == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (!this._taskDriverPool.containsKey(clusterName)) {
                    this._taskDriverPool.put(clusterName, new TaskDriver(this.getRealmAwareZkClient(), clusterName));
                }
                taskDriver = this._taskDriverPool.get(clusterName);
            }
        }
        return taskDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigAccessor getConfigAccessor() {
        if (this._configAccessor == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._configAccessor == null) {
                    this._configAccessor = new ConfigAccessor(this.getRealmAwareZkClient());
                }
            }
        }
        return this._configAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelixDataAccessor getDataAccessor(String clusterName) {
        HelixDataAccessor dataAccessor = this._helixDataAccessorPool.get(clusterName);
        if (dataAccessor == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (!this._helixDataAccessorPool.containsKey(clusterName)) {
                    ZkBaseDataAccessor baseDataAccessor = new ZkBaseDataAccessor(this.getRealmAwareZkClient());
                    this._helixDataAccessorPool.put(clusterName, (HelixDataAccessor)new ZKHelixDataAccessor(clusterName, InstanceType.ADMINISTRATOR, (BaseDataAccessor)baseDataAccessor));
                }
                dataAccessor = this._helixDataAccessorPool.get(clusterName);
            }
        }
        return dataAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDataAccessor<byte[]> getByteArrayZkBaseDataAccessor() {
        if (this._byteArrayZkBaseDataAccessor == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._byteArrayZkBaseDataAccessor == null) {
                    this._byteArrayZkBaseDataAccessor = new ZkBaseDataAccessor(this._zkAddr, (ZkSerializer)new ByteArraySerializer());
                }
            }
        }
        return this._byteArrayZkBaseDataAccessor;
    }

    public void close() {
        if (this._zkClient != null) {
            this._zkClient.close();
        }
        if (this._zkMetadataStoreDirectory != null) {
            this._zkMetadataStoreDirectory.close();
        }
        if (this._zkClientForListener != null) {
            this._zkClientForListener.close();
        }
    }

    public void handleChildChange(String parentPath, List<String> currentChilds) {
        if (this._zkClientForListener == null || this._zkClientForListener.isClosed()) {
            return;
        }
        this._zkClientForListener.unsubscribeAll();
        this._zkClientForListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    public void handleDataChange(String dataPath, Object data) {
        if (this._zkClientForListener == null || this._zkClientForListener.isClosed()) {
            return;
        }
        this.resetZkResources();
    }

    public void handleDataDeleted(String dataPath) {
        if (this._zkClientForListener == null || this._zkClientForListener.isClosed()) {
            return;
        }
        this._zkClientForListener.unsubscribeAll();
        this._zkClientForListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    public void handleStateChanged(Watcher.Event.KeeperState state) {
        if (this._zkClientForListener == null || this._zkClientForListener.isClosed()) {
            return;
        }
        this._zkClientForListener.unsubscribeAll();
        this._zkClientForListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    public void handleNewSession(String sessionId) {
        if (this._zkClientForListener == null || this._zkClientForListener.isClosed()) {
            return;
        }
        this._zkClientForListener.unsubscribeAll();
        this._zkClientForListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    public void handleSessionEstablishmentError(Throwable error) {
        if (this._zkClientForListener == null || this._zkClientForListener.isClosed()) {
            return;
        }
        this._zkClientForListener.unsubscribeAll();
        this._zkClientForListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetZkResources() {
        ServerContext serverContext = this;
        synchronized (serverContext) {
            LOG.info("ServerContext: Resetting ZK resources due to routing data change! Routing ZK: {}", (Object)this._zkAddr);
            try {
                HttpRoutingDataReader.reset();
                if (this._zkClient != null && !this._zkClient.isClosed()) {
                    this._zkClient.close();
                }
                if (this._byteArrayZkBaseDataAccessor != null) {
                    this._byteArrayZkBaseDataAccessor.close();
                }
                this._zkClient = null;
                this._zkHelixAdmin = null;
                this._clusterSetup = null;
                this._configAccessor = null;
                this._byteArrayZkBaseDataAccessor = null;
                this._helixDataAccessorPool.clear();
                this._taskDriverPool.clear();
            }
            catch (Exception e) {
                LOG.error("Failed to reset ZkClient and Helix APIs in ServerContext!", (Throwable)e);
            }
        }
    }
}

