/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceValidationUtil {
    private static final Logger _logger = LoggerFactory.getLogger(InstanceValidationUtil.class);
    public static Set<String> UNHEALTHY_STATES = ImmutableSet.of((Object)HelixDefinedState.DROPPED.name(), (Object)HelixDefinedState.ERROR.name());

    private InstanceValidationUtil() {
    }

    public static boolean isEnabled(HelixDataAccessor dataAccessor, String instanceName) {
        PropertyKey.Builder propertyKeyBuilder = dataAccessor.keyBuilder();
        InstanceConfig instanceConfig = (InstanceConfig)dataAccessor.getProperty(propertyKeyBuilder.instanceConfig(instanceName));
        ClusterConfig clusterConfig = (ClusterConfig)dataAccessor.getProperty(propertyKeyBuilder.clusterConfig());
        if (instanceConfig == null || clusterConfig == null) {
            throw new HelixException("InstanceConfig or ClusterConfig is NULL");
        }
        boolean enabledInInstanceConfig = instanceConfig.getInstanceEnabled();
        Map<String, String> disabledInstances = clusterConfig.getDisabledInstances();
        boolean enabledInClusterConfig = disabledInstances == null || !disabledInstances.keySet().contains(instanceName);
        return enabledInClusterConfig && enabledInInstanceConfig;
    }

    public static boolean isAlive(HelixDataAccessor dataAccessor, String instanceName) {
        LiveInstance liveInstance = (LiveInstance)dataAccessor.getProperty(dataAccessor.keyBuilder().liveInstance(instanceName));
        return liveInstance != null;
    }

    public static boolean hasResourceAssigned(HelixDataAccessor dataAccessor, String clusterId, String instanceName) {
        PropertyKey.Builder propertyKeyBuilder = dataAccessor.keyBuilder();
        LiveInstance liveInstance = (LiveInstance)dataAccessor.getProperty(propertyKeyBuilder.liveInstance(instanceName));
        if (liveInstance != null) {
            String sessionId = liveInstance.getEphemeralOwner();
            List<String> resourceNames = dataAccessor.getChildNames(propertyKeyBuilder.currentStates(instanceName, sessionId));
            for (String resourceName : resourceNames) {
                PropertyKey currentStateKey = propertyKeyBuilder.currentState(instanceName, sessionId, resourceName);
                CurrentState currentState = (CurrentState)dataAccessor.getProperty(currentStateKey);
                if (currentState == null || currentState.getPartitionStateMap().size() <= 0) continue;
                return true;
            }
        }
        _logger.warn(String.format("The instance %s is not active", instanceName));
        return false;
    }

    public static boolean hasDisabledPartitions(HelixDataAccessor dataAccessor, String clusterId, String instanceName) {
        PropertyKey propertyKey = dataAccessor.keyBuilder().instanceConfig(instanceName);
        InstanceConfig instanceConfig = (InstanceConfig)dataAccessor.getProperty(propertyKey);
        if (instanceConfig != null) {
            for (List<String> disabledPartitions : instanceConfig.getDisabledPartitionsMap().values()) {
                if (disabledPartitions == null || disabledPartitions.size() <= 0) continue;
                return true;
            }
            return false;
        }
        throw new HelixException("Fail to get instance config for " + instanceName);
    }

    public static boolean hasValidConfig(HelixDataAccessor dataAccessor, String clusterId, String instanceName) {
        PropertyKey propertyKey = dataAccessor.keyBuilder().instanceConfig(instanceName);
        InstanceConfig instanceConfig = (InstanceConfig)dataAccessor.getProperty(propertyKey);
        return instanceConfig != null && instanceConfig.isValid();
    }

    public static boolean hasErrorPartitions(HelixDataAccessor dataAccessor, String clusterId, String instanceName) {
        PropertyKey.Builder propertyKeyBuilder = new PropertyKey.Builder(clusterId);
        PropertyKey liveInstanceKey = propertyKeyBuilder.liveInstance(instanceName);
        LiveInstance liveInstance = (LiveInstance)dataAccessor.getProperty(liveInstanceKey);
        if (liveInstance != null) {
            String sessionId = liveInstance.getEphemeralOwner();
            PropertyKey currentStatesKey = propertyKeyBuilder.currentStates(instanceName, sessionId);
            List<String> resourceNames = dataAccessor.getChildNames(currentStatesKey);
            for (String resourceName : resourceNames) {
                PropertyKey key = propertyKeyBuilder.currentState(instanceName, sessionId, resourceName);
                CurrentState currentState = (CurrentState)dataAccessor.getProperty(key);
                if (currentState == null || !currentState.getPartitionStateMap().containsValue(HelixDefinedState.ERROR.name())) continue;
                return true;
            }
        }
        _logger.warn(String.format("The instance %s is not active", instanceName));
        return false;
    }

    public static List<String> perPartitionHealthCheck(List<ExternalView> externalViews, Map<String, Map<String, Boolean>> globalPartitionHealthStatus, String instanceToBeStop, HelixDataAccessor dataAccessor) {
        ArrayList<String> unhealthyPartitions = new ArrayList<String>();
        for (ExternalView externalView : externalViews) {
            if (ResourceConfig.ResourceConfigConstants.ANY_LIVEINSTANCE.name().equals(externalView.getReplicas())) continue;
            StateModelDefinition stateModelDefinition = (StateModelDefinition)dataAccessor.getProperty(dataAccessor.keyBuilder().stateModelDef(externalView.getStateModelDefRef()));
            block1: for (String partition : externalView.getPartitionSet()) {
                Map<String, String> stateMap = externalView.getStateMap(partition);
                if (!stateMap.containsKey(instanceToBeStop) || !stateMap.get(instanceToBeStop).equals(stateModelDefinition.getTopState())) continue;
                for (String siblingInstance : stateMap.keySet()) {
                    if (siblingInstance.equals(instanceToBeStop) || globalPartitionHealthStatus.containsKey(siblingInstance) && globalPartitionHealthStatus.get(siblingInstance).containsKey(partition) && globalPartitionHealthStatus.get(siblingInstance).get(partition).booleanValue()) continue;
                    unhealthyPartitions.add(partition);
                    continue block1;
                }
            }
        }
        return unhealthyPartitions;
    }

    public static boolean isInstanceStable(HelixDataAccessor dataAccessor, String instanceName) {
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        ClusterConfig clusterConfig = (ClusterConfig)dataAccessor.getProperty(keyBuilder.clusterConfig());
        if (clusterConfig == null) {
            throw new HelixException("Missing cluster config!");
        }
        if (!clusterConfig.isPersistIntermediateAssignment().booleanValue()) {
            throw new HelixException("isInstanceStable needs persist assignment on!");
        }
        List<String> idealStateNames = dataAccessor.getChildNames(keyBuilder.idealStates());
        for (String idealStateName : idealStateNames) {
            IdealState idealState = (IdealState)dataAccessor.getProperty(keyBuilder.idealStates(idealStateName));
            if (idealState == null || !idealState.isEnabled() || !idealState.isValid() || "Task".equals(idealState.getStateModelDefRef())) continue;
            ExternalView externalView = (ExternalView)dataAccessor.getProperty(keyBuilder.externalView(idealStateName));
            if (externalView == null) {
                throw new HelixException(String.format("Resource %s does not have external view!", idealStateName));
            }
            for (String partition : idealState.getPartitionSet()) {
                Map<String, String> isPartitionMap = idealState.getInstanceStateMap(partition);
                if (isPartitionMap == null) {
                    throw new HelixException(String.format("Partition %s of resource %s does not have an ideal state partition map", partition, idealStateName));
                }
                if (!isPartitionMap.containsKey(instanceName)) continue;
                Map<String, String> evPartitionMap = externalView.getStateMap(partition);
                if (evPartitionMap == null) {
                    throw new HelixException(String.format("Partition %s of resource %s does not have an external view partition map", partition, idealStateName));
                }
                if (evPartitionMap.containsKey(instanceName) && evPartitionMap.get(instanceName).equals(isPartitionMap.get(instanceName))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean siblingNodesActiveReplicaCheck(HelixDataAccessor dataAccessor, String instanceName) {
        PropertyKey.Builder propertyKeyBuilder = dataAccessor.keyBuilder();
        List<String> resources = dataAccessor.getChildNames(propertyKeyBuilder.idealStates());
        for (String resourceName : resources) {
            IdealState idealState = (IdealState)dataAccessor.getProperty(propertyKeyBuilder.idealStates(resourceName));
            if (idealState == null || !idealState.isEnabled() || !idealState.isValid() || "Task".equals(idealState.getStateModelDefRef())) continue;
            ExternalView externalView = (ExternalView)dataAccessor.getProperty(propertyKeyBuilder.externalView(resourceName));
            if (externalView == null) {
                throw new HelixException(String.format("Resource %s does not have external view!", resourceName));
            }
            int minActiveReplicas = externalView.getMinActiveReplicas();
            if (minActiveReplicas == -1) {
                _logger.warn("Resource " + resourceName + " is missing minActiveReplica field. Skip the sibling check");
                continue;
            }
            String stateModeDef = externalView.getStateModelDefRef();
            StateModelDefinition stateModelDefinition = (StateModelDefinition)dataAccessor.getProperty(propertyKeyBuilder.stateModelDef(stateModeDef));
            HashSet<String> unhealthyStates = new HashSet<String>(UNHEALTHY_STATES);
            if (stateModelDefinition != null) {
                unhealthyStates.add(stateModelDefinition.getInitialState());
            }
            for (String partition : externalView.getPartitionSet()) {
                Map<String, String> stateByInstanceMap = externalView.getStateMap(partition);
                if (!stateByInstanceMap.containsKey(instanceName)) continue;
                int numHealthySiblings = 0;
                for (Map.Entry<String, String> entry : stateByInstanceMap.entrySet()) {
                    if (entry.getKey().equals(instanceName) || unhealthyStates.contains(entry.getValue())) continue;
                    ++numHealthySiblings;
                }
                if (numHealthySiblings >= minActiveReplicas) continue;
                _logger.info("Partition {} doesn't have enough active replicas in sibling nodes. NumHealthySiblings: {}, minActiveReplicas: {}", new Object[]{partition, numHealthySiblings, minActiveReplicas});
                return false;
            }
        }
        return true;
    }
}

