/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.helix.HelixProperty;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.codehaus.jackson.map.ObjectMapper;

public class ControllerHistory
extends HelixProperty {
    private static final int HISTORY_SIZE = 10;
    private static final int MAINTENANCE_HISTORY_SIZE = 20;

    public ControllerHistory(String id) {
        super(id);
    }

    public ControllerHistory(ZNRecord record) {
        super(record);
    }

    public ZNRecord updateHistory(String clusterName, String instanceName, String version) {
        List<String> list = this._record.getListField(clusterName);
        if (list == null) {
            list = new ArrayList<String>();
            this._record.setListField(clusterName, list);
        }
        while (list.size() >= 10) {
            list.remove(0);
        }
        list.add(instanceName);
        List<String> historyList = this._record.getListField(ConfigProperty.HISTORY.name());
        if (historyList == null) {
            historyList = new ArrayList<String>();
            this._record.setListField(ConfigProperty.HISTORY.name(), historyList);
        }
        while (historyList.size() >= 10) {
            historyList.remove(0);
        }
        HashMap<String, String> historyEntry = new HashMap<String, String>();
        long currentTime = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTime = df.format(new Date(currentTime));
        historyEntry.put(ConfigProperty.CONTROLLER.name(), instanceName);
        historyEntry.put(ConfigProperty.TIME.name(), String.valueOf(currentTime));
        historyEntry.put(ConfigProperty.DATE.name(), dateTime);
        historyEntry.put(ConfigProperty.VERSION.name(), version);
        historyList.add(((Object)historyEntry).toString());
        return this._record;
    }

    public List<String> getHistoryList() {
        List<String> historyList = this._record.getListField(ConfigProperty.HISTORY.name());
        if (historyList == null) {
            historyList = new ArrayList<String>();
        }
        return historyList;
    }

    public ZNRecord updateMaintenanceHistory(boolean enabled, String reason, long currentTime, MaintenanceSignal.AutoTriggerReason internalReason, Map<String, String> customFields, MaintenanceSignal.TriggeringEntity triggeringEntity) throws IOException {
        List<String> maintenanceHistoryList = this._record.getListField(MaintenanceConfigKey.MAINTENANCE_HISTORY.name());
        if (maintenanceHistoryList == null) {
            maintenanceHistoryList = new ArrayList<String>();
            this._record.setListField(MaintenanceConfigKey.MAINTENANCE_HISTORY.name(), maintenanceHistoryList);
        }
        while (maintenanceHistoryList.size() >= 20) {
            maintenanceHistoryList.remove(0);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTime = df.format(new Date(currentTime));
        HashMap<String, String> maintenanceEntry = new HashMap<String, String>();
        maintenanceEntry.put(MaintenanceConfigKey.OPERATION_TYPE.name(), enabled ? OperationType.ENTER.name() : OperationType.EXIT.name());
        maintenanceEntry.put(MaintenanceConfigKey.REASON.name(), reason);
        maintenanceEntry.put(MaintenanceConfigKey.DATE.name(), dateTime);
        maintenanceEntry.put(MaintenanceSignal.MaintenanceSignalProperty.TIMESTAMP.name(), String.valueOf(currentTime));
        maintenanceEntry.put(MaintenanceSignal.MaintenanceSignalProperty.TRIGGERED_BY.name(), triggeringEntity.name());
        if (triggeringEntity == MaintenanceSignal.TriggeringEntity.CONTROLLER) {
            maintenanceEntry.put(MaintenanceSignal.MaintenanceSignalProperty.AUTO_TRIGGER_REASON.name(), internalReason.name());
        } else if (customFields != null && !customFields.isEmpty()) {
            for (Map.Entry<String, String> customFieldEntry : customFields.entrySet()) {
                if (maintenanceEntry.containsKey(customFieldEntry.getKey())) continue;
                maintenanceEntry.put(customFieldEntry.getKey(), customFieldEntry.getValue());
            }
        }
        maintenanceHistoryList.add(new ObjectMapper().writeValueAsString(maintenanceEntry));
        return this._record;
    }

    public List<String> getMaintenanceHistoryList() {
        List<String> maintenanceHistoryList = this._record.getListField(MaintenanceConfigKey.MAINTENANCE_HISTORY.name());
        if (maintenanceHistoryList == null) {
            maintenanceHistoryList = new ArrayList<String>();
        }
        return maintenanceHistoryList;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static enum HistoryType {
        CONTROLLER_LEADERSHIP,
        MAINTENANCE;

    }

    private static enum OperationType {
        ENTER,
        EXIT;

    }

    private static enum MaintenanceConfigKey {
        MAINTENANCE_HISTORY,
        OPERATION_TYPE,
        DATE,
        REASON;

    }

    private static enum ConfigProperty {
        HISTORY,
        TIME,
        DATE,
        VERSION,
        CONTROLLER;

    }
}

